/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.axis.ChartCategoryAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DAreaA;
import chart.chart2d.Graph2DAreaP;
import chart.chart2d.Graph2DAreaSt;
import chart.chart2d.Graph2DStaticHint;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartShading;
import chart.util.ChartHintLabel;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class Graph2DArea
extends Chart2DObject {
    protected Shape[] seriesShapes;
    protected Shape[] seriesTopFaceShapes;
    protected Shape[] seriesRightFaceShapes;
    protected Shape[][] itemShapes;
    protected float startX;
    protected float unitX;
    protected float unitY;
    protected int row;
    protected int col;
    protected float[][] value;
    private float[][] HighLightPattern;
    protected float[][] tHint;
    protected float[] absSumOfCols;
    protected float[][] point;
    protected float[][] tpoint;
    protected float[][] lastpoint;
    protected float[][] tlastpoint;
    protected float[][] tlastpoint2;
    protected int gap = 5;
    protected boolean useDropline = false;
    protected float[][] droplinePoints;
    protected float[][] bottomDroplinePoints;
    protected Line2D[] droplines;
    private String[][][] abs;
    protected double[] SumOfRows;
    protected GeneralPath topPath;
    protected GeneralPath rightPath;
    protected float depth;
    protected float depthH = 0.0f;
    protected float depthW = 0.0f;
    protected float startOffsetW = 0.0f;
    protected float startOffsetH = 0.0f;
    protected float offsetW = 0.0f;
    protected float offsetH = 0.0f;
    protected int offsetN = 1;
    protected float[][] dPoint;
    protected float[][] tDPoint;

    Graph2DArea(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer, int n) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
        this.offsetN = n;
    }

    public void init() {
        int n;
        super.init();
        this.useDropline = this.objectProperties.isUseDropline();
        double d = Math.PI / 180 * (double)this.objectProperties.getDepthDirection();
        this.depth = this.objectProperties.getDepth() / (float)this.layer.getChartCount();
        this.startOffsetW = (float)((double)(this.depth * (float)(this.offsetN - 1)) * Math.cos(d));
        this.startOffsetH = (float)((double)(this.depth * (float)(this.offsetN - 1)) * Math.sin(d));
        this.startOffsetW = this.startOffsetW < 0.0f ? 0.0f : this.startOffsetW;
        this.startOffsetH = this.startOffsetH < 0.0f ? 0.0f : this.startOffsetH;
        this.depth *= (float)this.offsetN;
        this.depthW = (float)((double)this.depth * Math.cos(d));
        this.depthH = (float)((double)this.depth * Math.sin(d));
        this.depthW = this.depthW < 0.0f ? 0.0f : this.depthW;
        this.depthH = this.depthH < 0.0f ? 0.0f : this.depthH;
        this.offsetW = this.depthW / (float)this.offsetN;
        this.offsetH = this.depthH / (float)this.offsetN;
        this.col = this.dataset.getCategorySize();
        this.row = this.dataset.getSeriesSize();
        this.value = new float[this.row][this.col];
        this.HighLightPattern = new float[this.row * this.col][2];
        this.tHint = new float[this.row * this.col][2];
        this.unitX = this.layer.I();
        this.unitY = this.layer.Z();
        this.abs = new String[this.row][this.col][3];
        int n2 = this.dataset.getChartDataSetInfo().getChartType();
        int n3 = ChartTypeInfo.getSubType(n2);
        boolean bl = n3 == 256;
        float f = 0.0f;
        int n4 = 0;
        while (n4 < this.row) {
            n = 0;
            while (n < this.col) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n4, n);
                if (number == null) {
                    this.value[n4][n] = 0.0f;
                } else {
                    this.value[n4][n] = number.floatValue();
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.abs[n4][n] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(n4, n);
                    } else {
                        this.abs[n4][n][0] = this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getOriginValue(n4, n));
                    }
                    this.HighLightPattern[n4 * this.col + n][0] = this.unitX * (float)n;
                    if (bl) {
                        f = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n) == 0.0f ? 1.0f : (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n);
                        this.HighLightPattern[n4 * this.col + n][1] = this.unitY * this.value[n4][n] / f;
                    } else {
                        this.HighLightPattern[n4 * this.col + n][1] = this.unitY * this.value[n4][n];
                    }
                }
                ++n;
            }
            ++n4;
        }
        if (this.valueLabelPosition != 0) {
            if (this.dataset.getChartDataSetModel().isOneGroup()) {
                this.SumOfRows = new double[this.row];
                double[] dArray = new double[this.row];
                int n5 = 0;
                while (n5 < this.row) {
                    int n6 = 0;
                    while (n6 < this.col) {
                        int n7 = n5;
                        dArray[n7] = dArray[n7] + (double)Math.abs(this.value[n5][n6]);
                        ++n6;
                    }
                    if (n5 == 0 || this instanceof Graph2DAreaA) {
                        this.SumOfRows[n5] = dArray[n5];
                    }
                    if ((this instanceof Graph2DAreaSt || this instanceof Graph2DAreaP) && n5 > 0) {
                        this.SumOfRows[n5] = dArray[n5] - dArray[n5 - 1];
                    }
                    if (this.SumOfRows[n5] == 0.0) {
                        this.SumOfRows[n5] = 1.0;
                    }
                    ++n5;
                }
            } else {
                this.SumOfRows = new double[this.col];
                n = 0;
                while (n < this.col) {
                    int n8 = 0;
                    while (n8 < this.row) {
                        if (this instanceof Graph2DAreaSt || this instanceof Graph2DAreaP) {
                            this.SumOfRows[n] = Math.abs(this.value[this.row - 1][n]);
                            break;
                        }
                        int n9 = n;
                        this.SumOfRows[n9] = this.SumOfRows[n9] + (double)Math.abs(this.value[n8][n]);
                        ++n8;
                    }
                    if (this.SumOfRows[n] == 0.0) {
                        this.SumOfRows[n] = 1.0;
                    }
                    ++n;
                }
            }
        }
        this.seriesShapes = new Shape[this.row];
        this.itemShapes = new Shape[this.row][this.col];
        this.droplinePoints = new float[this.row][this.col];
        this.droplines = new Line2D[this.col];
        this.bottomDroplinePoints = new float[this.col][2];
        if (this.layer.isDepth()) {
            this.seriesTopFaceShapes = new Shape[this.row];
            this.seriesRightFaceShapes = new Shape[this.row];
            int n10 = 0;
            while (n10 < this.row) {
                this.seriesTopFaceShapes[n10] = new GeneralPath();
                this.seriesRightFaceShapes[n10] = new GeneralPath();
                ++n10;
            }
            this.topPath = new GeneralPath();
            this.rightPath = new GeneralPath();
            this.dPoint = new float[this.col * this.row][2];
            this.tDPoint = new float[this.col * this.row][2];
        }
        int n11 = 0;
        while (n11 < this.row) {
            this.seriesShapes[n11] = new GeneralPath();
            int n12 = 0;
            while (n12 < this.col) {
                this.itemShapes[n11][n12] = new GeneralPath();
                ++n12;
            }
            ++n11;
        }
        this.point = new float[this.col][2];
        this.tpoint = new float[this.col][2];
        this.lastpoint = new float[this.col][2];
        this.tlastpoint = new float[this.col][2];
        this.tlastpoint2 = new float[this.col][2];
        this.startX = ((ChartCategoryAxis)this.layer.getAxisX()).isLineUnit() ? 0.0f : this.unitX / 2.0f;
    }

    public void locate() {
        int n;
        if (this.layer.isDepth()) {
            n = 0;
            while (n < this.row) {
                ((GeneralPath)this.seriesTopFaceShapes[n]).reset();
                ((GeneralPath)this.seriesRightFaceShapes[n]).reset();
                ++n;
            }
        }
        n = 0;
        while (n < this.row) {
            ((GeneralPath)this.seriesShapes[n]).reset();
            int n2 = 0;
            while (n2 < this.col) {
                ((GeneralPath)this.itemShapes[n][n2]).reset();
                ++n2;
            }
            ++n;
        }
        this.layer.I(this.HighLightPattern, this.tHint);
    }

    float[][] getStaticHintLocation() {
        return null;
    }

    public void paint(Graphics2D graphics2D) {
        int n = this.row - 1;
        while (n >= 0) {
            if (this.seriesPattern[n] != null) {
                if (this.layer.isDepth()) {
                    this.drawDepthArea(graphics2D, n);
                } else {
                    this.seriesPattern[n].fill(graphics2D, this.seriesShapes[n]);
                }
            }
            if (this.objectProperties.isContour()) {
                this.objectProperties.getContourPen().draw(graphics2D, this.seriesShapes[n]);
            }
            if (this.valueLabelPosition != 0) {
                Graph2DStaticHint graph2DStaticHint = new Graph2DStaticHint(this.paper.model, graphics2D, this.dataset, this.paper, this.layer, this.tHint, n, n + 1, this.valueLabelPosition, this.SumOfRows);
                graph2DStaticHint.paint();
            }
            --n;
        }
        if (!this.layer.isDepth() && this.useDropline) {
            int n2 = 0;
            while (n2 < this.col) {
                this.objectProperties.getContourPen().draw(graphics2D, this.droplines[n2]);
                ++n2;
            }
        }
    }

    public void drawDepthArea(Graphics2D graphics2D, int n) {
        if (this.seriesPattern[n] != null) {
            ChartFillPattern chartFillPattern = ChartShading.HighLightPattern(this.seriesPattern[n], -20);
            chartFillPattern.fill(graphics2D, this.seriesTopFaceShapes[n]);
            this.seriesPattern[n].fill(graphics2D, this.seriesShapes[n]);
            chartFillPattern.fill(graphics2D, this.seriesRightFaceShapes[n]);
        }
    }

    public Shape getShapeBySeries(int n) {
        return this.seriesShapes[n];
    }

    public Shape getShapeByItem(int n, int n2) {
        return this.itemShapes[n][n2];
    }

    public Shape[][] getItemShapes() {
        return this.itemShapes;
    }

    public String[] search(int n, int n2) {
        this.drilldown = null;
        int n3 = 0;
        while (n3 < this.row) {
            int n4 = 0;
            while (n4 < this.col) {
                if (this.itemShapes[n3][n4].contains(n, n2)) {
                    this.drilldown = new int[2];
                    this.drilldown[0] = n3;
                    this.drilldown[1] = n4;
                    return this.abs[n3][n4];
                }
                ++n4;
            }
            ++n3;
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public int searchSeries(int n, int n2) {
        int n3 = 0;
        while (n3 < this.seriesShapes.length) {
            if (this.seriesShapes[n3].contains(n, n2)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    protected void construtDroplines() {
        if (this.row == 0) {
            return;
        }
        float[][] fArray = new float[this.col][2];
        int n = 0;
        while (n < this.col) {
            fArray[n][0] = this.bottomDroplinePoints[n][0];
            fArray[n][1] = this.droplinePoints[0][n];
            int n2 = 0;
            while (n2 < this.row) {
                fArray[n][1] = fArray[n][1] > this.droplinePoints[n2][n] ? this.droplinePoints[n2][n] : fArray[n][1];
                ++n2;
            }
            this.droplines[n] = new Line2D.Float();
            this.droplines[n].setLine(this.bottomDroplinePoints[n][0], this.bottomDroplinePoints[n][1], fArray[n][0], fArray[n][1]);
            ++n;
        }
    }
}

