/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.awt.font;

import com.jinfonet.awt.JFont;
import com.jinfonet.awt.JFontEnv;
import com.jinfonet.awt.JFontHeader;
import com.jinfonet.awt.font.truetype.OpenTypeFont;
import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.util.RAFile;
import jet.util.RandomInputable;
import jet.util.RandomOutputable;

public class JMFont
extends Font
implements JFont,
JFontEnv {
    private static Hashtable QOIV = new Hashtable(10);
    private static Vector addElement = new Vector(10);
    JFont clear;
    int close;
    JFontEnv contains;
    boolean draw = true;
    float elements;

    public JMFont(String string, int n, float f, int n2, JFont jFont) {
        super(string, n2, Math.round(f));
        this.close = n;
        this.clear = jFont;
        this.draw = true;
        this.elements = f;
    }

    public void unload() {
    }

    public static final void unloadAllFonts() {
        Enumeration enumeration = QOIV.elements();
        while (enumeration.hasMoreElements()) {
            ((JFont)enumeration.nextElement()).unload();
        }
        QOIV.clear();
        addElement.removeAllElements();
    }

    public static final synchronized JFont loadFont(String string, RandomInputable randomInputable) {
        JFont jFont = (JFont)QOIV.get(string);
        if (jFont == null) {
            try {
                jFont = new OpenTypeFont(randomInputable);
                if (!addElement.contains(jFont.getBaseName())) {
                    addElement.addElement(jFont.getBaseName());
                    QOIV.put(string, jFont);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return jFont;
    }

    public static final JFont prepareName(String string) {
        JFont jFont;
        block3: {
            jFont = (JFont)QOIV.get(string);
            if (jFont == null && string.toLowerCase().endsWith(".ttf")) {
                try {
                    RAFile rAFile = new RAFile(string, "r");
                    jFont = new OpenTypeFont(rAFile, true);
                    rAFile.close();
                }
                catch (IOException iOException) {
                    if (!JRLog.isError(2)) break block3;
                    JRLog.error(2, iOException);
                }
            }
        }
        return jFont;
    }

    public static final synchronized JFont loadFont(String string) {
        JFont jFont = (JFont)QOIV.get(string);
        if (jFont == null && string.toLowerCase().endsWith(".ttf")) {
            try {
                RAFile rAFile = new RAFile(string, "r");
                jFont = new OpenTypeFont(rAFile);
                if (!addElement.contains(jFont.getBaseName())) {
                    addElement.addElement(jFont.getBaseName());
                    QOIV.put(string, jFont);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return jFont;
    }

    public static final synchronized JMFont make(String string, float f) {
        JFont jFont = JMFont.loadFont(string);
        JMFont jMFont = null;
        if (jFont != null) {
            String string2 = jFont.getMapFontName();
            jMFont = new JMFont(string2, 0, f, jFont.getStyle(), jFont);
        }
        return jMFont;
    }

    public JFont getImplFont() {
        return this.clear;
    }

    public void setImplFont(JFont jFont) {
        this.clear = jFont;
    }

    public void draw(Graphics graphics, String string, float f, float f2) {
        this.clear.draw(graphics, string, f, f2);
    }

    public FontMetrics getFontMetrics() {
        return this.clear.getFontMetrics(this);
    }

    public JFontHeader getFontHeader() {
        return this.clear.getFontHeader();
    }

    public void setFontEnv(JFontEnv jFontEnv) {
        this.contains = jFontEnv;
    }

    public FontMetrics getFontMetrics(JFontEnv jFontEnv) {
        return this.clear.getFontMetrics(jFontEnv);
    }

    public int[] getWidths() {
        return this.clear.getWidths();
    }

    public boolean isValid() {
        return this.draw;
    }

    public String getMapFontName() {
        return this.clear.getMapFontName();
    }

    public boolean isAsiaFont() {
        return this.clear.isAsiaFont();
    }

    public String getPSName() {
        return this.clear.getPSName();
    }

    public String getBaseName() {
        return this.clear.getBaseName();
    }

    public void writeTo(RandomOutputable randomOutputable) throws IOException {
        this.clear.writeTo(randomOutputable);
    }

    public int getResolution() {
        if (this.contains != null) {
            return this.contains.getResolution();
        }
        if (this.close == 0) {
            this.close = Unit.getResolution();
        }
        return this.close;
    }

    public float getPoints() {
        double d = 72.0 / (double)this.getResolution();
        return (float)((double)this.elements * d);
    }

    static {
        try {
            Class.forName("java.awt.GraphicsEnvironment");
            GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

