/*
 * Decompiled with CFR 0.152.
 */
package jet.acl;

import java.security.Principal;
import java.security.acl.NotOwnerException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import jet.acl.ACLException;
import jet.acl.AclTextReader;
import jet.acl.JetAclEntry;
import jet.acl.JetGroup;
import jet.acl.JetPrincipal;
import jet.acl.JetRole;
import jet.acl.JetUser;
import jet.client.connector.ClientConnector;
import jet.controls.JetBoolean;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAclEntryImpl;
import jet.cs.jacl.JAclImpl;
import jet.cs.jacl.SecurityData;
import jet.export.xml.ObjectToXML;
import jet.export.xml.XMLToObject;
import jet.server.api.SecurityContext;
import jet.util.TreeIterater;

public class JetAcl
extends JetObject
implements JetRootable,
JetContainable,
SecurityData,
Cloneable {
    private JetBoolean QOIV;
    private JetBoolean add;
    private String addElement = "";
    public static final int APPEND_TYPE = 1;
    public static final int OVERWRITE_TYPE = 2;
    public static final int REPLACE_NO_PERMISSION = 1;
    public static final int MERGE_WITH_PERMISSION = 2;
    private Vector addEntry = new Vector(5);
    private Hashtable addGroup = new Hashtable(10);
    private Hashtable addParentRole = new Hashtable(10);
    private Hashtable addRole = new Hashtable(10);
    private Hashtable addUser = new Hashtable();
    private Hashtable afterInit = new Hashtable();
    public static final int ALL = 0;
    public static final int SERVER = 1;
    public static final int USERDEFINED = 2;
    private int append = 0;
    private boolean clear = false;
    private int clearMem = 65553;
    private static final HashMap clone = new HashMap(2);

    public JetAcl() {
        this.contains();
    }

    public JetAcl(String string) {
        this.contains();
        this.setName(string);
    }

    public void setName(String string) {
        this.addElement = string;
    }

    public String getName() {
        return this.addElement;
    }

    public boolean isValidRLS() {
        return !this.QOIV.get();
    }

    public boolean isValidCLS() {
        return this.add.get();
    }

    public void setRLSValid(boolean bl) {
        this.QOIV.set(!bl);
    }

    public void setCLSValid(boolean bl) {
        this.add.set(bl);
    }

    public String addUser(JetUser jetUser) {
        String string = jetUser.getName();
        if (this.addGroup.containsKey(string)) {
            return new String("The user " + string + " already exits!");
        }
        JetAclEntry jetAclEntry = new JetAclEntry(jetUser);
        this.add(jetAclEntry);
        this.addGroup.put(string, jetAclEntry);
        return null;
    }

    public String addRole(JetRole jetRole) {
        String string = jetRole.getName();
        if (this.addParentRole.containsKey(string)) {
            return new String("The role " + string + " already exits!");
        }
        JetAclEntry jetAclEntry = new JetAclEntry(jetRole);
        this.add(jetAclEntry);
        this.addParentRole.put(string, jetAclEntry);
        return null;
    }

    public String addGroup(JetGroup jetGroup) {
        String string = jetGroup.getName();
        if (this.addRole.containsKey(string)) {
            return new String("The group " + string + " already exits!");
        }
        JetAclEntry jetAclEntry = new JetAclEntry(jetGroup);
        this.add(jetAclEntry);
        this.addRole.put(string, jetAclEntry);
        return null;
    }

    public boolean deleteUser(JetUser jetUser) {
        return this.deleteUser(jetUser.getName());
    }

    public boolean deleteUser(JetUser jetUser, boolean bl) {
        return this.deleteUser(jetUser.getName(), bl);
    }

    public boolean deleteUser(String string) {
        return this.deleteUser(string, false);
    }

    public boolean deleteUser(String string, boolean bl) {
        if (!this.addGroup.containsKey(string)) {
            return false;
        }
        JetAclEntry jetAclEntry = (JetAclEntry)this.addGroup.get(string);
        this.remove(jetAclEntry);
        this.addGroup.remove(string);
        if (bl) {
            Cloneable cloneable;
            Vector vector = ((JetUser)jetAclEntry.getPrincipal()).getParentRoleNames();
            int n = vector == null ? 0 : vector.size();
            int n2 = 0;
            while (n2 < n) {
                cloneable = (JetRole)this.getRole((String)vector.elementAt(n2));
                ((JetRole)cloneable).removeSubUser(string);
                ++n2;
            }
            cloneable = ((JetUser)jetAclEntry.getPrincipal()).getGroupNames();
            n = cloneable == null ? 0 : ((Vector)cloneable).size();
            int n3 = 0;
            while (n3 < n) {
                JetGroup jetGroup = (JetGroup)this.getGroup((String)((Vector)cloneable).elementAt(n3));
                jetGroup.removeUser(string);
                ++n3;
            }
        }
        return true;
    }

    public boolean deleteRole(JetRole jetRole) {
        return this.deleteRole(jetRole.getName());
    }

    public boolean deleteRole(JetRole jetRole, boolean bl) {
        return this.deleteRole(jetRole.getName(), bl);
    }

    public boolean deleteRole(String string) {
        return this.deleteRole(string, false);
    }

    public boolean deleteRole(String string, boolean bl) {
        if (!this.addParentRole.containsKey(string)) {
            return false;
        }
        JetAclEntry jetAclEntry = (JetAclEntry)this.addParentRole.get(string);
        this.remove(jetAclEntry);
        this.addParentRole.remove(string);
        if (bl) {
            Object object;
            Vector vector = ((JetRole)jetAclEntry.getPrincipal()).getSubUserNames();
            int n = vector == null ? 0 : vector.size();
            int n2 = 0;
            while (n2 < n) {
                object = (JetUser)this.getUser((String)vector.elementAt(n2));
                ((JetUser)object).removeParentRole(string);
                ++n2;
            }
            object = ((JetRole)jetAclEntry.getPrincipal()).getGroupNames();
            n = object == null ? 0 : ((Vector)object).size();
            int n3 = 0;
            while (n3 < n) {
                JetGroup jetGroup = (JetGroup)this.getGroup((String)((Vector)object).elementAt(n3));
                jetGroup.removeRole(string);
                ++n3;
            }
        }
        return true;
    }

    public boolean deleteGroup(JetGroup jetGroup, boolean bl) {
        return this.deleteGroup(jetGroup.getName(), bl);
    }

    public boolean deleteGroup(String string) {
        return this.deleteGroup(string, false);
    }

    public boolean deleteGroup(String string, boolean bl) {
        if (!this.addRole.containsKey(string)) {
            return false;
        }
        JetAclEntry jetAclEntry = (JetAclEntry)this.addRole.get(string);
        this.remove(jetAclEntry);
        this.addRole.remove(string);
        if (bl) {
            Object object;
            Vector vector = ((JetGroup)jetAclEntry.getPrincipal()).getUserNames();
            int n = vector == null ? 0 : vector.size();
            int n2 = 0;
            while (n2 < n) {
                object = (JetUser)this.getUser((String)vector.elementAt(n2));
                ((JetUser)object).removeGroup(string);
                ++n2;
            }
            object = ((JetGroup)jetAclEntry.getPrincipal()).getRoleNames();
            n = object == null ? 0 : ((Vector)object).size();
            int n3 = 0;
            while (n3 < n) {
                JetRole jetRole = (JetRole)this.getRole((String)((Vector)object).elementAt(n3));
                jetRole.removeGroup(string);
                ++n3;
            }
        }
        return true;
    }

    public Vector getEntries() {
        return this.getChildren();
    }

    public Vector getPincipals() {
        Vector<JetPrincipal> vector = new Vector<JetPrincipal>(10);
        int n = this.addEntry.size();
        int n2 = 0;
        while (n2 < n) {
            JetAclEntry jetAclEntry = (JetAclEntry)this.addEntry.elementAt(n2);
            vector.add(jetAclEntry.getPrincipal());
            ++n2;
        }
        return vector;
    }

    public Vector getUsers() {
        Vector<JetPrincipal> vector = new Vector<JetPrincipal>(10);
        int n = this.addEntry.size();
        int n2 = 0;
        while (n2 < n) {
            JetAclEntry jetAclEntry = (JetAclEntry)this.addEntry.elementAt(n2);
            if (jetAclEntry.getPrincipal() instanceof JetUser) {
                vector.add(jetAclEntry.getPrincipal());
            }
            ++n2;
        }
        return vector;
    }

    public Vector getRoles() {
        Vector<JetPrincipal> vector = new Vector<JetPrincipal>(10);
        int n = this.addEntry.size();
        int n2 = 0;
        while (n2 < n) {
            JetAclEntry jetAclEntry = (JetAclEntry)this.addEntry.elementAt(n2);
            if (jetAclEntry.getPrincipal() instanceof JetRole) {
                vector.add(jetAclEntry.getPrincipal());
            }
            ++n2;
        }
        return vector;
    }

    public Vector getGroups() {
        Vector<JetPrincipal> vector = new Vector<JetPrincipal>();
        int n = this.addEntry.size();
        int n2 = 0;
        while (n2 < n) {
            JetAclEntry jetAclEntry = (JetAclEntry)this.addEntry.elementAt(n2);
            if (jetAclEntry.getPrincipal() instanceof JetGroup) {
                vector.add(jetAclEntry.getPrincipal());
            }
            ++n2;
        }
        return vector;
    }

    public Vector getServerUsers() {
        return this.getUsers(1);
    }

    public Vector getDefaultUsers() {
        return this.getUsers(2);
    }

    public Vector getServerRoles() {
        return this.getRoles(1);
    }

    public Vector getDefaultRoles() {
        return this.getRoles(2);
    }

    public Vector getServerGroups() {
        return this.getGroups(1);
    }

    public Vector getDefaultGroups() {
        return this.getGroups(2);
    }

    public Vector getUsers(int n) {
        Vector vector = this.getUsers();
        int n2 = vector.size();
        Vector<JetUser> vector2 = new Vector<JetUser>();
        int n3 = 0;
        while (n3 < n2) {
            JetUser jetUser = (JetUser)vector.elementAt(n3);
            if (jetUser.getSourceType() == n) {
                vector2.add(jetUser);
            }
            ++n3;
        }
        return vector2;
    }

    public Vector getRoles(int n) {
        Vector vector = this.getRoles();
        int n2 = vector.size();
        Vector<JetRole> vector2 = new Vector<JetRole>();
        int n3 = 0;
        while (n3 < n2) {
            JetRole jetRole = (JetRole)vector.elementAt(n3);
            if (jetRole.getSourceType() == n) {
                vector2.add(jetRole);
            }
            ++n3;
        }
        return vector2;
    }

    public Vector getGroups(int n) {
        Vector vector = this.getGroups();
        int n2 = vector.size();
        Vector<JetGroup> vector2 = new Vector<JetGroup>();
        int n3 = 0;
        while (n3 < n2) {
            JetGroup jetGroup = (JetGroup)vector.elementAt(n3);
            if (jetGroup.getSourceType() == n) {
                vector2.add(jetGroup);
            }
            ++n3;
        }
        return vector2;
    }

    public JetAclEntry getAclEntry(JetPrincipal jetPrincipal) {
        if (jetPrincipal == null) {
            return null;
        }
        if (jetPrincipal instanceof JetUser) {
            return this.getAclEntry((JetUser)jetPrincipal);
        }
        if (jetPrincipal instanceof JetRole) {
            return this.getAclEntry((JetRole)jetPrincipal);
        }
        if (jetPrincipal instanceof JetGroup) {
            return this.getAclEntry((JetGroup)jetPrincipal);
        }
        return null;
    }

    public JetAclEntry getAclEntry(JetUser jetUser) {
        if (jetUser == null) {
            return null;
        }
        return (JetAclEntry)this.addGroup.get(jetUser.getName());
    }

    public JetAclEntry getAclEntry(JetRole jetRole) {
        if (jetRole == null) {
            return null;
        }
        return (JetAclEntry)this.addParentRole.get(jetRole.getName());
    }

    public JetAclEntry getAclEntry(JetGroup jetGroup) {
        if (jetGroup == null) {
            return null;
        }
        return (JetAclEntry)this.addRole.get(jetGroup.getName());
    }

    public void removeAllEntries() {
        this.addEntry.removeAllElements();
        this.addGroup.clear();
        this.addParentRole.clear();
        this.addRole.clear();
    }

    public Hashtable getUserEntries() {
        return this.addGroup;
    }

    public Hashtable getRoleEntries() {
        return this.addParentRole;
    }

    public Hashtable getGroupEntries() {
        return this.addRole;
    }

    public JetObject add(JetObject jetObject) {
        if (jetObject instanceof JetAclEntry) {
            this.addEntry.add(jetObject);
            jetObject.setParent(this);
            return jetObject;
        }
        return null;
    }

    public JetObject remove(JetObject jetObject) {
        boolean bl = this.addEntry.removeElement(jetObject);
        if (bl) {
            jetObject.setParent(null);
            return jetObject;
        }
        return null;
    }

    public void broadcast(JetObject jetObject, int n) {
    }

    public Vector getChildren() {
        return this.addEntry;
    }

    public boolean isAdminUser(String string) {
        JetUser jetUser = (JetUser)this.getUser(string);
        if (jetUser == null) {
            return false;
        }
        if (jetUser.isAdmin()) {
            return true;
        }
        Vector vector = jetUser.getParentRoleNames();
        int n = vector == null ? 0 : vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.isAdminRole((String)vector.elementAt(n2))) {
                return true;
            }
            ++n2;
        }
        Vector vector2 = jetUser.getGroupNames();
        n = vector2 == null ? 0 : vector2.size();
        int n3 = 0;
        while (n3 < n) {
            if (this.isAdminGroup((String)vector2.elementAt(n3))) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean isAdminRole(String string) {
        JetRole jetRole = (JetRole)this.getRole(string);
        if (jetRole == null) {
            return false;
        }
        if (jetRole.isAdminRole()) {
            return true;
        }
        Vector vector = jetRole.getParentRoleNames();
        int n = vector == null ? 0 : vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.isAdminRole((String)vector.elementAt(n2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isAdminGroup(String string) {
        JetGroup jetGroup = (JetGroup)this.getGroup(string);
        if (jetGroup == null) {
            return false;
        }
        if (jetGroup.isAdminGroup()) {
            return true;
        }
        Vector vector = jetGroup.getParentGroupNames();
        int n = vector == null ? 0 : vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.isAdminGroup((String)vector.elementAt(n2))) {
                return true;
            }
            ++n2;
        }
        Vector vector2 = jetGroup.getRoleNames();
        n = vector2 == null ? 0 : vector2.size();
        int n3 = 0;
        while (n3 < n) {
            if (this.isAdminRole((String)vector2.elementAt(n3))) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean isAdminUser(String string, SecurityData securityData) {
        BaseUser baseUser = securityData.getUser(string);
        if (baseUser == null) {
            return false;
        }
        JetUser jetUser = (JetUser)this.getUser(string);
        if (jetUser == null) {
            return false;
        }
        if (jetUser.isAdmin()) {
            return true;
        }
        Vector vector = baseUser.getParentRoleNames();
        int n = vector == null ? 0 : vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.isAdminRole((String)vector.elementAt(n2), securityData)) {
                return true;
            }
            ++n2;
        }
        Vector vector2 = baseUser.getGroupNames();
        n = vector2 == null ? 0 : vector2.size();
        int n3 = 0;
        while (n3 < n) {
            if (this.isAdminGroup((String)vector2.elementAt(n3))) {
                return true;
            }
            ++n3;
        }
        Vector vector3 = jetUser.getParentRoleNames();
        n = vector3 == null ? 0 : vector3.size();
        int n4 = 0;
        while (n4 < n) {
            JetRole jetRole = (JetRole)this.getRole((String)vector3.elementAt(n4));
            if (jetRole != null && jetRole.getSourceType() == 2 && jetRole.isAdminRole()) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public boolean isAdminRole(String string, SecurityData securityData) {
        BaseRole baseRole = securityData.getRole(string);
        if (baseRole == null) {
            return false;
        }
        JetRole jetRole = (JetRole)this.getRole(string);
        if (jetRole == null) {
            return false;
        }
        if (jetRole.isAdminRole()) {
            return true;
        }
        Vector vector = baseRole.getParentRoleNames();
        int n = vector == null ? 0 : vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.isAdminRole((String)vector.elementAt(n2), securityData)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isAdminGroup(String string, SecurityData securityData) {
        BaseGroup baseGroup = securityData.getGroup(string);
        if (baseGroup == null) {
            return false;
        }
        JetGroup jetGroup = (JetGroup)this.getGroup(string);
        if (jetGroup == null) {
            return false;
        }
        if (jetGroup.isAdminGroup()) {
            return true;
        }
        Vector vector = baseGroup.getParentGroupNames();
        int n = vector == null ? 0 : vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.isAdminGroup((String)vector.elementAt(n2), securityData)) {
                return true;
            }
            ++n2;
        }
        Vector vector2 = baseGroup.getRoleNames();
        n = vector2 == null ? 0 : vector2.size();
        int n3 = 0;
        while (n3 < n) {
            if (this.isAdminRole((String)vector2.elementAt(n3), securityData)) {
                return true;
            }
            ++n3;
        }
        Vector vector3 = jetGroup.getRoleNames();
        n = vector3 == null ? 0 : vector3.size();
        int n4 = 0;
        while (n4 < n) {
            JetRole jetRole = (JetRole)this.getRole((String)vector3.elementAt(n4));
            if (jetRole != null && jetRole.getSourceType() == 2 && jetRole.isAdminRole()) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public boolean isAdmin(SecurityContext securityContext) {
        Vector vector = securityContext.getRoles();
        int n = vector == null ? 0 : vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetRole jetRole = (JetRole)this.getRole((String)vector.elementAt(n2));
            if (jetRole != null && jetRole.isAdminRole()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isHaveUser(String string) {
        return this.addGroup.get(string) != null;
    }

    public boolean isHaveRole(String string) {
        return this.addParentRole.get(string) != null;
    }

    public boolean isHaveGroup(String string) {
        return this.addRole.get(string) != null;
    }

    public BaseRole getRole(String string) {
        JetAclEntry jetAclEntry = (JetAclEntry)this.addParentRole.get(string);
        if (jetAclEntry == null) {
            return null;
        }
        return (JetRole)jetAclEntry.getPrincipal();
    }

    public BaseUser getUser(String string) {
        JetAclEntry jetAclEntry = (JetAclEntry)this.addGroup.get(string);
        if (jetAclEntry == null) {
            return null;
        }
        return (JetUser)jetAclEntry.getPrincipal();
    }

    public BaseGroup getGroup(String string) {
        JetAclEntry jetAclEntry = (JetAclEntry)this.addRole.get(string);
        if (jetAclEntry == null) {
            return null;
        }
        return (JetGroup)jetAclEntry.getPrincipal();
    }

    public String getInstancePrefix() {
        return "ACL";
    }

    public void afterInit() {
        super.afterInit();
        int n = this.addEntry.size();
        int n2 = 0;
        while (n2 < n) {
            JetAclEntry jetAclEntry = (JetAclEntry)this.addEntry.elementAt(n2);
            JetPrincipal jetPrincipal = jetAclEntry.getPrincipal();
            if (jetPrincipal instanceof JetUser) {
                this.addGroup.put(((JetUser)jetPrincipal).getName(), jetAclEntry);
            }
            if (jetPrincipal instanceof JetRole) {
                this.addParentRole.put(((JetRole)jetPrincipal).getName(), jetAclEntry);
            }
            if (jetPrincipal instanceof JetGroup) {
                this.addRole.put(((JetGroup)jetPrincipal).getName(), jetAclEntry);
            }
            ++n2;
        }
    }

    public JetAcl copy() {
        return (JetAcl)this.clone();
    }

    public Object clone() {
        JetAcl jetAcl = new JetAcl();
        jetAcl.setName(this.getName());
        jetAcl.setRLSValid(this.isValidRLS());
        jetAcl.setCLSValid(this.isValidCLS());
        int n = this.addEntry.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)this.addEntry.elementAt(n2);
            if (jetObject instanceof JetAclEntry) {
                jetAcl.add(((JetAclEntry)jetObject).copy());
            }
            ++n2;
        }
        jetAcl.afterInit();
        return jetAcl;
    }

    public String refreshFromServer(String string, String string2, String string3, String string4, String string5) throws ACLException {
        return this.refreshFromServer(string, string2, string3, string4, string5, 1, 1);
    }

    public String refreshFromServer(String string, String string2, String string3, String string4, String string5, int n) throws ACLException {
        return this.refreshFromServer(string, string2, string3, string4, string5, 1, n);
    }

    public String refreshFromServer(String string, String string2, String string3, String string4, String string5, int n, int n2) throws ACLException {
        String string6 = new String("http://" + string + ":" + string2);
        Vector[] vectorArray = null;
        try {
            ClientConnector clientConnector = new ClientConnector(string6, string3, string4, string5);
            vectorArray = clientConnector.getUsersAndRolesInfo();
        }
        catch (Exception exception) {
            throw new ACLException(exception.getMessage());
        }
        if (vectorArray != null) {
            this.refreshPrincipal(vectorArray, n, n2);
        }
        return null;
    }

    public boolean refreshPrincipal(Vector[] vectorArray, int n, int n2) {
        if (vectorArray.length != 3) {
            return false;
        }
        Vector vector = vectorArray[0];
        Vector vector2 = vectorArray[1];
        Vector vector3 = vectorArray[2];
        switch (n) {
            case 1: {
                return this.add(vector, vector2, vector3, n2);
            }
            case 2: {
                return this.QOIV(vector, vector2, vector3);
            }
        }
        return false;
    }

    private boolean QOIV(Vector vector, Vector vector2, Vector vector3) {
        this.removeAllEntries();
        int n = vector == null ? 0 : vector.size();
        int n2 = 0;
        while (n2 < n) {
            JetUser jetUser = this.addEntry((BaseUser)vector.elementAt(n2));
            this.addUser(jetUser);
            ++n2;
        }
        int n3 = vector2 == null ? 0 : vector2.size();
        int n4 = 0;
        while (n4 < n3) {
            JetRole jetRole = this.addUser((BaseRole)vector2.elementAt(n4));
            this.addRole(jetRole);
            ++n4;
        }
        int n5 = vector3 == null ? 0 : vector3.size();
        int n6 = 0;
        while (n6 < n5) {
            JetGroup jetGroup = this.addParentRole((BaseGroup)vector3.elementAt(n6));
            this.addGroup(jetGroup);
            ++n6;
        }
        return true;
    }

    private boolean add(Vector vector, Vector vector2, Vector vector3, int n) {
        JetRole jetRole;
        JetGroup jetGroup;
        JetUser jetUser;
        if (n != 1 && n != 2) {
            return false;
        }
        boolean bl = false;
        Vector<String> vector4 = new Vector<String>();
        Vector vector5 = new Vector();
        int n2 = vector == null ? 0 : vector.size();
        BaseUser baseUser = null;
        int n3 = 0;
        while (n3 < n2) {
            baseUser = (BaseUser)vector.elementAt(n3);
            if (this.addGroup.containsKey(baseUser.getName())) {
                jetUser = (JetUser)this.getUser(baseUser.getName());
                if (jetUser.getSourceType() != 1) {
                    if (n == 1) {
                        this.deleteUser(jetUser, true);
                        this.addUser(this.addEntry(baseUser));
                    } else if (n == 2) {
                        this.addGroup(jetUser, baseUser);
                    }
                } else {
                    this.addGroup(jetUser, baseUser);
                }
            } else {
                jetUser = this.addEntry(baseUser);
                this.addUser(jetUser);
            }
            vector4.addElement(baseUser.getName());
            bl = true;
            ++n3;
        }
        vector5 = this.getServerUsers();
        n2 = vector5.size();
        int n4 = 0;
        while (n4 < n2) {
            jetUser = (JetUser)vector5.elementAt(n4);
            if (!vector4.contains(jetUser.getName())) {
                this.deleteUser(jetUser, true);
            }
            ++n4;
        }
        vector4.clear();
        vector5.removeAllElements();
        n2 = vector3 == null ? 0 : vector3.size();
        BaseGroup baseGroup = null;
        int n5 = 0;
        while (n5 < n2) {
            baseGroup = (BaseGroup)vector3.elementAt(n5);
            if (this.addRole.containsKey(baseGroup.getName())) {
                jetGroup = (JetGroup)this.getGroup(baseGroup.getName());
                if (jetGroup.getSourceType() != 1) {
                    if (n == 1) {
                        this.deleteGroup(jetGroup, true);
                        this.addGroup(this.addParentRole(baseGroup));
                    } else if (n == 2) {
                        this.addRole(jetGroup, baseGroup);
                    }
                } else {
                    this.addRole(jetGroup, baseGroup);
                }
            } else {
                jetGroup = this.addParentRole(baseGroup);
                this.addGroup(jetGroup);
            }
            vector4.addElement(baseGroup.getName());
            bl = true;
            ++n5;
        }
        vector5 = this.getServerGroups();
        n2 = vector5.size();
        int n6 = 0;
        while (n6 < n2) {
            jetGroup = (JetGroup)vector5.elementAt(n6);
            if (!vector4.contains(jetGroup.getName())) {
                this.deleteGroup(jetGroup, true);
            }
            ++n6;
        }
        vector4.clear();
        vector5.removeAllElements();
        n2 = vector2 == null ? 0 : vector2.size();
        BaseRole baseRole = null;
        int n7 = 0;
        while (n7 < n2) {
            baseRole = (BaseRole)vector2.elementAt(n7);
            if (this.addParentRole.containsKey(baseRole.getName())) {
                jetRole = (JetRole)this.getRole(baseRole.getName());
                if (jetRole.getSourceType() != 1) {
                    if (n == 1) {
                        this.deleteRole(jetRole);
                        this.addRole(this.addUser(baseRole));
                    } else if (n == 2) {
                        this.afterInit(jetRole, baseRole);
                    }
                } else {
                    this.afterInit(jetRole, baseRole);
                }
            } else {
                jetRole = this.addUser(baseRole);
                this.addRole(jetRole);
            }
            vector4.addElement(baseRole.getName());
            bl = true;
            ++n7;
        }
        vector5 = this.getServerRoles();
        n2 = vector5.size();
        int n8 = 0;
        while (n8 < n2) {
            jetRole = (JetRole)vector5.elementAt(n8);
            if (!vector4.contains(jetRole.getName())) {
                this.deleteRole(jetRole);
            }
            ++n8;
        }
        this.addElement();
        return bl;
    }

    private void addElement() {
        int n;
        JetGroup jetGroup;
        int n2;
        JetRole jetRole;
        int n3;
        int n4;
        JetUser jetUser;
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        vector = this.getUsers(2);
        int n5 = vector.size();
        int n6 = 0;
        while (n6 < n5) {
            jetUser = (JetUser)vector.elementAt(n6);
            vector4 = jetUser.getParentRoleNames();
            n4 = vector4.size();
            n3 = 0;
            while (n3 < n4) {
                jetRole = (JetRole)this.getRole((String)vector4.elementAt(n3));
                if (jetRole != null && jetRole.getSourceType() == 1) {
                    jetUser.removeParentRole(jetRole.getName());
                    --n4;
                    --n3;
                }
                ++n3;
            }
            vector4 = jetUser.getGroupNames();
            n4 = vector4.size();
            n2 = 0;
            while (n2 < n4) {
                jetGroup = (JetGroup)this.getGroup((String)vector4.elementAt(n2));
                if (jetGroup != null && jetGroup.getSourceType() == 1) {
                    jetUser.removeGroup(jetGroup.getName());
                    --n4;
                    --n2;
                }
                ++n2;
            }
            ++n6;
        }
        vector3 = this.getGroups(2);
        n5 = vector3.size();
        n3 = 0;
        while (n3 < n5) {
            jetGroup = (JetGroup)vector3.elementAt(n3);
            vector4 = jetGroup.getRoleNames();
            n4 = vector4.size();
            n2 = 0;
            while (n2 < n4) {
                jetRole = (JetRole)this.getRole((String)vector4.elementAt(n2));
                if (jetRole != null && jetRole.getSourceType() == 1) {
                    jetGroup.removeRole(jetRole.getName());
                    --n4;
                    --n2;
                }
                ++n2;
            }
            vector4 = jetGroup.getUserNames();
            n4 = vector4.size();
            n = 0;
            while (n < n4) {
                jetUser = (JetUser)this.getUser((String)vector4.elementAt(n));
                if (jetUser != null && jetUser.getSourceType() == 1) {
                    jetGroup.removeUser(jetUser.getName());
                    --n4;
                    --n;
                }
                ++n;
            }
            ++n3;
        }
        vector2 = this.getRoles(2);
        n5 = vector2.size();
        n2 = 0;
        while (n2 < n5) {
            jetRole = (JetRole)vector2.elementAt(n2);
            vector4 = jetRole.getSubUserNames();
            n4 = vector4.size();
            n = 0;
            while (n < n4) {
                jetUser = (JetUser)this.getUser((String)vector4.elementAt(n));
                if (jetUser.getSourceType() == 1) {
                    jetUser.addParentRole(jetRole.getName());
                }
                ++n;
            }
            vector4 = jetRole.getGroupNames();
            n4 = vector4.size();
            int n7 = 0;
            while (n7 < n4) {
                jetGroup = (JetGroup)this.getGroup((String)vector4.elementAt(n7));
                if (jetGroup.getSourceType() == 1) {
                    jetGroup.addRole(jetRole.getName());
                }
                ++n7;
            }
            ++n2;
        }
    }

    private JetUser addEntry(BaseUser baseUser) {
        JetUser jetUser = new JetUser();
        jetUser.setName(baseUser.getName());
        jetUser.setEmail(baseUser.getEmail());
        jetUser.setRoles(baseUser.getParentRoleNames());
        jetUser.setSourceType(1);
        jetUser.setGroups(baseUser.getGroupNames());
        return jetUser;
    }

    private void addGroup(JetUser jetUser, BaseUser baseUser) {
        jetUser.setSourceType(1);
        jetUser.setName(baseUser.getName());
        jetUser.setEmail(baseUser.getEmail());
        jetUser.setRoles(baseUser.getParentRoleNames());
        jetUser.setGroups(baseUser.getGroupNames());
    }

    private JetGroup addParentRole(BaseGroup baseGroup) {
        JetGroup jetGroup = new JetGroup();
        jetGroup.setName(baseGroup.getName());
        jetGroup.setSourceType(1);
        jetGroup.setUsers(baseGroup.getUserNames());
        jetGroup.setParentGroups(baseGroup.getParentGroupNames());
        jetGroup.setSubGroups(baseGroup.getSubGroupNames());
        jetGroup.setRoles(baseGroup.getRoleNames());
        return jetGroup;
    }

    private void addRole(JetGroup jetGroup, BaseGroup baseGroup) {
        jetGroup.setName(baseGroup.getName());
        jetGroup.setSourceType(1);
        jetGroup.setUsers(baseGroup.getUserNames());
        jetGroup.setParentGroups(baseGroup.getParentGroupNames());
        jetGroup.setSubGroups(baseGroup.getSubGroupNames());
        jetGroup.setRoles(baseGroup.getRoleNames());
    }

    private JetRole addUser(BaseRole baseRole) {
        JetRole jetRole = new JetRole();
        jetRole.setName(baseRole.getName());
        jetRole.setSourceType(1);
        jetRole.setUsers(baseRole.getSubUserNames());
        jetRole.setParentRoles(baseRole.getParentRoleNames());
        jetRole.setSubRoles(baseRole.getSubRoleNames());
        jetRole.setGroups(baseRole.getGroupNames());
        return jetRole;
    }

    private void afterInit(JetRole jetRole, BaseRole baseRole) {
        jetRole.setName(baseRole.getName());
        jetRole.setSourceType(1);
        jetRole.setUsers(baseRole.getSubUserNames());
        jetRole.setParentRoles(baseRole.getParentRoleNames());
        jetRole.setSubRoles(baseRole.getSubRoleNames());
        jetRole.setGroups(baseRole.getGroupNames());
    }

    public JAclImpl createAclImpl(BaseUser baseUser) throws NotOwnerException {
        return this.createAclImpl(baseUser, this, 0);
    }

    public JAclImpl createAclImpl(BaseUser baseUser, SecurityData securityData, int n) throws NotOwnerException {
        JAclImpl jAclImpl;
        block13: {
            JAclEntryImpl jAclEntryImpl;
            JetAclEntry jetAclEntry;
            JetUser jetUser;
            block12: {
                if (baseUser == null) {
                    return null;
                }
                jetUser = new JetUser();
                jAclImpl = new JAclImpl(jetUser, this.getName(), securityData);
                jetAclEntry = (JetAclEntry)this.addGroup.get(baseUser.getName());
                if (jetAclEntry != null) {
                    switch (n) {
                        case 0: {
                            jAclEntryImpl = jetAclEntry.createAclEntryImpl(baseUser, securityData);
                            jAclImpl.addEntry(jetUser, jAclEntryImpl);
                            break;
                        }
                        case 1: {
                            if (jetAclEntry.getPrincipal().getSourceType() != 1) break;
                            jAclEntryImpl = jetAclEntry.createAclEntryImpl(baseUser, securityData);
                            jAclImpl.addEntry(jetUser, jAclEntryImpl);
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                }
                if (n != 0 && n != 1) break block12;
                Vector vector = baseUser.getParentRoleNames();
                int n2 = vector == null ? 0 : vector.size();
                int n3 = 0;
                while (n3 < n2) {
                    BaseRole baseRole = securityData.getRole((String)vector.elementAt(n3));
                    if (baseRole != null) {
                        this.clear(jetUser, jAclImpl, baseRole, securityData, n);
                    }
                    ++n3;
                }
                Vector vector2 = baseUser.getGroupNames();
                n2 = vector2 == null ? 0 : vector2.size();
                int n4 = 0;
                while (n4 < n2) {
                    BaseGroup baseGroup = securityData.getGroup((String)vector2.elementAt(n4));
                    if (baseGroup != null) {
                        this.append(jetUser, jAclImpl, baseGroup, securityData, n);
                    }
                    ++n4;
                }
                break block13;
            }
            if (n != 2) break block13;
            Vector vector = this.clearMem(baseUser.getName());
            int n5 = vector == null ? 0 : vector.size();
            int n6 = 0;
            while (n6 < n5) {
                jetAclEntry = (JetAclEntry)vector.elementAt(n6);
                jAclEntryImpl = jetAclEntry.createAclEntryImpl((JetRole)jetAclEntry.getPrincipal(), securityData);
                jAclImpl.addEntry(jetUser, jAclEntryImpl);
                ++n6;
            }
        }
        return jAclImpl;
    }

    private void append(Principal principal, JAclImpl jAclImpl, BaseGroup baseGroup, SecurityData securityData, int n) throws NotOwnerException {
        Vector vector;
        JetAclEntry jetAclEntry = (JetAclEntry)this.addRole.get(baseGroup.getName());
        if (jetAclEntry != null) {
            switch (n) {
                case 0: {
                    JAclEntryImpl jAclEntryImpl = jetAclEntry.createAclEntryImpl(baseGroup, securityData);
                    jAclImpl.addEntry(principal, jAclEntryImpl);
                    break;
                }
                case 1: {
                    if (jetAclEntry.getPrincipal().getSourceType() != 1) break;
                    JAclEntryImpl jAclEntryImpl = jetAclEntry.createAclEntryImpl(baseGroup, securityData);
                    jAclImpl.addEntry(principal, jAclEntryImpl);
                    break;
                }
            }
        }
        int n2 = (vector = baseGroup.getParentGroupNames()) == null ? 0 : vector.size();
        int n3 = 0;
        while (n3 < n2) {
            BaseGroup baseGroup2 = securityData.getGroup((String)vector.elementAt(n3));
            if (baseGroup2 != null) {
                this.append(principal, jAclImpl, baseGroup2, securityData, n);
            }
            ++n3;
        }
        Vector vector2 = baseGroup.getRoleNames();
        n2 = vector2 == null ? 0 : vector2.size();
        int n4 = 0;
        while (n4 < n2) {
            BaseRole baseRole = securityData.getRole((String)vector2.elementAt(n4));
            if (baseRole != null) {
                this.clear(principal, jAclImpl, baseRole, securityData, n);
            }
            ++n4;
        }
    }

    private void clear(Principal principal, JAclImpl jAclImpl, BaseRole baseRole, SecurityData securityData, int n) throws NotOwnerException {
        Vector vector;
        JetAclEntry jetAclEntry = (JetAclEntry)this.addParentRole.get(baseRole.getName());
        if (jetAclEntry != null) {
            switch (n) {
                case 0: {
                    JAclEntryImpl jAclEntryImpl = jetAclEntry.createAclEntryImpl(baseRole, securityData);
                    jAclImpl.addEntry(principal, jAclEntryImpl);
                    break;
                }
                case 1: {
                    if (jetAclEntry.getPrincipal().getSourceType() != 1) break;
                    JAclEntryImpl jAclEntryImpl = jetAclEntry.createAclEntryImpl(baseRole, securityData);
                    jAclImpl.addEntry(principal, jAclEntryImpl);
                    break;
                }
            }
        }
        int n2 = (vector = baseRole.getParentRoleNames()) == null ? 0 : vector.size();
        int n3 = 0;
        while (n3 < n2) {
            BaseRole baseRole2 = securityData.getRole((String)vector.elementAt(n3));
            if (baseRole2 != null) {
                this.clear(principal, jAclImpl, baseRole2, securityData, n);
            }
            ++n3;
        }
    }

    private Vector clearMem(String string) {
        JetAclEntry jetAclEntry = (JetAclEntry)this.addGroup.get(string);
        if (jetAclEntry == null) {
            return null;
        }
        JetUser jetUser = (JetUser)jetAclEntry.getPrincipal();
        if (jetUser.getSourceType() != 1) {
            return null;
        }
        Vector<JetAclEntry> vector = new Vector<JetAclEntry>();
        Vector vector2 = jetUser.getParentRoleNames();
        int n = vector2 == null ? 0 : vector2.size();
        int n2 = 0;
        while (n2 < n) {
            JetRole jetRole;
            jetAclEntry = (JetAclEntry)this.addParentRole.get((String)vector2.elementAt(n2));
            if (jetAclEntry != null && (jetRole = (JetRole)jetAclEntry.getPrincipal()).getSourceType() == 2) {
                vector.add(jetAclEntry);
            }
            ++n2;
        }
        return vector;
    }

    public void setNamingTable(Hashtable hashtable) {
        this.addUser = hashtable;
    }

    public Hashtable getNamingTable() {
        return this.addUser;
    }

    public void setNamingCount(Hashtable hashtable) {
        this.afterInit = hashtable;
    }

    public Hashtable getNamingCount() {
        if (this.afterInit == null) {
            this.afterInit = new Hashtable();
        }
        return this.afterInit;
    }

    public void clearMem() {
        JetObject jetObject;
        this.addUser.clear();
        TreeIterater treeIterater = new TreeIterater(this, true);
        while ((jetObject = (JetObject)treeIterater.next()) != null) {
            jetObject.delete();
        }
    }

    public synchronized int getRefCount() {
        return this.append;
    }

    public synchronized void refer() {
        ++this.append;
    }

    public synchronized void free() {
        if (this.append > 0) {
            --this.append;
        }
        if (!this.clear && this.append == 0) {
            this.clearMem();
        }
    }

    public void setCached(boolean bl) {
        this.clear = bl;
    }

    public boolean isCached() {
        return this.clear;
    }

    public void setVersion(int n) {
        this.clearMem = n;
    }

    public int getVersion() {
        return this.clearMem;
    }

    public static void exportToXML(JetAcl jetAcl, String string) throws ACLException {
        try {
            ObjectToXML objectToXML = new ObjectToXML(jetAcl, string);
        }
        catch (Exception exception) {
            throw new ACLException(exception.getMessage());
        }
    }

    public static JetAcl importXML(String string) throws ACLException {
        JetAcl jetAcl = null;
        try {
            jetAcl = (JetAcl)XMLToObject.toObject(string);
        }
        catch (Exception exception) {
            throw new ACLException(exception.getMessage());
        }
        return jetAcl;
    }

    public static JetAcl importTxt(String string) throws ACLException {
        JetAcl jetAcl = null;
        try {
            jetAcl = AclTextReader.readAcl(string);
        }
        catch (Exception exception) {
            throw new ACLException(exception.getMessage());
        }
        return jetAcl;
    }

    public boolean equalsTo(JetAcl jetAcl) {
        JetAclEntry jetAclEntry;
        JetAclEntry jetAclEntry2;
        Hashtable hashtable = jetAcl.getUserEntries();
        Hashtable hashtable2 = jetAcl.getRoleEntries();
        Hashtable hashtable3 = jetAcl.getGroupEntries();
        if (this.isValidRLS() != jetAcl.isValidRLS() || this.isValidCLS() != jetAcl.isValidCLS()) {
            return false;
        }
        if (this.addGroup.size() != hashtable.size() || this.addParentRole.size() != hashtable2.size() || this.addRole.size() != hashtable3.size()) {
            return false;
        }
        String string = null;
        Set set = null;
        Iterator iterator = null;
        set = this.addGroup.keySet();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            jetAclEntry2 = (JetAclEntry)this.addGroup.get(string);
            jetAclEntry = (JetAclEntry)hashtable.get(string);
            if (jetAclEntry != null && jetAclEntry2.equalsTo(jetAclEntry)) continue;
            return false;
        }
        set = this.addRole.keySet();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            jetAclEntry2 = (JetAclEntry)this.addRole.get(string);
            jetAclEntry = (JetAclEntry)hashtable3.get(string);
            if (jetAclEntry != null && jetAclEntry2.equalsTo(jetAclEntry)) continue;
            return false;
        }
        set = this.addParentRole.keySet();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            jetAclEntry2 = (JetAclEntry)this.addParentRole.get(string);
            jetAclEntry = (JetAclEntry)hashtable2.get(string);
            if (jetAclEntry != null && jetAclEntry2.equalsTo(jetAclEntry)) continue;
            return false;
        }
        return true;
    }

    public HashMap getIndecialMap() {
        return clone;
    }

    private void contains() {
        this.QOIV = new JetBoolean(this, "IsNotValidRLS");
        this.add = new JetBoolean(this, "IsValidCLS");
    }

    static {
        int n = 0;
        clone.put("IsValidCLS", new Integer(n++));
        clone.put("IsNotValidRLS", new Integer(n++));
    }
}

