/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.util.JRLog;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jet.datastream.Communicator;
import jet.ie.CLSInfo;
import jet.ie.IV7ResultSetReader;
import jet.ie.RSDCLSInfos;
import jet.ie.RSDPermissions;
import jet.ie.RSDTools;
import jet.ie.RSTLoadControler;
import jet.ie.UpgradeToV8RsdUtil;
import jet.ie.VersionException;
import jet.ie.io.PJFDataInput;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUUniverse;
import jet.util.RandomInputable;

public abstract class AbstractRSDLoader {
    public static final String REPORTNAME = "ReportNames";
    public static final String REPORTINFOS = "ReportInfos";
    public static final String DATASETINFOS = "DatasetInfos";
    public static final String RESULTSETS = "ResultSets";
    public static final String REPORTSETS = "ReportSets";
    public static final String PARAMETERS = "Parameters";
    public static final String UNIVERSE = "Universe";
    public static final String BINDINFO = "BindInfo";
    public static final String INDEXINFO = "IndexInfo";
    public static final String PRECISION = "Precision";
    public static final String PERMISSION = "Permission";
    public static final String CLSINFOS = "CLSInfo";
    protected String _fileName = "";
    protected RandomInputable _raf;
    protected PJFDataInput _in;
    protected RSDTools _rsdTools;
    protected int _versionNumber;
    protected String[] _reportNames;
    protected JetRptReportSet[] jrReportSet;
    protected Hashtable _dataSetInfo;
    protected JetUUniverse _universe;
    protected Hashtable reportPanelAddressTable;
    protected Hashtable reportSetAddressTable;
    protected Hashtable addressTable;
    protected Hashtable _reportSet;
    protected Map _parameter;
    protected Hashtable _rptInfos;
    protected boolean _isZip;
    protected String _id;
    protected String _flag;
    protected Hashtable _precisions;
    protected RSDCLSInfos _clsInfos;
    protected RSDPermissions _permissions;
    protected UpgradeToV8RsdUtil _upgradeTool;
    protected IV7ResultSetReader rstReader;
    protected RSTLoadControler _rstLoader = null;
    protected int bufferSize = 4096;

    public abstract void openFile() throws VersionException;

    protected abstract void loadHeader() throws VersionException;

    public int getVersionNumber() {
        return this._versionNumber;
    }

    public String getUserID() {
        return this._id;
    }

    public synchronized String[] getReportNames() throws VersionException {
        if (this._reportNames == null) {
            Long l = (Long)this.addressTable.get(REPORTNAME);
            try {
                this._raf.seek(l);
                this._reportNames = this._rsdTools.loadReportNames(this._raf);
            }
            catch (IOException iOException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2407307, (Throwable)iOException);
                }
                throw new VersionException(407307, (Throwable)iOException);
            }
        }
        return this._reportNames;
    }

    protected Hashtable loadRptInfo() throws VersionException {
        Long l = (Long)this.addressTable.get(REPORTINFOS);
        try {
            this._raf.seek(l);
            return this._rsdTools.loadRptInfo(this._raf);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407309, (Throwable)iOException);
            }
            throw new VersionException(407309, (Throwable)iOException);
        }
    }

    public synchronized Map getRptInfo(int n) throws VersionException {
        if (this._versionNumber < 131073) {
            return this._upgradeTool.getReportInfo(n);
        }
        return (Map)this._rptInfos.get(new Integer(n));
    }

    public synchronized Vector getDataSetInfo(int n) throws VersionException {
        if (this._versionNumber < 131073) {
            return this._upgradeTool.getDataSetInfo(n);
        }
        return (Vector)this._dataSetInfo.get(new Integer(n));
    }

    protected Hashtable loadDataSetInfo() throws VersionException {
        Long l = (Long)this.addressTable.get(DATASETINFOS);
        try {
            this._raf.seek(l);
            return this._rsdTools.loadDataSetInfo(this._raf);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407313, (Throwable)iOException);
            }
            throw new VersionException(407313, (Throwable)iOException);
        }
    }

    public synchronized String[][] getBindInfo(int n, String string) throws VersionException {
        if (this._versionNumber < 131073) {
            try {
                return this._upgradeTool.getBindInfo(n, string);
            }
            catch (SQLException sQLException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2407314, (Throwable)sQLException);
                }
                throw new VersionException(407314, (Throwable)sQLException);
            }
        }
        Long l = (Long)this.addressTable.get(BINDINFO);
        try {
            this._raf.seek(l);
            Hashtable hashtable = this._rsdTools.loadBindInfo(this._raf);
            return (String[][])hashtable.get(this._rsdTools.getKey(n, string));
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407314, (Throwable)iOException);
            }
            throw new VersionException(407314, (Throwable)iOException);
        }
    }

    public synchronized Map getParameters() throws VersionException {
        if (this._parameter == null) {
            long l = (Long)this.addressTable.get(PARAMETERS);
            try {
                this._raf.seek(l);
                if (this._raf.readBoolean()) {
                    return null;
                }
                this._parameter = this._rsdTools.loadparameter(this._raf, this._versionNumber);
            }
            catch (IOException iOException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2407312, (Throwable)iOException);
                }
                throw new VersionException(407312, (Throwable)iOException);
            }
        }
        return this._parameter;
    }

    protected Hashtable getPrecisions() throws VersionException {
        try {
            Hashtable hashtable = new Hashtable();
            Long l = (Long)this.addressTable.get(PRECISION);
            this._raf.seek(l);
            hashtable = this._rsdTools.readPrecision(this._raf);
            return hashtable;
        }
        catch (Exception exception) {
            throw new VersionException(exception);
        }
    }

    public synchronized boolean getPrecision(String string, String string2) throws VersionException {
        if (this._versionNumber >= 131329) {
            String string3 = string.length() + string + string2.length() + string2;
            Boolean bl = (Boolean)this._precisions.get(string3);
            return bl;
        }
        Communicator communicator = this._rstLoader.getCommunicator(string, string2);
        return communicator.isHighPrecision();
    }

    protected RSDCLSInfos getClsInfos() throws VersionException {
        try {
            Long l = (Long)this.addressTable.get(CLSINFOS);
            this._raf.seek(l);
            RSDCLSInfos rSDCLSInfos = new RSDCLSInfos();
            rSDCLSInfos.load(this._raf);
            return rSDCLSInfos;
        }
        catch (Exception exception) {
            throw new VersionException(exception);
        }
    }

    public synchronized CLSInfo getCLSInfos(int n, String string) {
        if (this._clsInfos == null) {
            return null;
        }
        return this._clsInfos.getClsInfo(n, string);
    }

    protected synchronized RSDPermissions getPermissions() throws VersionException {
        try {
            Long l = (Long)this.addressTable.get(PERMISSION);
            this._raf.seek(l);
            RSDPermissions rSDPermissions = new RSDPermissions();
            rSDPermissions.load(this._raf);
            return rSDPermissions;
        }
        catch (Exception exception) {
            throw new VersionException(exception);
        }
    }

    public String[] getBCRCPermissionNames(int n) {
        if (this._permissions == null) {
            return null;
        }
        return this._permissions.getPermissionNames(n);
    }

    protected JetRptReportSet getReportSet(int n, boolean bl) throws VersionException {
        JetRptReportSet jetRptReportSet = new JetRptReportSet();
        if (this._versionNumber < 131073) {
            try {
                if (n == 0) {
                    long l = (Long)this.reportPanelAddressTable.get(new Integer(0));
                    this._raf.seek(l);
                    this._raf.readInt();
                    ArrayList arrayList = this._rsdTools.loadSelfContainPanelToReportSet(this._in);
                    jetRptReportSet = (JetRptReportSet)arrayList.get(0);
                    return jetRptReportSet;
                }
                long l = (Long)this.reportPanelAddressTable.get(new Integer(n));
                this._raf.seek(l);
                jetRptReportSet = bl ? this._rsdTools.loadPanelToReportSet(this._in) : this._upgradeTool.getReportSet(n);
                return jetRptReportSet;
            }
            catch (Exception exception) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2407306, (Throwable)exception);
                }
                throw new VersionException(407306, (Throwable)exception);
            }
        }
        Long l = (Long)this.reportSetAddressTable.get(String.valueOf(n));
        try {
            JetRptReportSet jetRptReportSet2;
            this._raf.seek(l);
            if (this._versionNumber < 131329) {
                this._in.readInt();
            }
            jetRptReportSet = jetRptReportSet2 = this._rsdTools.loadRptReportSet(this._in);
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407306, (Throwable)exception);
            }
            throw new VersionException(407306, (Throwable)exception);
        }
        return jetRptReportSet;
    }

    public synchronized JetRptReportSet getReportSet(int n) throws VersionException {
        if (this.jrReportSet != null) {
            if (this.jrReportSet[n] == null) {
                this.jrReportSet[n] = this.getReportSet(n, false);
                this.jrReportSet[n].setCached(true);
            }
            this.jrReportSet[n].refer();
            return this.jrReportSet[n];
        }
        return null;
    }

    public abstract void clear() throws IOException;

    protected Hashtable readAddressTable() throws VersionException {
        try {
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
            int n = this._raf.readInt();
            int n2 = 0;
            while (n2 < n) {
                String string = this._raf.readUTF();
                Long l = new Long(this._raf.readLong());
                hashtable.put(string, l);
                ++n2;
            }
            return hashtable;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407303, (Throwable)iOException);
            }
            throw new VersionException(407303, (Throwable)iOException);
        }
    }

    protected Hashtable readSubBlockAddressTableH(String string) throws VersionException {
        try {
            Long l = (Long)this.addressTable.get(string);
            if (l == null) {
                return null;
            }
            long l2 = l;
            this._raf.seek(l2);
            long l3 = this._raf.readLong();
            this._raf.seek(l3);
            int n = this._raf.readInt();
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>(n);
            int n2 = 0;
            while (n2 < n) {
                String string2 = this._raf.readUTF();
                hashtable.put(string2, new Long(this._raf.readLong()));
                ++n2;
            }
            return hashtable;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407304, (Throwable)iOException);
            }
            throw new VersionException(407304, (Throwable)iOException);
        }
    }
}

