/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import com.jinfonet.util.JRLog;
import java.awt.Image;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import jet.Env;
import jet.ReportEnv;
import jet.controls.JetBoolean;
import jet.controls.JetColumnName;
import jet.controls.JetColumnable;
import jet.controls.JetFont;
import jet.controls.JetImgProperty;
import jet.controls.JetImgVector;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetRootable;
import jet.controls.JetString;
import jet.controls.JetStringList;
import jet.controls.JetVector;
import jet.exception.InvalidParameterException;
import jet.jetc.LoaderNoCache;
import jet.jetc.ReadFailureException;
import jet.log.JRLogger;
import jet.naming.PropertyNameConstant;
import jet.report.JRObjectTemplate;
import jet.report.JetLink;
import jet.report.JetRptDBField;
import jet.report.JetRptDataSource;
import jet.report.JetRptField;
import jet.report.JetRptMap;
import jet.report.JetRptParameterField;
import jet.report.JetRptPicture;
import jet.report.JetRptReportPanel;
import jet.report.JetRptSubReport;
import jet.report.ole.JetRptOLEObject;
import jet.reportset.DataSet;
import jet.reportset.JetRptQueryDataSet;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptservice.util.ReportTools;
import jet.universe.JetUDatabase;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUUniverse;
import jet.util.FileUtil;
import jet.util.FontSets;
import jet.util.ImageLoader;
import jet.util.NLSResourceBundle;
import jet.util.TreeIterater;
import jet.util.WildcardMatcher;

public class JReportUtil {
    private static int CLS_FILE_EXTENSION = 0;
    public static final int IRT_SUBREPORT = CLS_FILE_EXTENSION++;
    public static final int IRT_IMAGE = CLS_FILE_EXTENSION++;
    public static final int IRT_FONT = CLS_FILE_EXTENSION++;
    public static final int IRT_STYLEGROUP = CLS_FILE_EXTENSION++;
    public static final int IRT_NLSPROP = CLS_FILE_EXTENSION++;
    public static final int IRT_XSDRES = CLS_FILE_EXTENSION++;
    public static final int IRT_DETAILREPORT = CLS_FILE_EXTENSION++;
    public static final int NUMOFIRT = CLS_FILE_EXTENSION;

    public static Vector[] getInternalResource(JetRptReportPanel jetRptReportPanel) {
        return JReportUtil.getInternalResource(jetRptReportPanel, null, null);
    }

    public static Vector[] getInternalResource(JetRptReportSet jetRptReportSet) {
        return JReportUtil.getInternalResource(jetRptReportSet, null, null);
    }

    public static final synchronized Vector[] getInternalResource(JetRptReportPanel jetRptReportPanel, String string, boolean bl) {
        return JReportUtil.getInternalResource(jetRptReportPanel, string, bl, null, null);
    }

    public static final synchronized Vector[] getInternalResource(JetRptReportSet jetRptReportSet, String string, boolean bl) {
        return JReportUtil.getInternalResource(jetRptReportSet, string, bl, null, null);
    }

    private static synchronized boolean CLS_FILE_EXTENSION(JetRptReportPanel jetRptReportPanel) {
        JetObject jetObject = JetObject.getRoot(jetRptReportPanel);
        return jetObject instanceof JetRptReportSet;
    }

    private static final synchronized void FILENAME_CONCAT_CHAR(JetRptReportPanel jetRptReportPanel, String string, boolean bl, Vector[] vectorArray, String string2, String string3) {
        JReportUtil.IRT_FONT(jetRptReportPanel, string, bl, vectorArray, string2, string3, JReportUtil.RPT_FILE_EXTENSION(string));
    }

    private static final synchronized void IRT_DETAILREPORT(JetRptReportSet jetRptReportSet, String string, boolean bl, Vector[] vectorArray, String string2, String string3) {
        String[] stringArray = jetRptReportSet.getAllReportsName();
        String[] stringArray2 = JReportUtil.RPT_FILE_EXTENSION(string);
        int n = 0;
        while (n < stringArray.length) {
            JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[n]);
            JReportUtil.IRT_FONT(jetRptReport, string, bl, vectorArray, string2, string3, stringArray2);
            ++n;
        }
    }

    private static final synchronized void IRT_FONT(JetRptReportPanel jetRptReportPanel, String string, boolean bl, Vector[] vectorArray, String string2, String string3, String[] stringArray) {
        JetObject jetObject;
        boolean bl2 = JReportUtil.CLS_FILE_EXTENSION(jetRptReportPanel);
        if (!bl && string != null && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        TreeIterater treeIterater = new TreeIterater(jetRptReportPanel, false);
        String string4 = null;
        boolean bl3 = stringArray != null && stringArray.length > 0;
        while ((jetObject = (JetObject)treeIterater.next()) != null) {
            if (jetObject instanceof JetRptSubReport) {
                if (vectorArray[IRT_SUBREPORT] == null) {
                    vectorArray[JReportUtil.IRT_SUBREPORT] = new Vector(1);
                }
                if ((string4 = bl2 ? ((JetRptSubReport)jetObject).reportSet.get() : ((JetRptSubReport)jetObject).report.get()) == null || string4.trim().length() <= 0 || vectorArray[IRT_SUBREPORT].contains(string4)) continue;
                vectorArray[IRT_SUBREPORT].addElement(string4);
                continue;
            }
            if (jetObject instanceof JetRptOLEObject) {
                if (vectorArray[IRT_IMAGE] == null) {
                    vectorArray[JReportUtil.IRT_IMAGE] = new Vector();
                }
                JReportUtil.bEmbed((JetRptOLEObject)jetObject, vectorArray[IRT_IMAGE]);
                treeIterater.skipBranch();
                continue;
            }
            Hashtable hashtable = jetObject.getProperties();
            if (bl3 && jetObject instanceof JetRptDBField) {
                JReportUtil.addElement(((JetRptDBField)jetObject).dataMappingFile.get(), stringArray, vectorArray);
            } else if (bl3 && jetObject instanceof JetRptParameterField) {
                JReportUtil.addElement(((JetRptParameterField)jetObject).dataMappingFile.get(), stringArray, vectorArray);
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string5;
                Object object;
                JetProperty jetProperty = (JetProperty)hashtable.get(enumeration.nextElement());
                if (jetProperty.isChangeByOther()) continue;
                if (jetProperty instanceof JetImgProperty) {
                    if (((JetImgProperty)jetProperty).isImageEmbed()) continue;
                    if (vectorArray[IRT_IMAGE] == null) {
                        vectorArray[JReportUtil.IRT_IMAGE] = new Vector(1);
                    }
                    JReportUtil.charAt(((JetImgProperty)jetProperty).get(), vectorArray[IRT_IMAGE]);
                    continue;
                }
                if (jetProperty instanceof JetFont) {
                    if (vectorArray[IRT_FONT] == null) {
                        vectorArray[JReportUtil.IRT_FONT] = new Vector(1);
                    }
                    JReportUtil.checkEnv(((JetFont)jetProperty).get(), bl, string, string2, vectorArray[IRT_FONT]);
                    continue;
                }
                if (jetProperty instanceof JetLink && (((JetLink)jetProperty).getLinkType() == 0 || ((JetLink)jetProperty).getLinkType() == 2)) {
                    string4 = ((JetLink)jetProperty).getReportName();
                    if (vectorArray[IRT_SUBREPORT] == null) {
                        vectorArray[JReportUtil.IRT_SUBREPORT] = new Vector(1);
                    }
                    if (string4 == null || string4.trim().length() <= 0) continue;
                    if (bl2) {
                        string4 = JetRptField.parseRptName(string4)[0];
                    }
                    if (string4.trim().length() <= 0 || vectorArray[IRT_SUBREPORT].contains(string4)) continue;
                    vectorArray[IRT_SUBREPORT].addElement(string4);
                    continue;
                }
                if (jetProperty instanceof JetImgVector) {
                    boolean bl4 = ((JetImgVector)jetProperty).isEmbed();
                    if (bl4) continue;
                    object = ((JetImgVector)jetProperty).getImgNameList();
                    if (vectorArray[IRT_IMAGE] == null) {
                        vectorArray[JReportUtil.IRT_IMAGE] = new Vector(1);
                    }
                    int n = 0;
                    while (n < ((Vector)object).size()) {
                        JReportUtil.charAt((String)((Vector)object).elementAt(n), vectorArray[IRT_IMAGE]);
                        ++n;
                    }
                    continue;
                }
                if (jetProperty.getName().equals("StyleFile")) {
                    String string6;
                    boolean bl5;
                    if (vectorArray[IRT_STYLEGROUP] == null) {
                        vectorArray[JReportUtil.IRT_STYLEGROUP] = new Vector(1);
                    }
                    boolean bl6 = bl5 = (string6 = ((JetString)jetProperty).get()) != null && string6.trim().length() > 0 && !string6.toLowerCase().endsWith("*.css");
                    if (!bl5) continue;
                    String string7 = ((JetString)jetProperty).get();
                    string5 = (bl ? ReportEnv.stylePath : string) + string7;
                    if (!new File(string5).exists() && string3 != null && string3.length() > 0) {
                        string5 = string3.endsWith(File.separator) ? string3.concat(string7) : string3.concat(File.separator).concat(string7);
                    }
                    if (vectorArray[IRT_STYLEGROUP].contains(string5)) continue;
                    vectorArray[IRT_STYLEGROUP].addElement(string5);
                    continue;
                }
                if (jetProperty.getName().equals("StyleList")) {
                    if (vectorArray[IRT_STYLEGROUP] == null) {
                        vectorArray[JReportUtil.IRT_STYLEGROUP] = new Vector(1);
                    }
                    Vector vector = ((JetVector)jetProperty).get();
                    Object object2 = object = bl ? ReportEnv.stylePath : string;
                    if (!((String)object).endsWith(File.separator)) {
                        object = ((String)object).concat(File.separator);
                    }
                    int n = 0;
                    while (n < vector.size()) {
                        string5 = (String)object + vector.get(n);
                        if (new File(string5).exists()) {
                            if (!vectorArray[IRT_STYLEGROUP].contains(string5)) {
                                vectorArray[IRT_STYLEGROUP].addElement(string5);
                            }
                        } else if (string3 != null && string3.length() > 0 && !vectorArray[IRT_STYLEGROUP].contains(string5 = string3.endsWith(File.separator) ? string3.concat((String)vector.get(n)) : string3.concat(File.separator).concat((String)vector.get(n)))) {
                            vectorArray[IRT_STYLEGROUP].addElement(string5);
                        }
                        ++n;
                    }
                    continue;
                }
                if (!jetProperty.getName().equals("DetailReport") || (string4 = ((JetString)jetProperty).get()) == null || string4.trim().length() <= 0) continue;
                if (bl2) {
                    string4 = JetRptField.parseRptName(string4)[0].trim();
                }
                if (vectorArray[IRT_DETAILREPORT] == null) {
                    vectorArray[JReportUtil.IRT_DETAILREPORT] = new Vector(1);
                }
                if (string4 == null || string4.length() <= 0 || vectorArray[IRT_DETAILREPORT].contains(string4)) continue;
                vectorArray[IRT_DETAILREPORT].addElement(string4);
            }
        }
        if (vectorArray[IRT_STYLEGROUP] == null) {
            vectorArray[JReportUtil.IRT_STYLEGROUP] = new Vector(1);
        }
        JReportUtil.archive(jetRptReportPanel, bl, string, string3, vectorArray[IRT_STYLEGROUP]);
        JRLog.trace(6, "getReportResource\n   Report [" + jetRptReportPanel.getInstName() + "] at [" + string + "] base Enviroment " + bl + ":" + JRLogger.ary("Internal Resource", vectorArray));
    }

    public static final Vector[] getReportResource(String string) throws ReadFailureException, IOException, NoSuchFieldException, IllegalAccessException, InstantiationException {
        return JReportUtil.getReportResource(string, true, null, null);
    }

    private static JetObject IRT_IMAGE(String string) throws ReadFailureException {
        LoaderNoCache loaderNoCache = new LoaderNoCache(string);
        return loaderNoCache.loadObject(false);
    }

    public static Vector[] getReportResource(String string, boolean bl) throws ReadFailureException, IOException, NoSuchFieldException, IllegalAccessException, InstantiationException {
        return JReportUtil.getReportResource(string, bl, null, null);
    }

    private static final Vector[] IRT_NLSPROP(String string, boolean bl, boolean bl2) throws ReadFailureException, IOException, NoSuchFieldException, IllegalAccessException, InstantiationException {
        return JReportUtil.IRT_STYLEGROUP(string, bl, bl2, null, null);
    }

    private static final Vector[] IRT_STYLEGROUP(String string, boolean bl, boolean bl2, String string2, String string3) throws ReadFailureException, IOException, NoSuchFieldException, IllegalAccessException, InstantiationException {
        long l = System.currentTimeMillis();
        Vector[] vectorArray = new Vector[NUMOFIRT];
        JReportUtil.IRT_SUBREPORT(string, bl, bl2, vectorArray, string2, string3);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JReportUtil: return from method: getReportResource(String rptFullPath,boolean useEnv, boolean deepSearch), cost: " + (System.currentTimeMillis() - l));
            int n = 0;
            while (n < vectorArray.length) {
                JRLog.trace(6, vectorArray[n]);
                ++n;
            }
        }
        return vectorArray;
    }

    private static final void IRT_SUBREPORT(String string, boolean bl, boolean bl2, Vector[] vectorArray, String string2, String string3) throws ReadFailureException, IOException, NoSuchFieldException, IllegalAccessException, InstantiationException {
        long l = System.currentTimeMillis();
        File file = new File(string);
        if (file.isFile()) {
            String string4 = file.getName();
            if (string4.endsWith(".xsd")) {
                if (vectorArray[IRT_XSDRES] == null) {
                    vectorArray[JReportUtil.IRT_XSDRES] = new Vector();
                }
                vectorArray[IRT_XSDRES].add(string4);
            } else {
                JReportUtil.PROPS_FILE_EXTENSION(file, bl2, vectorArray, bl, string2, string3);
            }
        } else if (file.isDirectory()) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            String[] stringArray = file.list(new WildcardMatcher("*.cls;*.rpt;*.clx", true, 2));
            int n = 0;
            while (n < stringArray.length) {
                JReportUtil.PROPS_FILE_EXTENSION(new File(string, stringArray[n]), bl2, vectorArray, bl, string2, string3);
                ++n;
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JReportUtil: return from method: getReportResource(String rptFullPath,\tboolean useEnv, boolean deepSearch, Vector[] ret), cost: " + (System.currentTimeMillis() - l));
        }
    }

    public static final synchronized Vector[] getReportResource(JetRptReportSet jetRptReportSet, File file, boolean bl) throws ReadFailureException, IOException, NoSuchFieldException, IllegalAccessException, InstantiationException {
        if (file == null) {
            return JReportUtil.getInternalResource(jetRptReportSet, null, bl);
        }
        String string = file.getParent();
        String[] stringArray = JReportUtil.RPT_FILE_EXTENSION(string);
        Vector[] vectorArray = new Vector[NUMOFIRT];
        Vector vector = vectorArray[IRT_SUBREPORT];
        if (vector == null) {
            vector = new Vector(1);
        }
        JReportUtil.NUMOFIRT(jetRptReportSet, file, vectorArray, bl, null, null, stringArray);
        Vector vector2 = vectorArray[IRT_SUBREPORT];
        if (vector2 != null && vector2.size() > 0) {
            int n = 0;
            while (n < vector2.size()) {
                if (!vector.contains(vector2.get(n))) {
                    JReportUtil.PROPS_FILE_EXTENSION(new File(string, (String)vector2.get(n)), true, vectorArray, bl, null, null);
                }
                ++n;
            }
        }
        return vectorArray;
    }

    private static final void IRT_XSDRES(JetRptReportPanel jetRptReportPanel, File file, Vector[] vectorArray, boolean bl, String string, String string2, String[] stringArray) throws ReadFailureException, IOException, NoSuchFieldException, IllegalAccessException, InstantiationException {
        if (file.isDirectory()) {
            return;
        }
        String string3 = file.getAbsoluteFile().getParent();
        String string4 = file.getName();
        Vector vector = vectorArray[IRT_SUBREPORT];
        if (vector == null) {
            vector = new Vector(1);
        }
        if (JReportUtil.QOIV(jetRptReportPanel)) {
            JReportUtil.IRT_FONT(jetRptReportPanel, string3, bl, vectorArray, string, string2, stringArray);
            String string5 = JReportUtil.add(string4);
            JReportUtil.addElement(string5, stringArray, vectorArray);
        } else {
            JReportUtil.FILENAME_CONCAT_CHAR(jetRptReportPanel, string3, bl, vectorArray, string, string2);
        }
    }

    private static final void NUMOFIRT(JetRptReportSet jetRptReportSet, File file, Vector[] vectorArray, boolean bl, String string, String string2, String[] stringArray) throws ReadFailureException, IOException, NoSuchFieldException, IllegalAccessException, InstantiationException {
        if (file.isDirectory()) {
            return;
        }
        String string3 = file.getAbsoluteFile().getParent();
        String string4 = file.getName();
        String string5 = JReportUtil.add(string4);
        JReportUtil.addElement(string5, stringArray, vectorArray);
        String[] stringArray2 = jetRptReportSet.getAllReportsName();
        int n = 0;
        while (n < stringArray2.length) {
            JetRptReport jetRptReport = jetRptReportSet.getReportView(stringArray2[n], null);
            if (jetRptReport != null) {
                if (JReportUtil.QOIV(jetRptReport)) {
                    JReportUtil.IRT_FONT(jetRptReport, string3, bl, vectorArray, string, string2, stringArray);
                } else {
                    JReportUtil.FILENAME_CONCAT_CHAR(jetRptReport, string3, bl, vectorArray, string, string2);
                }
            }
            ++n;
        }
    }

    private static final void PROPS_FILE_EXTENSION(File file, boolean bl, Vector[] vectorArray, boolean bl2, String string, String string2) throws ReadFailureException, IOException, NoSuchFieldException, IllegalAccessException, InstantiationException {
        String string3 = file.getAbsoluteFile().getParent();
        String[] stringArray = JReportUtil.RPT_FILE_EXTENSION(string3);
        JetObject jetObject = JReportUtil.IRT_IMAGE(file.getAbsolutePath());
        if (jetObject != null) {
            Vector vector;
            Vector vector2 = vectorArray[IRT_SUBREPORT];
            if (vector2 == null) {
                vector2 = new Vector(1);
            }
            if (jetObject instanceof JetRptReportSet) {
                JReportUtil.NUMOFIRT((JetRptReportSet)jetObject, file, vectorArray, bl2, string, string2, stringArray);
            } else if (jetObject instanceof JetRptReportPanel) {
                JReportUtil.IRT_XSDRES((JetRptReportPanel)jetObject, file, vectorArray, bl2, string, string2, stringArray);
            }
            if (bl && (vector = vectorArray[IRT_SUBREPORT]) != null && vector.size() > 0) {
                int n = 0;
                while (n < vector.size()) {
                    if (!vector2.contains(vector.get(n))) {
                        JReportUtil.PROPS_FILE_EXTENSION(new File(string3, (String)vector.get(n)), true, vectorArray, bl2, string, string2);
                    }
                    ++n;
                }
            }
        }
    }

    public static final boolean isNationalLanguageSupport(String string) throws IOException, ReadFailureException {
        JetRootable jetRootable = (JetRootable)((Object)JReportUtil.IRT_IMAGE(string));
        if (jetRootable instanceof JetRptReportPanel) {
            return JReportUtil.QOIV((JetRptReportPanel)jetRootable);
        }
        if (jetRootable instanceof JetRptReportSet) {
            String[] stringArray = ((JetRptReportSet)jetRootable).getAllReportsName();
            boolean bl = false;
            int n = 0;
            while (!bl && n < stringArray.length) {
                bl = JReportUtil.QOIV(((JetRptReportSet)jetRootable).getReport(stringArray[n]));
                ++n;
            }
            String string2 = JReportUtil.add(new File(string).getName());
            stringArray = new File(string).getParentFile().list(new FilenameFilter(string2){
                private final String val$prefix;
                {
                    this.val$prefix = string;
                }

                public boolean accept(File file, String string) {
                    File file2 = new File(file, string);
                    if (file2.isDirectory()) {
                        return false;
                    }
                    if (!string.toLowerCase().endsWith(NLSResourceBundle.PROPS_FILE_EXTENSION)) {
                        return false;
                    }
                    return string.startsWith(this.val$prefix);
                }
            });
            return bl;
        }
        return false;
    }

    private static final boolean QOIV(JetRptReportPanel jetRptReportPanel) {
        return ((JetBoolean)jetRptReportPanel.nameToProperty("nationalLanguageSupport")).get();
    }

    private static final String[] RPT_FILE_EXTENSION(String string) {
        if (string == null) {
            return new String[0];
        }
        return new File(string).list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                boolean bl = false;
                File file2 = new File(file, string);
                bl = file2.isDirectory() ? false : string.endsWith(NLSResourceBundle.PROPS_FILE_EXTENSION);
                return bl;
            }
        });
    }

    private static final String add(String string) {
        if (string.endsWith(NLSResourceBundle.CLS_FILE_EXTENSION)) {
            return string.substring(0, string.length() - NLSResourceBundle.CLS_FILE_EXTENSION.length());
        }
        if (string.endsWith(NLSResourceBundle.RPT_FILE_EXTENSION)) {
            return string.substring(0, string.length() - NLSResourceBundle.RPT_FILE_EXTENSION.length());
        }
        return string;
    }

    private static final void addElement(String string, String[] stringArray, Vector[] vectorArray) {
        if (string.trim().length() == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith(string)) {
                String string2 = stringArray[n].substring(string.length(), stringArray[n].length() - NLSResourceBundle.PROPS_FILE_EXTENSION.length());
                if (string2.length() == 0) {
                    if (vectorArray[IRT_NLSPROP] == null) {
                        vectorArray[JReportUtil.IRT_NLSPROP] = new Vector(1);
                    }
                    if (!vectorArray[IRT_NLSPROP].contains(stringArray[n])) {
                        vectorArray[IRT_NLSPROP].addElement(stringArray[n]);
                    }
                } else if (string2.startsWith(NLSResourceBundle.FILENAME_CONCAT_CHAR)) {
                    String string3 = "";
                    int n2 = string2.indexOf(NLSResourceBundle.FILENAME_CONCAT_CHAR, 1);
                    string3 = n2 > 0 ? string2.substring(1, n2) : string2.substring(1);
                    if (JReportUtil.append(string3)) {
                        if (vectorArray[IRT_NLSPROP] == null) {
                            vectorArray[JReportUtil.IRT_NLSPROP] = new Vector(1);
                        }
                        if (!vectorArray[IRT_NLSPROP].contains(stringArray[n])) {
                            vectorArray[IRT_NLSPROP].addElement(stringArray[n]);
                        }
                    }
                }
            }
            ++n;
        }
    }

    private static boolean append(String string) {
        String[] stringArray = Locale.getISOLanguages();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final void archive(JetRptReportPanel jetRptReportPanel, boolean bl, String string, String string2, Vector vector) {
        JReportUtil.ary(jetRptReportPanel.stlGroup, bl, string, string2, vector);
        if (jetRptReportPanel instanceof JetRptReport) {
            JReportUtil.ary(((JetRptReport)jetRptReportPanel).stlGrpOfDHTML, bl, string, string2, vector);
            JReportUtil.ary(((JetRptReport)jetRptReportPanel).stlGrpOfHTML, bl, string, string2, vector);
            JReportUtil.ary(((JetRptReport)jetRptReportPanel).stlGrpOfExcel, bl, string, string2, vector);
            JReportUtil.ary(((JetRptReport)jetRptReportPanel).stlGrpOfPDF, bl, string, string2, vector);
            JReportUtil.ary(((JetRptReport)jetRptReportPanel).stlGrpOfText, bl, string, string2, vector);
            JReportUtil.ary(((JetRptReport)jetRptReportPanel).stlGrpOfRTF, bl, string, string2, vector);
            JReportUtil.ary(((JetRptReport)jetRptReportPanel).stlGrpOfXML, bl, string, string2, vector);
            JReportUtil.ary(((JetRptReport)jetRptReportPanel).stlGrpOfPS, bl, string, string2, vector);
            JReportUtil.ary(((JetRptReport)jetRptReportPanel).stlGrpOfFax, bl, string, string2, vector);
            JReportUtil.ary(((JetRptReport)jetRptReportPanel).stlGrpOfRST, bl, string, string2, vector);
        }
    }

    private static final void ary(JetStringList jetStringList, boolean bl, String string, String string2, Vector vector) {
        boolean bl2;
        String string3 = jetStringList.get();
        boolean bl3 = bl2 = string3 != null && string3.trim().length() > 0 && !string3.trim().equalsIgnoreCase("None");
        if (bl2) {
            String string4 = jetStringList.get() + "_stl.xsd";
            String string5 = (bl ? ReportEnv.stylePath : string) + string4;
            if (!new File(string5).exists() && string2 != null && string2.length() > 0) {
                string5 = string2.endsWith(File.separator) ? string2.concat(string4) : string2.concat(File.separator).concat(string4);
            }
            if (!vector.contains(string5)) {
                vector.addElement(string5);
            }
        }
    }

    private static final void bEmbed(JetRptOLEObject jetRptOLEObject, Vector vector) {
        if (jetRptOLEObject.classid.get().equals("CAFEEFAC-0014-0001-0000-ABCDEFFEDCBA")) {
            String string = ((JetString)jetRptOLEObject.nameToProperty("Code")).get();
            String string2 = jetRptOLEObject.archive.get();
            if (string2 != null && string2.length() > 0) {
                vector.add(string2);
            } else {
                vector.add(string);
            }
        } else {
            JReportUtil.charAt(jetRptOLEObject.archive.get(), vector);
            int n = jetRptOLEObject.getExtraParamSize();
            int n2 = 0;
            while (n2 < n) {
                String string;
                JetString jetString = jetRptOLEObject.getExtraParamToJetString(n2);
                if (!jetString.isChangeByOther() && (string = jetString.get()).lastIndexOf(46) > string.lastIndexOf(File.separator)) {
                    JReportUtil.charAt(string, vector);
                }
                ++n2;
            }
        }
    }

    private static void charAt(String string, Vector vector) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        try {
            new URL(string);
            JRLog.trace(5, "Deploy " + string + " Failed, it is a URL.");
            return;
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string.trim());
            if (file.isAbsolute() || file.isDirectory()) {
                JRLog.trace(5, "Deploy " + string + " Failed, it is a absolute.");
                return;
            }
            if (!vector.contains(string)) {
                vector.add(string);
            }
            return;
        }
    }

    private static void checkEnv(String string, boolean bl, String string2, String string3, Vector vector) {
        boolean bl2;
        String string4 = JReportUtil.classid(string, bl, string2, string3);
        boolean bl3 = bl2 = string4 != null && string4.trim().length() > 0;
        if (bl2 && !vector.contains(string4)) {
            vector.addElement(string4);
        }
    }

    private static String classid(String string, boolean bl, String string2, String string3) {
        String string4 = null;
        if (string != null && string.startsWith("*")) {
            if (bl) {
                string4 = FontSets.getFontPath(string);
            } else if (string2 != null) {
                string4 = FontSets.getUserFontPath(string2, string.substring(1));
            }
            if ((string4 == null || string4.length() == 0) && string3 != null) {
                string4 = FontSets.getUserFontPath(string3, string.substring(1));
            }
        }
        return string4;
    }

    public static Vector[] getInternalResource(JetRptReportPanel jetRptReportPanel, String string, String string2) {
        return JReportUtil.getInternalResource(jetRptReportPanel, null, true, string, string2);
    }

    public static Vector[] getInternalResource(JetRptReportSet jetRptReportSet, String string, String string2) {
        return JReportUtil.getInternalResource(jetRptReportSet, null, true, string, string2);
    }

    public static synchronized Vector[] getInternalResource(JetRptReportPanel jetRptReportPanel, String string, boolean bl, String string2, String string3) {
        long l = System.currentTimeMillis();
        Vector[] vectorArray = new Vector[NUMOFIRT];
        JReportUtil.FILENAME_CONCAT_CHAR(jetRptReportPanel, string, bl, vectorArray, string2, string3);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JReportUtil: return from method: getInternalResource(JetRptReportPanel root, String rptFolder, boolean useEnv), cost: " + (System.currentTimeMillis() - l));
            JRLog.trace(6, vectorArray);
        }
        return vectorArray;
    }

    public static synchronized Vector[] getInternalResource(JetRptReportSet jetRptReportSet, String string, boolean bl, String string2, String string3) {
        long l = System.currentTimeMillis();
        Vector[] vectorArray = new Vector[NUMOFIRT];
        JReportUtil.IRT_DETAILREPORT(jetRptReportSet, string, bl, vectorArray, string2, string3);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JReportUtil: return from method: getInternalResource(JetRptReportPanel root, String rptFolder, boolean useEnv), cost: " + (System.currentTimeMillis() - l));
            JRLog.trace(6, vectorArray);
        }
        return vectorArray;
    }

    public static Vector[] getReportResource(String string, boolean bl, String string2, String string3) throws ReadFailureException, IOException, NoSuchFieldException, IllegalAccessException, InstantiationException {
        return JReportUtil.IRT_STYLEGROUP(string, bl, false, string2, string3);
    }

    public static final Vector[] getReportResource(String string, String string2, String string3) throws ReadFailureException, IOException, NoSuchFieldException, IllegalAccessException, InstantiationException {
        return JReportUtil.getReportResource(string, true, string2, string3);
    }

    public static Hashtable getImgMappingTable(JetRootable jetRootable) {
        Hashtable hashtable = new Hashtable();
        JReportUtil.concat(hashtable, jetRootable);
        return hashtable;
    }

    public static Hashtable getImgMappingTable(JetRootable[] jetRootableArray) {
        Hashtable hashtable = new Hashtable();
        int n = 0;
        while (n < jetRootableArray.length) {
            JReportUtil.concat(hashtable, jetRootableArray[n]);
            ++n;
        }
        return hashtable;
    }

    private static void concat(Hashtable hashtable, JetRootable jetRootable) {
        Hashtable hashtable2 = jetRootable.getNamingTable();
        Iterator iterator = hashtable2.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Map.Entry entry = iterator.next();
            JetObject jetObject = (JetObject)entry.getValue();
            if (jetObject instanceof JetRptPicture) {
                object2 = (JetRptPicture)jetObject;
                if (((JetRptPicture)object2).bEmbed.get()) continue;
                JReportUtil.contains(((JetRptPicture)object2).pictureName, hashtable);
                continue;
            }
            if (jetObject instanceof JetRptMap) {
                object2 = (JetRptMap)jetObject;
                if (((JetRptMap)object2).isData.get() || ((JetRptMap)object2).bEmbed.get()) continue;
                JReportUtil.contains(((JetRptMap)object2).src, hashtable);
                continue;
            }
            if (jetObject instanceof JetRptField) {
                Object object3;
                JetProperty jetProperty;
                object2 = (JetRptField)jetObject;
                if (((JRObjectTemplate)object2).getJetRptMode() == null) continue;
                object = ((JRObjectTemplate)object2).getJetRptMode().getCurrentRender();
                if (object.getRenderType() == 1) {
                    Object object4;
                    jetProperty = (JetImgVector)object.getRenderPropertyByName(PropertyNameConstant.getNameByID(1061));
                    if (((JetImgVector)jetProperty).isEmbed()) continue;
                    object3 = ((JetImgVector)jetProperty).getImgNameList();
                    List list = (List)((JetImgVector)jetProperty).getObject();
                    Vector vector = ((JetImgVector)jetProperty).getImageTypeVec();
                    int n = 0;
                    while (n < object3.size()) {
                        if (!hashtable.containsKey(object3.get(n)) && list.get(n) != null) {
                            object4 = new Vector();
                            ((Vector)object4).add(list.get(n));
                            ((Vector)object4).add(vector.get(n));
                            hashtable.put(object3.get(n), object4);
                        }
                        ++n;
                    }
                    object4 = (JetImgProperty)object.getRenderPropertyByName(PropertyNameConstant.getNameByID(622));
                    JReportUtil.contains((JetImgProperty)object4, hashtable);
                    continue;
                }
                if (object.getRenderType() != 3 && object.getRenderType() != 10 || !((JetBoolean)(jetProperty = (JetBoolean)object.getRenderPropertyByName(PropertyNameConstant.getNameByID(813)))).get()) continue;
                object3 = (JetImgProperty)object.getRenderPropertyByName(PropertyNameConstant.getNameByID(1581));
                JReportUtil.contains((JetImgProperty)object3, hashtable);
                continue;
            }
            object2 = jetObject.getProperties().values().iterator();
            while (object2.hasNext()) {
                object = (JetProperty)object2.next();
                if (!(object instanceof JetImgProperty)) continue;
                JReportUtil.contains((JetImgProperty)object, hashtable);
            }
        }
    }

    private static void contains(JetImgProperty jetImgProperty, Hashtable hashtable) {
        if (jetImgProperty.isChangeByOther()) {
            return;
        }
        if (jetImgProperty.isImageEmbed()) {
            return;
        }
        String string = jetImgProperty.get();
        String string2 = "";
        Vector<Object> vector = new Vector<Object>();
        if (ImageLoader.isFileFormat(string)) {
            string2 = jetImgProperty.getURL();
            if (string2 == null) {
                string2 = string;
            }
            if (string2 == null || string2.length() == 0) {
                return;
            }
            File file = new File(string2);
            if (file.isDirectory()) {
                return;
            }
            if (file.isAbsolute()) {
                if (hashtable.containsKey(string)) {
                    return;
                }
                Object object = jetImgProperty.getObject();
                Integer n = new Integer(jetImgProperty.getImageType());
                if (object == null) {
                    object = string2;
                }
                vector.add(object);
                vector.add(n);
            } else {
                if (hashtable.containsKey(string)) {
                    return;
                }
                String string3 = jetImgProperty.getPath();
                string2 = ImageLoader.getFilePath(string3, string2);
                Object object = jetImgProperty.getObject();
                Integer n = new Integer(jetImgProperty.getImageType());
                if (object == null) {
                    object = string2;
                }
                vector.add(object);
                vector.add(n);
            }
        } else {
            string2 = jetImgProperty.getURL();
            if (string2 == null) {
                string2 = string;
            }
            if (string2 == null || string2.length() == 0) {
                return;
            }
            string = string2;
            if (hashtable.containsKey(string)) {
                return;
            }
            Object object = jetImgProperty.getObject();
            Integer n = new Integer(jetImgProperty.getImageType());
            if (object == null) {
                object = string2;
            }
            vector.add(object);
            vector.add(n);
        }
        hashtable.put(string, vector);
    }

    public static void setImgMappingtable(JetRootable jetRootable, Hashtable hashtable) {
        Hashtable hashtable2 = jetRootable.getNamingTable();
        Iterator iterator = hashtable2.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Map.Entry entry = iterator.next();
            JetObject jetObject = (JetObject)entry.getValue();
            if (jetObject instanceof JetRptPicture) {
                object5 = (JetRptPicture)jetObject;
                if (((JetRptPicture)object5).bEmbed.get() || ((JetRptPicture)object5).pictureName.isChangeByOther() || ((JetRptPicture)object5).pictureName.isImageEmbed()) continue;
                object4 = ((JetRptPicture)object5).pictureName.getURL();
                if (object4 == null) {
                    object4 = ((JetRptPicture)object5).pictureName.get();
                }
                if (object4 == null || (object3 = (List)hashtable.get(object4)) == null || !(object3.get(0) instanceof Image)) continue;
                ((JetRptPicture)object5).setEmbedImage(JReportUtil.imageToByte((Image)object3.get(0), (Integer)object3.get(1)));
                continue;
            }
            if (jetObject instanceof JetRptMap) {
                object5 = (JetRptMap)jetObject;
                if (((JetRptMap)object5).isData.get() || ((JetRptMap)object5).bEmbed.get() || ((JetRptMap)object5).src.isChangeByOther() || ((JetRptMap)object5).src.isImageEmbed() || (object4 = ((JetRptMap)object5).src.get()) == null || (object3 = (List)hashtable.get(object4)) == null || !(object3.get(0) instanceof Image)) continue;
                ((JetRptMap)object5).setEmbedImage(JReportUtil.imageToByte((Image)object3.get(0), (Integer)object3.get(1)));
                continue;
            }
            if (jetObject instanceof JetRptField) {
                List<Integer> list;
                object5 = (JetRptField)jetObject;
                if (((JRObjectTemplate)object5).getJetRptMode() == null) continue;
                object4 = ((JRObjectTemplate)object5).getJetRptMode().getCurrentRender();
                if (object4.getRenderType() == 1) {
                    List list2;
                    Object object6;
                    object3 = (JetImgVector)object4.getRenderPropertyByName(PropertyNameConstant.getNameByID(1061));
                    if (((JetImgVector)object3).isEmbed()) continue;
                    object2 = ((JetImgVector)object3).getImgNameList();
                    object = new Vector(object2.size());
                    list = new Vector(object2.size());
                    int n = 0;
                    while (n < object2.size()) {
                        object6 = (List)hashtable.get(object2.get(n));
                        if (object6 == null || !(object6.get(0) instanceof Image)) {
                            object.add(null);
                            list.add(new Integer(-100));
                        } else {
                            object.add(object6.get(0));
                            list.add((Integer)object6.get(1));
                        }
                        ++n;
                    }
                    ((JetImgVector)object3).setObject((List)object, list);
                    object6 = (JetImgProperty)object4.getRenderPropertyByName(PropertyNameConstant.getNameByID(622));
                    if (((JetProperty)object6).isChangeByOther() || ((JetImgProperty)object6).isImageEmbed()) continue;
                    String string = ((JetImgProperty)object6).getURL();
                    if (string == null) {
                        string = ((JetString)object6).get();
                    }
                    if (string == null || (list2 = (List)hashtable.get(string)) == null || !(list2.get(0) instanceof Image)) continue;
                    ((JetImgProperty)object6).setEmbedImage((Image)list2.get(0));
                    ((JetImgProperty)object6).setEmbedImageType((Integer)list2.get(1));
                    continue;
                }
                if (object4.getRenderType() != 3 && object4.getRenderType() != 10 || !((JetBoolean)(object3 = (JetBoolean)object4.getRenderPropertyByName(PropertyNameConstant.getNameByID(813)))).get() || ((JetProperty)(object2 = (JetImgProperty)object4.getRenderPropertyByName(PropertyNameConstant.getNameByID(1581)))).isChangeByOther() || ((JetImgProperty)object2).isImageEmbed()) continue;
                object = ((JetImgProperty)object2).getURL();
                if (object == null) {
                    object = ((JetString)object2).get();
                }
                if (object == null || (list = (List)hashtable.get(object)) == null || !(list.get(0) instanceof Image)) continue;
                ((JetImgProperty)object2).setEmbedImage((Image)list.get(0));
                ((JetImgProperty)object2).setEmbedImageType((Integer)list.get(1));
                continue;
            }
            object5 = jetObject.getProperties().values().iterator();
            while (object5.hasNext()) {
                object4 = (JetProperty)object5.next();
                if (!(object4 instanceof JetImgProperty) || ((JetProperty)(object3 = (JetImgProperty)object4)).isChangeByOther() || ((JetImgProperty)object3).isImageEmbed()) continue;
                object2 = ((JetImgProperty)object3).getURL();
                if (object2 == null) {
                    object2 = ((JetString)object3).get();
                }
                if (object2 == null || (object = (List)hashtable.get(object2)) == null || !(object.get(0) instanceof Image)) continue;
                ((JetImgProperty)object3).setEmbedImage((Image)object.get(0));
                ((JetImgProperty)object3).setEmbedImageType((Integer)object.get(1));
            }
        }
    }

    public static void setImgMappingtable(JetRootable[] jetRootableArray, Hashtable hashtable) {
        int n = 0;
        while (n < jetRootableArray.length) {
            JReportUtil.setImgMappingtable(jetRootableArray[n], hashtable);
            ++n;
        }
    }

    public static byte[] imageToByte(Image image, int n) {
        return JetImgProperty.imageToByte(image, n);
    }

    public static byte[] imageToByte(Image image) {
        return JetImgProperty.imageToByte(image);
    }

    public static final void replaceMappingName(JetRptReportPanel jetRptReportPanel, Hashtable hashtable, Hashtable hashtable2) {
        JetObject jetObject;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        TreeIterater treeIterater = new TreeIterater(jetRptReportPanel, false);
        if (jetRptReportPanel instanceof JetRptReport) {
            JetRptReport jetRptReport = (JetRptReport)jetRptReportPanel;
            object4 = jetRptReport.getReportset();
            object3 = ((JetRptReportSet)object4).getDataSets().getChildren();
            int n = 0;
            int n2 = object3.size();
            while (n < n2) {
                Object e = object3.get(n);
                if (e instanceof DataSet) {
                    String string;
                    object2 = (DataSet)e;
                    if (hashtable2 != null && (object = object2.getQueryName()) != null && (string = (String)hashtable2.get(((String)object).toUpperCase())) != null) {
                        object2.setQueryName(string);
                    }
                    if (hashtable != null) {
                        object = object2.getAdditionalNames();
                        int n3 = 0;
                        int n4 = object.size();
                        while (n3 < n4) {
                            String string2;
                            String string3 = (String)object.get(n3);
                            if (string3 != null && (string2 = (String)hashtable.get(string3.toUpperCase())) != null) {
                                object.add(n3, string2);
                                object.remove(n3 + 1);
                            }
                            ++n3;
                        }
                    }
                }
                ++n;
            }
        }
        boolean bl = JReportUtil.CLS_FILE_EXTENSION(jetRptReportPanel);
        while ((jetObject = (JetObject)treeIterater.next()) != null) {
            if (!bl && jetObject instanceof JetRptDataSource && hashtable2 != null && (object3 = (String)hashtable2.get(((String)(object4 = ((JetRptDataSource)jetObject).uQueryName.getInspValue())).toUpperCase())) != null) {
                ((JetRptDataSource)jetObject).uQueryName.set((String)object3);
            }
            if (bl && jetObject instanceof JetRptQueryDataSet && hashtable2 != null && (object3 = (String)hashtable2.get(((String)(object4 = ((JetRptQueryDataSet)jetObject).getQueryName())).toUpperCase())) != null) {
                ((JetRptQueryDataSet)jetObject).setQueryName((String)object3);
            }
            if (hashtable == null) continue;
            object4 = jetObject.getProperties();
            object3 = ((Hashtable)object4).keys();
            while (object3.hasMoreElements()) {
                Object object5;
                JetProperty jetProperty = (JetProperty)((Hashtable)object4).get(object3.nextElement());
                if (jetProperty.isChangeByOther()) {
                    object5 = ((String)jetProperty.getChangeByObject()).toUpperCase();
                    String string = (String)hashtable.get(object5);
                    if (string == null) continue;
                    jetProperty.setChangeByObject(string);
                    continue;
                }
                if (!(jetProperty instanceof JetColumnable)) continue;
                if (jetProperty instanceof JetColumnName) {
                    object5 = jetProperty.getInspValue().toUpperCase();
                    String string = (String)hashtable.get(object5);
                    if (string == null) continue;
                    jetProperty.set(string);
                    continue;
                }
                if (!(jetProperty instanceof JetVector)) continue;
                object5 = ((JetVector)jetProperty).get();
                int n = 0;
                while (n < ((Vector)object5).size()) {
                    object2 = ((Vector)object5).elementAt(n).toString().toUpperCase();
                    object = (String)hashtable.get(object2);
                    if (object != null) {
                        jetProperty.set((String)object);
                    }
                    ++n;
                }
            }
        }
    }

    public static final void replaceMappingName(JetRptReportSet jetRptReportSet, Hashtable hashtable, Hashtable hashtable2) {
        String[] stringArray = jetRptReportSet.getAllReportsName();
        int n = 0;
        while (n < stringArray.length) {
            JReportUtil.replaceMappingName(jetRptReportSet.getReport(stringArray[n]), hashtable, hashtable2);
            ++n;
        }
    }

    private static Vector containsKey(String string, String string2) throws InvalidParameterException, ReadFailureException, IOException {
        Vector<Object> vector = new Vector<Object>(3);
        File file = new File(string);
        if (!file.isDirectory()) {
            throw new InvalidParameterException(string + " is invalid file path!");
        }
        JetRptReportPanel jetRptReportPanel = (JetRptReportPanel)JReportUtil.IRT_IMAGE(file.getCanonicalPath() + File.separator + string2);
        boolean bl = JReportUtil.CLS_FILE_EXTENSION(jetRptReportPanel);
        if (jetRptReportPanel != null) {
            Object object;
            Object object2;
            Object object3;
            String string3;
            JetObject jetObject;
            TreeIterater treeIterater = new TreeIterater(jetRptReportPanel, false);
            Hashtable<String, String> hashtable = new Hashtable<String, String>(6);
            while ((jetObject = (JetObject)treeIterater.next()) != null) {
                if (jetObject instanceof JetRptSubReport && (string3 = bl ? ((JetRptSubReport)jetObject).reportSet.get() : ((JetRptSubReport)jetObject).report.get()) != null && string3.trim().length() > 0 && !hashtable.contains(string3)) {
                    hashtable.put(JReportUtil.currentTimeMillis(string3).toLowerCase(), string3);
                }
                object3 = jetObject.getProperties();
                object2 = ((Hashtable)object3).keys();
                while (object2.hasMoreElements()) {
                    object = (JetProperty)((Hashtable)object3).get(object2.nextElement());
                    if (!(object instanceof JetLink) || ((JetLink)object).getLinkType() != 0 && ((JetLink)object).getLinkType() != 2) continue;
                    string3 = ((JetLink)object).getReportName();
                    if (bl) {
                        string3 = JetRptField.parseRptName(string3)[0];
                    }
                    if (string3 == null || string3.trim().length() <= 0 || hashtable.contains(string3)) continue;
                    hashtable.put(JReportUtil.currentTimeMillis(string3).toLowerCase(), string3);
                }
            }
            object3 = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    boolean bl = false;
                    File file2 = new File(file, string);
                    bl = file2.isDirectory() ? false : Env.getFileName(string, 6) != null || string.toLowerCase().endsWith(NLSResourceBundle.PROPS_FILE_EXTENSION);
                    return bl;
                }
            });
            object2 = JReportUtil.currentTimeMillis(string2);
            object = JReportUtil.dataMappingFile(string2);
            int n = 0;
            while (object3 != null && n < ((Object)object3).length) {
                string3 = JReportUtil.currentTimeMillis((String)object3[n]);
                if (string3.equalsIgnoreCase((String)object2)) {
                    if (((String)object3[n]).toLowerCase().endsWith(((String)object).toLowerCase())) {
                        vector.add(object3[n]);
                    } else if (JReportUtil.dataMappingFile((String)object3[n]).equalsIgnoreCase(NLSResourceBundle.PROPS_FILE_EXTENSION)) {
                        vector.add(object3[n]);
                    }
                } else if (hashtable.containsKey(string3.toLowerCase())) {
                    String string4 = JReportUtil.dataMappingFile((String)object3[n]);
                    if (string4.equalsIgnoreCase(NLSResourceBundle.PROPS_FILE_EXTENSION)) {
                        vector.add(object3[n]);
                    } else if (new File((String)object3[n]).getName().equalsIgnoreCase((String)hashtable.get(string3.toLowerCase()))) {
                        vector.add(object3[n]);
                    }
                }
                ++n;
            }
        }
        return vector;
    }

    public static Vector getRelaCatalFiles(String string) throws InvalidParameterException {
        return JReportUtil.copyFiles(string, false);
    }

    private static Vector copyFiles(String string, boolean bl) throws InvalidParameterException {
        File file = new File(string);
        if (!file.isDirectory()) {
            throw new InvalidParameterException(string + " is invalid file path!");
        }
        String[] stringArray = !bl ? file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                boolean bl = false;
                File file2 = new File(file, string);
                bl = file2.isDirectory() ? false : Env.getFileName(string, 6) == null && !string.endsWith(NLSResourceBundle.PROPS_FILE_EXTENSION);
                return bl;
            }
        }) : file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                return file2.isFile();
            }
        });
        int n = stringArray.length;
        Vector<String> vector = new Vector<String>(n);
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(stringArray[n2]);
            ++n2;
        }
        return vector;
    }

    public static Vector getHdsFiles(JetUUniverse jetUUniverse, JetRptReportPanel jetRptReportPanel) {
        long l = System.currentTimeMillis();
        Vector<String> vector = new Vector<String>(1);
        boolean bl = JReportUtil.CLS_FILE_EXTENSION(jetRptReportPanel);
        try {
            if (jetRptReportPanel != null) {
                if (bl) {
                    String string;
                    String string2;
                    JetUDatabase jetUDatabase;
                    JetUHierDataSource jetUHierDataSource;
                    DataSet dataSet = ReportTools.getDataSet(jetRptReportPanel);
                    if (dataSet != null && dataSet instanceof JetRptQueryDataSet && (jetUHierDataSource = (jetUDatabase = jetUUniverse.getDatabase(string2 = ((JetRptQueryDataSet)dataSet).getDsName())).getHierDataSourceByResourceName(string = ((JetRptQueryDataSet)dataSet).getQueryName())) != null) {
                        String string3;
                        String string4 = jetUHierDataSource.getURIValue();
                        if (string4.trim().length() > 0 && string4.indexOf(File.separator) <= -1 && !vector.contains(string4) && string4.indexOf("://") <= -1) {
                            vector.add(string4);
                        }
                        if ((string3 = jetUHierDataSource.getXSDValue()).trim().length() > 0 && string3.indexOf(File.separator) <= -1 && !vector.contains(string3) && string3.indexOf("://") <= -1) {
                            vector.add(string3);
                        }
                    }
                } else {
                    String string;
                    String string5;
                    JetUDatabase jetUDatabase;
                    JetUHierDataSource jetUHierDataSource;
                    JetRptDataSource jetRptDataSource = jetRptReportPanel.getDataSource();
                    if (jetRptDataSource != null && (jetUHierDataSource = (jetUDatabase = jetUUniverse.getDatabase(string5 = jetRptDataSource.sourceName.get())).getHierDataSourceByResourceName(string = jetRptDataSource.uQueryName.get())) != null) {
                        String string6;
                        String string7 = jetUHierDataSource.getURIValue();
                        if (string7.trim().length() > 0 && string7.indexOf(File.separator) <= -1 && !vector.contains(string7) && string7.indexOf("://") <= -1) {
                            vector.add(string7);
                        }
                        if ((string6 = jetUHierDataSource.getXSDValue()).trim().length() > 0 && string6.indexOf(File.separator) <= -1 && !vector.contains(string6) && string6.indexOf("://") <= -1) {
                            vector.add(string6);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            JRLog.error(3, exception);
        }
        JRLog.trace(6, "JReportUtil: return from method: getHdsFiles(JetUUniverse unv, JetRptReportPanel rpt), cost: " + (System.currentTimeMillis() - l));
        JRLog.trace(6, vector);
        return vector;
    }

    public static Vector getHdsFiles(JetUUniverse jetUUniverse, JetRptReportSet jetRptReportSet) {
        long l = System.currentTimeMillis();
        Vector<String> vector = new Vector<String>(1);
        try {
            String string;
            String string2;
            JetUDatabase jetUDatabase;
            JetUHierDataSource jetUHierDataSource;
            DataSet dataSet;
            if (jetRptReportSet != null && (dataSet = ReportTools.getDataSet(jetRptReportSet)) != null && dataSet instanceof JetRptQueryDataSet && (jetUHierDataSource = (jetUDatabase = jetUUniverse.getDatabase(string2 = ((JetRptQueryDataSet)dataSet).getDsName())).getHierDataSourceByResourceName(string = ((JetRptQueryDataSet)dataSet).getQueryName())) != null) {
                String string3;
                String string4 = jetUHierDataSource.getURIValue();
                if (string4.trim().length() > 0 && string4.indexOf(File.separator) <= -1 && !vector.contains(string4) && string4.indexOf("://") <= -1) {
                    vector.add(string4);
                }
                if ((string3 = jetUHierDataSource.getXSDValue()).trim().length() > 0 && string3.indexOf(File.separator) <= -1 && !vector.contains(string3) && string3.indexOf("://") <= -1) {
                    vector.add(string3);
                }
            }
        }
        catch (Exception exception) {
            JRLog.error(3, exception);
        }
        JRLog.trace(6, "JReportUtil: return from method: getHdsFiles(JetUUniverse unv, JetRptReportSet rpt), cost: " + (System.currentTimeMillis() - l));
        JRLog.trace(6, vector);
        return vector;
    }

    private static String currentTimeMillis(String string) {
        String string2 = new File(string).getName();
        int n = (string2 = Env.delXMLExt(string2)).lastIndexOf(46);
        if (n > -1) {
            if (string2.substring(n).equalsIgnoreCase(NLSResourceBundle.PROPS_FILE_EXTENSION)) {
                if ((n = (string2 = string2.substring(0, n)).lastIndexOf(NLSResourceBundle.FILENAME_CONCAT_CHAR)) > -1 && string2.length() - n < 4 && (n = (string2 = string2.substring(0, n)).lastIndexOf(NLSResourceBundle.FILENAME_CONCAT_CHAR)) > -1 && string2.length() - n < 4) {
                    string2 = string2.substring(0, n);
                }
            } else {
                string2 = string2.substring(0, n);
            }
        }
        return string2;
    }

    private static String dataMappingFile(String string) {
        int n = (string = Env.delXMLExt(string)).lastIndexOf(".");
        return n > -1 ? string.substring(n) : "";
    }

    private static final void delXMLExt() {
        System.out.println("Usage:  java <-Dreporthome=reporthome> jet.report.JReportUtil [reportfile] [destFolder]");
        System.out.println("Copy all the relative files of the report to the destination folder.");
    }

    public static void main(String[] stringArray) {
        block14: {
            if (stringArray.length == 2) {
                Env.checkEnv(null);
                try {
                    Vector[] vectorArray = JReportUtil.IRT_NLSPROP(stringArray[0], true, true);
                    String string = stringArray[1];
                    if (new File(string).isDirectory()) {
                        Vector vector;
                        String string2;
                        File file;
                        boolean bl;
                        if (!string.endsWith(File.separator)) {
                            string = string + File.separator;
                        }
                        String string3 = (bl = (file = new File(stringArray[0]).getCanonicalFile()).isDirectory()) ? file.getPath() : file.getParent();
                        String string4 = string2 = bl ? null : file.getName();
                        if (vectorArray != null) {
                            int n = 0;
                            while (n < NUMOFIRT) {
                                vector = vectorArray[n];
                                if (vector != null) {
                                    try {
                                        if (n == IRT_FONT || n == IRT_STYLEGROUP) {
                                            FileUtil.copyFiles(vector, string);
                                        } else {
                                            FileUtil.copyFiles(string3, string, vector);
                                        }
                                    }
                                    catch (IOException iOException) {
                                        JRLog.error(2, "zipRptFile\n" + iOException.getMessage(), (Throwable)iOException);
                                    }
                                }
                                ++n;
                            }
                        }
                        if (!bl) {
                            vector = JReportUtil.containsKey(string3, string2);
                            FileUtil.copyFiles(string3, string, vector);
                        }
                        vector = JReportUtil.copyFiles(string3, bl);
                        FileUtil.copyFiles(string3, string, vector);
                        break block14;
                    }
                    JReportUtil.delXMLExt();
                }
                catch (Exception exception) {
                    JRLog.error(2, "", (Throwable)exception);
                }
            } else {
                JReportUtil.delXMLExt();
            }
        }
        System.exit(0);
    }

    public static int[] buildKeyRect(String string, boolean bl, String string2) {
        int[] nArray = new int[3];
        nArray[0] = 0;
        nArray[1] = 0;
        int n = bl ? 1234567890 : 987654321;
        int n2 = 237523281;
        String string3 = "jinfonet";
        int n3 = 0;
        while (n3 < string.length()) {
            char c;
            int n4;
            nArray[0] = nArray[0] + string.charAt(n3) * n;
            char c2 = string.charAt(n3);
            if (string2 != null) {
                n4 = 0;
                while (n4 < string2.length()) {
                    c = string2.charAt(n4);
                    nArray[1] = nArray[1] + (nArray[1] + c2 + c) * c2 * c * n2;
                    ++n4;
                }
            }
            n4 = 0;
            while (n4 < string3.length()) {
                c = string3.charAt(n4);
                nArray[2] = nArray[2] + (nArray[2] + c2 + c) * c2 * c * n2;
                ++n4;
            }
            ++n3;
        }
        return nArray;
    }
}

