/*
 * Decompiled with CFR 0.152.
 */
package jet.report.xls.chart;

import java.io.IOException;
import jet.report.xls.Biff;
import jet.report.xls.GlobalWorksheet;
import util.RandomAccessStream;

public class MarkerFormat
extends Biff {
    public static final short NONE = 0;
    public static final short SQUARE = 1;
    public static final short DIAMOND = 2;
    public static final short TRIANGLE = 3;
    public static final short X = 4;
    public static final short STAR = 5;
    public static final short DOWJONES = 6;
    public static final short DEVIATION = 7;
    public static final short CIRCLE = 8;
    public static final short PLUSSIGN = 9;
    public static final short AUTOCOLOR = 1;
    public static final short NOBACK = 16;
    public static final short NOFORE = 32;
    int QOIV;
    int getColorIndex;
    int output;
    short readInt;
    short readShort;
    short writeInt;
    short writeShort;

    public MarkerFormat() {
    }

    public MarkerFormat(int n, int n2, short s, short s2, short s3, short s4, int n3) {
        this.QOIV = n;
        this.getColorIndex = n2;
        this.readInt = s;
        this.readShort = s2;
        this.writeInt = s3;
        this.writeShort = s4;
        this.output = n3;
        this.length = 20;
    }

    public MarkerFormat(int n, int n2, short s, short s2, int n3, GlobalWorksheet globalWorksheet) {
        this.QOIV = n;
        this.getColorIndex = n2;
        this.readInt = s;
        this.readShort = s2;
        this.writeInt = (short)globalWorksheet.getColorIndex(n);
        this.writeShort = (short)globalWorksheet.getColorIndex(n2);
        this.output = n3;
        this.length = 20;
    }

    public final int opcode() {
        return 4105;
    }

    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        this.writeInt(randomAccessStream, this.QOIV);
        this.writeInt(randomAccessStream, this.getColorIndex);
        this.writeShort(randomAccessStream, this.readInt);
        this.writeShort(randomAccessStream, this.readShort);
        this.writeShort(randomAccessStream, this.writeInt);
        this.writeShort(randomAccessStream, this.writeShort);
        this.writeInt(randomAccessStream, this.output);
        return this.length + 4;
    }

    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.QOIV = this.readInt(randomAccessStream);
        this.getColorIndex = this.readInt(randomAccessStream);
        this.readInt = this.readShort(randomAccessStream);
        this.readShort = this.readShort(randomAccessStream);
        this.writeInt = this.readShort(randomAccessStream);
        this.writeShort = this.readShort(randomAccessStream);
        this.output = this.readInt(randomAccessStream);
    }

    public void setType(byte by) {
        this.readInt = by;
    }

    public short getType() {
        return this.readInt;
    }

    public boolean isAutoColor() {
        return (this.readShort & 1) == 1;
    }

    public void setAutoColor(boolean bl) {
        this.readShort = (short)(bl ? this.readShort | 1 : this.readShort & 0xFFFFFFFE);
    }

    public boolean isNoback() {
        return (this.readShort & 0x10) == 16;
    }

    public void setNoback(boolean bl) {
        this.readShort = (short)(bl ? this.readShort | 0x10 : this.readShort & 0xFFFFFFEF);
    }

    public boolean isNofore() {
        return (this.readShort & 0x20) == 32;
    }

    public void setNofore(boolean bl) {
        this.readShort = (short)(bl ? this.readShort | 0x20 : this.readShort & 0xFFFFFFDF);
    }
}

