/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.resourceLogic;

import com.jinfonet.util.JRLog;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.formula.FormulaInfo;
import jet.formula.ParamDesc;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.universe.JetUDBField;
import jet.universe.JetUFormulaInterface;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.DataElementInfo;
import jet.universe.businesslogic.DetailInformation;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.InvalidEntityException;
import toolkit.db.DbTools;

class ParseResource {
    protected JetUUniverse unvs;
    protected Vector mappingFlds;
    protected Vector blColumnNames;
    protected Vector namesInReturnValue = new Vector();
    protected String strQueryName;
    protected String dataSourceName = "";
    protected Hashtable htDbFields = new Hashtable();
    protected Hashtable htBlDbFields = new Hashtable();
    protected Hashtable htFmls = new Hashtable();
    protected Hashtable htBlFmls = new Hashtable();
    protected Hashtable paramsBuff = new Hashtable();
    protected Vector returnValueParams = new Vector();
    protected Hashtable htMesures = new Hashtable();
    protected Hashtable htBlNodes = new Hashtable();
    protected int dataSetType = -1;
    protected boolean isBLData = false;
    private Vector QOIV = new Vector();

    public ParseResource(JetUUniverse jetUUniverse, String string, String string2, Vector vector, Vector vector2, Vector vector3, boolean bl, int n) {
        this.unvs = jetUUniverse;
        this.mappingFlds = vector;
        this.blColumnNames = vector2;
        this.QOIV = vector3;
        this.strQueryName = string2;
        this.dataSourceName = string;
        this.dataSetType = n;
        this.isBLData = bl;
    }

    protected void setNamesInReturnValue(Vector vector) {
        if (vector == null) {
            return;
        }
        this.namesInReturnValue = vector;
    }

    protected void initialize() {
        if (this.isBLData) {
            this.QOIV();
            if (this.mappingFlds != null && this.mappingFlds.size() > 0) {
                this.initMappingFields();
            }
        } else {
            this.initMappingFields();
        }
        this.checkIfMappingFldsValidToQuery();
    }

    protected void initMappingFields() {
        if (this.mappingFlds == null) {
            return;
        }
        int n = this.mappingFlds.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.mappingFlds.elementAt(n2);
            this.add(string, null);
            ++n2;
        }
    }

    private void QOIV() {
        if (this.blColumnNames == null) {
            return;
        }
        int n = 0;
        while (n < this.blColumnNames.size()) {
            String string = (String)this.blColumnNames.elementAt(n);
            BLNode bLNode = this.contains(string);
            String string2 = "";
            if (bLNode == null || !(bLNode instanceof DataElementInfo)) {
                JRLog.error(3, 3215003, new Object[]{string});
            } else {
                if (bLNode instanceof DimensionInfo) {
                    string2 = ((DimensionInfo)bLNode).getRefMappingName();
                } else if (bLNode instanceof DetailInformation) {
                    string2 = ((DetailInformation)bLNode).getRefMappingName();
                } else if (bLNode instanceof MeasureInfo) {
                    string2 = ((MeasureInfo)bLNode).getRefMappingName();
                }
                this.add(string2, string);
            }
            ++n;
        }
    }

    private void add(String string, String string2) {
        JetUResourceEntity jetUResourceEntity = this.addElement(this.dataSourceName, this.strQueryName, string);
        if (jetUResourceEntity == null && this.dataSetType != 0) {
            JRLog.error(3, 3215003, new Object[]{string});
            return;
        }
        if (jetUResourceEntity instanceof JetUDBField) {
            if (!this.htDbFields.containsKey(string)) {
                this.htDbFields.put(string, jetUResourceEntity);
            }
            if (string2 != null && !this.htBlDbFields.containsKey(string2)) {
                this.htBlDbFields.put(string2, jetUResourceEntity);
            }
        } else if (jetUResourceEntity instanceof JetUFormulaInterface) {
            this.putFormula(string, string2, (JetUFormulaInterface)((Object)jetUResourceEntity));
        } else if (jetUResourceEntity instanceof JetUParameter) {
            this.putParameter(string.toUpperCase(), (JetUParameter)jetUResourceEntity);
        }
    }

    private JetUResourceEntity addElement(String string, String string2, String string3) {
        Object object;
        Object object2 = null;
        if (this.dataSetType != 0) {
            object2 = string != null ? this.unvs.getResourceByName(string, string2, string3) : this.unvs.getResourceByName(string2, string3);
        }
        if (object2 != null) {
            if (string == null || string2 == null) {
                JRLog.error(3, 3215003, new Object[]{string, string2});
                object2 = null;
            } else {
                object = new Vector(1);
                ((Vector)object).add(string3);
                try {
                    this.unvs.checkIfMappingFldsValidToQuery(string, string2, (Vector)object);
                }
                catch (InvalidEntityException invalidEntityException) {
                    JRLog.error(3, 3215003, new Object[]{string3});
                    object2 = null;
                }
                catch (CannotFindQuery cannotFindQuery) {
                    JRLog.error(3, 3215003, new Object[]{string3});
                    object2 = null;
                }
            }
        }
        if (object2 == null) {
            object = this.unvs.getAnyResourceByName(string3);
            if (object != null && object instanceof JetUParameter) {
                object2 = object;
            } else if (object != null || this.dataSetType == 0) {
                // empty if block
            }
        }
        return object2;
    }

    protected void putFormula(String string, String string2, JetUFormulaInterface jetUFormulaInterface) {
        FormulaInfo formulaInfo = jetUFormulaInterface.getFormulaInfo();
        if (formulaInfo.parseOK) {
            if (!this.htFmls.containsKey(string)) {
                this.htFmls.put(string, jetUFormulaInterface);
            }
            if (string2 != null && !this.htBlFmls.containsKey(string2)) {
                this.htBlFmls.put(string2, jetUFormulaInterface);
            }
            this.putRefFldsToBuf(formulaInfo.refDBfield, this.htDbFields);
            this.putRefParamToBuf(formulaInfo.refParameter);
            this.blColumnNames(formulaInfo.refFormula);
        } else {
            JRLog.error(3, 3215004, new Object[]{string});
        }
    }

    private void blColumnNames(Vector vector) {
        String string = null;
        int n = 0;
        while (vector != null && n < vector.size()) {
            string = (String)vector.elementAt(n);
            JetUResourceEntity jetUResourceEntity = this.addElement(this.dataSourceName, this.strQueryName, string);
            if (jetUResourceEntity instanceof JetUFormulaInterface) {
                this.putFormula(string, null, (JetUFormulaInterface)((Object)jetUResourceEntity));
            }
            ++n;
        }
    }

    protected void putParameter(String string, JetUParameter jetUParameter) {
        if (this.QOIV.contains(string)) {
            this.putParameter(string, jetUParameter, 1);
        } else {
            this.putParameter(string, jetUParameter, 0);
        }
    }

    protected void putParameter(String string, JetUParameter jetUParameter, int n) {
        if (!this.paramsBuff.containsKey(string)) {
            Object object;
            ParamDesc paramDesc = jetUParameter.getParamDesc();
            paramDesc.setBeColumn(n);
            if (!this.returnValueParams.contains(string) && this.namesInReturnValue.contains(string)) {
                this.returnValueParams.addElement(string);
            }
            this.paramsBuff.put(string, paramDesc);
            String string2 = paramDesc.getBinding();
            String string3 = paramDesc.getColumn();
            if (string2 != null && (object = (JetUParameter)this.unvs.getMaterialByName(this.dataSourceName, string2)) != null) {
                paramDesc = ((JetUParameter)object).getParamDesc();
                paramDesc.setBeColumn(5);
                this.paramsBuff.put(string2.toUpperCase(), paramDesc);
            }
            if (n == 0 && string3 != null && string3.length() > 0) {
                paramDesc.setBeColumn(4);
            }
            if (jetUParameter.isReferPara()) {
                object = new Hashtable();
                jetUParameter.getAllReferP(this.unvs, this.dataSourceName, this.strQueryName, (Hashtable)object);
                Enumeration enumeration = ((Hashtable)object).keys();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    if (this.mappingFlds.contains(string4.toUpperCase())) continue;
                    this.putParameter(string4.toUpperCase(), (JetUParameter)((Hashtable)object).get(string4));
                }
            }
        }
    }

    protected void putRefFldsToBuf(Vector vector, Hashtable hashtable) {
        int n = 0;
        while (vector != null && n < vector.size()) {
            String string = (String)vector.elementAt(n);
            JetUResourceEntity jetUResourceEntity = this.addElement(this.dataSourceName, this.strQueryName, string);
            if (!hashtable.containsKey(string) && jetUResourceEntity != null) {
                hashtable.put(string, jetUResourceEntity);
            } else if (jetUResourceEntity == null) {
                JRLog.error(3, 3215003, new Object[]{string});
            }
            ++n;
        }
    }

    protected void putRefParamToBuf(Vector vector) {
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                JetUResourceEntity jetUResourceEntity = this.addElement(this.dataSourceName, this.strQueryName, string);
                if (jetUResourceEntity != null) {
                    this.putParameter(string.toUpperCase(), (JetUParameter)jetUResourceEntity);
                } else {
                    JRLog.error(3, 3215003, new Object[]{string});
                }
                ++n;
            }
        }
    }

    protected Vector getHtDbFieldNames() {
        Vector vector = new Vector();
        Enumeration enumeration = this.htDbFields.keys();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    protected Vector getHtDbFieldBlNames() {
        Vector vector = new Vector();
        Enumeration enumeration = this.htBlDbFields.keys();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    protected Vector getHtDbFields() {
        Vector vector = new Vector();
        Enumeration enumeration = this.htDbFields.keys();
        while (enumeration.hasMoreElements()) {
            vector.add(this.htDbFields.get(enumeration.nextElement()));
        }
        return vector;
    }

    protected Hashtable getParamsBuff() {
        return this.paramsBuff;
    }

    protected Vector getFmlNames() {
        Vector vector = new Vector();
        Enumeration enumeration = this.htFmls.keys();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    protected Vector getFmlBlNames() {
        Vector vector = new Vector();
        Enumeration enumeration = this.htBlFmls.keys();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    private void checkIfMappingFldsValidToQuery() {
        JetUResourceEntity jetUResourceEntity;
        Object object;
        Object object2;
        if (this.dataSetType != 3) {
            return;
        }
        JetUHierDataSource jetUHierDataSource = (JetUHierDataSource)this.unvs.getQueriableByResourceName(this.dataSourceName, this.strQueryName);
        StringBuffer stringBuffer = new StringBuffer(jetUHierDataSource.getParameter());
        String string = null;
        while ((string = DbTools.getFirstParameterNameInString(stringBuffer, new StringBuffer())) != null) {
            object2 = this.addElement(this.dataSourceName, this.strQueryName, string);
            if (object2 instanceof JetUParameter) {
                this.putParameter(string.toUpperCase(), (JetUParameter)object2);
                continue;
            }
            JRLog.error(3, 3215003, new Object[]{string});
        }
        object2 = jetUHierDataSource.getURI();
        if (((String)object2).startsWith(":") || ((String)object2).startsWith("@")) {
            object = ((String)object2).substring(1);
            jetUResourceEntity = this.addElement(this.dataSourceName, this.strQueryName, (String)object);
            if (jetUResourceEntity instanceof JetUParameter) {
                this.putParameter(((String)object).toUpperCase(), (JetUParameter)jetUResourceEntity);
            } else {
                JRLog.error(3, 3215003, new Object[]{object});
            }
        }
        if ((object = jetUHierDataSource.getParams()) != null) {
            int n = ((Vector)object).size();
            int n2 = 0;
            while (n2 < n) {
                String string2 = (String)((Vector)object).elementAt(n2);
                jetUResourceEntity = this.addElement(this.dataSourceName, this.strQueryName, (String)((Vector)object).elementAt(n2));
                if (jetUResourceEntity instanceof JetUParameter) {
                    this.putParameter(string2.toUpperCase(), (JetUParameter)jetUResourceEntity);
                } else {
                    JRLog.error(3, 3215003, new Object[]{string2});
                }
                ++n2;
            }
        }
    }

    private BLNode contains(String string) {
        JetUQueriable jetUQueriable = this.unvs.getQueriableByResourceName(this.dataSourceName, this.strQueryName);
        JBusinessLogic jBusinessLogic = ObjectLogicFactory.getDataSetLogic().getBusinessLogic(jetUQueriable);
        if (jBusinessLogic != null) {
            return jBusinessLogic.get(string);
        }
        return null;
    }
}

