/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.datatypes.DataTypeUtils;
import guitools.PainterConstants;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetEnumeration;
import jet.controls.JetFont;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetPropertyGroup;
import jet.controls.JetStringList;
import jet.controls.JetUnitNumber;
import jet.log.JRLogger;
import jet.naming.EnumerationConstant;
import jet.naming.PropertyNameConstant;
import jet.report.JetRptBorderStyle;
import jet.report.JetRptLineWidth;
import jet.universe.JetUResourceEntity;
import jet.util.HashVector;
import jet.util.ReportFormat;
import jet.util.ValueToUnit;

public abstract class JetUResourceField
extends JetUResourceEntity
implements PainterConstants {
    private static JRLogger ALIGNMENT_HOR_STR_NAMES = JRLogger.getLogger((class$jet$universe$JetUFileQuery == null ? (class$jet$universe$JetUFileQuery = JetUResourceField.class$("jet.universe.JetUFileQuery")) : class$jet$universe$JetUFileQuery).getName());
    protected static final int DEFAULT_FONTSIZE = Unit.convertInchToUnit(0.125);
    public JetColor backColor = new JetColor(this, "Background", null, true);
    public JetColor fontColor = new JetColor(this, "Foreground", Color.black);
    public JetUnitNumber width = new JetUnitNumber(this, "Width");
    public JetUnitNumber height = new JetUnitNumber(this, "Height");
    public JetFont fontName = new JetFont(this, "FontFace");
    public JetUnitNumber fontSize = new JetUnitNumber(this, "FontSize");
    public JetBoolean bold = new JetBoolean(this, "Bold", false);
    public JetBoolean italic = new JetBoolean(this, "Italic", false);
    public JetBoolean strikeout = new JetBoolean(this, "StrikeOut", false);
    public JetBoolean underline = new JetBoolean(this, "Underline", false);
    public JetEnumeration align = new JetEnumeration(this, "Alignment", 0);
    public JetEnumeration patternStyle = new JetEnumeration(this, "PatternStyle", 78);
    public JetColor patternColor = new JetColor(this, "PatternColor", Color.black, false);
    public JetStringList format = new JetStringList(this, "Format");
    public JetBoolean autoFit = new JetBoolean(this, "AutoFit", false);
    public JetBoolean wordWrap = new JetBoolean(this, "WordWrap", false);
    public JetRptLineWidth borderWidth = new JetRptLineWidth(this, "BorderWidth");
    public JetRptBorderStyle top = new JetRptBorderStyle(this, "TopLine");
    public JetRptBorderStyle bottom = new JetRptBorderStyle(this, "BottomLine");
    public JetRptBorderStyle left = new JetRptBorderStyle(this, "LeftLine");
    public JetRptBorderStyle right = new JetRptBorderStyle(this, "RightLine");
    public JetColor borderColor = new JetColor(this, "BorderColor", Color.black);
    public JetBoolean drawShadow = new JetBoolean(this, "Shadow");
    public JetColor shadowColor = new JetColor(this, "ShadowColor", Color.black);
    public JetEnumeration HAlignment = new JetEnumeration(this, PropertyNameConstant.getNameByID(979), 2);
    public JetEnumeration VAlignment = new JetEnumeration(this, PropertyNameConstant.getNameByID(1760), 6);
    public JetUnitNumber topPadding = new JetUnitNumber(this, "padding-top");
    public JetUnitNumber bottomPadding = new JetUnitNumber(this, "padding-bottom");
    public JetUnitNumber leftPadding = new JetUnitNumber(this, "padding-left");
    public JetUnitNumber rightPadding = new JetUnitNumber(this, "padding-right");
    static Class class$jet$universe$JetUFileQuery;

    public JetUResourceField() {
        this.I();
    }

    public JetUResourceField(String string, String string2) {
        super(string, string2);
        this.I();
    }

    void I() {
        this.topPadding.setUnitValue(ValueToUnit.convertInchToUnit(0.01));
        this.bottomPadding.setUnitValue(ValueToUnit.convertInchToUnit(0.01));
        this.leftPadding.setUnitValue(ValueToUnit.convertInchToUnit(0.03));
        this.rightPadding.setUnitValue(ValueToUnit.convertInchToUnit(0.03));
        this.patternStyle.set(new Integer(0));
        this.top.set(new Integer(0));
        this.bottom.set(new Integer(0));
        this.left.set(new Integer(0));
        this.right.set(new Integer(0));
        this.fontSize.setUnitValue(DEFAULT_FONTSIZE);
        this.align.set(new Integer(5));
        this.HAlignment.set(new Integer(0));
        this.VAlignment.set(new Integer(0));
    }

    public void setHAlignmentDefault(int n) {
        this.HAlignment.set(EnumerationConstant.ALIGNMENT_HOR_STR_NAMES[DataTypeUtils.getDefaultHAlignment(n)]);
    }

    public void setVAlignmentDefault(int n) {
        this.VAlignment.set(EnumerationConstant.ALIGNMENT_VER_STR_NAMES[DataTypeUtils.getDefaultVAlignment(n)]);
    }

    public void setFormatDefault(int n) {
        this.format.setDefault(DataTypeUtils.getDefaultFormat(n));
    }

    public void copyInitProperties(JetUResourceField jetUResourceField, JetObject jetObject) {
        HashVector hashVector = (HashVector)jetUResourceField.getEditableProperties();
        int n = 0;
        while (n < hashVector.size()) {
            String string = (String)hashVector.elementAt(n);
            if (!string.equals("General")) {
                JetPropertyGroup jetPropertyGroup = (JetPropertyGroup)hashVector.get(string);
                Vector vector = jetPropertyGroup.getProperties();
                int n2 = 0;
                while (n2 < vector.size()) {
                    JetProperty jetProperty = (JetProperty)vector.elementAt(n2);
                    JetProperty jetProperty2 = jetObject.nameToProperty(jetProperty.getName());
                    if (jetProperty2 != null) {
                        try {
                            jetProperty2.setUnitValue(jetProperty.toUnitString());
                        }
                        catch (Exception exception) {
                            ALIGNMENT_HOR_STR_NAMES.debug(exception);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public Hashtable copyInitProperties() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        HashVector hashVector = (HashVector)this.getEditableProperties();
        int n = 0;
        while (n < hashVector.size()) {
            String string = (String)hashVector.elementAt(n);
            if (!string.equals("General")) {
                JetPropertyGroup jetPropertyGroup = (JetPropertyGroup)hashVector.get(string);
                Vector vector = jetPropertyGroup.getProperties();
                int n2 = 0;
                while (n2 < vector.size()) {
                    JetProperty jetProperty = (JetProperty)vector.elementAt(n2);
                    hashtable.put(jetProperty.getName(), jetProperty.toUnitString());
                    ++n2;
                }
            }
            ++n;
        }
        return hashtable;
    }

    public Hashtable copyInitNoGeomtryProperties() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        HashVector hashVector = (HashVector)this.getEditableProperties();
        int n = 0;
        while (n < hashVector.size()) {
            String string = (String)hashVector.elementAt(n);
            if (!string.equals("General") && !string.equals("Geometry")) {
                JetPropertyGroup jetPropertyGroup = (JetPropertyGroup)hashVector.get(string);
                Vector vector = jetPropertyGroup.getProperties();
                int n2 = 0;
                while (n2 < vector.size()) {
                    JetProperty jetProperty = (JetProperty)vector.elementAt(n2);
                    hashtable.put(jetProperty.getName(), jetProperty.toUnitString());
                    ++n2;
                }
            }
            ++n;
        }
        return hashtable;
    }

    public void copyInitNoGeomtryProperties(JetUResourceField jetUResourceField, JetObject jetObject) {
        HashVector hashVector = (HashVector)jetUResourceField.getEditableProperties();
        int n = 0;
        while (n < hashVector.size()) {
            String string = (String)hashVector.elementAt(n);
            if (!string.equals("General") && !string.equals("Geometry")) {
                JetPropertyGroup jetPropertyGroup = (JetPropertyGroup)hashVector.get(string);
                Vector vector = jetPropertyGroup.getProperties();
                int n2 = 0;
                while (n2 < vector.size()) {
                    JetProperty jetProperty = (JetProperty)vector.elementAt(n2);
                    JetProperty jetProperty2 = jetObject.nameToProperty(jetProperty.getName());
                    if (jetProperty2 != null) {
                        try {
                            jetProperty2.setUnitValue(jetProperty.toUnitString());
                        }
                        catch (Exception exception) {
                            ALIGNMENT_HOR_STR_NAMES.debug(exception);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void afterInit() {
        super.afterInit();
        JetProperty jetProperty = this.nameToProperty("SQLType");
        JetProperty jetProperty2 = this.nameToProperty("Precision");
        if (jetProperty != null && jetProperty2 != null) {
            Vector vector = ReportFormat.getMoreFormat(((JetNumber)jetProperty).get(), ((JetNumber)jetProperty2).get());
            this.format.setList(vector);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

