/*
 * Decompiled with CFR 0.152.
 */
package jet.upgrade;

import java.awt.Color;
import java.util.Iterator;
import jet.controls.JetBoolean;
import jet.controls.JetColumnName;
import jet.controls.JetCommand;
import jet.controls.JetEnumeration;
import jet.controls.JetImgProperty;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetReference;
import jet.controls.JetRootable;
import jet.report.JetRptDataSourceProperty;
import jet.report.JetRptField;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptObject;
import jet.report.JetRptRectangle;
import jet.report.JetRptSectionObject;
import jet.report.table.JetRptNewTable;
import jet.report.table.JetRptTableGroup;
import jet.udos.JHyperLinkTmpl;

class UpgradeToV8Util {
    public static final String SUFFIX_REPORT = "_report";
    public static final String SUFFIX_VIEW = "_view";
    public static final String CONVERT_DATASET_INST_NAME = "convert_dataset";
    public static final String CONVERT_SECTION_OBJECT_INST_NAME = "convert_sectionObject";

    UpgradeToV8Util() {
    }

    protected static synchronized void setProperty(JetObject jetObject, JetProperty jetProperty) {
        JetProperty jetProperty2 = jetObject.nameToProperty(jetProperty.getName());
        if (jetProperty2 == null) {
            return;
        }
        if (jetProperty != jetProperty2) {
            JetProperty jetProperty3;
            Object object;
            if (jetProperty == null) {
                return;
            }
            if (jetProperty instanceof JetCommand && jetProperty2 instanceof JetCommand) {
                object = (JetCommand)jetProperty;
                jetProperty3 = (JetCommand)jetProperty2;
                ((JetCommand)jetProperty3).set(((JetCommand)object).get());
                ((JetCommand)jetProperty3).setData(((JetCommand)object).getData());
            }
            if ((object = jetProperty.toUnitString()) == null || !((String)object).equals(jetProperty2.toUnitString())) {
                if (jetProperty2 instanceof JetReference) {
                    jetProperty3 = (JetReference)jetProperty;
                    JetReference jetReference = (JetReference)jetProperty2;
                    try {
                        Object object2 = jetProperty3.getValue();
                        jetReference.setObject(object2);
                    }
                    catch (NullPointerException nullPointerException) {}
                } else {
                    try {
                        jetProperty2.setUnitValue((String)object);
                        if (jetProperty instanceof JetColumnName) {
                            ((JetColumnName)jetProperty2).setDispName(((JetColumnName)jetProperty).getDispName());
                        } else if (jetProperty2 instanceof JetImgProperty) {
                            ((JetImgProperty)jetProperty2).setPath(((JetImgProperty)jetProperty).getPath());
                            ((JetImgProperty)jetProperty2).setURL(((JetImgProperty)jetProperty).getURL());
                            ((JetImgProperty)jetProperty2).setResourceID(((JetImgProperty)jetProperty).getResourceID());
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if (jetProperty.isChangeByOther()) {
                jetProperty2.setChangeByObject(jetProperty.getChangeByObject());
            }
        }
    }

    protected static synchronized void copyProperties(JetRptObject jetRptObject, JetRptObject jetRptObject2) {
        JetObject.copyProperties(jetRptObject2, jetRptObject);
        UpgradeToV8Util.processDatasourceProperty(jetRptObject2);
    }

    protected static synchronized void processDatasourceProperty(JetRptObject jetRptObject) {
        Iterator iterator = jetRptObject.getProperties().entrySet().iterator();
        while (iterator.hasNext()) {
            JetProperty jetProperty = (JetProperty)iterator.next().getValue();
            if (!(jetProperty instanceof JetRptDataSourceProperty)) continue;
            jetProperty.set(null);
        }
    }

    protected static synchronized JetRptObject processTopN(JetRptObject jetRptObject) {
        if (jetRptObject instanceof JetRptNewTable || jetRptObject instanceof JetRptSectionObject || jetRptObject instanceof JetRptTableGroup || jetRptObject instanceof JetRptGroupPanel) {
            JetNumber jetNumber = (JetNumber)jetRptObject.nameToProperty("TopN");
            JetBoolean jetBoolean = (JetBoolean)jetRptObject.nameToProperty("NeedTopN");
            JetNumber jetNumber2 = (JetNumber)jetRptObject.nameToProperty("SelectN");
            JetEnumeration jetEnumeration = (JetEnumeration)jetRptObject.nameToProperty("SelectType");
            if (jetNumber.isChangeByOther()) {
                jetEnumeration.set(new Integer(1));
                jetNumber2.setChangeByObject(jetNumber.getChangeByObject());
                jetNumber.setChangeByObject(null);
                jetNumber.set(-1);
                jetBoolean.set(false);
            } else if (jetNumber.get() != -1) {
                jetEnumeration.set(new Integer(1));
                jetNumber2.set(jetNumber.get());
                jetNumber.set(-1);
                jetBoolean.set(false);
            }
        }
        return jetRptObject;
    }

    protected static synchronized void processBorder(JetRptObject jetRptObject) {
        if (jetRptObject instanceof JetRptRectangle) {
            JetRptRectangle jetRptRectangle = (JetRptRectangle)jetRptObject;
            int n = jetRptRectangle.borderWidth.get();
            jetRptRectangle.topBorderWidth.set(n);
            jetRptRectangle.bottomBorderWidth.set(n);
            jetRptRectangle.leftBorderWidth.set(n);
            jetRptRectangle.rightBorderWidth.set(n);
            Color color = jetRptRectangle.borderColor.get();
            jetRptRectangle.topBorderColor.set(color);
            jetRptRectangle.bottomBorderColor.set(color);
            jetRptRectangle.leftBorderColor.set(color);
            jetRptRectangle.rightBorderColor.set(color);
        }
    }

    protected static synchronized void processReference(JetRootable jetRootable, JetObject jetObject) {
        Iterator iterator = jetObject.getProperties().values().iterator();
        while (iterator.hasNext()) {
            JetObject jetObject2;
            String string;
            Object object;
            JetProperty jetProperty = (JetProperty)iterator.next();
            if (!(jetProperty instanceof JetReference) || !((object = ((JetReference)jetProperty).getObject()) instanceof JetObject) || (string = ((JetObject)object).getInstNameDirectly()) == null || (jetObject2 = ((JetObject)((Object)jetRootable)).nameToObject(string)) == null || jetObject2 == object) continue;
            ((JetReference)jetProperty).setReference(jetObject2);
        }
    }

    protected static synchronized void processAlignment(JetRptObject jetRptObject) {
        int n = -1;
        if (jetRptObject instanceof JetRptField) {
            n = ((JetRptField)jetRptObject).align.intValue();
        } else if (jetRptObject instanceof JHyperLinkTmpl) {
            n = ((JHyperLinkTmpl)jetRptObject).align.intValue();
        } else {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 1: {
                n2 = 0;
                n3 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                n3 = 1;
                break;
            }
            case 3: {
                n2 = 1;
                n3 = 1;
                break;
            }
            case 4: {
                n2 = 0;
                n3 = 0;
                break;
            }
            case 5: {
                n2 = 2;
                n3 = 0;
                break;
            }
            case 6: {
                n2 = 1;
                n3 = 0;
                break;
            }
            case 7: {
                n2 = 0;
                n3 = 2;
                break;
            }
            case 8: {
                n2 = 2;
                n3 = 2;
                break;
            }
            case 9: {
                n2 = 1;
                n3 = 2;
                break;
            }
            case 10: {
                n2 = 3;
                n3 = 1;
                break;
            }
            case 11: {
                n2 = 3;
                n3 = 0;
                break;
            }
            case 12: {
                n2 = 3;
                n3 = 0;
            }
        }
        if (jetRptObject instanceof JetRptField) {
            ((JetRptField)jetRptObject).HAlignment.setValue(new Integer(n2));
            ((JetRptField)jetRptObject).VAlignment.setValue(new Integer(n3));
        } else if (jetRptObject instanceof JHyperLinkTmpl) {
            ((JHyperLinkTmpl)jetRptObject).HAlignment.setValue(new Integer(n2));
            ((JHyperLinkTmpl)jetRptObject).VAlignment.setValue(new Integer(n3));
        }
    }
}

