/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.report.JReportNLSSupport;
import jet.report.JetRptObject;
import jet.reportset.JetRptReportSet;
import jet.util.NLSResourceBundle;
import jet.util.ValueToUnit;

public class NLSResourceBundleManager {
    private static int CATEGORY_COLUMN_TEXT = 0;
    public static int IDX_CATEGORY_LABEL_TEXT = CATEGORY_COLUMN_TEXT++;
    public static int IDX_CATEGORY_COLUMN_TEXT = CATEGORY_COLUMN_TEXT++;
    public static int IDX_CATEGORY_FORMAT_TEXT = CATEGORY_COLUMN_TEXT++;
    public static int IDX_CATEGORY_FIELD_VALUE = CATEGORY_COLUMN_TEXT++;
    public static int IDX_CATEGORY_FONT_TEXT = CATEGORY_COLUMN_TEXT++;
    public static int IDX_CATEGORY_PARAM_PROMPT = CATEGORY_COLUMN_TEXT++;
    public static int IDX_CATEGORY_TOC_TEXT = CATEGORY_COLUMN_TEXT++;
    public static final String[] INDEX_TO_CATEGORY = new String[]{JReportNLSSupport.CATEGORY_LABEL_TEXT, JReportNLSSupport.CATEGORY_COLUMN_TEXT, JReportNLSSupport.CATEGORY_FORMAT_TEXT, "FIELD_VALUE", JReportNLSSupport.CATEGORY_FONT_TEXT, JReportNLSSupport.CATEGORY_PARAMETER_PROMPTTXT, JReportNLSSupport.CATEGORY_TOC_TEXT};
    public static final String[] INDEX_TO_CATEGORYNAME = new String[]{"Label", "Column", "Format", "DataMapping", "FontFace/Name", "Prompt", "TOC"};

    public static NLSResourceBundle newNLSResourceBundleInstance() {
        NLSResourceBundle nLSResourceBundle = new NLSResourceBundle();
        nLSResourceBundle.isNewVersion = true;
        return nLSResourceBundle;
    }

    public static Locale[] getAvailableLocalesOfReport(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            return new Locale[0];
        }
        String string2 = file.getName();
        File file2 = file.getParentFile();
        String string3 = NLSResourceBundle.getReportNameFromFileName(string2);
        File[] fileArray = NLSResourceBundleManager.CATEGORY_FORMAT_TEXT(string3, NLSResourceBundle.PROPS_FILE_EXTENSION, file2);
        return NLSResourceBundleManager.CATEGORY_FONT_TEXT(fileArray, string3);
    }

    public static Locale[] getAvailableLocalesOfFieldNLS(String string, String string2) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return new Locale[0];
        }
        File[] fileArray = NLSResourceBundleManager.CATEGORY_FORMAT_TEXT(string2, NLSResourceBundle.PROPS_FILE_EXTENSION, file);
        return NLSResourceBundleManager.CATEGORY_FONT_TEXT(fileArray, string2);
    }

    public static String[] getAvailableEncoding() {
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        Iterator iterator = sortedMap.entrySet().iterator();
        String[] stringArray = new String[sortedMap.size()];
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Charset charset = (Charset)entry.getValue();
            stringArray[n] = charset.name();
            ++n;
        }
        return stringArray;
    }

    protected static Locale[] getAvailableLocales() {
        return Locale.getAvailableLocales();
    }

    public static List getAvailableNLSResourceFilePrefix(String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return new Vector();
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                String string = file.getName();
                return string.toLowerCase().endsWith(NLSResourceBundle.PROPS_FILE_EXTENSION.toLowerCase());
            }
        });
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            String string2 = file2.getName();
            if ((string2 = string2.substring(0, string2.length() - NLSResourceBundle.PROPS_FILE_EXTENSION.length())).startsWith(NLSResourceBundle.FILENAME_CONCAT_CHAR)) break;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, NLSResourceBundle.FILENAME_CONCAT_CHAR);
            Vector<String> vector2 = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector2.add(stringTokenizer.nextToken());
            }
            int n2 = vector2.size();
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            boolean bl = false;
            String string3 = "";
            stringBuffer.append((String)vector2.get(0));
            int n3 = 1;
            while (n3 < n2) {
                String string4 = (String)vector2.get(n3);
                if (bl) {
                    if (NLSResourceBundleManager.CATEGORY_PARAMETER_PROMPTTXT(string4)) {
                        if (n3 == n2 - 1 || n3 == n2 - 2) break;
                        bl = false;
                        stringBuffer.append(string3).append(NLSResourceBundle.FILENAME_CONCAT_CHAR).append(string4);
                        string3 = "";
                    } else {
                        stringBuffer.append(string3).append(NLSResourceBundle.FILENAME_CONCAT_CHAR).append(string4);
                        string3 = "";
                    }
                } else if (NLSResourceBundleManager.CATEGORY_LABEL_TEXT(string4)) {
                    bl = true;
                    string3 = NLSResourceBundle.FILENAME_CONCAT_CHAR + string4;
                } else {
                    stringBuffer.append(NLSResourceBundle.FILENAME_CONCAT_CHAR).append(string4);
                }
                ++n3;
            }
            NLSResourceBundleManager.CATEGORY_COLUMN_TEXT(vector, stringBuffer.toString());
            ++n;
        }
        vector.add(0, "");
        return vector;
    }

    private static void CATEGORY_COLUMN_TEXT(List list, Object object) {
        if (list.contains(object)) {
            return;
        }
        list.add(object);
    }

    public static Locale fieldNLSToLocale(File file) {
        String string = file.getName();
        string = string.substring(0, string.length() - NLSResourceBundle.PROPS_FILE_EXTENSION.length());
        Locale[] localeArray = NLSResourceBundleManager.getAvailableLocales();
        int n = localeArray.length;
        Vector<Locale> vector = new Vector<Locale>();
        int n2 = 0;
        while (n2 < n) {
            if (string.toLowerCase().endsWith(localeArray[n2].toString().toLowerCase())) {
                vector.add(localeArray[n2]);
            }
            ++n2;
        }
        n = vector.size();
        Locale locale = new Locale("", "", "");
        int n3 = 0;
        while (n3 < n) {
            Locale locale2 = (Locale)vector.get(n3);
            if (locale.toString().length() <= locale2.toString().length()) {
                locale = locale2;
            }
            ++n3;
        }
        return locale;
    }

    public static NLSResourceBundle loadReportNLS(String string, Locale locale) throws IOException {
        return NLSResourceBundle.getBundle(string, locale);
    }

    public static NLSResourceBundle loadNLSResource(InputStream inputStream) throws IOException {
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.newNLSResourceBundleInstance();
        nLSResourceBundle.load(inputStream);
        return nLSResourceBundle;
    }

    public static void removeReportNLSResource(String string, Locale locale) {
        String string2 = NLSResourceBundle.getReportNameFromFileName(string);
        NLSResourceBundleManager.removeNLSResource(string2, locale);
    }

    public static void removeNLSResource(String string, Locale locale) {
        if (string.endsWith(File.separator)) {
            return;
        }
        File file = new File(string + NLSResourceBundle.FILENAME_CONCAT_CHAR + locale + NLSResourceBundle.PROPS_FILE_EXTENSION);
        if (!file.exists() && !(file = new File(string + NLSResourceBundle.FILENAME_CONCAT_CHAR + locale.getLanguage() + NLSResourceBundle.PROPS_FILE_EXTENSION)).exists()) {
            file = new File(string + NLSResourceBundle.PROPS_FILE_EXTENSION);
        }
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    public static Map[] getAvailableCategoryContents(NLSResourceBundle nLSResourceBundle) {
        if (nLSResourceBundle == null) {
            return new Hashtable[0];
        }
        Map[] mapArray = new Hashtable[CATEGORY_COLUMN_TEXT];
        int n = 0;
        while (n < CATEGORY_COLUMN_TEXT) {
            mapArray[n] = new Hashtable();
            ++n;
        }
        Iterator<Map.Entry<Object, Object>> iterator = nLSResourceBundle.propResources.entrySet().iterator();
        block1: while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            int n2 = 0;
            while (n2 < CATEGORY_COLUMN_TEXT) {
                if (string.startsWith(INDEX_TO_CATEGORY[n2])) {
                    String string2 = nLSResourceBundle.decodeKey(string.substring(INDEX_TO_CATEGORY[n2].length() + 1));
                    String string3 = INDEX_TO_CATEGORY[n2] + NLSResourceBundle.CATEGORY_KEY_CONCAT_CHAR + string2;
                    ((Hashtable)mapArray[n2]).put(string3, nLSResourceBundle.decodeValue((String)entry.getValue()));
                    continue block1;
                }
                ++n2;
            }
        }
        return mapArray;
    }

    public static Map[] getAvailableContentsFromReport(JetRptReportSet jetRptReportSet) {
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.newNLSResourceBundleInstance();
        JReportNLSSupport.abstractResources(jetRptReportSet, nLSResourceBundle);
        return NLSResourceBundleManager.getAvailableCategoryContents(nLSResourceBundle);
    }

    /*
     * Unable to fully structure code
     */
    public static Map[] getAvailableCategoryContents(String var0, Locale var1_1, JetRptReportSet var2_2, boolean var3_3) throws IOException {
        block3: {
            var4_4 = NLSResourceBundleManager.loadReportNLS(var0, var1_1);
            if (var4_4.strEncoding == null || var4_4.strEncoding.length() == 0) {
                var4_4.strEncoding = System.getProperty("file.encoding");
            }
            if (var2_2 == null) break block3;
            var5_5 = NLSResourceBundleManager.newNLSResourceBundleInstance();
            JReportNLSSupport.abstractResources(var2_2, var5_5);
            var6_6 = var5_5.propResources.entrySet().iterator();
            if (!var3_3) ** GOTO lbl22
            while (var6_6.hasNext()) {
                var7_7 = var6_6.next();
                var8_9 = (String)var7_7.getKey();
                if (var8_9.startsWith(NLSResourceBundleManager.INDEX_TO_CATEGORY[NLSResourceBundleManager.IDX_CATEGORY_FIELD_VALUE])) continue;
                var4_4.propResources.put(var8_9, var7_7.getValue());
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var7_8 = var6_6.next();
                var8_10 = (String)var7_8.getKey();
                if (var8_10.startsWith(NLSResourceBundleManager.INDEX_TO_CATEGORY[NLSResourceBundleManager.IDX_CATEGORY_FIELD_VALUE]) || var4_4.propResources.containsKey(var8_10)) continue;
                var4_4.propResources.put(var8_10, var7_8.getValue());
lbl22:
                // 3 sources

                ** while (var6_6.hasNext())
            }
        }
        return NLSResourceBundleManager.getAvailableCategoryContents(var4_4);
    }

    public static Map[] getAvailableCategoryContents(NLSResourceBundle nLSResourceBundle, JetRptReportSet jetRptReportSet, boolean bl) {
        Map[] mapArray;
        block6: {
            mapArray = NLSResourceBundleManager.getAvailableCategoryContents(nLSResourceBundle);
            if (jetRptReportSet == null) break block6;
            NLSResourceBundle nLSResourceBundle2 = NLSResourceBundleManager.newNLSResourceBundleInstance();
            JReportNLSSupport.abstractResources(jetRptReportSet, nLSResourceBundle2);
            Map[] mapArray2 = NLSResourceBundleManager.getAvailableCategoryContents(nLSResourceBundle2);
            if (bl) {
                int n = 0;
                while (n < CATEGORY_COLUMN_TEXT) {
                    Map map = mapArray[n];
                    Map map2 = mapArray2[n];
                    Iterator iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String string = (String)entry.getKey();
                        if (string.startsWith(INDEX_TO_CATEGORY[IDX_CATEGORY_FIELD_VALUE])) continue;
                        map.put(string, entry.getValue());
                    }
                    ++n;
                }
            } else {
                int n = 0;
                while (n < CATEGORY_COLUMN_TEXT) {
                    Map map = mapArray[n];
                    Map map3 = mapArray2[n];
                    Iterator iterator = map3.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String string = (String)entry.getKey();
                        if (string.startsWith(INDEX_TO_CATEGORY[IDX_CATEGORY_FIELD_VALUE]) || map.containsKey(string)) continue;
                        map.put(string, entry.getValue());
                    }
                    ++n;
                }
            }
        }
        return mapArray;
    }

    public static void mergeNLSResourceBundle(NLSResourceBundle nLSResourceBundle, NLSResourceBundle nLSResourceBundle2) {
        Iterator<Map.Entry<Object, Object>> iterator = nLSResourceBundle2.propResources.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            nLSResourceBundle.propResources.put(entry.getKey(), entry.getValue());
        }
    }

    public static boolean isReportNLSReady(String string, Locale locale) throws IOException {
        if (string == null || string.trim().length() == 0 || locale == null) {
            return false;
        }
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.loadReportNLS(string, locale);
        Iterator<Map.Entry<Object, Object>> iterator = nLSResourceBundle.propResources.entrySet().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string2 = (String)entry.getKey();
            if (!string2.startsWith(INDEX_TO_CATEGORY[IDX_CATEGORY_LABEL_TEXT]) && !string2.startsWith(INDEX_TO_CATEGORY[IDX_CATEGORY_COLUMN_TEXT]) && !string2.startsWith(INDEX_TO_CATEGORY[IDX_CATEGORY_FORMAT_TEXT]) && !string2.startsWith(INDEX_TO_CATEGORY[IDX_CATEGORY_FONT_TEXT]) && !string2.startsWith(INDEX_TO_CATEGORY[IDX_CATEGORY_PARAM_PROMPT]) && !string2.startsWith(INDEX_TO_CATEGORY[IDX_CATEGORY_TOC_TEXT])) continue;
            bl = true;
            break;
        }
        nLSResourceBundle.clear();
        nLSResourceBundle = null;
        return bl;
    }

    public static NLSResourceBundle buildResourceBundleByValue(List list, String string) {
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.newNLSResourceBundleInstance();
        NLSResourceBundleManager.refreshResourceBundle(nLSResourceBundle, list);
        nLSResourceBundle.strEncoding = string;
        nLSResourceBundle.propResources.put(NLSResourceBundle.KEY_ENCODING, string);
        return nLSResourceBundle;
    }

    public static NLSResourceBundle buildResourceBundleByCategoryContents(Map[] mapArray) {
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.newNLSResourceBundleInstance();
        NLSResourceBundleManager.refreshResourceBundle(nLSResourceBundle, mapArray, true);
        return nLSResourceBundle;
    }

    public static NLSResourceBundle buildResourceBundleByCategoryContents(Map[] mapArray, String string) {
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.newNLSResourceBundleInstance();
        nLSResourceBundle.strEncoding = string;
        NLSResourceBundleManager.refreshResourceBundle(nLSResourceBundle, mapArray, true);
        nLSResourceBundle.put(NLSResourceBundle.KEY_ENCODING, string);
        return nLSResourceBundle;
    }

    public static NLSResourceBundle buildNLSResourceBundle(Properties properties, String string) {
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.newNLSResourceBundleInstance();
        String string2 = nLSResourceBundle.strEncoding = string == null || string.length() == 0 ? System.getProperty("file.encoding") : string;
        if (properties != null) {
            nLSResourceBundle.propResources.putAll((Map<?, ?>)properties);
        }
        return nLSResourceBundle;
    }

    public static NLSResourceBundle buildNLSResourceBundle(Properties properties, String string, JetRptObject jetRptObject, String string2, Locale locale) throws IOException {
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.loadReportNLS(string2, locale);
        NLSResourceBundle nLSResourceBundle2 = NLSResourceBundleManager.newNLSResourceBundleInstance();
        JReportNLSSupport.abstractResources(jetRptObject, nLSResourceBundle2);
        Map[] mapArray = NLSResourceBundleManager.getAvailableCategoryContents(nLSResourceBundle);
        Map[] mapArray2 = NLSResourceBundleManager.getAvailableCategoryContents(nLSResourceBundle2);
        Map[] mapArray3 = NLSResourceBundleManager.mergeNLSWithNLSContentAndFontMap(mapArray2, mapArray, properties);
        NLSResourceBundle nLSResourceBundle3 = NLSResourceBundleManager.newNLSResourceBundleInstance();
        int n = 0;
        while (n < mapArray3.length) {
            NLSResourceBundleManager.saveContentsToBundle(nLSResourceBundle3, mapArray3[n], true);
            ++n;
        }
        nLSResourceBundle.clear();
        nLSResourceBundle2.clear();
        mapArray = null;
        mapArray2 = null;
        mapArray3 = null;
        return nLSResourceBundle3;
    }

    public static void refreshResourceBundle(NLSResourceBundle nLSResourceBundle, Map[] mapArray) {
        NLSResourceBundleManager.refreshResourceBundle(nLSResourceBundle, mapArray, true);
    }

    public static void refreshResourceBundle(NLSResourceBundle nLSResourceBundle, Map[] mapArray, boolean bl) {
        NLSResourceBundleManager.refreshResourceBundle(nLSResourceBundle, mapArray, bl, null);
    }

    public static void refreshResourceBundle(NLSResourceBundle nLSResourceBundle, Map[] mapArray, boolean bl, String string) {
        int n = mapArray.length;
        int n2 = 0;
        while (n2 < n) {
            NLSResourceBundleManager.saveContentsToBundle(nLSResourceBundle, mapArray[n2], bl);
            ++n2;
        }
        if (nLSResourceBundle.propResources.getProperty(NLSResourceBundle.KEY_ENCODING) == null && string != null && string.length() > 0) {
            nLSResourceBundle.strEncoding = string;
            nLSResourceBundle.propResources.put(NLSResourceBundle.KEY_ENCODING, string);
        }
    }

    public static void refreshResourceBundle(NLSResourceBundle nLSResourceBundle, List list) {
        NLSResourceBundleManager.refreshResourceBundle(nLSResourceBundle, list, null);
    }

    public static void refreshResourceBundle(NLSResourceBundle nLSResourceBundle, List list, String string) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            if (list.get(n2) != null && nLSResourceBundle.get(INDEX_TO_CATEGORY[IDX_CATEGORY_FIELD_VALUE], string2 = (String)list.get(n2)) == null) {
                nLSResourceBundle.put(INDEX_TO_CATEGORY[IDX_CATEGORY_FIELD_VALUE], string2, string2);
            }
            ++n2;
        }
        if (string != null && string.length() > 0) {
            nLSResourceBundle.strEncoding = string;
            nLSResourceBundle.propResources.put(NLSResourceBundle.KEY_ENCODING, string);
        }
    }

    public static void resetResourceBundle(NLSResourceBundle nLSResourceBundle, List list) {
        NLSResourceBundleManager.resetResourceBundle(nLSResourceBundle, list, nLSResourceBundle.getEncoding());
    }

    public static void resetResourceBundle(NLSResourceBundle nLSResourceBundle, List list, String string) {
        nLSResourceBundle.clear();
        if (string != null && string.length() > 0) {
            nLSResourceBundle.strEncoding = string;
            nLSResourceBundle.propResources.put(NLSResourceBundle.KEY_ENCODING, string);
        }
        int n = 0;
        while (n < list.size()) {
            String string2 = (String)list.get(n);
            if (string2 != null) {
                nLSResourceBundle.put(INDEX_TO_CATEGORY[IDX_CATEGORY_FIELD_VALUE], string2, string2);
            }
            ++n;
        }
    }

    public static void resetResourceBundle(NLSResourceBundle nLSResourceBundle, Map[] mapArray) {
        NLSResourceBundleManager.resetResourceBundle(nLSResourceBundle, mapArray, nLSResourceBundle.getEncoding());
    }

    public static void resetResourceBundle(NLSResourceBundle nLSResourceBundle, Map[] mapArray, String string) {
        nLSResourceBundle.clear();
        int n = mapArray.length;
        int n2 = 0;
        while (n2 < n) {
            NLSResourceBundleManager.saveContentsToBundle(nLSResourceBundle, mapArray[n2], true);
            ++n2;
        }
        if (string != null && string.length() > 0) {
            nLSResourceBundle.strEncoding = string;
            nLSResourceBundle.propResources.put(NLSResourceBundle.KEY_ENCODING, string);
        }
    }

    public static void saveReportNLS(String string, Locale locale, String string2, Map[] mapArray) throws IOException {
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.newNLSResourceBundleInstance();
        int n = mapArray.length;
        if (n > IDX_CATEGORY_FIELD_VALUE) {
            if (n > CATEGORY_COLUMN_TEXT) {
                n = CATEGORY_COLUMN_TEXT;
            }
            int n2 = 0;
            while (n2 < IDX_CATEGORY_FIELD_VALUE) {
                NLSResourceBundleManager.saveContentsToBundle(nLSResourceBundle, mapArray[n2], true);
                ++n2;
            }
            int n3 = IDX_CATEGORY_FIELD_VALUE + 1;
            while (n3 < n) {
                NLSResourceBundleManager.saveContentsToBundle(nLSResourceBundle, mapArray[n3], true);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                NLSResourceBundleManager.saveContentsToBundle(nLSResourceBundle, mapArray[n4], true);
                ++n4;
            }
        }
        nLSResourceBundle.strEncoding = string2;
        nLSResourceBundle.storeWithEncoding(string, locale, string2);
    }

    protected static void saveContentsToBundle(NLSResourceBundle nLSResourceBundle, Map map, boolean bl) {
        if (bl) {
            Iterator iterator = map.entrySet().iterator();
            block0: while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                int n = 0;
                while (n < CATEGORY_COLUMN_TEXT) {
                    if (string.startsWith(INDEX_TO_CATEGORY[n])) {
                        String string2 = nLSResourceBundle.convertKey(string.substring(INDEX_TO_CATEGORY[n].length() + 1));
                        String string3 = INDEX_TO_CATEGORY[n] + NLSResourceBundle.CATEGORY_KEY_CONCAT_CHAR + string2;
                        nLSResourceBundle.propResources.put(string3, entry.getValue());
                        continue block0;
                    }
                    ++n;
                }
            }
        } else {
            Iterator iterator = map.entrySet().iterator();
            block2: while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                int n = 0;
                while (n < CATEGORY_COLUMN_TEXT) {
                    if (string.startsWith(INDEX_TO_CATEGORY[n])) {
                        String string4 = nLSResourceBundle.convertKey(string.substring(INDEX_TO_CATEGORY[n].length() + 1));
                        String string5 = INDEX_TO_CATEGORY[n] + NLSResourceBundle.CATEGORY_KEY_CONCAT_CHAR + string4;
                        if (nLSResourceBundle.propResources.get(string5) != null) continue block2;
                        nLSResourceBundle.propResources.put(string5, entry.getValue());
                        continue block2;
                    }
                    ++n;
                }
            }
        }
    }

    public static void saveNLSResource(OutputStream outputStream, String string, Map map) throws IOException {
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.newNLSResourceBundleInstance();
        NLSResourceBundleManager.saveContentsToBundle(nLSResourceBundle, map, true);
        nLSResourceBundle.strEncoding = string;
        nLSResourceBundle.storeWithEncoding(outputStream, string);
    }

    public static void saveNLSResource(String string, String string2, Map map) throws IOException {
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.newNLSResourceBundleInstance();
        NLSResourceBundleManager.saveContentsToBundle(nLSResourceBundle, map, true);
        nLSResourceBundle.strEncoding = string2;
        nLSResourceBundle.storeWithEncoding(string, string2);
    }

    public static void saveFieldNLS(String string, Locale locale, String string2, List list) throws IOException {
        if (string.endsWith(File.separator)) {
            throw new FileNotFoundException(string + "doesn't found");
        }
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.newNLSResourceBundleInstance();
        String string3 = string.concat(NLSResourceBundle.FILENAME_CONCAT_CHAR).concat(locale.toString()).concat(NLSResourceBundle.PROPS_FILE_EXTENSION);
        nLSResourceBundle.strEncoding = string2;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            if (list.get(n2) != null) {
                String string4 = list.get(n2).toString();
                nLSResourceBundle.put(INDEX_TO_CATEGORY[IDX_CATEGORY_FIELD_VALUE], string4, string4);
            }
            ++n2;
        }
        nLSResourceBundle.storeWithEncoding(string3, string2);
    }

    public static void saveFieldNLS(String string, Locale locale, NLSResourceBundle nLSResourceBundle) throws IOException {
        if (string.endsWith(File.separator)) {
            throw new FileNotFoundException(string + "doesn't found");
        }
        String string2 = string.concat(NLSResourceBundle.FILENAME_CONCAT_CHAR).concat(locale.toString()).concat(NLSResourceBundle.PROPS_FILE_EXTENSION);
        nLSResourceBundle.store(string2);
    }

    private static Locale[] CATEGORY_FONT_TEXT(File[] fileArray, String string) {
        Object object;
        int n = fileArray == null ? 0 : fileArray.length;
        Vector<Locale> vector = new Vector<Locale>(n);
        int n2 = 0;
        while (n2 < n) {
            object = fileArray[n2].getName();
            object = ((String)object).substring(string.length(), ((String)object).length() - NLSResourceBundle.PROPS_FILE_EXTENSION.length());
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (((String)object).startsWith(NLSResourceBundle.FILENAME_CONCAT_CHAR)) {
                int n3 = ((String)object).indexOf(95, 1);
                if (n3 > 0) {
                    string2 = ((String)object).substring(1, n3);
                    int n4 = ((String)object).indexOf(95, n3 + 1);
                    if (n4 > 0) {
                        string3 = ((String)object).substring(n3 + 1, n4);
                        string4 = ((String)object).substring(n4 + 1);
                    } else {
                        string3 = ((String)object).substring(n3 + 1, ((String)object).length());
                    }
                } else {
                    string2 = ((String)object).substring(1);
                }
            }
            if (NLSResourceBundleManager.CATEGORY_KEY_CONCAT_CHAR(string3, string2, string4)) {
                vector.add(new Locale(string2, string3, string4));
            }
            ++n2;
        }
        object = new Locale[vector.size()];
        int n5 = 0;
        while (n5 < vector.size()) {
            object[n5] = (Locale)vector.get(n5);
            ++n5;
        }
        return object;
    }

    private static File[] CATEGORY_FORMAT_TEXT(String string, String string2, File file) {
        return file.listFiles(new FilenameFilter(string2, string){
            private final String val$extension;
            private final String val$prefix;
            {
                this.val$extension = string;
                this.val$prefix = string2;
            }

            public boolean accept(File file, String string) {
                return string.endsWith(this.val$extension) && string.startsWith(this.val$prefix);
            }
        });
    }

    private static boolean CATEGORY_KEY_CONCAT_CHAR(String string, String string2, String string3) {
        if (NLSResourceBundleManager.CATEGORY_LABEL_TEXT(string2)) {
            if (string == null || string.length() == 0) {
                return true;
            }
            return NLSResourceBundleManager.CATEGORY_PARAMETER_PROMPTTXT(string);
        }
        return false;
    }

    private static boolean CATEGORY_LABEL_TEXT(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        String[] stringArray = Locale.getISOLanguages();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean CATEGORY_PARAMETER_PROMPTTXT(String string) {
        String[] stringArray = Locale.getISOCountries();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Map[] mergeNLSWithNLSContentAndFontMap(Map[] mapArray, Map[] mapArray2, Map map) {
        if (mapArray2 != null) {
            Map map2;
            String string;
            Iterator iterator;
            Set set;
            Map map3;
            Map map4;
            String string2 = (String)map.get("is_enable_label");
            String string3 = (String)map.get("is_enable_format");
            String string4 = (String)map.get("is_enable_font");
            Map map5 = new Hashtable();
            Map map6 = new Hashtable();
            if (string2 == null || !string2.equalsIgnoreCase("false")) {
                map4 = mapArray[IDX_CATEGORY_LABEL_TEXT];
                map3 = mapArray2[IDX_CATEGORY_LABEL_TEXT];
                if (map4 != null && map3 != null) {
                    set = map4.keySet();
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        if (map3.containsKey(string)) {
                            map5.put(string, map3.get(string));
                            continue;
                        }
                        map5.put(string, map4.get(string));
                    }
                }
            } else {
                map5 = mapArray[IDX_CATEGORY_LABEL_TEXT];
            }
            if (string3 == null || !string3.equalsIgnoreCase("false")) {
                map4 = mapArray[IDX_CATEGORY_FORMAT_TEXT];
                map3 = mapArray2[IDX_CATEGORY_FORMAT_TEXT];
                if (map4 != null && map3 != null) {
                    set = map4.keySet();
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        if (map3.containsKey(string)) {
                            map6.put(string, map3.get(string));
                            continue;
                        }
                        map6.put(string, map4.get(string));
                    }
                }
            } else {
                map6 = mapArray[IDX_CATEGORY_FORMAT_TEXT];
            }
            if (string4 == null || !string4.equalsIgnoreCase("false")) {
                map4 = mapArray[IDX_CATEGORY_FONT_TEXT];
                map3 = mapArray2[IDX_CATEGORY_FONT_TEXT];
                map2 = NLSResourceBundleManager.FILENAME_CONCAT_CHAR(map4, map3, map);
            } else {
                map4 = mapArray[IDX_CATEGORY_FONT_TEXT];
                map2 = map.size() == 0 ? new Hashtable() : NLSResourceBundleManager.CATEGORY_TOC_TEXT(map4, map);
            }
            mapArray[NLSResourceBundleManager.IDX_CATEGORY_LABEL_TEXT] = map5;
            mapArray[NLSResourceBundleManager.IDX_CATEGORY_FORMAT_TEXT] = map6;
            mapArray[NLSResourceBundleManager.IDX_CATEGORY_FONT_TEXT] = map2;
            return mapArray;
        }
        return NLSResourceBundleManager.IDX_CATEGORY_COLUMN_TEXT(mapArray, map);
    }

    private static Map CATEGORY_TOC_TEXT(Map map, Map map2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (map != null) {
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (map2 != null) {
                    String string2 = (String)map.get(string);
                    String[] stringArray = NLSResourceBundle.parseFontContext(string2);
                    String string3 = stringArray[0];
                    double d = NLSResourceBundleManager.IDX_CATEGORY_FONT_TEXT(Integer.parseInt(stringArray[1]));
                    String string4 = NLSResourceBundleManager.IDX_CATEGORY_FIELD_VALUE(string3, d, map2);
                    hashtable.put(string, string4);
                    continue;
                }
                hashtable.put(string, (String)map.get(string));
            }
        }
        return hashtable;
    }

    private static Map FILENAME_CONCAT_CHAR(Map map, Map map2, Map map3) {
        Hashtable hashtable = new Hashtable();
        if (map != null) {
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (map2.containsKey(string)) {
                    hashtable.put(string, map2.get(string));
                    continue;
                }
                if (map3 != null) {
                    String string2 = (String)map.get(string);
                    String[] stringArray = NLSResourceBundle.parseFontContext(string2);
                    String string3 = stringArray[0];
                    double d = NLSResourceBundleManager.IDX_CATEGORY_FONT_TEXT(Integer.parseInt(stringArray[1]));
                    String string4 = NLSResourceBundleManager.IDX_CATEGORY_FIELD_VALUE(string3, d, map3);
                    hashtable.put(string, string4);
                    continue;
                }
                hashtable.put(string, map.get(string));
            }
        }
        return hashtable;
    }

    private static Map[] IDX_CATEGORY_COLUMN_TEXT(Map[] mapArray, Map map) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Map map2 = mapArray[IDX_CATEGORY_FONT_TEXT];
        if (map2 != null) {
            Set set = map2.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map2.get(string);
                String[] stringArray = NLSResourceBundle.parseFontContext(string2);
                String string3 = stringArray[0];
                double d = NLSResourceBundleManager.IDX_CATEGORY_FONT_TEXT(Integer.parseInt(stringArray[1]));
                String string4 = NLSResourceBundleManager.IDX_CATEGORY_FIELD_VALUE(string3, d, map);
                hashtable.put(string, string4);
            }
        }
        mapArray[NLSResourceBundleManager.IDX_CATEGORY_FONT_TEXT] = hashtable;
        return mapArray;
    }

    private static String IDX_CATEGORY_FIELD_VALUE(String string, double d, Map map) {
        double d2;
        String string2 = string + NLSResourceBundle.CATEGORY_KEY_CONCAT_CHAR + d;
        String string3 = (String)map.get(string2);
        if (string3 == null) {
            string2 = string + NLSResourceBundle.CATEGORY_KEY_CONCAT_CHAR + "*";
        }
        string3 = (String)map.get(string2);
        String string4 = string;
        double d3 = d;
        if (string3 != null) {
            int n = string3.indexOf(NLSResourceBundle.CATEGORY_KEY_CONCAT_CHAR);
            string4 = string3.substring(0, n);
            string3 = string3.substring(n + 1);
            n = string3.indexOf(NLSResourceBundle.CATEGORY_KEY_CONCAT_CHAR);
            String string5 = string3.substring(0, n);
            d2 = Double.parseDouble(string5);
            String string6 = string3.substring(n + 1);
            boolean bl = false;
            if (string6.equalsIgnoreCase("true")) {
                bl = true;
            }
            d3 = bl ? (d2 < 0.0 ? d - Math.abs(d2) : d + d2) : d2;
        }
        double d4 = NLSResourceBundleManager.IDX_CATEGORY_FORMAT_TEXT(d3);
        d2 = ValueToUnit.convertPointToUnit(d4);
        return NLSResourceBundle.mergeFontContext(string4, String.valueOf(d2));
    }

    private static double IDX_CATEGORY_FONT_TEXT(double d) {
        double d2 = d * 72.0 / 5760.0;
        return NLSResourceBundleManager.IDX_CATEGORY_FORMAT_TEXT(d2);
    }

    private static double IDX_CATEGORY_FORMAT_TEXT(double d) {
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        BigDecimal bigDecimal2 = bigDecimal.setScale(1, 4);
        double d2 = bigDecimal2.doubleValue();
        String string = String.valueOf(d2);
        String string2 = string.substring(string.indexOf(".") + 1);
        String string3 = string.substring(0, string.indexOf("."));
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string3);
        double d3 = 0.0;
        if (n < 5) {
            d3 = Double.parseDouble(string3);
        }
        if (n == 5) {
            d3 = Double.parseDouble(string3 + "." + "5");
        }
        if (n > 5) {
            String string4 = String.valueOf(n2 + 1);
            d3 = Double.parseDouble(string4);
        }
        return d3;
    }
}

