/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import jet.dataengine.util.DSLog;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import toolkit.db.DataSourceInfo;
import toolkit.db.DateTimeFormat;
import toolkit.db.ProcColumnInfo;
import toolkit.db.ProcParaInfo;
import toolkit.db.gui.MappingSQLType;

public class ProcInfo
extends DataSourceInfo {
    public static final int PROCEDURE_CATALOG = 1;
    public static final int PROCEDURE_SCHEMA = 2;
    public static final int PROCEDURE_NAME = 3;
    public static final int REMARKS = 4;
    public static final int PROCEDURE_TYPE = 8;
    public static final int PARAM_NAME = 4;
    public static final int PARAM_TYPE = 5;
    public static final int DATA_TYPE = 6;
    public static final int TYPE_NAME = 7;
    public static final int PRECISION = 8;
    public static final int LENGTH = 9;
    public static final int SCALE = 10;
    public static final int RADIX = 11;
    public static final int NULLABLE = 12;
    public static final int procedureResultUnknown = 0;
    public static final int procedureNoResult = 1;
    public static final int procedureReturnsResult = 2;
    public String strCatalog;
    public String strSchema;
    public String strName;
    public String strRemarks;
    public int iType;
    public Vector vecParams = null;
    private static JRLogger TYPE = JRLogger.getLogger((class$toolkit$db$ProcInfo == null ? (class$toolkit$db$ProcInfo = ProcInfo.class$("toolkit.db.ProcInfo")) : class$toolkit$db$ProcInfo).getName());
    static Class class$toolkit$db$ProcInfo;
    static Class class$toolkit$db$JdbcScalarFunctions;

    public ProcInfo(String string, String string2, String string3, String string4, int n) {
        this.strCatalog = string;
        this.strSchema = string2;
        this.strName = string3;
        this.strRemarks = string4;
        this.iType = n;
    }

    public String getName() {
        return this.strName;
    }

    public void setName(String string) {
        this.strName = string;
    }

    public String getCatalog() {
        return this.strCatalog;
    }

    public String getSchema() {
        return this.strSchema;
    }

    public void setType(int n) {
        this.iType = n;
    }

    public int getType() {
        return this.iType;
    }

    public Vector getParameters() {
        return this.vecParams;
    }

    public void setParams(Vector vector) {
        this.vecParams = vector;
    }

    public int getParamsCount() {
        return this.vecParams == null ? -1 : this.vecParams.size();
    }

    public int getINParamsCount() {
        if (this.vecParams != null) {
            int n = 0;
            int n2 = this.vecParams.size();
            int n3 = 0;
            while (n3 < n2) {
                ProcParaInfo procParaInfo = (ProcParaInfo)this.vecParams.elementAt(n3);
                if (procParaInfo.isINParameter()) {
                    ++n;
                }
                ++n3;
            }
            return n;
        }
        return -1;
    }

    public Vector getColumns() {
        return this.vecColumns;
    }

    public void setColumns(Vector vector) {
        this.vecColumns = vector;
    }

    public void fetchProcedureParams(Connection connection, DateTimeFormat dateTimeFormat) throws SQLException {
        this.vecParams = ProcInfo.getProcedureParams(connection, this, dateTimeFormat);
    }

    public void fetchProcColumns(ResultSet resultSet) throws SQLException {
        this.vecColumns = ProcInfo.getProcColumns(resultSet);
    }

    public void fetchProcColumns(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.vecColumns = ProcInfo.getProcColumns(resultSetMetaData);
    }

    public static Vector getProcedures(Connection connection) throws SQLException {
        Vector<ProcInfo> vector = new Vector<ProcInfo>();
        DatabaseMetaData databaseMetaData = null;
        databaseMetaData = connection.getMetaData();
        ResultSet resultSet = null;
        ProcInfo procInfo = null;
        if (connection.getClass().getName().equals("oracle.jdbc.driver.OracleConnection") && Locale.getDefault().toString().startsWith("zh")) {
            Class<?> clazz = connection.getClass();
            try {
                Method method = clazz.getDeclaredMethod("setDefaultRowPrefetch", Integer.TYPE);
                method.invoke((Object)connection, new Integer(300));
            }
            catch (Throwable throwable) {
                DSLog.getDSLog((class$toolkit$db$JdbcScalarFunctions == null ? (class$toolkit$db$JdbcScalarFunctions = ProcInfo.class$("toolkit.db.JdbcScalarFunctions")) : class$toolkit$db$JdbcScalarFunctions).getName()).debug(throwable.getMessage());
            }
        }
        resultSet = databaseMetaData.getProcedures(null, null, "%");
        while (resultSet.next()) {
            procInfo = new ProcInfo(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getShort(8));
            vector.addElement(procInfo);
        }
        resultSet.close();
        return vector;
    }

    public static Vector getProcedures(Connection connection, String string) throws SQLException {
        Vector<ProcInfo> vector = new Vector<ProcInfo>();
        DatabaseMetaData databaseMetaData = null;
        databaseMetaData = connection.getMetaData();
        ResultSet resultSet = null;
        ProcInfo procInfo = null;
        if (connection.getClass().getName().equals("oracle.jdbc.driver.OracleConnection") && Locale.getDefault().toString().startsWith("zh")) {
            Class<?> clazz = connection.getClass();
            try {
                Method method = clazz.getDeclaredMethod("setDefaultRowPrefetch", Integer.TYPE);
                method.invoke((Object)connection, new Integer(300));
            }
            catch (Throwable throwable) {
                DSLog.getDSLog((class$toolkit$db$JdbcScalarFunctions == null ? (class$toolkit$db$JdbcScalarFunctions = ProcInfo.class$("toolkit.db.JdbcScalarFunctions")) : class$toolkit$db$JdbcScalarFunctions).getName()).debug(throwable.getMessage());
            }
        }
        resultSet = databaseMetaData.getProcedures(string, null, "%");
        while (resultSet.next()) {
            procInfo = new ProcInfo(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getShort(8));
            vector.addElement(procInfo);
        }
        resultSet.close();
        return vector;
    }

    public static Vector getProcedureParams(Connection connection, ProcInfo procInfo, DateTimeFormat dateTimeFormat) throws SQLException {
        Vector<ProcParaInfo> vector = new Vector<ProcParaInfo>();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getProcedureColumns(procInfo.getCatalog(), procInfo.getSchema(), procInfo.getName(), "%");
        int n = 1;
        ProcParaInfo procParaInfo = null;
        boolean bl = true;
        while (resultSet.next()) {
            String string = resultSet.getString(4);
            int n2 = resultSet.getInt(5);
            if (TYPE.isDebugEnabled()) {
                TYPE.debug("All of the parameters of this stored procedure: \ntype =  " + n2 + " name =" + string);
            }
            if (n2 != 1 && n2 != 2 && n2 != 4) continue;
            procParaInfo = new ProcParaInfo(n, string, n2, JetUConnection.mapColType(resultSet.getInt(6)), resultSet.getString(7), resultSet.getInt(8), resultSet.getInt(9), resultSet.getShort(10), resultSet.getShort(11), resultSet.getShort(12), bl, dateTimeFormat);
            vector.addElement(procParaInfo);
            ++n;
        }
        resultSet.close();
        return vector;
    }

    public static Vector getProcColumns(ResultSetMetaData resultSetMetaData) throws SQLException {
        Vector<ProcColumnInfo> vector = new Vector<ProcColumnInfo>();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 1;
        while (n2 <= n) {
            int n3 = resultSetMetaData.getPrecision(n2);
            if (n3 <= 0) {
                n3 = resultSetMetaData.getColumnDisplaySize(n2);
            }
            vector.addElement(new ProcColumnInfo(n2, resultSetMetaData.getColumnName(n2), MappingSQLType.mapColType(resultSetMetaData.getColumnType(n2)), n3, 0, resultSetMetaData.getScale(n2), 0, resultSetMetaData.isNullable(n2), resultSetMetaData.getColumnType(n2) == 2003));
            ++n2;
        }
        return vector;
    }

    public static Vector getProcColumns(ResultSet resultSet) throws SQLException {
        return ProcInfo.getProcColumns(resultSet.getMetaData());
    }

    public boolean hasBinaryParameter() {
        if (this.vecParams == null) {
            return false;
        }
        ProcParaInfo procParaInfo = null;
        int n = this.vecParams.size();
        int n2 = 0;
        while (n2 < n) {
            procParaInfo = (ProcParaInfo)this.vecParams.elementAt(n2);
            if (procParaInfo.isBinaryParameter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        return this.getName() + "|" + this.getParameters() + "|" + this.getColumns();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

