/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import util.Node;
import util.RandomAccessStream;

public abstract class StreamObject
extends Node {
    public static void output(OutputStream outputStream, StreamObject streamObject) throws IOException {
        RandomAccessStream randomAccessStream = new RandomAccessStream(255);
        streamObject.output(outputStream, randomAccessStream);
        randomAccessStream.close();
    }

    public static void output(File file, StreamObject streamObject) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            StreamObject.output(fileOutputStream, streamObject);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    public static void output(OutputStream outputStream, StreamObject streamObject, int n, int n2) throws IOException {
        RandomAccessStream randomAccessStream = new RandomAccessStream(255);
        randomAccessStream.writeInt(n);
        randomAccessStream.writeInt(n2);
        streamObject.output(outputStream, randomAccessStream);
        randomAccessStream.close();
    }

    public static void output(File file, StreamObject streamObject, int n, int n2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            StreamObject.output(fileOutputStream, streamObject, n, n2);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    public abstract int getType();

    public int getLength() {
        return 0;
    }

    protected void output(OutputStream outputStream, RandomAccessStream randomAccessStream) throws IOException {
        randomAccessStream.writeInt(this.getType());
        randomAccessStream.writeInt(this.length);
        randomAccessStream.writeInt(this.getLength());
        this.outputProps(randomAccessStream);
        randomAccessStream.write(randomAccessStream.getPointer(), outputStream);
        randomAccessStream.seek(0);
        int n = 0;
        while (n < this.length) {
            ((StreamObject)this.nodes[n]).output(outputStream, randomAccessStream);
            ++n;
        }
    }

    protected void outputProps(RandomAccessStream randomAccessStream) throws IOException {
    }

    protected void output(DataOutput dataOutput, RandomAccessStream randomAccessStream) throws IOException {
        randomAccessStream.writeInt(this.getType());
        randomAccessStream.writeInt(this.length);
        randomAccessStream.writeInt(this.getLength());
        this.outputProps(randomAccessStream);
        randomAccessStream.write(randomAccessStream.getPointer(), dataOutput);
        randomAccessStream.seek(0);
        int n = 0;
        while (n < this.length) {
            ((StreamObject)this.nodes[n]).output(dataOutput, randomAccessStream);
            ++n;
        }
    }
}

