/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.security.control;

import com.jinfonet.security.api.AuthContent;
import com.jinfonet.security.api.CubeAuthorizeManager;
import com.jinfonet.security.api.PrincipalLoader;
import com.jinfonet.security.api.PrincipalManager;
import com.jinfonet.security.api.SecurityService;
import com.jinfonet.security.api.SecurityStorage;
import com.jinfonet.security.api.exception.InvalidResource;
import com.jinfonet.security.api.exception.NoPermissionException;
import com.jinfonet.security.control.AuthContentImpl;
import com.jinfonet.security.control.CubeAclManager;
import com.jinfonet.security.control.JRUser;
import com.jinfonet.security.control.xml.SecurityStorageXMLImpl;
import com.jinfonet.security.util.AclToolkit;
import com.jinfonet.security.util.FileNameToolkit;
import java.io.File;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class JRCubeAuthorizeManager
implements CubeAuthorizeManager {
    private CubeAclManager QOIV = null;
    private SecurityStorage append = null;
    private String buildAuthFileName = null;
    public static final String DESINGER_OPERATOR = "jinfonet-designer-operator";

    public JRCubeAuthorizeManager(String string) {
        this.buildAuthFileName = FileNameToolkit.buildAuthFileName(string, "auth");
        try {
            this.reload();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean checkPermission(String string, String string2, Permission permission) throws InvalidResource {
        if (!SecurityService.getInstance().needSecurity()) {
            return true;
        }
        if (string == null || permission == null) {
            return false;
        }
        if (string2 == null) {
            throw new InvalidResource("Resource path is null.");
        }
        Principal principal = SecurityService.getInstance().getPrincipalManager().getPrincipal(string, 2);
        return this.QOIV.checkPermission(principal, string2, permission);
    }

    public Hashtable[] getPermissions(String string, String string2) throws NoPermissionException, InvalidResource {
        if (string2 == null) {
            throw new InvalidResource("Resource path is null.");
        }
        Principal principal = string.equals(DESINGER_OPERATOR) ? new JRUser(DESINGER_OPERATOR, "designer") : SecurityService.getInstance().getPrincipalManager().getPrincipal(string, 2);
        return this.QOIV.getPermissions(principal, string2);
    }

    public void setPermissions(String string, String string2, Hashtable[] hashtableArray) throws NoPermissionException, InvalidResource {
        if (hashtableArray == null) {
            return;
        }
        if (string2 == null) {
            throw new InvalidResource("Resource path is null.");
        }
        Principal principal = string.equals(DESINGER_OPERATOR) ? new JRUser(DESINGER_OPERATOR, "designer") : SecurityService.getInstance().getPrincipalManager().getPrincipal(string, 2);
        this.QOIV.setPermissions(principal, string2, hashtableArray);
    }

    public void saveToAuth(String string, String string2) throws Exception {
        PrincipalManager principalManager;
        String string3;
        SecurityService.getInstance().setCubeAuthorizeManager(string2, this);
        Hashtable hashtable = this.QOIV.getAcls();
        Hashtable<String, Hashtable[]> hashtable2 = new Hashtable<String, Hashtable[]>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            principalManager = (Acl)hashtable.get(string3);
            if (principalManager == null) continue;
            Hashtable[] hashtableArray = AclToolkit.getHsahtableFromAcls((Acl)principalManager);
            hashtable2.put(string3, hashtableArray);
        }
        string3 = FileNameToolkit.buildAuthFileName(string2, "auth");
        principalManager = SecurityService.getInstance().getPrincipalManager();
        int n = principalManager.getLoaderType();
        Properties properties = principalManager.getLoaderProperties();
        AuthContentImpl authContentImpl = new AuthContentImpl(hashtable2, n, properties);
        this.append.save(string, string3, authContentImpl);
    }

    public void clearMem() {
        this.QOIV.clearMem();
    }

    public synchronized void reload() throws Exception {
        File file = new File(this.buildAuthFileName);
        String string = System.getProperty("com.jinfonet.security.storage");
        this.append = string != null && string.length() != 0 ? (SecurityStorage)Class.forName(string).newInstance() : new SecurityStorageXMLImpl();
        PrincipalManager principalManager = SecurityService.getInstance().getPrincipalManager();
        if (file.exists()) {
            AuthContent authContent = this.append.load("system", this.buildAuthFileName);
            int n = authContent.getLoaderType();
            Properties properties = authContent.getLoaderProperties();
            properties.setProperty("load_from_locale", "true");
            PrincipalLoader principalLoader = principalManager.getPrincipalLoader(n);
            principalLoader.preLoad(properties);
            principalLoader.confirmLoading();
            Hashtable hashtable = this.QOIV(authContent);
            this.QOIV = new CubeAclManager(principalManager, hashtable);
        } else {
            this.QOIV = new CubeAclManager(principalManager, new Hashtable());
        }
    }

    private Hashtable QOIV(AuthContent authContent) throws NotOwnerException {
        Hashtable hashtable = authContent.getPermissions();
        Enumeration enumeration = hashtable.keys();
        Hashtable<String, Acl> hashtable2 = new Hashtable<String, Acl>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Hashtable[] hashtableArray = (Hashtable[])hashtable.get(string);
            if (hashtableArray == null) continue;
            String string2 = "JRAcl[" + string + "]";
            Acl acl = AclToolkit.createAclByHashtable(new JRUser("system", "build-in user"), string2, hashtableArray, SecurityService.getInstance().getPrincipalManager());
            hashtable2.put(string, acl);
        }
        return hashtable2;
    }
}

