/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core.node;

import java.util.ArrayList;
import java.util.Arrays;
import jet.dataengine.api.DSException;
import jet.dataengine8.olap.core.node.ANode;
import jet.dataengine8.util.LongArrayList;

public class NodeHashMap {
    transient int QOIV;
    private int add;
    private float append;
    private transient ANode[] copy;

    public NodeHashMap(int n) {
        this(n, 0.75f);
    }

    NodeHashMap(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        int n2 = 1;
        while (n2 < n) {
            n2 <<= 1;
        }
        this.append = f;
        this.copy = new ANode[n2];
        this.add = (int)((float)n2 * f);
        Arrays.fill(this.copy, null);
    }

    public NodeHashMap() {
        this(128, 0.75f);
    }

    public int size() {
        return this.QOIV;
    }

    public boolean isEmpty() {
        return this.QOIV == 0;
    }

    public ANode get(long l) {
        int n = NodeHashMap.QOIV(l) & this.copy.length - 1;
        ANode aNode = this.copy[n];
        while (aNode != null) {
            if (aNode.getKey() == l) {
                return aNode;
            }
            aNode = aNode.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.copy.length;
        ANode[] aNodeArray = this.copy;
        int n2 = n << 1;
        ANode[] aNodeArray2 = new ANode[n2];
        this.add = (int)((float)n2 * this.append);
        this.copy = aNodeArray2;
        int n3 = 0;
        while (n3 < n) {
            ANode aNode = aNodeArray[n3];
            while (aNode != null) {
                ANode aNode2 = aNode;
                aNode = aNode.next;
                int n4 = NodeHashMap.QOIV(aNode2.getKey()) & n2 - 1;
                aNode2.next = aNodeArray2[n4];
                aNodeArray2[n4] = aNode2;
            }
            ++n3;
        }
    }

    public void put(long l, ANode aNode) {
        if (aNode == null) {
            throw new NullPointerException();
        }
        if (aNode.getKey() != l) {
            throw new IllegalArgumentException();
        }
        int n = NodeHashMap.QOIV(l) & this.copy.length - 1;
        ANode aNode2 = this.copy[n];
        ANode aNode3 = null;
        while (aNode2 != null) {
            if (aNode2.getKey() == l) {
                aNode.next = aNode2.next;
                if (aNode3 == null) {
                    this.copy[n] = aNode;
                } else {
                    aNode3.next = aNode;
                }
                return;
            }
            aNode3 = aNode2;
            aNode2 = aNode2.next;
        }
        if (this.QOIV >= this.add) {
            this.rehash();
            this.put(l, aNode);
            return;
        }
        aNode.next = this.copy[n];
        this.copy[n] = aNode;
        ++this.QOIV;
    }

    private static int QOIV(long l) {
        int n = (int)(l ^ l >>> 32);
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    public ANode remove(long l) {
        int n = NodeHashMap.QOIV(l) & this.copy.length - 1;
        ANode aNode = this.copy[n];
        ANode aNode2 = null;
        while (aNode != null) {
            if (aNode.getKey() == l) {
                if (aNode2 != null) {
                    aNode2.next = aNode.next;
                } else {
                    this.copy[n] = aNode.next;
                }
                --this.QOIV;
                return aNode;
            }
            aNode2 = aNode;
            aNode = aNode.next;
        }
        return null;
    }

    public void clear() {
        int n = 0;
        while (n < this.copy.length) {
            this.copy[n] = null;
            ++n;
        }
        this.QOIV = 0;
    }

    public Object clone() {
        NodeHashMap nodeHashMap = new NodeHashMap(this.copy.length, this.append);
        int n = 0;
        int n2 = this.copy.length;
        while (n < n2) {
            ANode aNode = this.copy[n];
            while (aNode != null) {
                ANode aNode2 = aNode.copy();
                aNode2.next = nodeHashMap.copy[n];
                nodeHashMap.copy[n] = aNode2;
                aNode = aNode.next;
            }
            ++n;
        }
        nodeHashMap.QOIV = this.QOIV;
        return nodeHashMap;
    }

    public LongArrayList keys() {
        LongArrayList longArrayList = new LongArrayList(this.QOIV);
        int n = 0;
        while (n < this.copy.length) {
            ANode aNode = this.copy[n];
            while (aNode != null) {
                longArrayList.add(aNode.getKey());
                aNode = aNode.next;
            }
            ++n;
        }
        return longArrayList;
    }

    public void trimNodeDetailRecordIndexArray() throws DSException {
        int n = 0;
        while (n < this.copy.length) {
            ANode aNode = this.copy[n];
            while (aNode != null) {
                aNode.getRowID().trimToSize();
                aNode = aNode.next;
            }
            ++n;
        }
    }

    public ANode[] values() {
        ANode[] aNodeArray = new ANode[]{};
        if (this.QOIV != 0) {
            int n = 0;
            aNodeArray = new ANode[this.QOIV];
            int n2 = 0;
            while (n2 < this.copy.length) {
                ANode aNode = this.copy[n2];
                while (aNode != null) {
                    aNodeArray[n++] = aNode;
                    aNode = aNode.next;
                }
                ++n2;
            }
        }
        return aNodeArray;
    }

    public ArrayList valueList() {
        ArrayList<ANode> arrayList = new ArrayList<ANode>(this.QOIV);
        int n = 0;
        while (n < this.copy.length) {
            ANode aNode = this.copy[n];
            while (aNode != null) {
                arrayList.add(aNode);
                aNode = aNode.next;
            }
            ++n;
        }
        return arrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.QOIV != 0) {
            stringBuffer.append("[");
            int n = 0;
            while (n < this.copy.length) {
                ANode aNode = this.copy[n];
                while (aNode != null) {
                    stringBuffer.append("[").append(aNode.getKey()).append(",").append(aNode).append("],");
                    aNode = aNode.next;
                }
                ++n;
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }
}

