/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.query;

import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.query.JDataSourceQuery;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.util.DSLog;
import jet.dataengine.util.StringTools;
import jet.dataengine8.query.ARawDataQuery;
import jet.dataengine8.query.QueryManager;
import jet.datasource.InputStreamFactory;
import jet.formula.JetRptFormula;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUQuery;
import jet.universe.JetUUniverse;
import jet.universe.JetUXMLConnection;

public class DataSourceQuery
extends ARawDataQuery
implements JDataSourceQuery {
    private static String GetQueryByResourceName = "DataSourceQuery";
    private JetUUniverse NULL_ParameterList;
    private String QOIV;
    private String append;
    private String check;
    private JetRptFormula[] checkCanBeChange = ARawDataQuery.ZERO_FORMULA_ARRAY;
    private String checkClose;
    private InputStreamFactory checkDataSourceName;
    private boolean checkMappingName = false;

    public DataSourceQuery(QueryManager queryManager, int n) throws DSException {
        super(queryManager, n);
    }

    public JetUUniverse getCatalog() throws DSException {
        super.checkClose();
        return this.NULL_ParameterList;
    }

    public void setCatalog(JetUUniverse jetUUniverse) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.NULL_ParameterList = jetUUniverse;
    }

    public String getDataSourceName() throws DSException {
        super.checkClose();
        return this.QOIV;
    }

    public void setDataSourceName(String string) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.QOIV = string;
    }

    public String getQueryName() throws DSException {
        super.checkClose();
        return this.append;
    }

    public void setQueryName(String string) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.append = string;
    }

    public String getWherePortion() throws DSException {
        super.checkClose();
        return this.check;
    }

    public void setWherePortion(String string) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.check = string;
    }

    public JetRptFormula[] getPass1Formulas() throws DSException {
        super.checkClose();
        return (JetRptFormula[])this.checkCanBeChange.clone();
    }

    public void setPass1Formulas(JetRptFormula[] jetRptFormulaArray) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        if (jetRptFormulaArray != null) {
            this.checkCanBeChange = (JetRptFormula[])jetRptFormulaArray.clone();
        }
    }

    public void setPolicy(String string) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.checkClose = string;
    }

    public String getPolicy() throws DSException {
        super.checkClose();
        return this.checkClose;
    }

    public void check() throws DSException, JRStopEngineException {
        super.check();
        if (this.NULL_ParameterList == null) {
            throw new DSException(1055);
        }
        if (this.QOIV == null) {
            throw new DSException(1056);
        }
        if (StringTools.isEmptyStringWithTrim(this.append)) {
            throw new DSException(1057);
        }
        this.checkDataSourceName(this.NULL_ParameterList, this.QOIV);
        this.checkQueryName(this.NULL_ParameterList, this.QOIV, this.append);
        this.checkMappingName(this.NULL_ParameterList, this.QOIV);
        JetUDatabase jetUDatabase = this.NULL_ParameterList.getDatabase(this.QOIV);
        this.filters = ExpressionToolKit.replaceAllName(jetUDatabase, this.filters);
        if (this.parameterValueList != null && this.parameterValueList != ParameterValueList.NULL_ParameterList) {
            this.parameterValueList.updateParameterName(this.NULL_ParameterList.getDatabase(this.QOIV));
        }
        int n = 0;
        while (n < this.checkCanBeChange.length) {
            JetRptFormula jetRptFormula = this.checkCanBeChange[n];
            if (jetRptFormula.formulainfo.formulatype.getAttr() != 9 && !jetRptFormula.useSysVars() && !jetRptFormula.isNextPrev() && jetRptFormula.isSumFormula()) {
                throw new DSException(1106, new Object[]{jetRptFormula.getName()});
            }
            ++n;
        }
    }

    public void dump() throws DSException {
        this.checkClose();
        if (!DSLog.isAdhoc() || !this.log.isDebugEnabled()) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("DataSource Query:");
            this.log.indent(GetQueryByResourceName);
            super.dump();
            this.log.debug("universe: " + (this.NULL_ParameterList == null ? "null" : this.NULL_ParameterList.getName()));
            this.log.debug("dataSourceName: " + this.QOIV);
            this.log.debug("queryName: " + this.append);
            this.log.debug("wherePortion: " + this.check);
            this.log.debug("Pass1 formulas: size = " + this.checkCanBeChange.length);
            this.log.indent(GetQueryByResourceName);
            int n = 0;
            int n2 = this.checkCanBeChange.length;
            while (n < n2) {
                JetRptFormula jetRptFormula = this.checkCanBeChange[n];
                this.log.debug(jetRptFormula.getName());
                ++n;
            }
            this.log.deIndent(GetQueryByResourceName);
            this.log.debug("End Pass1 formulas");
            this.log.debug("Policy: " + this.checkClose);
            this.log.deIndent(GetQueryByResourceName);
            this.log.debug("End DataSource Query.");
        }
    }

    public JQuery copy(int n) throws DSException {
        super.checkClose();
        DataSourceQuery dataSourceQuery = new DataSourceQuery(this.manager, n);
        this.copyRawDataQuery(dataSourceQuery);
        dataSourceQuery.NULL_ParameterList = this.NULL_ParameterList;
        dataSourceQuery.QOIV = this.QOIV;
        dataSourceQuery.append = this.append;
        if (this.mappingNames != ARawDataQuery.ZERO_STRING_ARRAY) {
            dataSourceQuery.mappingNames = (String[])this.mappingNames.clone();
        }
        dataSourceQuery.check = this.check;
        if (this.checkCanBeChange != ARawDataQuery.ZERO_FORMULA_ARRAY) {
            dataSourceQuery.checkCanBeChange = (JetRptFormula[])this.checkCanBeChange.clone();
        }
        dataSourceQuery.checkClose = this.checkClose;
        return dataSourceQuery;
    }

    public boolean supportPushdown() {
        JetUConnection jetUConnection = this.NULL_ParameterList.getDatabase(this.QOIV).getConnection();
        if (jetUConnection == null || jetUConnection instanceof JetUXMLConnection) {
            return false;
        }
        String string = ((JetUJDBCConnection)jetUConnection).getJdbcDriver();
        if (string != null && string.equals("com.jinfonet.jdbc.obj.ObjectDriver")) {
            return false;
        }
        JetUQuery jetUQuery = this.NULL_ParameterList.GetQueryByResourceName(this.QOIV, this.append);
        if (jetUQuery instanceof JetUQuery) {
            JetUQuery jetUQuery2 = jetUQuery;
            if (jetUQuery2.enableSQLStmtCreator.get()) {
                return true;
            }
            if (!StringTools.isEmptyStringWithTrim(jetUQuery2.getPsqlQuery().getUserDefinedQueryStmt())) {
                return false;
            }
            return jetUQuery2.getPsqlQuery().getUnionVector().size() == 0;
        }
        return false;
    }

    protected void clearMemory() {
        super.clearMemory();
        this.NULL_ParameterList = null;
        this.QOIV = null;
        this.append = null;
        this.check = null;
        this.checkCanBeChange = null;
        this.checkClose = null;
    }

    public InputStreamFactory getInputStremFactory() throws DSException {
        return this.checkDataSourceName;
    }

    public boolean hasInputStreamFactory() {
        return this.checkMappingName;
    }

    public void setInputStreamFactory(InputStreamFactory inputStreamFactory) throws DSException {
        this.checkMappingName = inputStreamFactory != null;
        this.checkDataSourceName = inputStreamFactory;
        if (this.log.isDebugEnabled()) {
            this.log.debug(" *** Query : HDSQuery. hasStreamFactory:" + this.checkMappingName + ".");
            this.log.debug(" *** InputStreamFactory: " + this.checkDataSourceName);
        }
    }
}

