/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.datatypes.DataTypeUtils;
import com.jinfonet.util.JRLog;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import jet.JRStopEngineException;
import jet.connect.DbArray;
import jet.connect.DbBinary;
import jet.connect.DbValue;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSField;
import jet.datastream.DSOtherField;
import jet.datastream.DSParagraph;
import jet.datastream.DSSection;
import jet.datastream.DSTableCell;
import jet.datastream.DSTableRow;
import jet.datastream.DSTabular;
import jet.datastream.DSTabularCell;
import jet.datastream.DSTextBox;
import jet.datastream.DirtyFieldInParagraphManager;
import jet.datastream.JRObjectResult;
import jet.rptservice.api.design.ActionWithValueInfo;
import jet.util.Converter;
import jet.util.DbValueFormat;
import jet.util.JFieldValueNLSManager;
import jet.util.ReportFormat;
import jet.util.UpdLFString;
import jet.util.VersionControlable;

public class DSDBField
extends DSField
implements ActionWithValueInfo {
    private String UTFLength = null;
    protected DbValue value = null;
    private int beforeWrite = 0;
    private boolean convertString = false;
    private boolean dup = false;
    protected DbValue previousValue = null;
    protected byte flagDsDb = 0;

    public DbValue getValue(JRecord jRecord) {
        String string = null;
        if (this.value != null) {
            return this.value;
        }
        string = this.beforeWrite >= 262145 || this.beforeWrite == 0 ? (String)this.getPropertyByName("RuntimeColumnName", jRecord).getObject() : (String)this.getPropertyByName("ColumnName", jRecord).getObject();
        DbValue dbValue = null;
        int n = 0;
        if (this.F == null) {
            this.F = this.getSection();
        }
        if (this.F != null) {
            n = this.F.getObjectType();
        }
        if (n == 517 || n == 514 || n == 2564 || n == 2563) {
            dbValue = this.getPagelevel(string, n);
        }
        if (dbValue != null) {
            return dbValue;
        }
        dbValue = jRecord.getCell(string);
        if (dbValue == null) {
            return this.getRecord().getCell(string);
        }
        return dbValue;
    }

    public DbValue getValue() {
        String string = null;
        if (this.value != null) {
            return this.value;
        }
        string = this.beforeWrite >= 262145 || this.beforeWrite == 0 ? (String)this.getPropertyByName("RuntimeColumnName").getObject() : (String)this.getPropertyByName("ColumnName").getObject();
        DbValue dbValue = null;
        int n = 0;
        if (this.F == null) {
            this.F = this.getSection();
        }
        if (this.F != null) {
            n = this.F.getObjectType();
        }
        if (n == 517 || n == 514 || n == 2564 || n == 2563) {
            dbValue = this.getPagelevel(string, n);
        }
        if (dbValue != null) {
            return dbValue;
        }
        return this.getRecord().getCell(string);
    }

    public void setStringValue(String string) {
        this.UTFLength = string;
    }

    public String getText() {
        if (this.UTFLength != null) {
            return this.UTFLength;
        }
        try {
            if (this.getParent() != null && this.getParent() instanceof DSParagraph) {
                DirtyFieldInParagraphManager dirtyFieldInParagraphManager = this.getCommunicator().getDirtyFieldInParagraphLayoutManager();
                if (dirtyFieldInParagraphManager == null) {
                    dirtyFieldInParagraphManager = new DirtyFieldInParagraphManager();
                    this.getCommunicator().setDirtyFieldInParagraphLayoutManager(dirtyFieldInParagraphManager);
                }
                if (dirtyFieldInParagraphManager.isDirtyFInP(this)) {
                    return dirtyFieldInParagraphManager.getTrueText(this);
                }
            }
        }
        catch (Exception exception) {
            return this.UTFLength();
        }
        return this.UTFLength();
    }

    public String getText(JRecord jRecord) {
        block6: {
            if (this.UTFLength != null) {
                return this.UTFLength;
            }
            try {
                if (this.getParent() != null && this.getParent() instanceof DSParagraph) {
                    DirtyFieldInParagraphManager dirtyFieldInParagraphManager = this.getCommunicator().getDirtyFieldInParagraphLayoutManager();
                    if (dirtyFieldInParagraphManager == null) {
                        dirtyFieldInParagraphManager = new DirtyFieldInParagraphManager();
                        this.getCommunicator().setDirtyFieldInParagraphLayoutManager(dirtyFieldInParagraphManager);
                    }
                    if (dirtyFieldInParagraphManager.isDirtyFInP(this)) {
                        return dirtyFieldInParagraphManager.getTrueText(this);
                    }
                }
            }
            catch (Exception exception) {
                if (!JRLog.isError(3)) break block6;
                JRLog.trace(3, exception);
            }
        }
        return this.QOIV(jRecord);
    }

    public String getDirtyTextInParagraph() {
        return this.UTFLength();
    }

    private String QOIV(JRecord jRecord) {
        Object object;
        DbValue dbValue = this.getValue(jRecord);
        String string = DSDBField.formatValueToString(this, dbValue);
        String string2 = null;
        if (this.nlsBundle != null) {
            string2 = this.nlsBundle.getDataMapped(string);
        } else {
            object = this.getPropertyByName("DataMappingFile");
            String string3 = null;
            if (object != null) {
                string3 = (String)this.getPropertyByName("DataMappingFile").getObject();
            }
            if (string3 != null) {
                JFieldValueNLSManager jFieldValueNLSManager;
                if (this.nlsManager != null) {
                    string2 = this.nlsManager.getFieldBindNLSValue(string3, string);
                } else if (string3.length() != 0 && (jFieldValueNLSManager = this.getCommunicator().getFieldNLSManager()) != null) {
                    string2 = jFieldValueNLSManager.getFieldBindNLSValue(string3, string);
                }
            }
        }
        if (string2 != null) {
            string = string2;
        }
        if (this.isRuntimeConvert) {
            if (this.fromEncoding != -1 && this.toEncoding != -1) {
                string = Converter.convertString(string, this.fromEncoding, this.toEncoding);
            }
        } else {
            object = this.getCommunicator();
            this.fromEncoding = object.getFromEncoding();
            this.toEncoding = object.getToEncoding();
            if (this.fromEncoding != -1 && this.toEncoding != -1) {
                string = Converter.convertString(string, this.fromEncoding, this.toEncoding);
            }
        }
        return string;
    }

    private String UTFLength() {
        Object object;
        DbValue dbValue = this.getValue();
        String string = DSDBField.formatValueToString(this, dbValue);
        String string2 = null;
        if (this.nlsBundle != null) {
            string2 = this.nlsBundle.getDataMapped(string);
        } else {
            object = this.getPropertyByName("DataMappingFile");
            String string3 = null;
            if (object != null) {
                string3 = (String)this.getPropertyByName("DataMappingFile").getObject();
            }
            if (string3 != null) {
                JFieldValueNLSManager jFieldValueNLSManager;
                if (this.nlsManager != null) {
                    string2 = this.nlsManager.getFieldBindNLSValue(string3, string);
                } else if (string3.length() != 0 && (jFieldValueNLSManager = this.getCommunicator().getFieldNLSManager()) != null) {
                    string2 = jFieldValueNLSManager.getFieldBindNLSValue(string3, string);
                }
            }
        }
        if (string2 != null) {
            string = string2;
        }
        if (this.isRuntimeConvert) {
            if (this.fromEncoding != -1 && this.toEncoding != -1) {
                string = Converter.convertString(string, this.fromEncoding, this.toEncoding);
            }
        } else {
            object = this.getCommunicator();
            this.fromEncoding = object.getFromEncoding();
            this.toEncoding = object.getToEncoding();
            if (this.fromEncoding != -1 && this.toEncoding != -1) {
                string = Converter.convertString(string, this.fromEncoding, this.toEncoding);
            }
        }
        return string;
    }

    protected void beforeWrite() {
        super.beforeWrite();
        this.flagDsDb = (byte)(this.flagDsDb | (this.UTFLength != null ? (byte)1 : 0));
        this.flagDsDb = (byte)(this.flagDsDb | (this.convertString ? 2 : 0));
        this.flagDsDb = (byte)(this.flagDsDb | (this.dup ? 4 : 0));
    }

    public static String formatValueToString(DSField dSField, DbValue dbValue) {
        String string = null;
        if (dbValue != null && !dbValue.isNull()) {
            if (dbValue instanceof DbBinary) {
                return "";
            }
            String string2 = (String)dSField.getPropertyByName("Format").getObject();
            if (string2.equals("")) {
                string2 = DataTypeUtils.getDefaultFormat(dbValue.getSqlType());
            }
            if (string2 == null || string2.equals("") || string2.equalsIgnoreCase("null")) {
                string = dbValue.toString();
            } else {
                DbValueFormat dbValueFormat;
                block13: {
                    dbValueFormat = null;
                    try {
                        dbValueFormat = ReportFormat.getOneFormat(dbValue.getSqlType(), string2, dSField.getLocale(), dSField.getTimeZone());
                    }
                    catch (Exception exception) {
                        if (!JRLog.isError(3)) break block13;
                        JRLog.error(3, exception);
                    }
                }
                if (dbValue instanceof DbArray) {
                    String string3 = UpdLFString.getUpdString((String)dSField.getPropertyByName("ValueDelimiter").getObject());
                    string = dbValueFormat != null ? dbValueFormat.format(dbValue, string3) : dbValue.toString();
                } else {
                    string = dbValueFormat != null ? dbValueFormat.format(dbValue) : dbValue.toString();
                }
            }
        } else {
            block14: {
                string = null;
                try {
                    string = (String)dSField.getPropertyByName("DisplayNull").getObject();
                }
                catch (Exception exception) {
                    if (!JRLog.isError(2)) break block14;
                    JRLog.error(2, exception);
                }
            }
            if (string == null) {
                string = "NULL";
            }
        }
        return string;
    }

    public Object clone() {
        return this.dup(new DSDBField());
    }

    public DSDBField dup(DSDBField dSDBField) {
        super.dup(dSDBField);
        dSDBField.convertString = this.convertString;
        if (this.convertString) {
            dSDBField.value = (DbValue)this.value.clone();
        }
        return dSDBField;
    }

    protected void readPorpertiesForV8ParameterField(DataInput dataInput, DSDataStreamable dSDataStreamable) throws JRStopEngineException, IOException {
        super.readProperties(dataInput, dSDataStreamable);
    }

    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        if (dataInput instanceof VersionControlable) {
            int n;
            this.beforeWrite = n = ((VersionControlable)((Object)dataInput)).getVersion();
            if (n > 262160 || n == 0) {
                this.flagDsDb = dataInput.readByte();
            }
            if (n >= 131094 && n <= 262160) {
                boolean bl = dataInput.readBoolean();
                if (!bl) {
                    this.UTFLength = dataInput.readUTF();
                }
            } else if ((n > 262160 || n == 0) && (this.flagDsDb & 1) != 0) {
                this.UTFLength = dataInput.readUTF();
            }
            if (n >= 262145 && n <= 262160) {
                this.convertString = dataInput.readBoolean();
                if (this.convertString) {
                    this.value = DSOtherField.I(dataInput);
                }
                this.dup = dataInput.readBoolean();
            } else if (n > 262160 || n == 0) {
                boolean bl = this.convertString = (this.flagDsDb & 2) != 0;
                if (this.convertString) {
                    this.value = DSOtherField.I(dataInput);
                }
                this.dup = (this.flagDsDb & 4) != 0;
            }
        }
    }

    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeByte(this.flagDsDb);
        if (this.UTFLength != null) {
            dataOutput.writeUTF(this.UTFLength);
        }
        if (this.convertString) {
            DSOtherField.I(dataOutput, this.value);
        }
    }

    protected int propLength() {
        int n = super.propLength();
        ++n;
        if (this.UTFLength != null) {
            n += 2 + JRObjectResult.UTFLength(this.UTFLength);
        }
        if (this.convertString) {
            n += DSOtherField.I(this.value);
        }
        return n;
    }

    public String getFormat() {
        String string = (String)this.getPropertyByName("Format").getObject();
        if (string == null || string.equals("") || string.equalsIgnoreCase("null")) {
            string = null;
        }
        return string;
    }

    public void setValue(DbValue dbValue) {
        this.value = dbValue;
    }

    public JRecord getRecord() {
        if (this.getCacheRecord() != null) {
            return (JRecord)this.getCacheRecord();
        }
        DSContainer dSContainer = (DSContainer)this.getParent();
        while (!(dSContainer instanceof DSSection)) {
            if (dSContainer instanceof DSParagraph || dSContainer instanceof DSTextBox || dSContainer instanceof DSTabular || dSContainer instanceof DSTabularCell) {
                if (!((Boolean)dSContainer.getPropertyByName("dataInherit").getObject()).booleanValue()) {
                    return null;
                }
            } else {
                if (dSContainer.getObjectType() == 262182) {
                    return null;
                }
                if (dSContainer instanceof DSTableCell) {
                    return dSContainer.getRecord();
                }
            }
            dSContainer = (DSContainer)dSContainer.getParent();
        }
        return this.booleanValue();
    }

    private JRecord booleanValue() {
        return super.getRecord();
    }

    public String getObjectName() {
        return this.getTemplate().getInstName();
    }

    public List getAvailableValues() {
        DSTableRow dSTableRow = this.getTableRow();
        if (dSTableRow != null) {
            return dSTableRow.getAvailableValues();
        }
        return this.getSection().getAvailableValues();
    }

    public void setCanBeSaveDbValue(boolean bl) {
        this.convertString = bl;
    }

    public void setIsParapraphSplitField(boolean bl) {
        this.dup = bl;
    }

    public boolean isParagraphSplitField() {
        return this.dup;
    }

    public void setPreviousValue(DbValue dbValue) {
        this.previousValue = dbValue;
    }

    public DbValue getPreviousValue() {
        return this.previousValue;
    }

    public String getPreviousText() {
        if (this.previousValue != null) {
            return DSDBField.formatValueToString(this, this.previousValue);
        }
        return this.getText();
    }

    public boolean isCanBeSaveDbValue() {
        return this.convertString;
    }
}

