/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine.accessor.cube;

import com.jinfonet.util.JRLog;
import java.sql.Timestamp;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.JDataEngine;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.schema.olap.cursor.CubeCursor;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptDataContainer;
import jet.rptengine.ContainerInfo;
import jet.rptengine.JReportEngine;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.engine.accessor.cube.CursorManager;
import jet.rptservice.engine.infocenter.CubeViewInfo;
import jet.rptservice.engine.infocenter.ForceExpiredTable;
import jet.rptservice.util.ReportTools;

public class CubeCursorAccessor {
    JReportEngine QOIV;
    JDataEngine append;
    CursorManager currentTimeMillis;

    public CubeCursorAccessor(JReportEngine jReportEngine) {
        this.QOIV = jReportEngine;
        this.append = jReportEngine.getDataEngine();
        this.currentTimeMillis = new CursorManager();
    }

    public void init() {
        this.currentTimeMillis.I(this.getFET());
    }

    public synchronized CubeCursor getCubeViewCursor(JetRptCTCrossTab jetRptCTCrossTab) throws JRScheduleException, JRStopEngineException {
        if (this.QOIV.isStopping()) {
            throw new JRStopEngineException(220041, new String[]{"engine is stopped when getting cube view cursor."}, null);
        }
        long l = 0L;
        if (JRLog.isTrace(5)) {
            l = System.currentTimeMillis();
            JRLog.trace(5, new String("\n&&&&&&&&&&&&Cube Process:get CubeViewCursor:" + jetRptCTCrossTab + "\n"));
        }
        CubeCursor cubeCursor = null;
        String string = jetRptCTCrossTab.getInstName();
        ContainerInfo containerInfo = this.getContainerInfo(string);
        int n = this.currentTimeMillis.B(string);
        try {
            if (n == 0) {
                int n2 = this.getCubeQueryId(jetRptCTCrossTab);
                String string2 = ReportTools.getDataSet(jetRptCTCrossTab).getName();
                this.getRptSetEngine().runDataSet(string2, false);
                IBooleanExpression iBooleanExpression = this.QOIV.getReportViewCenter().getBrowseFilter(jetRptCTCrossTab.getInstName());
                CubeViewInfo cubeViewInfo = containerInfo.getCubeViewInfo();
                this.currentTimeMillis.I(string, n2, cubeViewInfo, this.append, iBooleanExpression);
            } else {
                this.currentTimeMillis.C(string);
            }
            cubeCursor = this.currentTimeMillis.Z(string);
        }
        catch (DSException dSException) {
            throw new JRScheduleException(225001, new String[]{" DataContainer [" + string + "]"}, dSException);
        }
        catch (ConditionException conditionException) {
            throw new JRScheduleException(225002, new String[]{" DataContainer [" + string + "]"}, conditionException);
        }
        if (JRLog.isTrace(5)) {
            long l2 = System.currentTimeMillis();
            JRLog.trace(5, new String("#####Get CubeView Cursor: " + string + " : " + (l2 - l)));
        }
        return cubeCursor;
    }

    protected int getCubeQueryId(JetRptCTCrossTab jetRptCTCrossTab) {
        return this.QOIV.getCubeQueryId(jetRptCTCrossTab);
    }

    protected JRptSetEngine getRptSetEngine() {
        return this.QOIV.getRptSetEngine();
    }

    protected ContainerInfo getContainerInfo(String string) {
        return this.QOIV.getContainerInfo(string);
    }

    public ForceExpiredTable getFET() {
        return this.QOIV.getReportViewCenter().getForceExpiredTable();
    }

    public void submit() throws JRScheduleException {
        if (this.currentTimeMillis != null) {
            this.currentTimeMillis.I();
        }
    }

    public void closeAllCubeViewCursor() {
        this.currentTimeMillis.Z();
    }

    public void closeCubeViewCursor(JetRptDataContainer jetRptDataContainer) throws JRScheduleException {
        String string = jetRptDataContainer.getInstName();
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " closeCubeViewCursor(" + string + ") begin at:" + new Timestamp(System.currentTimeMillis()));
        }
        this.currentTimeMillis.I(string);
    }

    String name() {
        String string = "";
        if (this.QOIV != null) {
            string = this.QOIV.name();
        }
        if (string != null && string.length() > 0) {
            string = "of " + string;
        }
        return "CubeCursorAccessor " + string + " ";
    }
}

