/*
 * Decompiled with CFR 0.152.
 */
package jet.swingviewer;

import guitools.toolkit.TPaintBoard;
import guitools.toolkit.Unit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import jet.JRStopEngineException;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.datastream.DataStream;
import jet.thinviewer.JReportDrillDownViewer;
import jet.thinviewer.viewerSizeChangedListener;

public class DrillDownView
extends JFrame
implements viewerSizeChangedListener {
    int I = 5;
    int Z = 5;
    protected ImageIcon titleImage = null;
    Communicator C;
    private DataStream QOIV;
    private String add;
    Timer B = null;
    JPanel addAdjustmentListener;
    JScrollBar D = new JScrollBar(1);
    JScrollBar F = new JScrollBar(0);
    DSPage changeContentsSize;
    protected JReportDrillDownViewer drillDownViewer;
    TPaintBoard J = new TPaintBoard();
    boolean convertUnitToPixel;
    boolean S = false;
    Scroller getDataStream;
    Dimension A;

    public DrillDownView(Communicator communicator, DataStream dataStream, DSPage dSPage, String string, boolean bl) {
        super(string);
        this.C = communicator;
        this.QOIV = dataStream;
        this.changeContentsSize = dSPage;
        this.add = string;
        this.convertUnitToPixel = bl;
        this.setBounds(20, 20, 800, 400);
        this.getContentPane().setLayout(new BorderLayout());
    }

    public void setViewer(JReportDrillDownViewer jReportDrillDownViewer) {
        this.drillDownViewer = jReportDrillDownViewer;
        jReportDrillDownViewer.setLocation(this.I, this.Z);
    }

    public JReportDrillDownViewer getDrillDownViwer() {
        this.initViewer(this.changeContentsSize, this.add, this.QOIV);
        return this.drillDownViewer;
    }

    public void initViewer(DSPage dSPage, String string, DataStream dataStream) {
        this.drillDownViewer = new JReportDrillDownViewer(this, dataStream, string){
            private final DrillDownView this$0;
            {
                this.this$0 = drillDownView;
                super(dataStream, string);
            }

            public Insets getInsets() {
                return new Insets(1, 1, 5, 5);
            }

            public void paint(Graphics graphics) {
                super.paint(graphics);
                Dimension dimension = this.getSize();
                graphics.setColor(Color.black);
                int n = 0;
                while (n < 1) {
                    graphics.drawRect(n, n, dimension.width - 4 - 2 - n * 2, dimension.height - 4 - 2 - n * 2);
                    ++n;
                }
                graphics.setColor(Color.black);
                graphics.fillRect(3, dimension.height - 4 - 1, dimension.width - 3 - 1, 4);
                graphics.fillRect(dimension.width - 4 - 1, 3, 4, dimension.height - 3 - 1);
            }
        };
        this.drillDownViewer.setCurPage(dSPage);
        Rectangle rectangle = dataStream.getPageArea();
        this.drillDownViewer.setBounds(0, 0, rectangle.width, rectangle.height);
        this.A = new Dimension(rectangle.width / 10, rectangle.height / 10);
        this.J.add(this.drillDownViewer);
        this.J.setBackground(Color.gray);
        this.getDataStream = new Scroller(this);
        this.F.addAdjustmentListener(this.getDataStream);
        this.D.addAdjustmentListener(this.getDataStream);
        this.addAdjustmentListener = new JPanel();
        this.addAdjustmentListener.add((Component)this.J, "Center");
        this.addAdjustmentListener.add((Component)this.D, "East");
        this.addAdjustmentListener.add((Component)this.F, "South");
        this.addAdjustmentListener.setBackground(Color.gray);
        Rectangle rectangle2 = this.drillDownViewer.getViewerArea();
        this.J.add(this.drillDownViewer);
        this.J.setBackground(Color.gray);
        this.getContentPane().add(this.addAdjustmentListener);
        this.drillDownViewer.runThread();
        this.addAdjustmentListener.setBounds(5, 5, rectangle2.width, rectangle2.height);
        this.addAdjustmentListener.setLayout(new ViewerLayout(this));
        this.addAdjustmentListener.setBounds(15, 15, rectangle2.width, rectangle2.height);
        this.show();
        this.I();
    }

    public Communicator getCommunicator() {
        return this.C;
    }

    public void refresh() {
        int n = this.C.getResolution();
        try {
            DataStream dataStream = (DataStream)this.C.getDataStream(0);
            Rectangle rectangle = dataStream.getPageArea();
            rectangle.x = Unit.convertUnitToPixel(rectangle.x, n);
            rectangle.y = Unit.convertUnitToPixel(rectangle.y, n);
            rectangle.width = Unit.convertUnitToPixel(rectangle.width, n);
            rectangle.height = Unit.convertUnitToPixel(rectangle.height, n);
        }
        catch (JRStopEngineException jRStopEngineException) {
            jRStopEngineException.printStackTrace();
        }
    }

    public boolean setTitleImage(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.titleImage = imageIcon;
            this.setIconImage(imageIcon.getImage());
            return true;
        }
        return false;
    }

    public void setCommunicator(Communicator communicator) {
        this.C = communicator;
    }

    public void setDataStream(DataStream dataStream) {
        this.QOIV = dataStream;
    }

    public void setGroupBy(String string) {
        this.add = string;
    }

    public void setScrollPosition(int n, int n2) {
        this.F.setValue(n);
        this.D.setValue(n2);
    }

    public void viewerSizeChanged(Dimension dimension) {
        this.invalidate();
        this.validate();
    }

    public void changeContentsSize() {
        this.F.setMaximumSize(new Dimension((int)this.drillDownViewer.getSize().getWidth(), 25));
        this.D.setMaximumSize(new Dimension(25, (int)this.drillDownViewer.getSize().getHeight()));
    }

    public void scrolls(int n, int n2) {
        this.F.setValue(n);
        this.D.setValue(n2);
        this.changeContentsSize();
    }

    public int[] getScrollPosition() {
        int[] nArray = new int[]{this.F.getValue(), this.D.getValue()};
        return nArray;
    }

    private synchronized void I() {
        this.B = new Timer(1000, new ActionListener(this){
            private final DrillDownView this$0;
            {
                this.this$0 = drillDownView;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.S = this.this$0.C.isEngineFinished();
                if (this.this$0.B != null) {
                    this.this$0.A = this.this$0.drillDownViewer.getSize();
                    this.this$0.D.setMaximum(this.this$0.A.height + 2 * this.this$0.Z);
                    this.this$0.F.setMaximum(this.this$0.A.width + 2 * this.this$0.I);
                    this.this$0.drillDownViewer.reload();
                    this.this$0.B.stop();
                    this.this$0.B = null;
                }
            }
        });
        this.B.start();
    }

    class ViewerLayout
    implements LayoutManager {
        private final DrillDownView this$0;

        ViewerLayout(DrillDownView drillDownView) {
            this.this$0 = drillDownView;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return container.getSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n;
            Dimension dimension = container.getSize();
            if (this.this$0.S) {
                this.this$0.A = this.this$0.drillDownViewer.getSize().height != 67351 ? this.this$0.drillDownViewer.getSize() : this.this$0.drillDownViewer.getSize();
            }
            this.this$0.S = true;
            Point point = this.this$0.drillDownViewer.getLocation();
            int n2 = this.this$0.D.getPreferredSize().width;
            int n3 = this.this$0.F.getPreferredSize().height;
            if (dimension.width >= this.this$0.A.width + 2 * this.this$0.I && dimension.height >= this.this$0.A.height + 2 * this.this$0.Z) {
                this.this$0.F.setVisible(false);
                this.this$0.D.setVisible(false);
                n2 = 0;
                n3 = 0;
            } else {
                if (dimension.width < this.this$0.A.width + 2 * this.this$0.I) {
                    if (!this.this$0.F.isVisible()) {
                        point.x = this.this$0.I;
                        this.this$0.F.setVisible(true);
                    }
                    if (dimension.height >= this.this$0.A.height + 2 * this.this$0.Z + n3) {
                        n2 = 0;
                        this.this$0.D.setVisible(false);
                    } else if (!this.this$0.D.isVisible()) {
                        point.y = this.this$0.Z;
                        this.this$0.D.setVisible(true);
                    }
                }
                if (dimension.height < this.this$0.A.height + 2 * this.this$0.Z) {
                    if (!this.this$0.D.isVisible()) {
                        point.y = this.this$0.Z;
                        this.this$0.D.setVisible(true);
                    }
                    if (dimension.width >= this.this$0.A.width + 2 * this.this$0.I + n2) {
                        n3 = 0;
                        this.this$0.F.setVisible(false);
                    } else if (!this.this$0.F.isVisible()) {
                        point.x = this.this$0.I;
                        this.this$0.F.setVisible(true);
                    }
                }
            }
            int n4 = dimension.width - n2;
            int n5 = dimension.height - n3;
            this.this$0.F.setMaximumSize(new Dimension((int)this.this$0.drillDownViewer.getSize().getWidth(), 25));
            this.this$0.D.setMaximumSize(new Dimension(25, (int)this.this$0.drillDownViewer.getSize().getHeight()));
            this.this$0.J.setBounds(0, 0, n4, n5);
            if (this.this$0.D.isVisible()) {
                n = Math.min(this.this$0.D.getValue(), this.this$0.A.height + 2 * this.this$0.Z + n3 - dimension.height);
                point.y = this.this$0.Z - n;
                this.this$0.D.setBounds(n4, 0, n2, n5);
                this.this$0.D.setValue(n);
                this.this$0.D.setMaximum(this.this$0.A.height + 2 * this.this$0.Z);
                this.this$0.D.setVisibleAmount(n5);
                this.this$0.D.setBlockIncrement(n5);
                this.this$0.D.setUnitIncrement(n5 / 10);
            } else {
                point.y = (dimension.height - this.this$0.A.height - n3) / 2;
            }
            if (this.this$0.F.isVisible()) {
                n = Math.min(this.this$0.F.getValue(), this.this$0.A.width + 2 * this.this$0.I + n2 - dimension.width);
                point.x = this.this$0.I - n;
                this.this$0.F.setBounds(0, n5, n4, n3);
                this.this$0.F.setValue(n);
                this.this$0.F.setMaximum(this.this$0.A.width + 2 * this.this$0.I);
                this.this$0.F.setVisibleAmount(n4);
                this.this$0.F.setBlockIncrement(n4);
                this.this$0.F.setUnitIncrement(n4 / 10);
            } else {
                point.x = (dimension.width - this.this$0.A.width - n2) / 2;
            }
            if (!this.this$0.drillDownViewer.getLocation().equals(point)) {
                this.this$0.J.scrolls(point.x - this.this$0.I, point.y - this.this$0.Z);
            }
            this.this$0.J.unlockUpdate();
        }
    }

    class Scroller
    implements AdjustmentListener {
        private final DrillDownView this$0;

        Scroller(DrillDownView drillDownView) {
            this.this$0 = drillDownView;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Dimension dimension = this.this$0.drillDownViewer.getSize();
            Point point = this.this$0.J.getClientAreaOffsets();
            int n = this.this$0.F.isVisible() ? Math.min(this.this$0.F.getValue(), dimension.width + 2 * this.this$0.I) : -point.x;
            int n2 = this.this$0.D.isVisible() ? Math.min(this.this$0.D.getValue(), dimension.height + 2 * this.this$0.Z) : -point.y;
            this.this$0.J.scrolls(-n, -n2);
        }
    }
}

