/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import chart.ChartCoordinatePaper;
import chart.ChartDefinition;
import chart.ChartEnv;
import chart.ChartLabelBase;
import chart.ChartLegend;
import chart.ChartPlatform;
import chart.chart3d.ChartMatrix;
import chart.data.ChartDataSetInfo;
import chart.data.ChartTypeInfo;
import chart.util.ChartHtmlMapExport;
import com.jinfonet.awt.ps.PSGraphics;
import com.jinfonet.util.JRLog;
import guitools.toolkit.TContainer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.Record;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSContainer;
import jet.datastream.DSSection;
import jet.datastream.JRObjectResult;
import jet.thinviewer.ChartDrillDownImplementor;
import jet.thinviewer.JReportContainerable;
import jet.udo.JRObjectRender;
import jet.util.PropertySetable;

public class JReportChartPlatform
extends TContainer
implements JRObjectRender,
JReportContainerable,
MouseListener,
MouseMotionListener {
    public static final int CORDINATE_NORMAL = 0;
    public static final int CORDINATE_3D = 1;
    public static final int CORDINATE_3D_BENCH = 2;
    public static final int CORDINATE_PIE = 3;
    private ChartPlatform KEY_ANTIALIASING;
    private DSChartPlatform QOIV;
    private ChartCoordinatePaper VALUE_ANTIALIAS_ON;
    private Point WORDWRAPPER_GAP;
    private int _xrot;
    private float[] booleanValue = new float[3];
    private Point contains;
    ChartLabelBase[] createChartPlatform;
    private ChartMatrix m = new ChartMatrix();
    private ChartMatrix drawImage = new ChartMatrix();
    String drilldownInChart;
    String equals;
    String equalsIgnoreCase;
    boolean error = true;
    ChartLegend exportHTML;

    public JReportChartPlatform() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._xrot = 0;
    }

    public void paint(Graphics graphics) {
        if (this.KEY_ANTIALIASING == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6401501);
            }
            return;
        }
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        try {
            if (graphics instanceof PSGraphics) {
                Rectangle rectangle = this.KEY_ANTIALIASING.getBounds();
                bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
                graphics2D = (Graphics2D)bufferedImage.getGraphics();
            } else {
                graphics2D = (Graphics2D)graphics;
            }
        }
        catch (ClassCastException classCastException) {
            Rectangle rectangle = this.KEY_ANTIALIASING.getBounds();
            bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 6);
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
        }
        this.KEY_ANTIALIASING(graphics2D);
        if (bufferedImage != null) {
            graphics.drawImage(bufferedImage, 0, 0, this);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6401502);
        }
    }

    private void KEY_ANTIALIASING(Graphics2D graphics2D) {
        Object object = null;
        if (this.KEY_ANTIALIASING.getProperties().isAntiAliasing()) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.KEY_ANTIALIASING.paint(graphics2D);
        if (this.VALUE_ANTIALIAS_ON.getProperties().isInteractive() && this.VALUE_ANTIALIAS_ON.getProperties().isShowTips()) {
            this.QOIV(graphics2D);
        }
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
        super.paint(graphics2D);
    }

    private void QOIV(Graphics2D graphics2D) {
        if (this.createChartPlatform != null) {
            float f = 0.0f;
            int n = this.createChartPlatform.length - 1;
            while (n >= 0) {
                if (this.createChartPlatform[n] != null && this.createChartPlatform[n].getLabelText() != null) {
                    Rectangle2D rectangle2D = this.createChartPlatform[n].getChartTextStyle().getDimension(graphics2D, this.createChartPlatform[n].getLabelText());
                    if (this.KEY_ANTIALIASING.contains((int)((double)this.contains.x + rectangle2D.getWidth()), this.contains.y)) {
                        this.createChartPlatform[n].paint(graphics2D, this.contains.x + ChartEnv.WORDWRAPPER_GAP, (float)((double)this.contains.y - rectangle2D.getHeight()) - f);
                    } else {
                        this.createChartPlatform[n].paint(graphics2D, (float)((double)(this.contains.x + ChartEnv.WORDWRAPPER_GAP) - rectangle2D.getWidth()), (float)((double)this.contains.y - rectangle2D.getHeight()) - f);
                    }
                    f = (float)((double)f + (rectangle2D.getHeight() + (double)ChartEnv.WORDWRAPPER_GAP));
                }
                --n;
            }
        }
    }

    public List getHtmlDrilldownMap() {
        if (this.KEY_ANTIALIASING == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6401501);
            }
            return null;
        }
        String string = (String)this.QOIV.getPropertyByName("HyperLink").getObject();
        String string2 = (String)this.QOIV.getPropertyByName("XHyperLink").getObject();
        String string3 = (String)this.QOIV.getPropertyByName("ZHyperLink").getObject();
        ChartHtmlMapExport chartHtmlMapExport = new ChartHtmlMapExport(this.KEY_ANTIALIASING);
        chartHtmlMapExport.exportHTML(string, string2, string3);
        return chartHtmlMapExport.getResultMap();
    }

    public List getDHtmlDrilldownMap() {
        if (this.KEY_ANTIALIASING == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6401501);
            }
            return null;
        }
        String string = (String)this.QOIV.getPropertyByName("HyperLink").getObject();
        String string2 = (String)this.QOIV.getPropertyByName("XHyperLink").getObject();
        String string3 = (String)this.QOIV.getPropertyByName("ZHyperLink").getObject();
        ChartHtmlMapExport chartHtmlMapExport = new ChartHtmlMapExport(this.KEY_ANTIALIASING);
        chartHtmlMapExport.exportHTML(string, string2, string3);
        return chartHtmlMapExport.getResultMap();
    }

    public void setStatus(int n) {
    }

    public void setProperty(PropertySetable propertySetable) {
        this.QOIV = (DSChartPlatform)propertySetable;
        this.QOIV.init();
        this.QOIV.resetBounds();
        this.KEY_ANTIALIASING = this.QOIV.createChartPlatform();
        if (this.KEY_ANTIALIASING == null) {
            return;
        }
        this.VALUE_ANTIALIAS_ON = this.KEY_ANTIALIASING.getChartCoordinatePaper();
        ChartDefinition chartDefinition = this.KEY_ANTIALIASING.getChartDefinition();
        ChartDataSetInfo[] chartDataSetInfoArray = chartDefinition.getChartDataSetInfos();
        int n = ChartTypeInfo.getPrimType(chartDataSetInfoArray[0].getChartType());
        if (chartDefinition.is3DEffect()) {
            this._xrot = n == 1 ? 2 : 1;
        } else if (n == 4) {
            this._xrot = 3;
        }
        this.drilldownInChart = (String)this.QOIV.getPropertyByName("HyperLink").getObject();
        this.equals = (String)this.QOIV.getPropertyByName("XHyperLink").getObject();
        this.equalsIgnoreCase = (String)this.QOIV.getPropertyByName("ZHyperLink").getObject();
        Vector vector = this.QOIV.getChildren();
        int n2 = 0;
        while (n2 < vector.size()) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(n2);
            if (jRObjectResult.getObjectType() == 72) {
                this.error = (Boolean)jRObjectResult.getPropertyByName("Interactive").getObject();
                this.m._xrot(((Number)jRObjectResult.getPropertyByName("AngleX").getObject()).intValue());
                this.m.yrot(((Number)jRObjectResult.getPropertyByName("AngleY").getObject()).intValue());
                try {
                    this.m.zrot(((Number)jRObjectResult.getPropertyByName("AngleZ").getObject()).intValue());
                }
                catch (NullPointerException nullPointerException) {
                    this.m.zrot(0.0);
                }
                break;
            }
            ++n2;
        }
        this.booleanValue[0] = this.VALUE_ANTIALIAS_ON.properties.getAngleX();
        this.booleanValue[1] = this.VALUE_ANTIALIAS_ON.properties.getAngleY();
        this.exportHTML = this.KEY_ANTIALIASING.getChartLegend();
    }

    public void createChildren(DSContainer dSContainer) {
    }

    public void relocate() {
    }

    public void boundsChanged() {
    }

    public void setSelected(boolean bl) {
    }

    public void deselectAll() {
    }

    public void updateProperties(int n, Component component) {
    }

    public void setProperty(PropertySetable propertySetable, Record record) {
    }

    public String[] toHtml(String string) {
        ChartHtmlMapExport chartHtmlMapExport = new ChartHtmlMapExport(this.KEY_ANTIALIASING);
        return chartHtmlMapExport.getResult();
    }

    public String[] toDHtml(String string) {
        string = this.KEY_ANTIALIASING.getChartDefinition().getCategory();
        if (string == null) {
            string = "";
        }
        ChartHtmlMapExport chartHtmlMapExport = new ChartHtmlMapExport(this.KEY_ANTIALIASING);
        return chartHtmlMapExport.getResult();
    }

    public String[] toDHtml() {
        String string = this.KEY_ANTIALIASING.getChartDefinition().getCategory();
        if (string == null) {
            string = "";
        }
        ChartHtmlMapExport chartHtmlMapExport = new ChartHtmlMapExport(this.KEY_ANTIALIASING);
        return chartHtmlMapExport.getResult();
    }

    public void changeType(int n, int n2, int n3) {
    }

    public void refreshDSChart() {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        String[] stringArray;
        Point point;
        int n2;
        int n3;
        if (this.KEY_ANTIALIASING == null || !this.error) {
            return;
        }
        if (this.VALUE_ANTIALIAS_ON.getZDim() != null && this.equalsIgnoreCase != null && !this.equalsIgnoreCase.trim().equalsIgnoreCase("") || this.VALUE_ANTIALIAS_ON.getXDim() != null && this.equals != null && !this.equals.trim().equalsIgnoreCase("")) {
            this.setCursor(Cursor.getPredefinedCursor(1));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.exportHTML != null) {
            if (this.exportHTML.getBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
                n3 = mouseEvent.getX() - this.exportHTML.getBounds().x;
                n2 = mouseEvent.getY() - this.exportHTML.getBounds().y;
                this.exportHTML.hintText = this.exportHTML.getHintValue(n3, n2);
                if (this.exportHTML.hintText != null) {
                    point = mouseEvent.getPoint();
                    this.contains = mouseEvent.getPoint();
                    stringArray = this.exportHTML.hintText;
                    this.createChartPlatform = new ChartLabelBase[stringArray.length];
                    n = 0;
                    while (n < stringArray.length) {
                        this.createChartPlatform[n] = new ChartLabelBase(stringArray[n]);
                        this.createChartPlatform[n].setChartTextStyle(this.VALUE_ANTIALIAS_ON.getProperties().getHintTextStyle());
                        ++n;
                    }
                } else {
                    this.createChartPlatform = null;
                }
            } else {
                this.createChartPlatform = null;
            }
        }
        if (this.createChartPlatform == null && this.VALUE_ANTIALIAS_ON != null && this.VALUE_ANTIALIAS_ON.getBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
            n3 = mouseEvent.getX() - this.VALUE_ANTIALIAS_ON.getBounds().x;
            n2 = mouseEvent.getY() - this.VALUE_ANTIALIAS_ON.getBounds().y;
            this.VALUE_ANTIALIAS_ON.hintText = this.VALUE_ANTIALIAS_ON.getHintValue(n3, n2);
            if (this.VALUE_ANTIALIAS_ON.hintText != null) {
                point = mouseEvent.getPoint();
                this.contains = mouseEvent.getPoint();
                stringArray = this.VALUE_ANTIALIAS_ON.hintText;
                this.createChartPlatform = new ChartLabelBase[stringArray.length];
                n = 0;
                while (n < stringArray.length) {
                    this.createChartPlatform[n] = new ChartLabelBase(stringArray[n]);
                    this.createChartPlatform[n].setChartTextStyle(this.VALUE_ANTIALIAS_ON.getProperties().getHintTextStyle());
                    ++n;
                }
            } else {
                this.createChartPlatform = null;
            }
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.KEY_ANTIALIASING == null || !this.error) {
            return;
        }
        this.WORDWRAPPER_GAP = mouseEvent.getPoint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.KEY_ANTIALIASING == null || !this.error) {
            return;
        }
        switch (this._xrot) {
            case 3: {
                this.VALUE_ANTIALIAS_ON(mouseEvent);
                break;
            }
            case 1: {
                this.WORDWRAPPER_GAP(mouseEvent);
                break;
            }
            case 2: {
                this._xrot(mouseEvent);
                break;
            }
        }
        this.VALUE_ANTIALIAS_ON.locate();
        this.WORDWRAPPER_GAP = mouseEvent.getPoint();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.KEY_ANTIALIASING == null || !this.error) {
            return;
        }
        if (mouseEvent.getClickCount() == 2) {
            Object object;
            Object object2;
            int[] nArray = this.VALUE_ANTIALIAS_ON.getDrilldown();
            String string = this.VALUE_ANTIALIAS_ON.getXDim();
            String string2 = this.VALUE_ANTIALIAS_ON.getZDim();
            if (nArray != null) {
                object2 = this.VALUE_ANTIALIAS_ON.getDrilldownGroup();
                object = this.getParent();
                while (!(object instanceof ChartDrillDownImplementor)) {
                    object = ((Component)object).getParent();
                }
                if (object != null) {
                    String string3 = this.getHyperLink(object2[0], object2[1]);
                    if (string3 != null && !string3.equals("")) {
                        ((ChartDrillDownImplementor)object).drilldownInChart(string3, this.QOIV.getSection());
                    } else {
                        DSSection dSSection = this.QOIV.getSection();
                        if (dSSection != null && ((Boolean)this.QOIV.getPropertyByName("GotoDetail").getObject()).booleanValue()) {
                            try {
                                ((ChartDrillDownImplementor)object).drilldownInChart(object2[0], object2[1], dSSection);
                            }
                            catch (JRStopEngineException jRStopEngineException) {
                                JRLog.error(131600, jRStopEngineException);
                            }
                        }
                    }
                }
            }
            if (string != null) {
                object2 = this.getParent();
                while (!(object2 instanceof ChartDrillDownImplementor)) {
                    object2 = ((Component)object2).getParent();
                }
                if (object2 != null && (object = this.getXHyperLink(string)) != null && !((String)object).equals("")) {
                    ((ChartDrillDownImplementor)object2).drilldownInChart((String)object, this.QOIV.getSection());
                }
            }
            if (string2 != null) {
                object2 = this.getParent();
                while (!(object2 instanceof ChartDrillDownImplementor)) {
                    object2 = ((Component)object2).getParent();
                }
                if (object2 != null && (object = this.getZHyperLink(string2)) != null && !((String)object).equals("")) {
                    ((ChartDrillDownImplementor)object2).drilldownInChart((String)object, this.QOIV.getSection());
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void VALUE_ANTIALIAS_ON(MouseEvent mouseEvent) {
        float f = this.KEY_ANTIALIASING.getHeight();
        f = f < (float)this.KEY_ANTIALIASING.getWidth() ? f : (float)this.KEY_ANTIALIASING.getWidth();
        this.booleanValue[0] = this.booleanValue[0] + (float)Math.round((float)((double)((float)(mouseEvent.getX() - this.WORDWRAPPER_GAP.x) * 360.0f / f) / Math.PI));
        this.booleanValue[0] = this.booleanValue[0] < 0.0f ? 360.0f + this.booleanValue[0] : this.booleanValue[0];
        this.booleanValue[0] = this.booleanValue[0] > 360.0f ? this.booleanValue[0] - 360.0f : this.booleanValue[0];
        this.booleanValue[1] = this.booleanValue[1] + (float)Math.round((float)((double)((float)(this.WORDWRAPPER_GAP.y - mouseEvent.getY()) * 180.0f / f) / Math.PI));
        this.booleanValue[1] = this.booleanValue[1] > 90.0f ? 90.0f : this.booleanValue[1];
        this.booleanValue[1] = this.booleanValue[1] < 0.0f ? 0.0f : this.booleanValue[1];
        this.VALUE_ANTIALIAS_ON.properties.setAngleX(this.booleanValue[0]);
        this.VALUE_ANTIALIAS_ON.properties.setAngleY(this.booleanValue[1]);
    }

    private void WORDWRAPPER_GAP(MouseEvent mouseEvent) {
        float[] fArray2;
        fArray2 = new float[]{(float)((double)fArray2[0] + (double)((float)(mouseEvent.getY() - this.WORDWRAPPER_GAP.y) * 360.0f / (float)this.KEY_ANTIALIASING.getWidth()) / Math.PI), (float)((double)fArray2[1] + (double)((float)(this.WORDWRAPPER_GAP.x - mouseEvent.getX()) * 360.0f / (float)this.KEY_ANTIALIASING.getHeight()) / Math.PI)};
        this.drawImage.unit();
        this.drawImage.xrot(fArray2[0]);
        this.drawImage.yrot(fArray2[1]);
        this.m.mul(this.drawImage);
        this.VALUE_ANTIALIAS_ON.properties.setRotationMatrix(this.m.getMatrix());
    }

    private void _xrot(MouseEvent mouseEvent) {
        float[] fArray2;
        fArray2 = new float[]{(float)((double)fArray2[0] + (double)((float)(this.WORDWRAPPER_GAP.x - mouseEvent.getX()) * 360.0f / (float)this.KEY_ANTIALIASING.getHeight()) / Math.PI), (float)((double)fArray2[1] + (double)((float)(mouseEvent.getY() - this.WORDWRAPPER_GAP.y) * 360.0f / (float)this.KEY_ANTIALIASING.getWidth()) / Math.PI)};
        this.drawImage.unit();
        this.drawImage.xrot(fArray2[0]);
        this.drawImage.yrot(fArray2[1]);
        this.m.mul(this.drawImage);
        this.VALUE_ANTIALIAS_ON.properties.setRotationMatrix(this.m.getMatrix());
    }

    public String getHyperLink(String string, String string2) {
        String string3 = this.drilldownInChart;
        string3 = string3 != null && !string3.equals("") ? JReportChartPlatform.parseHyperLink(string3, string, string2) : null;
        return string3;
    }

    public String getXHyperLink(String string) {
        String string2 = this.equals;
        if (string2 != null) {
            string2 = JReportChartPlatform.parseXHyperLink(string2, string);
        }
        return string2;
    }

    public String getZHyperLink(String string) {
        String string2 = this.equalsIgnoreCase;
        if (string2 != null) {
            string2 = JReportChartPlatform.parseZHyperLink(string2, string);
        }
        return string2;
    }

    public static String parseZHyperLink(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = -1;
        n = stringBuffer.toString().indexOf("@ZDIM");
        if (n != -1) {
            stringBuffer.replace(n, n + 5, string2);
        }
        return stringBuffer.toString();
    }

    public static String parseXHyperLink(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = -1;
        n = stringBuffer.toString().indexOf("@XDIM");
        if (n != -1) {
            stringBuffer.replace(n, n + 5, string2);
        }
        return stringBuffer.toString();
    }

    public static String parseHyperLink(String string, String string2, String string3) {
        return ChartHtmlMapExport.parseHyperLink(string, string2, string3);
    }

    public List getCompInfoForDHTML() {
        if (this.KEY_ANTIALIASING == null) {
            return null;
        }
        ChartHtmlMapExport chartHtmlMapExport = new ChartHtmlMapExport(this.KEY_ANTIALIASING);
        return chartHtmlMapExport.getCompInfoForDHTML();
    }
}

