/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import guitools.toolkit.Unit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.datastream.DSBody;
import jet.datastream.DSContainable;
import jet.datastream.DSContainer;
import jet.datastream.DSPage;
import jet.datastream.DSSection;
import jet.datastream.DataStream;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.thinviewer.JReportBody;
import jet.thinviewer.JReportContainer;
import jet.thinviewer.JReportViewer;
import jet.thinviewer.ViewerTools;
import jet.udo.JRObjectRender;
import jet.util.Containable;
import jet.util.PropertySetable;

public class JReportDrillDownViewer
extends JReportViewer {
    DSPage I = null;

    public JReportDrillDownViewer(DataStream dataStream, String string) {
        super(dataStream);
        this.groupby = string;
        this.res = dataStream.getCommunicator().getResolution();
    }

    boolean I(String string) {
        return !this.groupby.equals(string);
    }

    public void setCurPage(DSPage dSPage) {
        this.I = dSPage;
        Insets insets = this.getInsets();
        Rectangle rectangle = dSPage.getPrintableArea();
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = Unit.convertUnitToPixel(rectangle.x, this.res) + insets.left;
        rectangle2.y = Unit.convertUnitToPixel(rectangle.y, this.res) + insets.top;
        rectangle2.width = Unit.convertUnitToPixel(rectangle.width, this.res);
        rectangle2.height = Unit.convertUnitToPixel(rectangle.height, this.res);
        this.viewerClient.setBounds(rectangle2);
    }

    protected void addChild() {
        Cloneable cloneable;
        JReportContainer jReportContainer = null;
        int n = 0;
        int n2 = this.I.size();
        int n3 = 0;
        while (n3 < n2) {
            Containable containable;
            cloneable = this.I.getObject(n3);
            int n4 = cloneable.getObjectType();
            if ((n4 & 0x200) == 512) {
                containable = (DSSection)cloneable;
                Rectangle rectangle = ((JRVisiableResult)((Object)containable)).getBounds();
                jReportContainer = (JReportContainer)JReportDrillDownViewer.I((JRObjectResult)((Object)containable));
                jReportContainer.setProperty((PropertySetable)((Object)containable));
                jReportContainer.setBounds(rectangle.x, n, rectangle.width, rectangle.height);
                jReportContainer.createChildren((DSContainer)containable);
                this.viewerClient.add((Component)jReportContainer, 0);
                if (!((Boolean)((JRVisiableResult)((Object)containable)).getPropertyByName("Underlay").getObject()).booleanValue()) {
                    n += rectangle.height;
                }
            } else if (n4 == 262177) {
                containable = (JReportBody)JReportDrillDownViewer.I(cloneable);
                ((JReportBody)containable).setProperty((PropertySetable)((Object)cloneable));
                ((Component)((Object)containable)).setBounds(((DSBody)cloneable).getBounds());
                ((JReportBody)containable).createChildren((DSBody)cloneable);
                this.viewerClient.add((Component)((Object)containable), 0);
            }
            ++n3;
        }
        this.add(this.viewerClient);
        this.validateTree();
        cloneable = this.viewerClient.getSize();
        if (n > ((Dimension)cloneable).height) {
            Dimension dimension = this.getSize();
            this.setSize(dimension.width, dimension.height + n - ((Dimension)cloneable).height);
            this.viewerClient.setSize(((Dimension)cloneable).width, n);
            if (this.sizeChangedListener != null) {
                this.sizeChangedListener.viewerSizeChanged(this.getSize());
            }
        }
        this.status = 4;
    }

    public void drillDown(String string, DSSection dSSection) throws JRStopEngineException {
        if (this.drillDownImplement != null) {
            int n = -1;
            try {
                n = this.I(dSSection);
            }
            catch (IOException iOException) {
                ViewerTools.I(2401519, iOException);
                this.status = -1;
            }
            DSPage dSPage = null;
            if (n != -1) {
                dSPage = this.dataStream.getCommunicator().getDrillDownPage(dSSection.getDataStream().getSubIndex(), n, dSSection.getRecordIndex(), dSSection.getTemplateIndex(), (Integer)dSSection.getTemplate().getPropertyByName("BranchIdx").getObject(), dSSection);
            }
            if (dSPage != null) {
                this.drillDownImplement.addDrillDownCard(dSPage, string, dSSection.groupValue.toString(), this.dataStream);
            }
        }
    }

    private int I(DSSection dSSection) throws IOException, JRStopEngineException {
        int n = -1;
        int n2 = this.dataStream.getCommunicator().getPageNum();
        int n3 = 1;
        while (n3 <= n2) {
            DSPage dSPage = this.dataStream.getPage(n3);
            if (this.search(dSPage, dSSection)) {
                n = n3;
                break;
            }
            ++n3;
        }
        return n;
    }

    private boolean search(DSContainable dSContainable, DSSection dSSection) {
        if (dSContainable.equals(dSSection)) {
            return true;
        }
        Vector vector = dSContainable.getChildren();
        int n = 0;
        while (n < vector.size()) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(n);
            if (jRObjectResult instanceof DSContainer && this.search((DSContainer)jRObjectResult, dSSection)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static JRObjectRender I(JRObjectResult jRObjectResult) {
        return ViewerTools.I(jRObjectResult, true);
    }
}

