/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.JetObjInspector.ObjectInfo;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUDocNode;
import jet.universe.JetUDocument;
import jet.universe.JetUReportDoc;
import jet.universe.JetUTree;
import jet.universe.JetUTreeNode;
import jet.universe.JetUUniverse;
import jet.universe.exception.DocException;
import jet.util.WildcardMatcher;

public class JetUDocFolder
extends JetUTree
implements JetUDocNode {
    public JetString name = new JetString(this, "Name");
    public JetString desc = new JetString(this, "Description");
    transient ObjectInfo QOIV = null;
    private static JRLogger add;
    private static final HashMap addElement;
    static Class class$jet$universe$JetUDocFolder;
    static final boolean $assertionsDisabled;

    public JetUDocFolder() {
    }

    public JetUDocFolder(String string, String string2) {
        this.setName(string);
        this.setDesc(string2);
    }

    public JetObject add(JetObject jetObject, int n) {
        if (!($assertionsDisabled || jetObject instanceof JetUDocFolder || jetObject instanceof JetUDocument)) {
            throw new AssertionError((Object)"Invalid child of JetUDocFolder! ");
        }
        super.add(jetObject, n);
        return jetObject;
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String string) {
        this.name.set(string);
    }

    public String getDesc() {
        return this.desc.get();
    }

    public void setDesc(String string) {
        this.desc.set(string);
    }

    public JetUUniverse getUniverse() {
        JetUTreeNode jetUTreeNode = (JetUTreeNode)((Object)this.getParent());
        while (jetUTreeNode != null) {
            if (jetUTreeNode instanceof JetUUniverse) {
                return (JetUUniverse)jetUTreeNode;
            }
            jetUTreeNode = (JetUTreeNode)((Object)jetUTreeNode.getParent());
        }
        return null;
    }

    protected String getPath() {
        String string = "";
        JetUTree jetUTree = null;
        jetUTree = (JetUTree)this.getParent();
        if (jetUTree instanceof JetUDocFolder) {
            string = ((JetUDocFolder)jetUTree).getLocator();
        }
        return string;
    }

    public String getLocator() {
        String string = this.getPath();
        if (string.equals("")) {
            return "/";
        }
        if (string.equals("/")) {
            return string + this.getName();
        }
        return string + "/" + this.getName();
    }

    public JetUDocFolder getRootFolder() {
        JetUDocFolder jetUDocFolder = this;
        JetUTree jetUTree = (JetUTree)this.getParent();
        while (jetUTree instanceof JetUDocFolder) {
            jetUDocFolder = (JetUDocFolder)jetUTree;
            jetUTree = (JetUTree)jetUTree.getParent();
        }
        return jetUDocFolder;
    }

    public JetUDocFolder addFolder(String string, String string2) {
        JetUDocFolder jetUDocFolder = new JetUDocFolder(string, string2);
        return this.addFolder(jetUDocFolder);
    }

    public JetUDocFolder addFolder(String string) throws DocException {
        if (!string.startsWith("/")) {
            throw new DocException(1, string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        JetUDocFolder jetUDocFolder = this.getRootFolder();
        String string2 = "";
        Object var5_5 = null;
        JetUDocNode jetUDocNode = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            jetUDocNode = jetUDocFolder.getChildByName(string2);
            if (jetUDocNode != null && jetUDocNode instanceof JetUReportDoc) {
                throw new DocException(1, string);
            }
            jetUDocFolder = jetUDocNode == null ? jetUDocFolder.addFolder(string2, "") : (JetUDocFolder)jetUDocNode;
        }
        return jetUDocFolder;
    }

    protected JetUDocNode getChildByName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetUDocNode jetUDocNode = null;
        int n2 = 0;
        while (n2 < n) {
            jetUDocNode = (JetUDocNode)vector.elementAt(n2);
            if (jetUDocNode.getName().equalsIgnoreCase(string)) {
                return jetUDocNode;
            }
            ++n2;
        }
        return null;
    }

    public JetUDocFolder addFolder(JetUDocFolder jetUDocFolder) {
        this.add(jetUDocFolder);
        return jetUDocFolder;
    }

    public JetUDocFolder getFolderByName(String string) {
        JetUDocNode jetUDocNode = this.getChildByName(string);
        return jetUDocNode != null && jetUDocNode instanceof JetUDocFolder ? (JetUDocFolder)jetUDocNode : null;
    }

    public JetUReportDoc addReport(String string, String string2, String string3, String string4, String string5, String string6, String string7, long l, long l2, long l3) {
        JetUReportDoc jetUReportDoc = new JetUReportDoc(string, string2, string3, string4, string5, string6, string7, l, l2, l3);
        return this.addReport(jetUReportDoc);
    }

    public JetUReportDoc addReport(JetUReportDoc jetUReportDoc) {
        this.add(jetUReportDoc);
        return jetUReportDoc;
    }

    public boolean delete(boolean bl) {
        JetUTree jetUTree = (JetUTree)this.getParent();
        if (jetUTree instanceof JetUDocFolder) {
            ((JetUDocFolder)jetUTree).removeDocNode(this, bl);
            ((JetUDocFolder)jetUTree).remove(this);
            return true;
        }
        return false;
    }

    public JetUDocNode removeDocNode(JetUDocNode jetUDocNode) throws SecurityException {
        return (JetUDocNode)((Object)this.remove((JetObject)((Object)jetUDocNode)));
    }

    public void removeDocNode(JetUDocNode jetUDocNode, boolean bl) {
        if (jetUDocNode instanceof JetUReportDoc) {
            jetUDocNode.delete(bl);
        } else if (jetUDocNode instanceof JetUDocFolder) {
            Vector vector = (Vector)((JetUDocFolder)jetUDocNode).getChildren().clone();
            int n = vector.size();
            JetUDocNode jetUDocNode2 = null;
            int n2 = 0;
            while (n2 < n) {
                jetUDocNode2 = (JetUDocNode)vector.elementAt(n2);
                ((JetUDocFolder)jetUDocNode).removeDocNode(jetUDocNode2, bl);
                ++n2;
            }
        }
    }

    public boolean containsReports() {
        return this.getAllReports().size() > 0;
    }

    public Vector getAllReports() {
        Vector vector = new Vector();
        Vector vector2 = this.getChildren();
        if (vector2 != null) {
            this.getReports(vector2, vector);
        }
        return vector;
    }

    public Vector getAllDocFiles() {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = this.getAllReports();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(((JetUReportDoc)vector2.elementAt(n2)).getFile());
            ++n2;
        }
        return vector;
    }

    public Vector getAllChildren() {
        Vector vector = new Vector();
        Vector vector2 = this.getChildren();
        if (vector2 != null) {
            this.getAllChildren(vector2, vector);
        }
        return vector;
    }

    protected void getAllChildren(Vector vector, Vector vector2) {
        int n = vector.size();
        JetUDocNode jetUDocNode = null;
        int n2 = 0;
        while (n2 < n) {
            jetUDocNode = (JetUDocNode)vector.elementAt(n2);
            vector2.addElement(jetUDocNode);
            if (jetUDocNode instanceof JetUDocFolder) {
                this.getAllChildren(((JetUDocFolder)jetUDocNode).getChildren(), vector2);
            }
            ++n2;
        }
    }

    public JetUDocNode getChildByLocator(String string) {
        if (!$assertionsDisabled && string.equals("")) {
            throw new AssertionError((Object)"The Locator can not be empty");
        }
        JetUDocFolder jetUDocFolder = this.getRootFolder();
        if (string.equals("/")) {
            return jetUDocFolder;
        }
        if (string.startsWith("/")) {
            return jetUDocFolder.getChildByRelativeLocator(string.substring("/".length()));
        }
        return this.getChildByRelativeLocator(string);
    }

    public JetUDocNode getChildByRelativeLocator(String string) {
        int n = string.indexOf("/");
        if (n == -1) {
            return this.getChildByName(string);
        }
        String string2 = string.substring(0, n);
        JetUDocFolder jetUDocFolder = this.getFolderByName(string2);
        if (jetUDocFolder != null) {
            return (JetUDocFolder)jetUDocFolder.getChildByRelativeLocator(string.substring(n + "/".length()));
        }
        return null;
    }

    public void getReports(Vector vector, Vector vector2) {
        int n = vector.size();
        JetUDocNode jetUDocNode = null;
        int n2 = 0;
        while (n2 < n) {
            jetUDocNode = (JetUDocNode)vector.elementAt(n2);
            if (jetUDocNode instanceof JetUReportDoc) {
                vector2.addElement(jetUDocNode);
            } else if (jetUDocNode instanceof JetUDocFolder) {
                this.getReports(((JetUDocFolder)jetUDocNode).getChildren(), vector2);
            }
            ++n2;
        }
    }

    public Vector getItemsByName(String string) {
        Vector<JetUDocNode> vector = new Vector<JetUDocNode>();
        Vector vector2 = this.getAllChildren();
        int n = vector2.size();
        JetUDocNode jetUDocNode = null;
        int n2 = 0;
        while (n2 < n) {
            jetUDocNode = (JetUDocNode)vector2.elementAt(n2);
            if (jetUDocNode.isMatch(string, true)) {
                vector.addElement(jetUDocNode);
            }
            ++n2;
        }
        return vector;
    }

    public JetUReportDoc getReportByName(String string) {
        JetUDocNode jetUDocNode = this.getChildByName(string);
        return jetUDocNode != null && jetUDocNode instanceof JetUReportDoc ? (JetUReportDoc)jetUDocNode : null;
    }

    public Vector search(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        Vector vector = new Vector();
        this.search(vector, string, bl, bl2, bl3, bl4, bl5, bl6);
        return vector;
    }

    public void search(Vector vector, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetUDocNode jetUDocNode = null;
        boolean bl7 = false;
        int n2 = 0;
        while (n2 < n) {
            jetUDocNode = (JetUDocNode)vector2.elementAt(n2);
            bl7 = jetUDocNode instanceof JetUReportDoc && bl4 ? ((JetUReportDoc)jetUDocNode).isMatch(string, bl, bl5, bl6) : (jetUDocNode instanceof JetUDocFolder && bl3 ? jetUDocNode.isMatch(string, bl) : false);
            if (bl7) {
                vector.addElement(jetUDocNode);
            }
            ++n2;
        }
        if (bl2) {
            int n3 = 0;
            while (n3 < n) {
                jetUDocNode = (JetUDocNode)vector2.elementAt(n3);
                if (jetUDocNode instanceof JetUDocFolder) {
                    ((JetUDocFolder)jetUDocNode).search(vector, string, bl, bl2, bl3, bl4, bl5, bl6);
                }
                ++n3;
            }
        }
    }

    public boolean isMatch(String string, boolean bl) {
        return WildcardMatcher.matchWildcard(this.getName(), string, bl);
    }

    protected void createObjectInfo() {
        this.QOIV = new ObjectInfo(this, null);
    }

    public ObjectInfo getObjectInfo() {
        if (this.QOIV == null) {
            this.createObjectInfo();
        }
        return this.QOIV;
    }

    public String toString() {
        return this.getLocator();
    }

    public String getInstancePrefix() {
        return "DocFolder";
    }

    public HashMap getIndecialMap() {
        return addElement;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$JetUDocFolder == null ? (class$jet$universe$JetUDocFolder = JetUDocFolder.class$("jet.universe.JetUDocFolder")) : class$jet$universe$JetUDocFolder).desiredAssertionStatus();
        add = JRLogger.getLogger((class$jet$universe$JetUDocFolder == null ? (class$jet$universe$JetUDocFolder = JetUDocFolder.class$("jet.universe.JetUDocFolder")) : class$jet$universe$JetUDocFolder).getName());
        addElement = new HashMap(2);
        addElement.put("Description", new Integer(0));
        addElement.put("Name", new Integer(1));
    }
}

