/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.util.StringTokenizer;
import java.util.Vector;
import jet.exception.JURLExecuterException;
import jet.util.EngineExecuter;
import jet.util.JURLEngineExecuter;
import jet.util.JURLException;
import jet.util.JURLExecuter;

public class JURL {
    public static final String schemeDelimiter = ":/";
    public static final String strParameterDelimiter = ";";
    public static final char pathPrefix = '/';
    public static final String strPackageDelimiter = ".";
    String QOIV;
    String addElement;
    EngineExecuter append = null;
    String[] arraycopy = new String[0];
    String buildParamsString;

    public JURL(String string) throws JURLException {
        this.parseURL(string);
    }

    public JURL(String string, EngineExecuter engineExecuter) throws JURLException {
        this(string);
        this.append = engineExecuter;
    }

    public void setURL(String string) throws JURLException {
        this.parseURL(string);
    }

    public String getURL() {
        return this.buildURL();
    }

    public void setScheme(String string) {
        this.QOIV = string;
    }

    public String getScheme() {
        return this.QOIV;
    }

    public void setClassName(String string) {
        this.addElement = string;
    }

    public String getClassName() {
        return this.addElement;
    }

    public void setParams(String[] stringArray) {
        this.arraycopy = stringArray;
    }

    public String[] getParams() {
        return this.arraycopy;
    }

    public void setParamsString(String string) {
        this.parseParamsString(string);
    }

    public String getParamsString() {
        return this.buildParamsString();
    }

    public void setClientName(String string) {
        this.buildParamsString = string;
    }

    protected void parseURL(String string) throws JURLException {
        int n = string.indexOf(schemeDelimiter);
        if (n < 0) {
            throw new JURLException("No class name found");
        }
        this.QOIV = string.substring(0, n);
        String string2 = null;
        int n2 = string.indexOf(strParameterDelimiter, n + schemeDelimiter.length());
        if (n2 < 0) {
            this.addElement = string.substring(n + schemeDelimiter.length(), string.length());
        } else {
            this.addElement = string.substring(n + schemeDelimiter.length(), n2);
            string2 = string.substring(n2 + 1, string.length());
        }
        if (this.addElement == null || this.addElement.length() == 0) {
            throw new JURLException("No class name found");
        }
        if (!JURL.isValidClassName(this.addElement)) {
            throw new JURLException(this.addElement);
        }
        if (string2 != null && string2.length() != 0) {
            this.setParamsString(string2);
        }
    }

    public static boolean isValidClassName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, strPackageDelimiter);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (JURL.isIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentifier(String string) {
        int n = string.length();
        char c = string.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            c = string.charAt(n2);
            if (!Character.isJavaIdentifierPart(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected String buildURL() {
        String string = "";
        if (this.QOIV != null && this.QOIV.length() != 0) {
            string = string + this.QOIV;
            if (this.addElement != null && this.addElement.length() != 0) {
                string = string + schemeDelimiter + this.addElement;
                String string2 = this.getParamsString();
                if (string2 != null && string2.length() != 0) {
                    string = string + strParameterDelimiter + string2;
                }
            }
        }
        return string;
    }

    protected void parseParamsString(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, strParameterDelimiter);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
            int n = vector.size();
            this.arraycopy = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.arraycopy[n2] = (String)vector.elementAt(n2);
                ++n2;
            }
        }
    }

    protected String buildParamsString() {
        String string = "";
        int n = this.arraycopy.length;
        int n2 = 0;
        while (n2 < n) {
            string = string + this.arraycopy[n2];
            if (n2 + 1 < n) {
                string = string + strParameterDelimiter;
            }
            ++n2;
        }
        return string;
    }

    public String toString() {
        return this.buildURL();
    }

    public boolean exec() throws ClassNotFoundException, InstantiationException, IllegalAccessException, JURLExecuterException {
        String[] stringArray;
        if (this.buildParamsString != null && this.buildParamsString.length() > 0) {
            int n = this.arraycopy.length;
            stringArray = new String[n + 1];
            System.arraycopy(this.arraycopy, 0, stringArray, 0, n);
            stringArray[n] = this.buildParamsString;
        } else {
            stringArray = this.arraycopy;
        }
        JURLExecuter jURLExecuter = (JURLExecuter)Class.forName(this.addElement).newInstance();
        if (jURLExecuter instanceof JURLEngineExecuter) {
            return ((JURLEngineExecuter)jURLExecuter).exec(stringArray, this.append);
        }
        return jURLExecuter.exec(stringArray);
    }
}

