/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartDataObject;
import chart.chart3d.Chart3DObject;
import chart.chart3d.Chart3DPaper;
import chart.chart3d.Chart3DStrip;
import chart.chart3d.ChartCompass;
import chart.chart3d.ChartMatrix;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import chart.util.ChartHintLabel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;

public class Graph3DAreaA
extends Chart3DObject {
    ChartDataSet add;
    Chart3DPaper appendCover;
    int[] areaSurface;
    boolean[][] availableLength;
    protected Chart3DStrip[][] strip;
    protected Chart3DStrip[][] bottom;
    protected Chart3DStrip[][][][] areas;
    protected ChartFillPattern[] pattern;
    protected ChartCompass compass;
    int availableOriginY;
    int bottomCover;
    boolean contains;
    private ChartPenStyle draw;
    GeneralPath drawArea;
    protected boolean outerAscending;
    protected boolean innerAscending;
    float[] drawAreaSurface;
    Rectangle drawSelectedOutLine = new Rectangle();
    float[][] fill;
    int floatValue = 2;
    float[] getCategorySize;
    int[][][][] getChartPlatform;
    Color[] getCompass;
    float getContourPen;

    Graph3DAreaA(ChartDataSet chartDataSet, Chart3DPaper chart3DPaper) {
        super(chartDataSet, chart3DPaper);
        this.add = chartDataSet;
        this.areaSurface = chart3DPaper.getIntType();
        this.appendCover = chart3DPaper;
        this.availableOriginY = chartDataSet.getCategorySize();
        this.bottomCover = chartDataSet.getSeriesSize();
        this.pattern = chart3DPaper.getChartPlatform().getFillPatternByArarry(0);
        this.getContourPen = chart3DPaper.getProperties().getGraphProperties().getThresholdFillTransparency();
    }

    public void locate() {
    }

    void transform(ChartMatrix chartMatrix) {
        if (this.availableOriginY < 2) {
            return;
        }
        int n = 0;
        while (n < this.bottomCover) {
            if (this.strip[n] != null) {
                int n2 = 0;
                while (n2 < this.strip[n].length) {
                    this.strip[n][n2].transform(chartMatrix);
                    this.bottom[n][n2].transform(chartMatrix);
                    int n3 = 0;
                    while (n3 < this.floatValue) {
                        int n4 = 0;
                        while (n4 < 3) {
                            this.areas[n][n2][n3][n4].transform(chartMatrix);
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        this.QOIV();
    }

    public void init() {
        int n;
        int n2;
        int n3;
        this.drawArea = new GeneralPath();
        this.contains = this.appendCover.getProperties().getGraphProperties().isContour();
        this.draw = this.properties.getGraphProperties().getContourPen();
        if (this.availableOriginY < 2) {
            return;
        }
        this.setCompass(this.appendCover.getCompass());
        this.strip = new Chart3DStrip[this.bottomCover][];
        this.bottom = new Chart3DStrip[this.bottomCover][];
        this.areas = new Chart3DStrip[this.bottomCover][][][];
        this.getChartPlatform = new int[this.bottomCover][][][];
        this.drawAreaSurface = this.appendCover.getUnit();
        float f = 20.0f;
        if (f > this.drawAreaSurface[2]) {
            f = this.drawAreaSurface[2];
        }
        float f2 = 0.0f;
        f2 = this.appendCover.availableOriginY(this.appendCover.getOriginY());
        float f3 = this.drawAreaSurface[0];
        float f4 = 0.0f;
        float f5 = this.drawAreaSurface[2] / 2.0f - f / 2.0f;
        float f6 = this.drawAreaSurface[2];
        this.fill = new float[this.bottomCover][this.availableOriginY];
        this.availableLength = new boolean[this.bottomCover][];
        int[] nArray = new int[this.bottomCover];
        int n4 = 0;
        while (n4 < this.bottomCover) {
            n3 = 0;
            while (n3 < this.availableOriginY - 1) {
                Number number = ((Chart1DDataSet)this.add).getValue(n4, n3);
                Number number2 = ((Chart1DDataSet)this.add).getValue(n4, n3 + 1);
                float f7 = number == null ? 0.0f : number.floatValue();
                float f8 = number2 == null ? 0.0f : number2.floatValue();
                if (f7 > 0.0f && f8 < 0.0f || f7 < 0.0f && f8 > 0.0f) {
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + 1;
                }
                this.fill[n4][n3] = f7;
                if (n3 == this.availableOriginY - 2) {
                    this.fill[n4][n3 + 1] = f8;
                }
                ++n3;
            }
            ++n4;
        }
        if (this.appendCover.getProperties().getGraphProperties().isShowThresholdLine() && this.appendCover.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.floatValue = 2;
            this.getCategorySize = new float[this.floatValue];
            this.getCompass = new Color[this.floatValue];
            this.getCategorySize[0] = (float)this.appendCover.getProperties().getGraphProperties().getThresholdValue();
            this.getCategorySize[1] = (float)this.appendCover.getProperties().getGraphProperties().getThresholdValue2();
            this.getCompass[0] = this.appendCover.getProperties().getGraphProperties().getThresholdLineColor();
            this.getCompass[1] = this.appendCover.getProperties().getGraphProperties().getThresholdLineColor2();
        } else if (this.appendCover.getProperties().getGraphProperties().isShowThresholdLine()) {
            this.floatValue = 1;
            this.getCategorySize = new float[this.floatValue];
            this.getCompass = new Color[this.floatValue];
            this.getCategorySize[0] = (float)this.appendCover.getProperties().getGraphProperties().getThresholdValue();
            this.getCompass[0] = this.appendCover.getProperties().getGraphProperties().getThresholdLineColor();
        } else if (this.appendCover.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.floatValue = 1;
            this.getCategorySize = new float[this.floatValue];
            this.getCompass = new Color[this.floatValue];
            this.getCategorySize[0] = (float)this.appendCover.getProperties().getGraphProperties().getThresholdValue2();
            this.getCompass[0] = this.appendCover.getProperties().getGraphProperties().getThresholdLineColor2();
        } else {
            this.floatValue = 0;
            this.getCategorySize = new float[this.floatValue];
            this.getCompass = new Color[this.floatValue];
        }
        n3 = 0;
        while (n3 < this.floatValue) {
            float f9 = 0.0f;
            n2 = n3;
            while (n2 < this.floatValue) {
                if (this.getCategorySize[n3] > this.getCategorySize[n2]) {
                    f9 = this.getCategorySize[n2];
                    this.getCategorySize[n2] = this.getCategorySize[n3];
                    this.getCategorySize[n3] = f9;
                    Color color = this.getCompass[n2];
                    this.getCompass[n2] = this.getCompass[n3];
                    this.getCompass[n3] = color;
                }
                ++n2;
            }
            ++n3;
        }
        float[] fArray = new float[this.floatValue];
        int n6 = 0;
        while (n6 < this.floatValue) {
            fArray[n6] = this.appendCover.availableLength(this.getCategorySize[n6] * this.drawAreaSurface[1]);
            if (fArray[n6] < 2.0f && fArray[n6] != 0.0f) {
                fArray[n6] = fArray[n6] + 3.0f;
            }
            ++n6;
        }
        n2 = 0;
        while (n2 < this.bottomCover) {
            n = this.availableOriginY - 1 + nArray[n2];
            this.strip[n2] = new Chart3DStrip[n];
            this.bottom[n2] = new Chart3DStrip[n];
            this.availableLength[n2] = new boolean[n + 1];
            this.areas[n2] = new Chart3DStrip[n][this.floatValue][3];
            this.getChartPlatform[n2] = new int[n][this.floatValue][4];
            ++n2;
        }
        float f10 = f4;
        float f11 = f5;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        int n7 = 0;
        while (n7 < this.bottomCover) {
            float f17 = f11;
            n = 0;
            int n8 = 0;
            while (n8 < this.availableOriginY - 1) {
                int n9;
                int n10;
                int n11;
                f12 = f10 + f3;
                f16 = this.fill[n7][n8];
                f14 = this.fill[n7][n8 + 1];
                f15 = f16 * this.drawAreaSurface[1];
                f13 = f14 * this.drawAreaSurface[1];
                f15 = this.appendCover.availableLength(f15);
                f13 = this.appendCover.availableLength(f13);
                if (this.fill[n7][n8] > 0.0f && this.fill[n7][n8 + 1] < 0.0f || this.fill[n7][n8] < 0.0f && this.fill[n7][n8 + 1] > 0.0f) {
                    float f18 = f13 == f15 ? f12 : (f10 * f13 + (f12 - f10) * f2 - f12 * f15) / (f13 - f15);
                    this.strip[n7][n8 + n] = new Chart3DStrip(this.pattern[n7], this.contains, this.draw);
                    this.strip[n7][n8 + n].setAreaSurfaceVertex(f10, f15, f11, f18, f2, f11, f);
                    this.strip[n7][n8 + n + 1] = new Chart3DStrip(this.pattern[n7], this.contains, this.draw);
                    this.strip[n7][n8 + n + 1].setAreaSurfaceVertex(f18, f2, f11, f12, f13, f11, f);
                    this.bottom[n7][n8 + n] = new Chart3DStrip(this.pattern[n7], this.contains, this.draw);
                    this.bottom[n7][n8 + n].setAreaSurfaceVertex(f10, f2, f11, f18, f2, f17, f);
                    this.bottom[n7][n8 + n + 1] = new Chart3DStrip(this.pattern[n7], this.contains, this.draw);
                    this.bottom[n7][n8 + n + 1].setAreaSurfaceVertex(f18, f2, f11, f12, f2, f17, f);
                    if (this.fill[n7][n8] > 0.0f) {
                        this.availableLength[n7][n8 + n + 1] = true;
                    } else {
                        this.availableLength[n7][n8 + n] = true;
                    }
                    n11 = 0;
                    while (n11 < 2) {
                        n10 = 0;
                        while (n10 < this.floatValue) {
                            this.getChartPlatform[n7][n8 + n + n11][n10][0] = 0;
                            this.getChartPlatform[n7][n8 + n + n11][n10][1] = 0;
                            this.getChartPlatform[n7][n8 + n + n11][n10][2] = 0;
                            this.getChartPlatform[n7][n8 + n + n11][n10][3] = 0;
                            this.areas[n7][n8 + n + n11][n10][0] = new Chart3DStrip(this.pattern[0], this.contains, this.draw);
                            this.areas[n7][n8 + n + n11][n10][1] = new Chart3DStrip(this.pattern[0], this.contains, this.draw);
                            this.areas[n7][n8 + n + n11][n10][2] = new Chart3DStrip(this.pattern[0], this.contains, this.draw);
                            this.areas[n7][n8 + n + n11][n10][0].setThresholdColor(this.getCompass[n10], this.getContourPen);
                            this.areas[n7][n8 + n + n11][n10][1].setThresholdColor(this.getCompass[n10], this.getContourPen);
                            this.areas[n7][n8 + n + n11][n10][2].setThresholdColor(this.getCompass[n10], this.getContourPen);
                            ++n10;
                        }
                        ++n11;
                    }
                    n10 = 0;
                    while (n10 < this.floatValue) {
                        if (fArray[n10] < f15 && fArray[n10] > f13) {
                            if (fArray[n10] > f2) {
                                this.areas[n7][n8 + n][n10][2].setLineVertex1(this.drawAreaSurface[0] * (float)n8 + (fArray[n10] - f15) / (f2 - f15) * (f18 - f10), fArray[n10], (float)n7 * this.drawAreaSurface[2] + this.drawAreaSurface[2] / 2.0f - f / 2.0f, 0.0f, f, f18 - f10 - (fArray[n10] - f15) / (f2 - f15) * (f18 - f10));
                                int[] nArray2 = this.getChartPlatform[n7][n8 + n][n10];
                                nArray2[1] = nArray2[1] + 1;
                            } else {
                                this.areas[n7][n8 + n + 1][n10][2].setLineVertex1(f18, fArray[n10], (float)n7 * this.drawAreaSurface[2] + this.drawAreaSurface[2] / 2.0f - f / 2.0f, 0.0f, f, f12 - f18 - (fArray[n10] - f13) / (f2 - f13) * (f12 - f18));
                                int[] nArray3 = this.getChartPlatform[n7][n8 + n + 1][n10];
                                nArray3[3] = nArray3[3] + 1;
                            }
                        } else if (fArray[n10] > f15 && fArray[n10] < f13) {
                            if (fArray[n10] > f2) {
                                this.areas[n7][n8 + n + 1][n10][2].setLineVertex1(f18, fArray[n10], (float)n7 * this.drawAreaSurface[2] + this.drawAreaSurface[2] / 2.0f - f / 2.0f, 0.0f, f, f12 - f18 - (fArray[n10] - f13) / (f2 - f13) * (f12 - f18));
                                int[] nArray4 = this.getChartPlatform[n7][n8 + n + 1][n10];
                                nArray4[1] = nArray4[1] + 1;
                            } else {
                                this.areas[n7][n8 + n][n10][2].setLineVertex1(this.drawAreaSurface[0] * (float)n8 + (fArray[n10] - f15) / (f2 - f15) * (f18 - f10), fArray[n10], (float)n7 * this.drawAreaSurface[2] + this.drawAreaSurface[2] / 2.0f - f / 2.0f, 0.0f, f, f18 - f10 - (fArray[n10] - f15) / (f2 - f15) * (f18 - f10));
                                int[] nArray5 = this.getChartPlatform[n7][n8 + n][n10];
                                nArray5[3] = nArray5[3] + 1;
                            }
                        }
                        ++n10;
                    }
                    n9 = 0;
                    while (n9 < this.floatValue) {
                        if (fArray[n9] > f2) {
                            if (fArray[n9] > f15) {
                                this.areas[n7][n8 + n][n9][2].setLineVertex1(this.drawAreaSurface[0] * (float)n8, fArray[n9], (float)n7 * this.drawAreaSurface[2] + this.drawAreaSurface[2] / 2.0f - f / 2.0f, 0.0f, f, f18 - f10);
                                int[] nArray6 = this.getChartPlatform[n7][n8 + n][n9];
                                nArray6[0] = nArray6[0] + 1;
                            }
                            if (fArray[n9] > f13) {
                                this.areas[n7][n8 + n + 1][n9][2].setLineVertex1(f18, fArray[n9], (float)n7 * this.drawAreaSurface[2] + this.drawAreaSurface[2] / 2.0f - f / 2.0f, 0.0f, f, f12 - f18);
                                int[] nArray7 = this.getChartPlatform[n7][n8 + n + 1][n9];
                                nArray7[0] = nArray7[0] + 1;
                            }
                        } else if (fArray[n9] < f2) {
                            if (fArray[n9] < f15) {
                                this.areas[n7][n8 + n][n9][2].setLineVertex1(this.drawAreaSurface[0] * (float)n8, fArray[n9], (float)n7 * this.drawAreaSurface[2] + this.drawAreaSurface[2] / 2.0f - f / 2.0f, 0.0f, f, f18 - f10);
                                int[] nArray8 = this.getChartPlatform[n7][n8 + n][n9];
                                nArray8[2] = nArray8[2] + 1;
                            }
                            if (fArray[n9] < f13) {
                                this.areas[n7][n8 + n + 1][n9][2].setLineVertex1(f18, fArray[n9], (float)n7 * this.drawAreaSurface[2] + this.drawAreaSurface[2] / 2.0f - f / 2.0f, 0.0f, f, f12 - f18);
                                int[] nArray9 = this.getChartPlatform[n7][n8 + n + 1][n9];
                                nArray9[2] = nArray9[2] + 1;
                            }
                        }
                        ++n9;
                    }
                    ++n;
                } else {
                    this.strip[n7][n8 + n] = new Chart3DStrip(this.pattern[n7], this.contains, this.draw);
                    this.strip[n7][n8 + n].setAreaSurfaceVertex(f10, f15, f11, f12, f13, f17, f);
                    this.bottom[n7][n8 + n] = new Chart3DStrip(this.pattern[n7], this.contains, this.draw);
                    this.bottom[n7][n8 + n].setAreaSurfaceVertex(f10, f2, f11, f12, f2, f17, f);
                    if (this.fill[n7][n8] < 0.0f) {
                        this.availableLength[n7][n8 + n] = true;
                    }
                    if (this.fill[n7][n8 + 1] < 0.0f) {
                        this.availableLength[n7][n8 + n + 1] = true;
                    }
                    n11 = 0;
                    while (n11 < this.floatValue) {
                        this.getChartPlatform[n7][n8 + n][n11][0] = 0;
                        this.getChartPlatform[n7][n8 + n][n11][1] = 0;
                        this.getChartPlatform[n7][n8 + n][n11][2] = 0;
                        this.getChartPlatform[n7][n8 + n][n11][3] = 0;
                        this.areas[n7][n8 + n][n11][0] = new Chart3DStrip(this.pattern[0], this.contains, this.draw);
                        this.areas[n7][n8 + n][n11][1] = new Chart3DStrip(this.pattern[0], this.contains, this.draw);
                        this.areas[n7][n8 + n][n11][2] = new Chart3DStrip(this.pattern[0], this.contains, this.draw);
                        this.areas[n7][n8 + n][n11][0].setThresholdColor(this.getCompass[n11], this.getContourPen);
                        this.areas[n7][n8 + n][n11][1].setThresholdColor(this.getCompass[n11], this.getContourPen);
                        this.areas[n7][n8 + n][n11][2].setThresholdColor(this.getCompass[n11], this.getContourPen);
                        ++n11;
                    }
                    n10 = 0;
                    while (n10 < this.floatValue) {
                        if (fArray[n10] < f15 && fArray[n10] > f13) {
                            if (fArray[n10] > f2) {
                                this.areas[n7][n8][n10][2].setLineVertex1(this.drawAreaSurface[0] * (float)n8 + (fArray[n10] - f15) / (f13 - f15) * this.drawAreaSurface[0], fArray[n10], (float)n7 * this.drawAreaSurface[2] + this.drawAreaSurface[2] / 2.0f - f / 2.0f, 0.0f, f, this.drawAreaSurface[0] - (fArray[n10] - f15) / (f13 - f15) * this.drawAreaSurface[0]);
                                int[] nArray10 = this.getChartPlatform[n7][n8][n10];
                                nArray10[1] = nArray10[1] + 1;
                            } else {
                                this.areas[n7][n8][n10][2].setLineVertex1(this.drawAreaSurface[0] * (float)n8, fArray[n10], (float)n7 * this.drawAreaSurface[2] + this.drawAreaSurface[2] / 2.0f - f / 2.0f, 0.0f, f, (fArray[n10] - f15) / (f13 - f15) * this.drawAreaSurface[0]);
                                int[] nArray11 = this.getChartPlatform[n7][n8][n10];
                                nArray11[3] = nArray11[3] + 1;
                            }
                        } else if (fArray[n10] > f15 && fArray[n10] < f13) {
                            if (fArray[n10] > f2) {
                                this.areas[n7][n8][n10][2].setLineVertex1(this.drawAreaSurface[0] * (float)n8, fArray[n10], (float)n7 * this.drawAreaSurface[2] + this.drawAreaSurface[2] / 2.0f - f / 2.0f, 0.0f, f, (fArray[n10] - f15) / (f13 - f15) * this.drawAreaSurface[0]);
                                int[] nArray12 = this.getChartPlatform[n7][n8][n10];
                                nArray12[1] = nArray12[1] + 1;
                            } else {
                                this.areas[n7][n8][n10][2].setLineVertex1(this.drawAreaSurface[0] * (float)n8 + (fArray[n10] - f15) / (f13 - f15) * this.drawAreaSurface[0], fArray[n10], (float)n7 * this.drawAreaSurface[2] + this.drawAreaSurface[2] / 2.0f - f / 2.0f, 0.0f, f, this.drawAreaSurface[0] - (fArray[n10] - f15) / (f13 - f15) * this.drawAreaSurface[0]);
                                int[] nArray13 = this.getChartPlatform[n7][n8][n10];
                                nArray13[3] = nArray13[3] + 1;
                            }
                        }
                        ++n10;
                    }
                    n9 = 0;
                    while (n9 < this.floatValue) {
                        if (fArray[n9] > f15 && fArray[n9] > f13 && fArray[n9] > f2) {
                            this.areas[n7][n8][n9][2].setLineVertex1(this.drawAreaSurface[0] * (float)n8, fArray[n9], (float)n7 * this.drawAreaSurface[2] + this.drawAreaSurface[2] / 2.0f - f / 2.0f, 0.0f, f, this.drawAreaSurface[0]);
                            int[] nArray14 = this.getChartPlatform[n7][n8][n9];
                            nArray14[0] = nArray14[0] + 1;
                        } else if (fArray[n9] < f15 && fArray[n9] < f13 && fArray[n9] < f2) {
                            this.areas[n7][n8][n9][2].setLineVertex1(this.drawAreaSurface[0] * (float)n8, fArray[n9], (float)n7 * this.drawAreaSurface[2] + this.drawAreaSurface[2] / 2.0f - f / 2.0f, 0.0f, f, this.drawAreaSurface[0]);
                            int[] nArray15 = this.getChartPlatform[n7][n8][n9];
                            nArray15[2] = nArray15[2] + 1;
                        }
                        ++n9;
                    }
                }
                f10 = f12;
                n11 = 0;
                while (n11 < this.floatValue) {
                    this.areas[n7][n8][n11][0].setLineVertex1(this.drawAreaSurface[0] * (float)n8, fArray[n11], this.drawAreaSurface[2] * (float)n7, 0.0f, this.drawAreaSurface[2] / 2.0f - f / 2.0f, this.drawAreaSurface[0]);
                    this.areas[n7][n8][n11][1].setLineVertex1(this.drawAreaSurface[0] * (float)n8, fArray[n11], this.drawAreaSurface[2] * (float)n7 + this.drawAreaSurface[2] / 2.0f + f / 2.0f, 0.0f, this.drawAreaSurface[2] / 2.0f - f / 2.0f, this.drawAreaSurface[0]);
                    ++n11;
                }
                ++n8;
            }
            f10 = f4;
            f11 += f6;
            ++n7;
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.availableOriginY < 2) {
            return;
        }
        int n = 0;
        while (n < this.bottomCover) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = n;
            if (!this.outerAscending) {
                n6 = this.bottomCover - n - 1;
            }
            int n7 = 0;
            while (n7 < this.availableOriginY - 1) {
                n5 = n7;
                if (!this.innerAscending) {
                    n5 = this.availableOriginY - 1 - n7 - 1;
                }
                n4 = 0;
                while (n4 < this.floatValue) {
                    if (!this.outerAscending) {
                        this.areas[n6][n5][n4][1].drawArea(graphics2D, 0);
                    } else {
                        this.areas[n6][n5][n4][0].drawArea(graphics2D, 0);
                    }
                    ++n4;
                }
                ++n7;
            }
            n5 = 0;
            while (n5 < this.strip[n6].length) {
                int n8;
                int n9;
                n4 = n5;
                if (!this.innerAscending) {
                    n4 = this.strip[n6].length - n5 - 1;
                }
                if ((this.appendCover.getShownFace() >> 3 & 1) == 1) {
                    if (this.availableLength[n6][n4]) {
                        n3 = 0;
                        while (n3 < this.floatValue) {
                            n2 = 0;
                            while (n2 < this.getChartPlatform[n6][n4][n3][2]) {
                                this.areas[n6][n4][n3][2].drawArea(graphics2D, n2 + this.getChartPlatform[n6][n4][n3][0] + this.getChartPlatform[n6][n4][n3][1] + this.getChartPlatform[n6][n4][n3][3]);
                                ++n2;
                            }
                            n9 = 0;
                            while (n9 < this.getChartPlatform[n6][n4][n3][3]) {
                                this.areas[n6][n4][n3][2].drawArea(graphics2D, n9);
                                ++n9;
                            }
                            ++n3;
                        }
                        this.strip[n6][n4].drawAreaSurface(graphics2D, this.contains);
                        this.bottom[n6][n4].drawAreaSurface(graphics2D, this.contains);
                        n2 = 0;
                        while (n2 < this.floatValue) {
                            n9 = 0;
                            while (n9 < this.getChartPlatform[n6][n4][n2][1]) {
                                this.areas[n6][n4][n2][2].drawArea(graphics2D, n9 + this.getChartPlatform[n6][n4][n2][3]);
                                ++n9;
                            }
                            n8 = 0;
                            while (n8 < this.getChartPlatform[n6][n4][n2][0]) {
                                this.areas[n6][n4][n2][2].drawArea(graphics2D, n8 + this.getChartPlatform[n6][n4][n2][1] + this.getChartPlatform[n6][n4][n2][3]);
                                ++n8;
                            }
                            ++n2;
                        }
                    } else {
                        n3 = 0;
                        while (n3 < this.floatValue) {
                            n2 = 0;
                            while (n2 < this.getChartPlatform[n6][n4][n3][2]) {
                                this.areas[n6][n4][n3][2].drawArea(graphics2D, n2 + this.getChartPlatform[n6][n4][n3][0] + this.getChartPlatform[n6][n4][n3][1] + this.getChartPlatform[n6][n4][n3][3]);
                                ++n2;
                            }
                            n9 = 0;
                            while (n9 < this.getChartPlatform[n6][n4][n3][3]) {
                                this.areas[n6][n4][n3][2].drawArea(graphics2D, n9);
                                ++n9;
                            }
                            ++n3;
                        }
                        this.bottom[n6][n4].drawAreaSurface(graphics2D, this.contains);
                        this.strip[n6][n4].drawAreaSurface(graphics2D, this.contains);
                        n2 = 0;
                        while (n2 < this.floatValue) {
                            n9 = 0;
                            while (n9 < this.getChartPlatform[n6][n4][n2][1]) {
                                this.areas[n6][n4][n2][2].drawArea(graphics2D, n9 + this.getChartPlatform[n6][n4][n2][3]);
                                ++n9;
                            }
                            n8 = 0;
                            while (n8 < this.getChartPlatform[n6][n4][n2][0]) {
                                this.areas[n6][n4][n2][2].drawArea(graphics2D, n8 + this.getChartPlatform[n6][n4][n2][1] + this.getChartPlatform[n6][n4][n2][3]);
                                ++n8;
                            }
                            ++n2;
                        }
                    }
                } else if (this.availableLength[n6][n4]) {
                    n3 = 0;
                    while (n3 < this.floatValue) {
                        n2 = 0;
                        while (n2 < this.getChartPlatform[n6][n4][n3][0]) {
                            this.areas[n6][n4][n3][2].drawArea(graphics2D, n2 + this.getChartPlatform[n6][n4][n3][1] + this.getChartPlatform[n6][n4][n3][3]);
                            ++n2;
                        }
                        n9 = 0;
                        while (n9 < this.getChartPlatform[n6][n4][n3][1]) {
                            this.areas[n6][n4][n3][2].drawArea(graphics2D, n9 + this.getChartPlatform[n6][n4][n3][3]);
                            ++n9;
                        }
                        ++n3;
                    }
                    this.bottom[n6][n4].drawAreaSurface(graphics2D, this.contains);
                    this.strip[n6][n4].drawAreaSurface(graphics2D, this.contains);
                    n2 = 0;
                    while (n2 < this.floatValue) {
                        n9 = 0;
                        while (n9 < this.getChartPlatform[n6][n4][n2][3]) {
                            this.areas[n6][n4][n2][2].drawArea(graphics2D, n9);
                            ++n9;
                        }
                        n8 = 0;
                        while (n8 < this.getChartPlatform[n6][n4][n2][2]) {
                            this.areas[n6][n4][n2][2].drawArea(graphics2D, n8 + this.getChartPlatform[n6][n4][n2][1] + this.getChartPlatform[n6][n4][n2][0] + this.getChartPlatform[n6][n4][n2][3]);
                            ++n8;
                        }
                        ++n2;
                    }
                } else {
                    n3 = 0;
                    while (n3 < this.floatValue) {
                        n2 = 0;
                        while (n2 < this.getChartPlatform[n6][n4][n3][0]) {
                            this.areas[n6][n4][n3][2].drawArea(graphics2D, n2 + this.getChartPlatform[n6][n4][n3][1] + this.getChartPlatform[n6][n4][n3][3]);
                            ++n2;
                        }
                        n9 = 0;
                        while (n9 < this.getChartPlatform[n6][n4][n3][1]) {
                            this.areas[n6][n4][n3][2].drawArea(graphics2D, n9 + this.getChartPlatform[n6][n4][n3][3]);
                            ++n9;
                        }
                        ++n3;
                    }
                    this.strip[n6][n4].drawAreaSurface(graphics2D, this.contains);
                    this.bottom[n6][n4].drawAreaSurface(graphics2D, this.contains);
                    n2 = 0;
                    while (n2 < this.floatValue) {
                        n9 = 0;
                        while (n9 < this.getChartPlatform[n6][n4][n2][3]) {
                            this.areas[n6][n4][n2][2].drawArea(graphics2D, n9);
                            ++n9;
                        }
                        n8 = 0;
                        while (n8 < this.getChartPlatform[n6][n4][n2][2]) {
                            this.areas[n6][n4][n2][2].drawArea(graphics2D, n8 + this.getChartPlatform[n6][n4][n2][3] + this.getChartPlatform[n6][n4][n2][0] + this.getChartPlatform[n6][n4][n2][1]);
                            ++n8;
                        }
                        ++n2;
                    }
                }
                ++n5;
            }
            this.paintInnerFace(graphics2D, n6);
            this.paintOuterFace(graphics2D, n6);
            n4 = 0;
            while (n4 < this.availableOriginY - 1) {
                n3 = n4;
                if (!this.innerAscending) {
                    n3 = this.availableOriginY - 1 - n4 - 1;
                }
                n2 = 0;
                while (n2 < this.floatValue) {
                    if (!this.outerAscending) {
                        this.areas[n6][n3][n2][0].drawArea(graphics2D, 0);
                    } else {
                        this.areas[n6][n3][n2][1].drawArea(graphics2D, 0);
                    }
                    ++n2;
                }
                ++n4;
            }
            ++n;
        }
        this.areaSurface(graphics2D);
    }

    public Shape getShapeBySeries(int n) {
        return null;
    }

    public Shape getShapeByItem(int n, int n2) {
        return this.strip[n][n2].toHtml();
    }

    public String[] search(int n, int n2) {
        this.drilldown = null;
        String[] stringArray = null;
        if (this.availableOriginY < 2) {
            this.selectedSeriesIndex = -1;
            return null;
        }
        Area area = new Area();
        int n3 = 0;
        while (n3 < this.bottomCover) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.availableOriginY) {
                if (n5 != this.availableOriginY - 1) {
                    this.drawSelectedOutLine = new Rectangle((int)this.strip[n3][n5 + n4].tVertex[0][0] - 5, (int)this.strip[n3][n5 + n4].tVertex[0][1] - 5, 10, 10);
                    if (this.fill[n3][n5] > 0.0f && this.fill[n3][n5 + 1] < 0.0f || this.fill[n3][n5] < 0.0f && this.fill[n3][n5 + 1] > 0.0f) {
                        ++n4;
                    }
                } else {
                    this.drawSelectedOutLine = new Rectangle((int)this.strip[n3][n5 + n4 - 1].tVertex[1][0] - 5, (int)this.strip[n3][n5 + n4 - 1].tVertex[1][1] - 5, 10, 10);
                }
                if (this.drawSelectedOutLine.contains(n, n2)) {
                    if (area.contains(this.drawSelectedOutLine)) {
                        this.selectedSeriesIndex = -1;
                        return null;
                    }
                    if (this.appendCover.getProperties().isShowCategoryAndSeries()) {
                        stringArray = new String[3];
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.add, this.appendCover, 3);
                        stringArray = chartHintLabel.hintLabelShowCategoryAndSeries(n3, n5);
                    } else {
                        stringArray = new String[]{this.add.getFormatedHintValue(((Chart1DDataSet)this.add).getValue(n3, n5))};
                    }
                    this.selectedSeriesIndex = n3;
                    this.drilldown = new int[2];
                    this.drilldown[0] = n3;
                    this.drilldown[1] = n5;
                    return stringArray;
                }
                ++n5;
            }
            this.appendCover(area, n3);
            ++n3;
        }
        this.selectedSeriesIndex = -1;
        return null;
    }

    protected void appendCover(Area area, int n) {
        area.add(this.outerFaceCover(n));
        area.add(this.innerFaceCover(n));
        area.add(this.bottomCover(n));
    }

    protected void paintInnerFace(Graphics2D graphics2D, int n) {
        int n2 = this.strip[n].length - 1;
        this.drawArea.reset();
        if (!this.innerAscending) {
            this.drawArea.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            this.drawArea.lineTo(this.strip[n][0].tVertex[0][0], this.strip[n][0].tVertex[0][1]);
            this.drawArea.lineTo(this.strip[n][0].tVertex[3][0], this.strip[n][0].tVertex[3][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
        } else {
            this.drawArea.moveTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
        }
        if (this.pattern[n] != null) {
            this.pattern[n].fill(graphics2D, this.drawArea);
        }
        if (this.contains) {
            this.draw.draw(graphics2D, this.drawArea);
        }
    }

    protected void paintOuterFace(Graphics2D graphics2D, int n) {
        int n2 = this.strip[n].length - 1;
        this.drawArea.reset();
        if (!this.outerAscending) {
            this.drawArea.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            int n3 = 0;
            while (n3 <= n2) {
                this.drawArea.lineTo(this.strip[n][n3].tVertex[0][0], this.strip[n][n3].tVertex[0][1]);
                ++n3;
            }
            this.drawArea.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
        } else {
            this.drawArea.moveTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            int n4 = 0;
            while (n4 <= n2) {
                this.drawArea.lineTo(this.strip[n][n4].tVertex[3][0], this.strip[n][n4].tVertex[3][1]);
                ++n4;
            }
            this.drawArea.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
        }
        if (this.pattern[n] != null) {
            this.pattern[n].fill(graphics2D, this.drawArea);
        }
        if (this.contains) {
            this.draw.draw(graphics2D, this.drawArea);
        }
    }

    private void QOIV() {
        this.appendCover();
        this.add();
    }

    private void add() {
        this.outerAscending = (this.appendCover.getShownFace() >> 5 & 1) == 1;
    }

    private void appendCover() {
        this.innerAscending = (this.appendCover.getShownFace() & 1) != 1;
    }

    public void setCompass(ChartCompass chartCompass) {
        this.compass = chartCompass;
    }

    protected Area innerFaceCover(int n) {
        int n2 = this.strip[n].length - 1;
        this.drawArea.reset();
        if (!this.innerAscending) {
            this.drawArea.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            this.drawArea.lineTo(this.strip[n][0].tVertex[0][0], this.strip[n][0].tVertex[0][1]);
            this.drawArea.lineTo(this.strip[n][0].tVertex[3][0], this.strip[n][0].tVertex[3][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
        } else {
            this.drawArea.moveTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
        }
        return new Area(this.drawArea);
    }

    protected Area outerFaceCover(int n) {
        int n2 = this.strip[n].length - 1;
        this.drawArea.reset();
        if (!this.outerAscending) {
            this.drawArea.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            int n3 = 0;
            while (n3 <= n2) {
                this.drawArea.lineTo(this.strip[n][n3].tVertex[0][0], this.strip[n][n3].tVertex[0][1]);
                ++n3;
            }
            this.drawArea.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
        } else {
            this.drawArea.moveTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            int n4 = 0;
            while (n4 <= n2) {
                this.drawArea.lineTo(this.strip[n][n4].tVertex[3][0], this.strip[n][n4].tVertex[3][1]);
                ++n4;
            }
            this.drawArea.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.drawArea.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
        }
        return new Area(this.drawArea);
    }

    protected Area bottomCover(int n) {
        Area area = new Area();
        int n2 = 0;
        while (n2 < this.strip[n].length) {
            int n3 = n2;
            if (!this.innerAscending) {
                n3 = this.strip[n].length - n2 - 1;
            }
            if ((this.appendCover.getShownFace() >> 3 & 1) == 1) {
                if (this.availableLength[n][n3]) {
                    area.add(this.strip[n][n3].areaSurface());
                    area.add(this.bottom[n][n3].areaSurface());
                } else {
                    area.add(this.bottom[n][n3].areaSurface());
                    area.add(this.strip[n][n3].areaSurface());
                }
            } else if (this.availableLength[n][n3]) {
                area.add(this.bottom[n][n3].areaSurface());
                area.add(this.strip[n][n3].areaSurface());
            } else {
                area.add(this.strip[n][n3].areaSurface());
                area.add(this.bottom[n][n3].areaSurface());
            }
            ++n2;
        }
        return area;
    }

    public Shape[][] getItemShapes(int n) {
        if (this.availableOriginY < 2) {
            return null;
        }
        Area area = new Area();
        Shape[][] shapeArray = new Shape[this.bottomCover][this.availableOriginY];
        int n2 = 0;
        while (n2 < this.bottomCover) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.availableOriginY) {
                Rectangle rectangle;
                if (n4 != this.availableOriginY - 1) {
                    rectangle = new Rectangle((int)this.strip[n2][n4 + n3].tVertex[0][0] - 5, (int)this.strip[n2][n4 + n3].tVertex[0][1] - 5, 10, 10);
                    if (this.fill[n2][n4] > 0.0f && this.fill[n2][n4 + 1] < 0.0f || this.fill[n2][n4] < 0.0f && this.fill[n2][n4 + 1] > 0.0f) {
                        ++n3;
                    }
                } else {
                    rectangle = new Rectangle((int)this.strip[n2][n4 + n3 - 1].tVertex[1][0] - 5, (int)this.strip[n2][n4 + n3 - 1].tVertex[1][1] - 5, 10, 10);
                }
                if (area.contains(rectangle)) {
                    shapeArray[n2][n4] = null;
                } else {
                    shapeArray[n2][n4] = new GeneralPath();
                    int n5 = (int)rectangle.getX();
                    int n6 = (int)rectangle.getY();
                    int n7 = n5 + 10;
                    int n8 = n6 + 10;
                    ((GeneralPath)shapeArray[n2][n4]).moveTo(n5, n8);
                    ((GeneralPath)shapeArray[n2][n4]).lineTo(n7, n8);
                    ((GeneralPath)shapeArray[n2][n4]).lineTo(n7, n6);
                    ((GeneralPath)shapeArray[n2][n4]).lineTo(n5, n6);
                    ((GeneralPath)shapeArray[n2][n4]).lineTo(n5, n8);
                }
                ++n4;
            }
            this.appendCover(area, n2);
            ++n2;
        }
        return shapeArray;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public int searchSeries(int n, int n2) {
        return 0;
    }

    private void areaSurface(Graphics2D graphics2D) {
        if (this.availableOriginY < 2) {
            return;
        }
        int n = 0;
        while (n < this.bottomCover) {
            if (this.strip[n] != null) {
                int n2 = 0;
                while (n2 < this.strip[n].length) {
                    if (this.selectedSeriesIndex == n && this.status == 1) {
                        this.strip[n][n2].drawSelectedOutLine(graphics2D);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }
}

