/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.ui;

import guitools.GuiUtil;
import guitools.UIResource;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.GregorianCalendar;
import javax.swing.JLabel;
import jet.cs.ui.SVSpin;

public class STimeSpin
extends SVSpin
implements AdjustmentListener,
MouseListener {
    private static boolean QOIV = GuiUtil.isWindows();
    private static Font add = new Font("DateFont", 0, QOIV ? 11 : 12);
    private static Color addAdjustmentListener = UIResource.getColor((Object)"Highlited Text Color");
    private static Color addMouseListener = UIResource.getColor((Object)"Background of Hightlited Text");
    private static int append = 2;
    private static int black = QOIV ? 14 : 18;
    private static int doLayout = QOIV ? 4 : 8;
    private static int getAPM = QOIV ? 14 : 18;
    private static int getAdjustmentType = QOIV ? 2 : 2;
    private static int getColor = QOIV ? 16 : 20;
    private static GregorianCalendar getFormatInt = new GregorianCalendar();
    public static int minHour = 1;
    public static int maxHour = 12;
    public static int minMin = getFormatInt.getMinimum(12);
    public static int maxMin = getFormatInt.getMaximum(12);
    protected boolean isPM = false;
    protected int hour = minHour;
    protected int min = minMin;
    protected JLabel labH = new JLabel(String.valueOf(this.hour), 4);
    protected JLabel labColon = new JLabel(":", 2);
    protected JLabel labM = new JLabel(String.valueOf(this.hour), 4);
    protected JLabel labBlank = new JLabel(" ", 0);
    protected JLabel labAP = new JLabel("AM", 4);
    protected JLabel labCurr = this.labH;
    private int getMaximum = this.vScrollbar.getValue();

    public STimeSpin() {
        this(minHour, minMin, false);
    }

    public STimeSpin(int n, int n2, boolean bl) {
        this.hour = n;
        if (n == 0) {
            this.hour = 12;
        }
        this.min = n2;
        this.isPM = bl;
        this.setFont(add);
        this.labH.setOpaque(true);
        this.labM.setOpaque(true);
        this.labAP.setOpaque(true);
        this.holder.setBackground(Color.white);
        this.labH.setBackground(Color.white);
        this.labH.setForeground(Color.black);
        this.labH.setText(String.valueOf(this.hour));
        this.labH.addMouseListener(this);
        this.labColon.setBackground(Color.white);
        this.labColon.setForeground(Color.black);
        this.labM.setBackground(Color.white);
        this.labM.setForeground(Color.black);
        this.labM.setText(STimeSpin.getFormatInt(n2));
        this.labM.addMouseListener(this);
        this.labBlank.setBackground(Color.white);
        this.labBlank.setForeground(Color.black);
        this.labAP.setBackground(Color.white);
        this.labAP.setForeground(Color.black);
        this.labAP.setText(String.valueOf(this.getAPM()));
        this.labAP.addMouseListener(this);
        this.addAdjustmentListener(this);
        this.holder.setLayout(null);
        this.holder.add(this.labH);
        this.holder.add(this.labColon);
        this.holder.add(this.labM);
        this.holder.add(this.labBlank);
        this.holder.add(this.labAP);
        this.doLayout();
    }

    public String getAPM() {
        return this.isPM ? "PM" : "AM";
    }

    public int getHour() {
        return this.hour;
    }

    public int getHourOfDay() {
        int n = this.hour;
        if (this.hour == 12) {
            n = 0;
        }
        if (this.isPM) {
            n += 12;
        }
        return n;
    }

    public int getMin() {
        return this.min;
    }

    public void setTime(int n, int n2, boolean bl) {
        this.hour = n;
        if (n == 0) {
            this.hour = 12;
        }
        this.min = n2;
        this.isPM = bl;
        this.labH.setText(String.valueOf(this.hour));
        this.labM.setText(STimeSpin.getFormatInt(n2));
        this.labAP.setText(String.valueOf(this.getAPM()));
        this.repaint();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.labH.setEnabled(bl);
        this.labColon.setEnabled(bl);
        this.labM.setEnabled(bl);
        this.labBlank.setEnabled(bl);
        this.labAP.setEnabled(bl);
    }

    public boolean isPM() {
        return this.isPM;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        String string = null;
        int n = adjustmentEvent.getAdjustmentType();
        if (n == 5) {
            int n2 = adjustmentEvent.getValue();
            if (n2 > this.getMaximum) {
                n = 1;
            } else if (n2 < this.getMaximum) {
                n = 2;
            }
        }
        switch (n) {
            case 1: {
                if (this.labCurr == this.labH) {
                    --this.hour;
                    if (this.hour < minHour) {
                        this.hour = maxHour;
                    }
                    string = String.valueOf(this.hour);
                } else if (this.labCurr == this.labM) {
                    --this.min;
                    if (this.min < minMin) {
                        this.min = maxMin;
                    }
                    string = STimeSpin.getFormatInt(this.min);
                } else {
                    this.isPM = !this.isPM;
                    string = this.getAPM();
                }
                this.labCurr.setText(string);
                this.notifyChanged();
                break;
            }
            case 2: {
                if (this.labCurr == this.labH) {
                    ++this.hour;
                    if (this.hour > maxHour) {
                        this.hour = minHour;
                    }
                    string = String.valueOf(this.hour);
                } else if (this.labCurr == this.labM) {
                    ++this.min;
                    if (this.min > maxMin) {
                        this.min = minMin;
                    }
                    string = STimeSpin.getFormatInt(this.min);
                } else {
                    this.isPM = !this.isPM;
                    string = this.getAPM();
                }
                this.labCurr.setText(string);
                this.notifyChanged();
            }
        }
        this.getMaximum = this.vScrollbar.getValue();
    }

    public void layoutContainer(Container container) {
        super.layoutContainer(container);
        Dimension dimension = this.holder.getSize();
        int n = dimension.height - 2 * append;
        int n2 = append;
        int n3 = append;
        this.labH.setBounds(n2, n3, black, n);
        this.labColon.setBounds(n2 + black, n3, doLayout, n);
        this.labM.setBounds(n2 + black + doLayout, n3, getAPM, n);
        this.labBlank.setBounds(black + doLayout + getAPM, 0, getAdjustmentType, n);
        this.labAP.setBounds(n2 + black + doLayout + getAPM + getAdjustmentType, n3, getColor, n);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        if (jLabel != this.labCurr) {
            this.labCurr.setForeground(Color.black);
            this.labCurr.setBackground(Color.white);
            this.labCurr.invalidate();
            this.labCurr = jLabel;
        }
        this.labCurr.setForeground(addAdjustmentListener);
        this.labCurr.setBackground(addMouseListener);
        this.labCurr.invalidate();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public static String getFormatInt(int n) {
        return n < 10 ? '0' + Integer.toString(n) : Integer.toString(n);
    }
}

