/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.ChartObject;
import chart.graphics.ChartBackground;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartGraphicsUtil;
import chart.graphics.ChartPenStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public abstract class ChartComponent
extends ChartObject {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected ChartBackground background;
    public ChartPenStyle selectedPen = new ChartPenStyle();
    public ChartPenStyle preSelectedPen = new ChartPenStyle();
    public ChartPenStyle editedPen = new ChartPenStyle();
    protected List children;

    public ChartComponent() {
        this.needRelocate = false;
        this.children = new ArrayList();
        this.background = null;
    }

    public ChartComponent(int n, int n2, int n3, int n4) {
        this();
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public ChartComponent(Rectangle rectangle) {
        this();
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public abstract ChartObject getChartObject(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D graphics2D) {
        if (this.width == 0 || this.height == 0) {
            return;
        }
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        if (this.needRelocate) {
            this.locate();
        }
        if (this.background != null) {
            this.background.paintBackground(graphics2D, rectangle);
        }
        int n = this.children.size() - 1;
        while (n >= 0) {
            Object var9_8;
            ChartComponent chartComponent = (ChartComponent)this.children.get(n);
            Rectangle rectangle2 = chartComponent.getBounds();
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            try {
                chartComponent.paint(graphics2D2);
                var9_8 = null;
            }
            catch (Throwable throwable) {
                var9_8 = null;
                graphics2D2.dispose();
                throw throwable;
            }
            graphics2D2.dispose();
            --n;
        }
        this.paintBorder(graphics2D);
    }

    protected Rectangle getCoreArea() {
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        return rectangle;
    }

    protected void paintBorder(Graphics2D graphics2D) {
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, dimension.height - 1);
        switch (this.status) {
            case 1: {
                ChartPenStyle chartPenStyle = this.selectedPen;
                ChartGraphicsUtil.drawHighlightBorder(graphics2D, chartPenStyle, rectangle, true);
                break;
            }
            case 2: {
                ChartPenStyle chartPenStyle = this.preSelectedPen;
                ChartGraphicsUtil.drawHighlightBorder(graphics2D, chartPenStyle, rectangle, false);
                break;
            }
            case 3: {
                ChartPenStyle chartPenStyle = this.editedPen;
                ChartGraphicsUtil.drawHighlightBorder(graphics2D, chartPenStyle, rectangle, false);
                break;
            }
        }
    }

    public void setBackground(Color color) {
        this.background.setPattern(new ChartColorPattern(color));
    }

    public void setBackground(ChartBackground chartBackground) {
        this.background = chartBackground;
    }

    public ChartBackground getBackground() {
        return this.background;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public void setBounds(Rectangle rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void setLocation(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public int getComponentCount() {
        return this.children.size();
    }

    public ChartComponent getComponent(int n) {
        return (ChartComponent)this.children.get(n);
    }

    public void add(ChartComponent chartComponent) {
        this.children.add(chartComponent);
    }

    public void add(ChartComponent chartComponent, int n) {
        this.children.add(n, chartComponent);
    }

    public void remove(int n) {
        this.children.remove(n);
    }

    public void remove(ChartComponent chartComponent) {
        this.children.remove(chartComponent);
    }

    public void remove(Object object) {
        this.children.remove(object);
    }
}

