/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DLineNode;
import chart.chart2d.Graph2DScatterCurve;
import chart.data.Chart2DDataSet;
import chart.data.ChartDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartPenStyle;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;

public class Graph2DScatter
extends Chart2DObject {
    protected ChartPenStyle pen;
    protected int col;
    protected int row;
    protected int style;
    protected Shape[] seriesShapes;
    protected Shape[][] itemShapes;
    protected Graph2DLineNode lineNode;
    protected int scatterType;
    protected int gap = 5;
    protected float[][] scatters;
    protected float[][] tScatters;
    protected float[][] value;
    protected float unitX;
    protected float unitY;
    protected float minX;
    protected Graph2DScatterCurve curve;
    private int append;
    private int[] availableValue;
    private Shape[] availableValueX;
    private String[][][] closePath;

    Graph2DScatter(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    public void init() {
        int n;
        super.init();
        this.pen = new ChartPenStyle();
        this.pen.setPenWidth(this.objectProperties.getLineThickness());
        this.row = this.dataset.getSeriesSize();
        this.col = this.dataset.getCategorySize();
        this.style = this.objectProperties.getLineNodeStyle();
        this.lineNode = new Graph2DLineNode();
        this.pen.setPenWidth(this.objectProperties.getLineThickness());
        if (this.paper.I.getChartLegend() != null) {
            this.availableValue = this.paper.I.getChartLegend().getIconStyleList();
        }
        this.scatters = new float[this.row * this.col][2];
        this.tScatters = new float[this.row * this.col][2];
        this.value = new float[this.row * this.col][2];
        this.closePath = new String[this.row][this.col][4];
        this.append = this.row / 2;
        this.seriesShapes = new Shape[this.row];
        this.itemShapes = new Shape[this.row][this.col];
        this.availableValueX = new Shape[this.row];
        this.unitX = this.layer.I();
        this.unitY = this.layer.Z();
        int n2 = 0;
        while (n2 < this.row) {
            this.seriesShapes[n2] = new GeneralPath();
            this.availableValueX[n2] = new GeneralPath();
            int n3 = 0;
            while (n3 < this.col) {
                this.itemShapes[n2][n3] = new GeneralPath();
                ++n3;
            }
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < this.row) {
            n = 0;
            while (n < this.col) {
                Number number = ((Chart2DDataSet)this.dataset).getX(n4, n);
                if (this.layer.isShowCategoryAndSeries()) {
                    this.closePath[n4][n] = this.hintLabelShowCategoryAndSeries(4, n4, n, number);
                } else {
                    if (number != null) {
                        this.value[n4 * this.col + n][0] = number.floatValue();
                        stringBuffer.append("X: ");
                        stringBuffer.append(this.dataset.getFormatedHintValue(number));
                        this.closePath[n4][n][0] = stringBuffer.toString();
                        stringBuffer.setLength(0);
                    }
                    if ((number = ((Chart2DDataSet)this.dataset).getY(n4, n)) != null) {
                        this.value[n4 * this.col + n][1] = number.floatValue();
                        stringBuffer.append("Y: ");
                        stringBuffer.append(this.dataset.getFormatedHintValue(number));
                        this.closePath[n4][n][1] = stringBuffer.toString();
                        stringBuffer.setLength(0);
                    }
                }
                ++n;
            }
            ++n4;
        }
        this.minX = (float)((ChartNumericAxis)this.layer.getAxisX()).getMin();
        n = 0;
        while (n < this.row) {
            int n5 = 0;
            while (n5 < this.col) {
                this.scatters[n * this.col + n5][0] = this.layer.availableValueX(this.value[n * this.col + n5][0]) * this.unitX;
                this.scatters[n * this.col + n5][1] = this.unitY * this.layer.availableValue(this.value[n * this.col + n5][1]);
                ++n5;
            }
            ++n;
        }
    }

    public void locate() {
        int n;
        int n2 = 0;
        while (n2 < this.row) {
            ((GeneralPath)this.seriesShapes[n2]).reset();
            ((GeneralPath)this.availableValueX[n2]).reset();
            n = 0;
            while (n < this.col) {
                ((GeneralPath)this.itemShapes[n2][n]).reset();
                ++n;
            }
            ++n2;
        }
        this.layer.I(this.scatters, this.tScatters);
        n = 0;
        while (n < this.row) {
            int n3 = 0;
            while (n3 < this.col) {
                if (((Chart2DDataSet)this.dataset).getX(n, n3) != null && ((Chart2DDataSet)this.dataset).getY(n, n3) != null) {
                    ((GeneralPath)this.itemShapes[n][n3]).moveTo(this.tScatters[n * this.col + n3][0] - (float)this.gap, this.tScatters[n * this.col + n3][1] + (float)this.gap);
                    ((GeneralPath)this.itemShapes[n][n3]).lineTo(this.tScatters[n * this.col + n3][0] + (float)this.gap, this.tScatters[n * this.col + n3][1] + (float)this.gap);
                    ((GeneralPath)this.itemShapes[n][n3]).lineTo(this.tScatters[n * this.col + n3][0] + (float)this.gap, this.tScatters[n * this.col + n3][1] - (float)this.gap);
                    ((GeneralPath)this.itemShapes[n][n3]).lineTo(this.tScatters[n * this.col + n3][0] - (float)this.gap, this.tScatters[n * this.col + n3][1] - (float)this.gap);
                    ((GeneralPath)this.itemShapes[n][n3]).closePath();
                    ((GeneralPath)this.availableValueX[n]).append(this.itemShapes[n][n3], false);
                }
                ++n3;
            }
            ++n;
        }
    }

    public void paint(Graphics2D graphics2D) {
        switch (this.scatterType) {
            case 0: {
                int n = 0;
                while (n < this.row) {
                    this.drawLine(graphics2D, n);
                    int n2 = 0;
                    while (n2 < this.col) {
                        this.drawScatterN(graphics2D, n, n2);
                        ++n2;
                    }
                    ++n;
                }
                break;
            }
            case 1: {
                if (this.style == 9) {
                    this.style = 2;
                }
                int n = 0;
                while (n < this.row) {
                    int n3 = 0;
                    while (n3 < this.col) {
                        this.drawScatterN(graphics2D, n, n3);
                        ++n3;
                    }
                    ++n;
                }
                break;
            }
            case 2: {
                this.drawCurve(graphics2D);
                int n = 0;
                while (n < this.row) {
                    int n4 = 0;
                    while (n4 < this.col) {
                        this.drawScatterN(graphics2D, n, n4);
                        ++n4;
                    }
                    ++n;
                }
                break;
            }
        }
    }

    public void drawCurve(Graphics2D graphics2D) {
        float[][] fArray2 = new float[this.col][2];
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.pen.createStroke());
        int n = 0;
        while (n < this.row) {
            if (this.seriesPattern[n] instanceof ChartColorPattern) {
                this.pen.setPenColor((ChartColorPattern)this.seriesPattern[n]);
                graphics2D.setColor(this.pen.getPenColor().getColor());
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.col) {
                    int n4;
                    float[][] fArray3;
                    if (n3 == this.col - 1 && n2 != this.col - 1 && ((Chart2DDataSet)this.dataset).getX(n, n3) != null && ((Chart2DDataSet)this.dataset).getY(n, n3) != null) {
                        fArray3 = new float[n2 + 1][2];
                        fArray3[n2][0] = this.tScatters[this.col * n + this.col - 1][0];
                        fArray3[n2][1] = this.tScatters[this.col * n + this.col - 1][1];
                        n4 = 0;
                        while (n4 < n2) {
                            fArray3[n4][0] = fArray2[n4][0];
                            fArray3[n4][1] = fArray2[n4][1];
                            ++n4;
                        }
                        this.curve.drawCurve(graphics2D, fArray3);
                    } else if (((Chart2DDataSet)this.dataset).getX(n, n3) == null || ((Chart2DDataSet)this.dataset).getY(n, n3) == null) {
                        if (n2 > 1) {
                            fArray3 = new float[n2][2];
                            n4 = 0;
                            while (n4 < n2) {
                                fArray3[n4][0] = fArray2[n4][0];
                                fArray3[n4][1] = fArray2[n4][1];
                                ++n4;
                            }
                            this.curve.drawCurve(graphics2D, fArray3);
                        }
                        fArray2 = new float[this.col][2];
                        n2 = 0;
                    } else {
                        fArray2[n2][0] = this.tScatters[this.col * n + n3][0];
                        fArray2[n2][1] = this.tScatters[this.col * n + n3][1];
                        if (n2 == this.col - 1) {
                            this.curve.drawCurve(graphics2D, fArray2);
                        }
                        ++n2;
                    }
                    ++n3;
                }
            }
            ++n;
        }
        graphics2D.setStroke(stroke);
    }

    public void drawLine(Graphics2D graphics2D, int n) {
        if (this.seriesPattern[n] instanceof ChartColorPattern) {
            this.pen.setPenColor((ChartColorPattern)this.seriesPattern[n]);
            this.pen.draw(graphics2D, this.seriesShapes[n]);
        }
    }

    public void drawScatterN(Graphics2D graphics2D, int n, int n2) {
        int n3 = this.style;
        if (this.availableValue != null) {
            n3 = this.paper.formatLineNode(this.style, this.availableValue[n % this.availableValue.length]);
        }
        if (((Chart2DDataSet)this.dataset).getX(n, n2) != null && ((Chart2DDataSet)this.dataset).getY(n, n2) != null && this.seriesPattern[n] instanceof ChartColorPattern) {
            this.pen.setPenColor((ChartColorPattern)this.seriesPattern[n]);
            graphics2D.setColor(this.pen.getPenColor().getColor());
            this.lineNode.drawNode(graphics2D, (int)this.tScatters[n * this.col + n2][0], (int)this.tScatters[n * this.col + n2][1], n3, this.objectProperties.getLineNodeWidth(), this.objectProperties.getLineNodeHeight());
        }
    }

    float[][] getStaticHintLocation() {
        return null;
    }

    public Shape getShapeBySeries(int n) {
        return this.availableValueX[n];
    }

    public Shape getShapeByItem(int n, int n2) {
        return this.itemShapes[n][n2];
    }

    public Shape[][] getItemShapes() {
        return this.itemShapes;
    }

    public String[] search(int n, int n2) {
        this.drilldown = null;
        int n3 = 0;
        while (n3 < this.row) {
            int n4 = 0;
            while (n4 < this.col) {
                if (this.itemShapes[n3][n4].contains(n, n2)) {
                    this.drilldown = new int[2];
                    this.drilldown[0] = n3;
                    this.drilldown[1] = n4;
                    return this.closePath[n3][n4];
                }
                ++n4;
            }
            ++n3;
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public int searchSeries(int n, int n2) {
        int n3 = 0;
        while (n3 < this.availableValueX.length) {
            if (this.availableValueX[n3].contains(n, n2)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public String[] hintLabelShowCategoryAndSeries(int n, int n2, int n3, Number number) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[n];
        stringBuffer.append(this.paper.model.getCategoryNmae() + ": ");
        stringBuffer.append(this.dataset.getFormatedHintCategoryValue(this.paper.model.getCategoryName(n3), n3));
        stringArray[0] = stringBuffer.toString();
        stringBuffer.setLength(0);
        if (this.paper.model.getSeriesN() != null) {
            stringBuffer.append(this.paper.model.getSeriesN() + ": ");
            stringBuffer.append(this.dataset.getFormatedHintSeriesValue(this.paper.model.getSeriesName(n2 % this.paper.model.getSeriesNames().size()), n2 % this.paper.model.getSeriesNames().size()));
            stringArray[1] = stringBuffer.toString();
            stringBuffer.setLength(0);
        } else {
            stringArray[1] = "";
            stringBuffer.setLength(0);
        }
        if (number != null) {
            this.value[n2 * this.col + n3][0] = number.floatValue();
            stringBuffer.append("X: ");
            stringBuffer.append(this.dataset.getFormatedHintValue(number));
            stringArray[2] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        if ((number = ((Chart2DDataSet)this.dataset).getY(n2, n3)) != null) {
            this.value[n2 * this.col + n3][1] = number.floatValue();
            stringBuffer.append("Y: ");
            stringBuffer.append(this.dataset.getFormatedHintValue(number));
            stringArray[3] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        return stringArray;
    }
}

