/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rfax;

import com.java4less.rfax.Capabilities;
import com.java4less.rfax.FaxProducer;
import com.java4less.rfax.FaxStatusListener;
import com.java4less.rfax.HDLCFrame;
import com.java4less.rfax.T4Encoder;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;

public class FaxModem {
    CommPortIdentifier QOIV;
    SerialPort add;
    OutputStream addByte;
    InputStream addLog;
    protected byte[] reverseBytes = new byte[256];
    String addLogCh = "COM1";
    boolean addLogLn = false;
    boolean append = false;
    boolean cancelReception = false;
    String charAt = "ATV1Q0";
    protected static double TRAINING_SECONDS = 1.5;
    protected Capabilities cap;
    public int maxRetries = 3;
    public static final int BITRATE_2400 = 0;
    public static final int BITRATE_4800 = 1;
    public static final int BITRATE_7200 = 2;
    public static final int BITRATE_9600 = 3;
    public static final int BITRATE_12000 = 4;
    public static final int BITRATE_14400 = 5;
    protected static int[] brClass2_to_Class1 = new int[]{24, 48, 72, 96, 121, 145};
    protected static String[] brClass2_to_Class1V = new String[]{"V27", "V27", "V29", "V29", "V17", "V17"};
    protected static final byte CAN = 24;
    protected static final byte DLE = 16;
    protected static final byte ETX = 3;
    protected static final byte MPS2 = 0;
    protected static final byte EOP2 = 2;
    protected static final byte MPS20 = 44;
    protected static final byte EOP20 = 46;
    protected static final byte XON = 17;
    protected static final byte XOFF = 19;
    public int bitRate = 3;
    public int resolution = 1;
    public static final int RESOLUTION_NORMAL = 0;
    public static final int RESOLUTION_FINE = 1;
    public String faxFile = "tmpFax";
    public StringBuffer lastError = new StringBuffer();
    public String resetCommand = "ATZ";
    public int timeout = 30;
    public int resetDelay = 0;
    protected static final int RESP_ERROR = 1;
    protected static final int RESP_FHNG = 2;
    protected static final int RESP_FPTS = 3;
    protected static final int RESP_CONNECT = 4;
    protected static final int RESP_FCON = 5;
    protected static final int RESP_NO_CARRIER = 6;
    protected static final int RESP_NO_DIALTONE = 7;
    protected static final int RESP_BUSY = 8;
    protected static final int RESP_TIMEOUT = 9;
    protected static final int RESP_OK = 10;
    public int lastResponse = 0;
    public int pageCode = -1;
    protected int postPageCode = -1;
    public int hangCode = -1;
    protected String[][] faxErrorCodes = new String[][]{{" 0", " None"}, {" 1", " Ring Detect without successful handshake"}, {" 2", " Call aborted; from +FK or AN"}, {" 3", " No Loop Current"}, {" 10", " Unspecified Phase A error"}, {" 11", " No Answer (T.30 T1 timeout)"}, {" 20", " Unspecified Transmit Phase B error"}, {" 21", " Remote cannot receive or send"}, {" 22", " COMREC error in transmit Phase B"}, {" 23", " COMREC invalid command received"}, {" 24", " RSPEC error"}, {" 25", " DCS sent three times without response"}, {" 26", " DIS/DTC received 3 times; DCS not recognised"}, {" 27", " Failure to train at 2400bps or +FMINSP value"}, {" 28", " RSPREC invalid response received"}, {" 40", " Unspecified Transmit Phase C error"}, {" 43", " DTE to DCE  underflow"}, {" 50", " Unspecified Transmit Phase D error"}, {" 51", " RSPREC error"}, {" 52", " No response to MPS repeated three times"}, {" 53", " Invalid response to MPS"}, {" 54", " No response to EOP repeated three times"}, {" 55", " Invalid response to EOP"}, {" 56", " No response to EOM repeated three times"}, {" 57", " Invalid response to EOM"}, {" 58", " Unable to continue after PIN or PIP"}};
    public static final int FLOWCONTROL_NONE = 0;
    public static final int FLOWCONTROL_XONXOFF = 1;
    public static final int FLOWCONTROL_RTSCTS = 2;
    public int flowControl = 0;
    public String ATFlowControlNone = "";
    public String ATFlowControlXONXOFF = "";
    public String ATFlowControlRTSCTS = "";
    protected String atResponse = "";
    public boolean directBitOrder = false;
    public boolean AtFBOR = true;
    public boolean dialTone = true;
    public int faxClass = 2;
    public String ownId = "12345";
    public String remoteId = "";
    public String noEcho = "ATE0";
    public boolean log = true;
    public boolean debug = true;
    public String logStr = "";
    public FaxProducer producer;
    public String[] initCommands = new String[0];
    protected int pages = 0;
    protected T4Encoder encoder = new T4Encoder();
    public FaxStatusListener listener = null;
    protected boolean V27Supported = true;
    protected boolean V29Supported = true;
    protected boolean V17Supported = false;
    public int MPSEOPdelay = 8;
    public int sendBufferSize = 250000;
    private boolean close = false;
    long compareTo = 0L;
    long connect = 0L;

    public String getInitString() {
        return this.charAt;
    }

    public void setInitString(String string) {
        this.charAt = string;
    }

    public void setPortName(String string) {
        this.addLogCh = string;
    }

    public boolean supportsClass1() {
        return this.addLogLn;
    }

    public boolean supportsClass2() {
        return this.append;
    }

    public boolean supportsClass20() {
        return this.cancelReception;
    }

    public T4Encoder getEncoder() {
        return this.encoder;
    }

    public FaxModem() {
        this.encoder.minBytesLine = 0;
        int n = 0;
        while (n < 256) {
            byte by = (byte)n;
            byte by2 = 0;
            if ((by & 0x80) > 0) {
                by2 = (byte)(by2 | 1);
            }
            if ((by & 0x40) > 0) {
                by2 = (byte)(by2 | 2);
            }
            if ((by & 0x20) > 0) {
                by2 = (byte)(by2 | 4);
            }
            if ((by & 0x10) > 0) {
                by2 = (byte)(by2 | 8);
            }
            if ((by & 8) > 0) {
                by2 = (byte)(by2 | 0x10);
            }
            if ((by & 4) > 0) {
                by2 = (byte)(by2 | 0x20);
            }
            if ((by & 2) > 0) {
                by2 = (byte)(by2 | 0x40);
            }
            if ((by & 1) > 0) {
                by2 = (byte)(by2 | 0x80);
            }
            this.reverseBytes[n] = by2;
            ++n;
        }
    }

    public boolean createFaxFiles(FaxProducer faxProducer) {
        if (this.faxClass == 1) {
            this.directBitOrder = true;
        }
        if (faxProducer != null) {
            this.producer = faxProducer;
        }
        if (this.producer == null) {
            return false;
        }
        if (this.listener != null) {
            this.listener.faxProgress(6, 0);
        }
        this.pages = 0;
        boolean bl = this.encoder.createEOP = this.faxClass == 20;
        if (this.faxClass == 1) {
            this.encoder.createEOP = false;
        }
        Image image = null;
        image = this.producer.getFaxPage(this.pages);
        while (image != null) {
            byte[] byArray = this.encoder.encodeImage(image);
            if (byArray != null) {
                this.writeFile(this.faxFile + "." + this.pages, byArray, byArray.length);
                ++this.pages;
            }
            image = this.producer.getFaxPage(this.pages);
        }
        return true;
    }

    protected byte[] readFile(String string) {
        byte[] byArray = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byArray = new byte[(int)new File(string).length()];
            fileInputStream.read(byArray, 0, byArray.length);
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Read file " + string + " " + exception.getMessage());
            return null;
        }
        return byArray;
    }

    protected boolean writeFile(String string, byte[] byArray, int n) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray, 0, n);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error writing to file " + exception.getMessage());
            return false;
        }
        return true;
    }

    public boolean open(FaxProducer faxProducer) throws Exception {
        if (!this.createFaxFiles(faxProducer)) {
            this.lastError.append("Could not create fax files. \n");
            return false;
        }
        if (this.listener != null) {
            this.listener.faxProgress(1, 0);
        }
        try {
            this.QOIV = CommPortIdentifier.getPortIdentifier((String)this.addLogCh);
        }
        catch (Exception exception) {
            this.lastError.append("Could not find port " + this.addLogCh + "\n");
            return false;
        }
        if (this.QOIV == null) {
            this.lastError.append("Could not find port " + this.addLogCh + "\n");
            return false;
        }
        if (this.QOIV.getPortType() != 1) {
            this.lastError.append("" + this.addLogCh + " is not a serial port" + "\n");
            throw new Exception("" + this.addLogCh + " is not a serial port ");
        }
        try {
            this.add = (SerialPort)this.QOIV.open("JReport", 2000);
        }
        catch (PortInUseException portInUseException) {
            this.lastError.append("Could not open port " + this.addLogCh + "\n");
            throw new Exception("Could not open port ");
        }
        try {
            this.add.enableReceiveTimeout(1000);
        }
        catch (Exception exception) {
            this.close();
        }
        try {
            this.addByte = this.add.getOutputStream();
            this.addLog = this.add.getInputStream();
        }
        catch (IOException iOException) {
            this.lastError.append("Could not get streams\n");
            throw new Exception("Could not get serial port streams ");
        }
        try {
            this.add.setSerialPortParams(19200, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            this.lastError.append("Could not configure port\n");
            throw new Exception("Could not configure port ");
        }
        if (this.listener != null) {
            this.listener.faxProgress(2, 0);
        }
        if (!this.sendATCommand(this.resetCommand)) {
            this.lastError.append("Could not reset modem with ATZ\n");
            throw new Exception("reset modem  failed!");
        }
        if (this.resetDelay > 0) {
            this.softDelay(this.resetDelay);
        }
        if (this.flowControl == 2 && this.ATFlowControlRTSCTS.length() >= 0) {
            this.sendATCommand(this.ATFlowControlRTSCTS);
        }
        if (this.flowControl == 1 && this.ATFlowControlXONXOFF.length() > 0) {
            this.sendATCommand(this.ATFlowControlXONXOFF);
        }
        if (this.flowControl == 0 && this.ATFlowControlNone.length() > 0) {
            this.sendATCommand(this.ATFlowControlNone);
        }
        try {
            if (this.flowControl == 2) {
                this.add.setFlowControlMode(2);
            }
            if (this.faxClass != 1 && this.flowControl == 1) {
                this.add.setFlowControlMode(8);
            }
            if (this.flowControl == 0) {
                this.add.setFlowControlMode(0);
            }
        }
        catch (Exception exception) {
            throw new Exception("Set flow control error");
        }
        if (this.log) {
            if ((this.add.getFlowControlMode() & 8) > 0) {
                this.addLogLn("FLOWCONTROL_XONXOFF_OUT");
            }
            if ((this.add.getFlowControlMode() & 4) > 0) {
                this.addLogLn("FLOWCONTROL_XONXOFF_IN");
            }
            if ((this.add.getFlowControlMode() & 1) > 0) {
                this.addLogLn("FLOWCONTROL_RTSCTS_IN");
            }
            if ((this.add.getFlowControlMode() & 2) > 0) {
                this.addLogLn("FLOWCONTROL_RTSCTS_OUT");
            }
        }
        this.sendATCommand(this.noEcho);
        this.sendATCommand(this.charAt);
        this.queryCapabilities();
        if (this.addLogLn && this.faxClass == 1) {
            if (!this.sendATCommand("AT+FCLASS=1")) {
                this.lastError.append("Could not set class 1\n");
                throw new Exception("set class1 failed");
            }
            this.queryBR();
        }
        if (this.append && this.faxClass == 2) {
            if (!this.sendATCommand("AT+FCLASS=2")) {
                this.lastError.append("Could not set class 2\n");
                throw new Exception("set class2 failed");
            }
            if (this.debug) {
                this.sendATCommand("AT+FBUG=1");
            }
        }
        if (this.cancelReception && this.faxClass == 20) {
            if (!this.sendATCommand("AT+FCLASS=2.0")) {
                this.lastError.append("Could not set class 2.0\n");
                throw new Exception("set class2.0 failed");
            }
            this.sendATCommand("AT+FNR=1,1,1,0");
            if (this.debug) {
                this.sendATCommand("AT+FBU=1");
            }
        }
        if (this.AtFBOR) {
            if (this.faxClass == 2) {
                if (!this.directBitOrder) {
                    this.sendATCommand("AT+FBOR=1");
                }
                if (this.directBitOrder) {
                    this.sendATCommand("AT+FBOR=0");
                }
            }
            if (this.faxClass == 20) {
                if (!this.directBitOrder) {
                    this.sendATCommand("AT+FBO=1");
                }
                if (this.directBitOrder) {
                    this.sendATCommand("AT+FBO=0");
                }
            }
        }
        if (this.ownId.length() > 0) {
            if (this.faxClass == 20) {
                this.sendATCommand("AT+FLI=\"" + this.ownId + "\"");
            }
            if (this.faxClass == 2) {
                this.sendATCommand("AT+FLID=\"" + this.ownId + "\"");
            }
        }
        if (this.faxClass == 20) {
            this.sendATCommand("AT+FCC=" + this.resolution + "," + this.bitRate + ",0,2,0,0,0,0");
        }
        if (this.faxClass == 2) {
            this.sendATCommand("AT+FDCC=" + this.resolution + "," + this.bitRate + ",0,2,0,0,0,0");
        }
        int n = 0;
        while (n < this.initCommands.length) {
            this.sendATCommand(this.initCommands[n]);
            ++n;
        }
        return true;
    }

    protected void addLog(String string) {
        this.logStr = this.logStr + string;
        if (this.debug) {
            System.out.print(string);
        }
    }

    protected void addLogLn(String string) {
        this.logStr = this.logStr + "\n" + string;
        if (this.debug) {
            System.out.println(string);
        }
    }

    protected void addLogCh(int n) {
        String string = "";
        string = n < 32 ? "<" + n + ">" : "" + (char)n;
        this.logStr = this.logStr + string;
        if (this.debug) {
            System.out.print(string);
        }
    }

    public synchronized boolean sendFax(String string) throws Exception {
        this.hangCode = -1;
        boolean bl = false;
        int n = 0;
        String string2 = "";
        if (this.listener != null) {
            this.listener.faxProgress(3, 0);
        }
        for (int i = 0; i <= this.maxRetries; ++i) {
            if (i == this.maxRetries) {
                this.close = true;
            }
            if (!this.connect(string)) {
                this.hangup();
                if (i == this.maxRetries) {
                    throw new Exception("connect destination failed");
                }
                this.ATFlowControlNone(5000);
                continue;
            }
            if (this.faxClass == 1) {
                if (!this.phaseB()) {
                    return false;
                }
                if (!this.sendTSI()) {
                    return false;
                }
            }
            int n2 = 0;
            boolean bl2 = false;
            boolean bl3 = true;
            while (n2 < this.pages) {
                byte[] byArray;
                if (this.listener != null) {
                    this.listener.faxProgress(4, n2);
                }
                boolean bl4 = false;
                if (new File("send.g3").exists()) {
                    byArray = this.readFile("send.g3");
                    bl4 = true;
                } else {
                    byArray = this.readFile(this.faxFile + "." + n2);
                }
                if (byArray == null) {
                    this.lastError.append("Could not read fax file. \n");
                    return false;
                }
                if (this.faxClass == 1 && (bl2 || bl3)) {
                    if (bl2 && !this.sendClass1FTH(3)) {
                        return false;
                    }
                    if (!this.sendDCS()) {
                        return false;
                    }
                    if (!this.doTraining()) {
                        return false;
                    }
                }
                bl2 = false;
                if (!(this.faxClass != 2 && this.faxClass != 20 || this.sendATCommandnoWait("AT+FDT"))) {
                    this.lastError.append("Could not start phase C \n");
                    return false;
                }
                if (this.faxClass == 20) {
                    this.waitForOK("CONNECT", false);
                }
                if (this.faxClass == 2) {
                    int n3 = this.add.getFlowControlMode();
                    try {
                        this.add.setFlowControlMode(0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (this.log) {
                            this.addLog("Response: ");
                        }
                        string2 = "";
                        int n4 = this.addLog.read();
                        string2 = string2 + n4;
                        while (n4 != 17) {
                            n4 = this.addLog.read();
                            if (this.log) {
                                this.addLogCh(n4);
                            }
                            string2 = string2 + n4;
                            if (n4 == 13 && string2.indexOf("OK") >= 0) break;
                            if (n4 != 17 || !this.log) continue;
                            this.addLogLn("XON received");
                        }
                        if (string2.indexOf("+FHNG") >= 0) {
                            this.lastResponse = 2;
                            this.lastError.append("Remote closed connection \n");
                            return false;
                        }
                        if (string2.indexOf("+FHS") >= 0) {
                            this.lastResponse = 2;
                            this.lastError.append("Remote closed connection \n");
                            return false;
                        }
                    }
                    catch (Exception exception) {
                        this.lastError.append("Error reading (wait for XON)\n");
                        throw new Exception("Error reading (wait for XON)");
                    }
                    try {
                        this.add.setFlowControlMode(n3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.pageCode = -1;
                if (this.faxClass == 1) {
                    if (!this.sendDataClass1(byArray, bl4)) {
                        this.lastError.append("Could not send page bytes \n");
                        return false;
                    }
                    byte[] byArray2 = new byte[]{0, 8, -128, 0, 8, -128, 0, 8, -128};
                    this.sendBytes(byArray2, byArray2.length);
                    byte[] byArray3 = new byte[]{16, 3};
                    this.sendBytes(byArray3, byArray3.length);
                    if (!this.waitForOK("OK", false)) {
                        return false;
                    }
                } else if (!this.sendData(byArray)) {
                    this.lastError.append("Could not send page bytes \n");
                    return false;
                }
                if (this.faxClass == 20) {
                    byte[] byArray4;
                    if (n2 == this.pages - 1) {
                        byArray4 = new byte[]{16, 46};
                        this.sendBytes(byArray4, byArray4.length);
                    } else {
                        byArray4 = new byte[]{16, 44};
                        this.sendBytes(byArray4, byArray4.length);
                    }
                    this.sendATCommand("AT+FPS?");
                }
                if (this.faxClass == 2) {
                    byte[] byArray5 = new byte[]{16, 3};
                    this.sendBytes(byArray5, byArray5.length);
                    try {
                        Thread.currentThread();
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n2 == this.pages - 1) {
                        this.sendATCommand("AT+FET=2");
                    } else {
                        this.sendATCommand("AT+FET=0");
                    }
                    if (this.pageCode == -1) {
                        this.sendATCommand("AT+FPTS?");
                    }
                }
                bl = false;
                bl3 = false;
                if (this.faxClass == 1) {
                    if (this.MPSEOPdelay > 0 && !this.sendATCommand("AT+FTS=" + this.MPSEOPdelay)) {
                        return false;
                    }
                    int n5 = 1;
                    HDLCFrame hDLCFrame = null;
                    while (n5 <= 3) {
                        if (!this.sendClass1FET(n2 == this.pages - 1)) {
                            return false;
                        }
                        if (!this.sendATCommandnoWait("AT+FRH=3")) {
                            return false;
                        }
                        hDLCFrame = this.waitForFrame(3000);
                        if (!this.waitForOK("OK", false)) {
                            return false;
                        }
                        if (hDLCFrame != null) break;
                        ++n5;
                    }
                    if (hDLCFrame == null) {
                        this.lastError.append("Response to MPS/EOP not received after 3 retries. \n");
                        return false;
                    }
                    if (hDLCFrame.getFrameType() == 44) {
                        this.lastError.append("Procedure interrupted \n");
                        return false;
                    }
                    if (hDLCFrame.getFrameType() == 172) {
                        this.lastError.append("Procedure interrupted \n");
                        return false;
                    }
                    if (hDLCFrame.getFrameType() == 140 && this.log) {
                        this.addLogLn("Positive message confirmation.");
                    }
                    if (n2 == this.pages - 1 && hDLCFrame.getFrameType() == 204) {
                        bl2 = true;
                        if (this.log) {
                            this.addLogLn("Retrain positive.");
                        }
                    }
                    if (hDLCFrame.getFrameType() == 76) {
                        bl2 = true;
                        if (n < this.maxRetries) {
                            bl = true;
                            ++n;
                            if (this.log) {
                                this.addLogLn("Retry " + n + " of " + this.maxRetries);
                            }
                        } else {
                            this.lastError.append("Too many retries. \n");
                            if (!this.log) break;
                            this.addLogLn("Too many retries.");
                            break;
                        }
                    }
                    if (hDLCFrame.getFrameType() == 250) {
                        this.lastError.append("Disconnect frame received \n");
                        this.hangCode = 20;
                        break;
                    }
                }
                if (this.faxClass == 2 || this.faxClass == 20) {
                    switch (this.pageCode) {
                        case -1: {
                            break;
                        }
                        case 0: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            if (n >= this.maxRetries) break;
                            bl = true;
                            ++n;
                            break;
                        }
                    }
                }
                if (!bl) {
                    ++n2;
                }
                if (this.hangCode >= 0) break;
            }
            if (this.listener != null) {
                this.listener.faxProgress(5, 0);
            }
            if (this.faxClass == 1 && this.sendClass1Disconnect()) {
                this.hangCode = 0;
            }
            this.hangup();
            break;
        }
        return this.hangCode == 0;
    }

    public boolean waitFor(String string) {
        return this.waitForOK(string, true);
    }

    protected boolean waitForOK(String string, boolean bl) {
        try {
            return this.waitForOK(string, bl, this.timeout);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean waitForOKWithE(String string, boolean bl) throws Exception {
        return this.waitForOK(string, bl, this.timeout);
    }

    protected void softDelay(int n) {
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean waitForOK(String string, boolean bl, int n) throws Exception {
        String string2 = "";
        String string3 = "";
        this.atResponse = "";
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTime().getTime();
        if (this.log) {
            this.addLogLn("");
            this.addLog("Response: ");
        }
        int n2 = this.addLog.read();
        string2 = string2 + (char)n2;
        while (true) {
            long l2 = Calendar.getInstance().getTime().getTime();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(6, 7);
            String string4 = new SimpleDateFormat("ddmmyyyy").format(calendar2.getTime());
            if (l < l2 && l2 - l > (long)(n * 1000)) {
                this.timeout = 9;
                this.lastError.append("Timeout waiting for response \n");
                this.close();
                throw new Exception("Timeout waiting for response");
            }
            if (n2 == 13) {
                if (string3.indexOf("+FHNG:") >= 0 || string3.indexOf("+FHS:") >= 0 || string3.indexOf("+FHG:") >= 0) {
                    this.hangCode = new Integer(string3.substring(string3.indexOf(":") + 1, string3.length()));
                }
                if (string3.indexOf("+FPS:") >= 0 || string3.indexOf("+FPTS:") >= 0) {
                    this.pageCode = new Integer(string3.substring(string3.indexOf(":") + 1, string3.length()));
                }
                if (string3.indexOf("+FET:") >= 0) {
                    this.postPageCode = new Integer(string3.substring(string3.indexOf(":") + 1, string3.length()));
                }
                if (string3.indexOf("+FTSI:") >= 0) {
                    this.remoteId = string3.substring(string3.indexOf(":") + 1, string3.length());
                }
                if (string3.indexOf("+FCSI:") >= 0) {
                    this.remoteId = string3.substring(string3.indexOf(":") + 1, string3.length());
                }
                if (string3.indexOf("+FDSC:") >= 0) {
                    String string5 = string3.substring(string3.indexOf(":") + 1, string3.length());
                    Capabilities capabilities = new Capabilities();
                    capabilities.decodeCapabilitiesClass2(string5);
                }
                if (string3.indexOf("+FCON") >= 0 || string3.indexOf("+FCO") >= 0) {
                    this.lastResponse = 5;
                }
                if (string3.indexOf("CONNECT") >= 0 && this.faxClass == 1) {
                    this.lastResponse = 5;
                }
                if (string3.indexOf("ERROR") >= 0 || string3.indexOf("FCERROR") >= 0) {
                    this.lastResponse = 1;
                    return false;
                }
                if (string3.indexOf("BUSY") >= 0 && this.close) {
                    this.lastResponse = 8;
                    this.lastError.append("Line busy \n");
                    throw new Exception("Line busy");
                }
                if (string3.indexOf("NO DIALTONE") >= 0) {
                    this.lastResponse = 7;
                    this.lastError.append("No dial tone \n");
                    return false;
                }
                if (string3.indexOf("NO CARRIER") >= 0 && string.compareTo("NO CARRIER") != 0) {
                    this.lastResponse = 6;
                    this.lastError.append("No carrier \n");
                    return false;
                }
                string3 = "";
            }
            if (this.log) {
                this.addLogCh(n2);
            }
            if (n2 == 13 && string2.indexOf(string) >= 0 && (string2.indexOf("OK") >= 0 || !bl)) break;
            if (!(n2 != 13 || string2.indexOf("+FHNG") < 0 || string2.indexOf("OK") < 0 && bl)) {
                return false;
            }
            if (!(n2 != 13 || string2.indexOf("+FHG") < 0 || string2.indexOf("OK") < 0 && bl)) {
                return false;
            }
            if (!(n2 != 13 || string2.indexOf("+FHS") < 0 || string2.indexOf("OK") < 0 && bl)) {
                return false;
            }
            if (string2.indexOf("ERROR") >= 0) {
                return false;
            }
            n2 = this.addLog.read();
            string2 = string2 + (char)n2;
            this.atResponse = this.atResponse + (char)n2;
            if (n2 == 10 || n2 == 13) continue;
            string3 = string3 + (char)n2;
        }
        if (this.log) {
            this.addLogLn("");
        }
        return true;
    }

    protected boolean sendClass1Disconnect() {
        if (!this.sendClass1FTH(3)) {
            return false;
        }
        HDLCFrame hDLCFrame = new HDLCFrame();
        hDLCFrame.setLast(true);
        hDLCFrame.setFrameType((byte)-5);
        if (!this.sendFrame(hDLCFrame)) {
            return false;
        }
        return this.waitForOK("OK", false);
    }

    protected boolean sendClass1FET(boolean bl) {
        if (!this.sendClass1FTH(3, 3)) {
            return false;
        }
        HDLCFrame hDLCFrame = new HDLCFrame();
        hDLCFrame.setLast(true);
        if (bl) {
            hDLCFrame.setFrameType((byte)47);
        } else {
            hDLCFrame.setFrameType((byte)79);
        }
        if (!this.sendFrame(hDLCFrame)) {
            return false;
        }
        return this.waitForOK("OK", false);
    }

    protected boolean sendTSI() {
        if (!this.sendClass1FTH(3)) {
            return false;
        }
        HDLCFrame hDLCFrame = new HDLCFrame();
        hDLCFrame.setLast(false);
        hDLCFrame.setFrameType((byte)67);
        int n = this.ownId.length() - 1;
        while (n >= 0) {
            hDLCFrame.addByte((byte)this.ownId.charAt(n));
            --n;
        }
        int n2 = 0;
        while (n2 < 20 - this.ownId.length()) {
            hDLCFrame.addByte((byte)32);
            ++n2;
        }
        if (!this.sendFrame(hDLCFrame)) {
            return false;
        }
        return this.waitForOK("CONNECT", false);
    }

    protected boolean sendDCS() {
        HDLCFrame hDLCFrame = new HDLCFrame();
        hDLCFrame.setLast(true);
        hDLCFrame.setFrameType((byte)-125);
        this.minCapabilities(this.cap);
        byte[] byArray = this.cap.encodeCapabilities();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            byArray[n] = this.reverseBytes[n2];
            ++n;
        }
        hDLCFrame.addByte(byArray[0]);
        hDLCFrame.addByte(byArray[1]);
        hDLCFrame.addByte(byArray[2]);
        if (!this.sendFrame(hDLCFrame)) {
            return false;
        }
        return this.waitForOK("OK", false);
    }

    protected boolean phaseB() {
        HDLCFrame hDLCFrame = null;
        boolean bl = false;
        while (true) {
            if ((hDLCFrame = this.waitForFrame(10000)) == null) {
                return false;
            }
            if (!this.waitForOK("OK", false)) {
                return false;
            }
            if (hDLCFrame.getFrameType() == 128) {
                bl = true;
                this.cap = new Capabilities();
                byte[] byArray = hDLCFrame.getData();
                int n = 0;
                while (n < byArray.length) {
                    int n2 = byArray[n];
                    if (n2 < 0) {
                        n2 = 256 + n2;
                    }
                    byArray[n] = this.reverseBytes[n2];
                    ++n;
                }
                this.cap.decodeCapabilities(byArray);
            }
            if (hDLCFrame.isLast()) break;
            this.sendATCommandnoWait("AT+FRH=3");
        }
        if (!bl) {
            this.lastError.append("DIS not received \n");
            return false;
        }
        if (!this.cap.t4) {
            this.lastError.append("Receiver does not support T.4 \n");
            return false;
        }
        return true;
    }

    protected boolean doTraining() {
        boolean bl = true;
        HDLCFrame hDLCFrame = null;
        while (bl) {
            this.sendTraining();
            bl = false;
            this.sendATCommand("AT+FTS=1");
            this.sendATCommandnoWait("AT+FRH=3");
            do {
                if ((hDLCFrame = this.waitForFrame(30000)) != null) continue;
                return false;
            } while (!hDLCFrame.isLast());
            if (hDLCFrame.getFrameType() != 68) continue;
            this.lastError.append("Training failed at speed " + this.cap.rate + "\n");
            bl = true;
            int n = 1;
            if (this.bitRate == 5) {
                n = 3;
            }
            if (this.bitRate == 4) {
                n = 3;
            }
            if (this.bitRate == 3) {
                n = 1;
            }
            if (this.bitRate == 2) {
                n = 1;
            }
            if (this.bitRate == 1) {
                n = 0;
            }
            if (this.bitRate == 0) {
                bl = false;
            }
            if (bl) {
                this.bitRate = n;
            }
            this.sendClass1FTH(3);
            if (this.sendDCS()) continue;
            return false;
        }
        if (hDLCFrame != null && hDLCFrame.getFrameType() != 132) {
            this.lastError.append("Confirmation to receive excepted. \n");
            return false;
        }
        return this.waitForOK("OK", false);
    }

    protected void cancelReception() {
        if (this.log) {
            this.addLogLn("Cancel: ");
        }
        byte[] byArray = new byte[]{24};
        this.sendBytes(byArray, 1);
        this.waitFor("OK");
    }

    protected HDLCFrame waitForFrameWithRetry(int n) {
        int n2 = 1;
        while (n2 <= 3) {
            HDLCFrame hDLCFrame = this.waitForFrame(n);
            if (hDLCFrame != null) {
                return hDLCFrame;
            }
            ++n2;
        }
        return null;
    }

    private void ATFlowControlNone(int n) {
        boolean bl = true;
        long l = Calendar.getInstance().getTime().getTime();
        while (bl) {
            long l2 = Calendar.getInstance().getTime().getTime();
            if (l2 < l || l2 - l <= (long)n) continue;
            bl = false;
        }
    }

    protected HDLCFrame waitForFrame(int n) {
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTime().getTime();
        long l2 = 0L;
        String string = "";
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray = new byte[1024];
        int n2 = 0;
        try {
            if (this.log) {
                this.addLog("Wait for frame: ");
            }
            int n3 = this.addLog.read();
            while (true) {
                long l3;
                if ((l3 = Calendar.getInstance().getTime().getTime()) - l > (long)n) {
                    this.cancelReception();
                    this.lastResponse = 9;
                    this.lastError.append("Timeout waiting for frame \n");
                    return null;
                }
                if (n3 == 13) {
                    if (string.indexOf("ERROR") >= 0) {
                        this.lastResponse = 1;
                        return null;
                    }
                    if (string.indexOf("FCERROR") >= 0) {
                        this.lastResponse = 1;
                        return null;
                    }
                    if (string.indexOf("OK") >= 0) {
                        this.lastResponse = 10;
                        return null;
                    }
                    string = "";
                }
                if (this.log) {
                    this.addLog(" " + Integer.toHexString(n3));
                }
                if (n3 == 255 && !bl2) {
                    bl2 = true;
                    l2 = calendar.getTime().getTime();
                }
                if (bl2) {
                    if (!bl) {
                        if (n3 == 16) {
                            bl = true;
                        } else {
                            byArray[n2++] = (byte)n3;
                        }
                    } else {
                        if (n3 == 16) {
                            bl = false;
                            byArray[n2++] = (byte)n3;
                        }
                        if (n3 == 3) break;
                    }
                }
                if ((n3 = this.addLog.read()) == 10 || n3 == 13) continue;
                string = string + (char)n3;
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        if (n2 == 0) {
            return null;
        }
        return new HDLCFrame(byArray, n2);
    }

    protected boolean enterFrameReceiveMode() {
        if (!this.sendATCommandnoWait("AT+FRH=3")) {
            return false;
        }
        return this.waitForOK("CONNECT", false);
    }

    protected boolean connect(String string) throws Exception {
        String string2 = "P";
        if (this.dialTone) {
            string2 = "T";
        }
        if (this.faxClass == 1) {
            if (!this.sendATCommandnoWait("ATD" + string2 + string)) {
                return false;
            }
            this.waitForOKWithE("CONNECT", false);
        } else if (!this.sendATCommand("ATD" + string2 + string)) {
            return false;
        }
        return this.lastResponse == 5;
    }

    protected void hangup() {
        this.sendATCommand("ATH");
    }

    protected void minCapabilities(Capabilities capabilities) {
        int n = brClass2_to_Class1[this.bitRate];
        if (n < capabilities.rate) {
            capabilities.rate = n;
            capabilities.vRate = brClass2_to_Class1V[this.bitRate];
        }
        if (capabilities.resolution == 1 && this.resolution == 0) {
            capabilities.resolution = 0;
        }
        if (this.encoder.lineWidth < capabilities.width) {
            capabilities.width = this.encoder.lineWidth;
        }
        capabilities.huffman = 1;
    }

    protected void queryCapabilities() {
        this.sendATCommand("AT+FCLASS=?");
        if (this.atResponse.indexOf("1") > 0) {
            this.addLogLn = true;
        }
        if (this.atResponse.indexOf("2") > 0) {
            this.append = true;
        }
        if (this.atResponse.indexOf("2.0") > 0) {
            this.cancelReception = true;
        }
    }

    protected void queryBR() {
        if (this.addLogLn) {
            this.sendATCommand("AT+FTM=?");
            if (this.atResponse.indexOf("48") > 0) {
                this.V27Supported = true;
            }
            if (this.atResponse.indexOf("96") > 0) {
                this.V29Supported = true;
            }
            if (this.atResponse.indexOf("97") > 0) {
                this.V17Supported = true;
            }
            if (this.atResponse.indexOf("98") > 0) {
                this.V17Supported = true;
            }
            if (this.atResponse.indexOf("145") > 0) {
                this.V17Supported = true;
            }
            if (this.atResponse.indexOf("146") > 0) {
                this.V17Supported = true;
            }
        }
    }

    public boolean close() throws Exception {
        int n = 0;
        while (n < this.pages) {
            try {
                File file = new File(this.faxFile + "." + n);
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        try {
            this.addLog.close();
            this.addByte.close();
            this.add.close();
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
        return true;
    }

    protected boolean sendATCommandnoWait(String string) {
        char c = '\r';
        try {
            if (this.log) {
                this.addLogLn("");
                this.addLogLn("Command out.");
            }
            if (this.log) {
                this.addLog(string);
            }
            string = string + c;
            this.addByte.write(string.getBytes());
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            return false;
        }
        return true;
    }

    protected boolean sendData(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        byte[] byArray2 = new byte[65];
        try {
            while (n2 < byArray.length) {
                n = 0;
                while (n < 64 && n2 < byArray.length) {
                    byte by = 0;
                    if (this.directBitOrder) {
                        int n4;
                        if ((n4 = byArray[n2++]) < 0) {
                            n4 = 256 + n4;
                        }
                        by = this.reverseBytes[n4];
                    } else {
                        by = byArray[n2++];
                    }
                    if (by == 16) {
                        byArray2[n++] = 16;
                    }
                    byArray2[n++] = by;
                }
                if (!this.sendBytes(byArray2, n)) {
                    return false;
                }
                if (!this.log) continue;
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return true;
    }

    protected boolean sendDataClass1(byte[] byArray, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        byte[] byArray2 = new byte[this.sendBufferSize];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string = "Line: ";
        boolean bl2 = false;
        if (!bl && this.cap.scanTime > 0) {
            double d = (double)this.cap.scanTime / 1000.0;
            n5 = (int)((double)(this.cap.rate * 100 / 8) * d);
        }
        if (this.log) {
            this.addLogLn("Number of byte/line " + n5 + " (" + this.cap.scanTime + " ms )");
        }
        if (!this.sendClass1FTM(this.cap.rate)) {
            return false;
        }
        try {
            if (this.flowControl == 1) {
                this.add.setFlowControlMode(8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n4 = 0;
            while (n2 < byArray.length && !bl2) {
                n = 0;
                while (n < this.sendBufferSize && n2 < byArray.length && !bl2) {
                    byte by = 0;
                    byte by2 = 0;
                    boolean bl3 = false;
                    if (n2 < byArray.length - 1) {
                        by2 = byArray[n2 + 1];
                    }
                    if ((byArray[n2] & 7) == 0 && by2 == 1) {
                        bl3 = true;
                    }
                    if (this.directBitOrder) {
                        int n7;
                        if ((n7 = byArray[n2++]) < 0) {
                            n7 = 256 + n7;
                        }
                        by = this.reverseBytes[n7];
                    } else {
                        by = byArray[n2++];
                    }
                    if (by == 16) {
                        byArray2[n++] = 16;
                    }
                    byArray2[n++] = by;
                    if (bl3 && n6 > 0 && ++n4 < n5) {
                        while (n4 < n5) {
                            byArray2[n++] = 0;
                            ++n4;
                        }
                    }
                    if (!bl3) continue;
                    byArray2[n++] = this.directBitOrder ? -128 : 1;
                    ++n2;
                    ++n6;
                    n4 = 0;
                }
                if (this.sendBytes(byArray2, n)) continue;
                bl2 = true;
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        try {
            if (this.flowControl == 1) {
                this.add.setFlowControlMode(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !bl2;
    }

    protected boolean sendFrameWithRetry(HDLCFrame hDLCFrame) {
        int n = 1;
        boolean bl = false;
        while (n <= 3 && !bl) {
            if (!this.sendFrame(hDLCFrame)) {
                return false;
            }
            if (hDLCFrame.isLast()) {
                if (this.waitForOK("OK", false)) {
                    bl = true;
                } else if (this.waitForOK("CONNECT", false)) {
                    bl = true;
                }
            }
            ++n;
        }
        return bl;
    }

    protected boolean sendFrame(HDLCFrame hDLCFrame) {
        byte[] byArray = hDLCFrame.getRawData();
        if (this.log) {
            this.addLogLn("");
            this.addLog("Send frame: ");
            int n = 0;
            while (n < byArray.length) {
                this.addLog(" " + Integer.toHexString(byArray[n] & 0xFF));
                ++n;
            }
        }
        this.startTimer(2500);
        if (!this.sendBytes(byArray, byArray.length)) {
            return false;
        }
        byte[] byArray2 = new byte[]{16, 3};
        if (!this.sendBytes(byArray2, 2)) {
            return false;
        }
        if (this.timeout()) {
            this.lastError.append("timeout sending frame. \n");
            return false;
        }
        return true;
    }

    protected boolean sendBytes(byte[] byArray, int n) {
        try {
            this.addLog("Send " + n + " bytes  ... ");
            this.addByte.write(byArray, 0, n);
            this.addLogLn("OK");
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            return false;
        }
        return true;
    }

    protected void startTimer(int n) {
        this.connect = n;
        Calendar calendar = Calendar.getInstance();
        this.compareTo = calendar.getTime().getTime();
    }

    protected boolean timeout() {
        long l = Calendar.getInstance().getTime().getTime();
        return l - this.compareTo > this.connect * 1000L;
    }

    protected boolean sendClass1FTH(int n) {
        return this.sendClass1FTH(n, this.timeout);
    }

    protected boolean sendClass1FTH(int n, int n2) {
        String string = "AT+FTH=" + n;
        int n3 = 0;
        while (n3 < 3) {
            if (!this.sendATCommandnoWait(string)) {
                return false;
            }
            try {
                if (this.waitForOK("CONNECT", false, n2)) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n3;
        }
        return n3 < 3;
    }

    protected boolean sendClass1FTM(int n) {
        String string = "AT+FTM=" + n;
        if (!this.sendATCommandnoWait(string)) {
            return false;
        }
        return this.waitForOK("CONNECT", false);
    }

    protected boolean sendTraining() {
        this.sendATCommand("AT+FTS=7");
        if (!this.sendClass1FTM(this.cap.rate)) {
            return false;
        }
        try {
            if (this.flowControl == 1) {
                this.add.setFlowControlMode(8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = new byte[(int)((double)(this.cap.rate * 100 / 8) * TRAINING_SECONDS) + 1];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
        byArray[byArray.length - 1] = 1;
        this.sendBytes(byArray, byArray.length);
        byte[] byArray2 = new byte[]{16, 3};
        this.sendBytes(byArray2, byArray2.length);
        try {
            if (this.flowControl == 1) {
                this.add.setFlowControlMode(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.waitFor("OK");
    }

    protected boolean sendATCommand(String string) {
        if (string.trim().length() == 0) {
            return true;
        }
        if (this.sendATCommandnoWait(string)) {
            return this.waitFor("OK");
        }
        return false;
    }

    public void deleteFaxFiles() {
        int n = 0;
        while (n < this.pages) {
            File file = new File(this.faxFile + "." + n);
            file.delete();
            ++n;
        }
    }
}

