/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.datasource;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.DataSchemaObjectType;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JDataField;
import com.jinfonet.dataservice.api.schema.relational.JRelationModel;
import com.jinfonet.dataservice.schema.ASchemaObject;
import jet.dataengine.api.DSException;

public abstract class ADataField
extends ASchemaObject
implements JDataField,
JAttribute {
    protected int encodingType;
    protected int fieldMappingType = 1;
    protected boolean foreignKey = false;
    protected boolean primaryKey = false;
    protected int toEncodingType = -1;
    protected int useEncodingType = -1;

    public ADataField(String string) throws DSException {
        super(string, DataSchemaObjectType.DATAFIELD);
        this.aliasName = string;
    }

    public void dump() {
        super.dump();
        this.log.debug("fieldMappingType: " + this.getFieldMappingType());
        this.log.debug("isPrimaryKey: " + this.isPrimaryKey());
        this.log.debug("isForeignKey: " + this.isForeignKey());
        ADataField aDataField = this;
        this.log.debug("JAttribute:AttributeName: " + aDataField.getAttributeName());
        this.log.debug("JAttribute:DataType: " + aDataField.getDataType());
        this.log.debug("JAttribute:Length: " + aDataField.getLength());
        this.log.debug("JAttribute:Precision: " + aDataField.getPrecision());
        this.log.debug("JAttribute:Scale: " + aDataField.getScale());
    }

    public String getAttributeName() {
        String string = this.getQualifyName();
        return string.replace('.', '_');
    }

    public int getFieldMappingType() {
        return this.fieldMappingType;
    }

    public int getFromEncoding() {
        return this.encodingType;
    }

    public JRelationModel getRecordModel() {
        return (JRelationModel)super.getContainer();
    }

    public int getToEncoding() {
        return this.toEncodingType;
    }

    public String getTypeName() {
        return Types.getDataTypeName(this.getDataType());
    }

    public int getUseEncodingType() {
        return this.useEncodingType;
    }

    public boolean isForeignKey() {
        return this.foreignKey;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setCaseSensitive(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void setDataType(int n) {
        throw new UnsupportedOperationException();
    }

    public void setForeignKey(boolean bl) {
        this.foreignKey = bl;
    }

    public void setFromEncoding(int n) {
        this.encodingType = n;
    }

    public void setIsCurrency(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void setIsNullable(int n) {
        throw new UnsupportedOperationException();
    }

    public void setLength(int n) {
        throw new UnsupportedOperationException();
    }

    public void setPrecision(int n) {
        throw new UnsupportedOperationException();
    }

    public void setPrimaryKey(boolean bl) {
        this.primaryKey = bl;
    }

    public void setScale(int n) {
        throw new UnsupportedOperationException();
    }

    public void setToEncoding(int n) {
        this.toEncodingType = n;
    }

    public void setUseEncodingType(int n) {
        this.useEncodingType = n;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isConstant() {
        return false;
    }

    public Object getConstant() {
        return null;
    }

    public void setConstant(Object object) {
    }
}

