/*
 * Decompiled with CFR 0.152.
 */
package jet.acl;

import java.util.HashMap;
import java.util.Vector;
import jet.acl.AclTools;
import jet.acl.JetPrincipal;
import jet.controls.JetBoolean;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.cs.jacl.BaseGroup;

public class JetGroup
extends JetPrincipal
implements BaseGroup {
    private JetString QOIV;
    private JetString addString;
    private JetVector afterInit;
    private JetVector clone;
    private JetVector equals;
    private JetVector get;
    private JetBoolean getGroupName;
    private int getLength = -1;
    private static final HashMap getParentGroups = new HashMap(7);

    public JetGroup() {
        this.QOIV();
    }

    public String getGroupName() {
        return this.QOIV.get();
    }

    public void setGroupName(String string) {
        this.QOIV.set(string);
    }

    public boolean isAdminGroup() {
        return this.getGroupName.get();
    }

    public void setAdminGroup(boolean bl) {
        this.getGroupName.set(bl);
    }

    public Vector getUsers() {
        return this.afterInit.get();
    }

    public void setUsers(Vector vector) {
        AclTools.setStrings(this.afterInit, vector);
    }

    public Vector getRoles() {
        return this.clone.get();
    }

    public void setRoles(Vector vector) {
        AclTools.setStrings(this.clone, vector);
    }

    public Vector getParentGroups() {
        return this.equals.get();
    }

    public void setParentGroups(Vector vector) {
        AclTools.setStrings(this.equals, vector);
    }

    public Vector getSubGroups() {
        return this.get.get();
    }

    public void setSubGroups(Vector vector) {
        AclTools.setStrings(this.get, vector);
    }

    public String getName() {
        return this.getGroupName();
    }

    public void setName(String string) {
        this.setGroupName(string);
    }

    public boolean equalsTo(JetPrincipal jetPrincipal) {
        if (!(jetPrincipal instanceof JetGroup)) {
            return false;
        }
        JetGroup jetGroup = (JetGroup)jetPrincipal;
        return this.isAdminGroup() == jetGroup.isAdminGroup() && this.getSourceType() == jetGroup.getSourceType() && this.getGroupName().equals(jetGroup.getGroupName()) && this.getUsers().toString().equals(jetGroup.getUsers().toString()) && this.getRoles().toString().equals(jetGroup.getRoles().toString()) && this.getParentGroups().toString().equals(jetGroup.getParentGroups().toString()) && this.getSubGroups().toString().equals(jetGroup.getSubGroups().toString());
    }

    public int getSourceType() {
        return this.getLength;
    }

    public void setSourceType(int n) {
        this.getLength = n;
        this.addString.set(this.getSourceName(n));
    }

    public Vector getRoleNames() {
        return this.getRoles();
    }

    public boolean isFromServer() {
        return this.getSourceType() == 1;
    }

    public Vector getParentGroupNames() {
        return this.getParentGroups();
    }

    public Vector getUserNames() {
        return this.getUsers();
    }

    public Vector getSubGroupNames() {
        return this.getSubGroups();
    }

    public boolean isHaveRole(String string) {
        return AclTools.isHaveString(this.clone, string);
    }

    public void addRole(String string) {
        AclTools.addString(this.clone, string);
    }

    public void removeRole(String string) {
        AclTools.removeString(this.clone, string);
    }

    public int getRolesCount() {
        return AclTools.getLength(this.clone);
    }

    public boolean isHaveParentGroup(String string) {
        return AclTools.isHaveString(this.equals, string);
    }

    public void addParentGroup(String string) {
        AclTools.addString(this.equals, string);
    }

    public void removeParentGroup(String string) {
        AclTools.removeString(this.equals, string);
    }

    public int getParentGroupsCount() {
        return AclTools.getLength(this.equals);
    }

    public void addUser(String string) {
        AclTools.addString(this.afterInit, string);
    }

    public void removeUser(String string) {
        AclTools.removeString(this.afterInit, string);
    }

    public boolean isHaveUser(String string) {
        return AclTools.isHaveString(this.afterInit, string);
    }

    public int getUsersCount() {
        return AclTools.getLength(this.afterInit);
    }

    public void addSubGroup(String string) {
        AclTools.addString(this.get, string);
    }

    public void removeSubGroup(String string) {
        AclTools.removeString(this.get, string);
    }

    public boolean isHaveSubGroup(String string) {
        return AclTools.isHaveString(this.get, string);
    }

    public int getSubGroupsCount() {
        return AclTools.getLength(this.get);
    }

    public String getInstancePrefix() {
        return "Group";
    }

    public void afterInit() {
        super.afterInit();
        this.getLength = this.getSourceType(this.addString.get());
    }

    public Object clone() {
        JetGroup jetGroup = new JetGroup();
        jetGroup.setGroupName(this.getGroupName());
        jetGroup.setAdminGroup(this.isAdminGroup());
        jetGroup.setSourceType(this.getSourceType());
        jetGroup.setUsers(this.getUsers());
        jetGroup.setRoles(this.getRoles());
        jetGroup.setParentGroups(this.getParentGroups());
        jetGroup.setSubGroups(this.getSubGroups());
        return jetGroup;
    }

    public JetGroup copy() {
        return (JetGroup)this.clone();
    }

    public HashMap getIndecialMap() {
        return getParentGroups;
    }

    private void QOIV() {
        this.QOIV = new JetString(this, "GroupName");
        this.addString = new JetString(this, "SourceName");
        this.afterInit = new JetVector(this, "Users");
        this.clone = new JetVector(this, "Roles");
        this.equals = new JetVector(this, "ParentGroups");
        this.get = new JetVector(this, "SubGroups");
        this.getGroupName = new JetBoolean(this, "IsReportAdminGroup");
    }

    static {
        int n = 0;
        getParentGroups.put("IsReportAdminGroup", new Integer(n++));
        getParentGroups.put("Roles", new Integer(n++));
        getParentGroups.put("SubGroups", new Integer(n++));
        getParentGroups.put("ParentGroups", new Integer(n++));
        getParentGroups.put("GroupName", new Integer(n++));
        getParentGroups.put("Users", new Integer(n++));
        getParentGroups.put("SourceName", new Integer(n++));
    }
}

