/*
 * Decompiled with CFR 0.152.
 */
package jet.client.connector;

import guitools.toolkit.JDebug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import jet.JCliResource;
import jet.client.api.APIUtil;
import jet.client.api.JRClient;
import jet.client.api.JRResponseException;
import jet.cs.CSUtil;
import jet.cs.secinfo.SecInfoXMLReader;
import org.xml.sax.SAXException;

public class ClientConnector {
    public String urlstr = "";
    public HttpURLConnection connection;
    protected String address = "";
    private String QOIV = "";

    public ClientConnector(String string, String string2, String string3, String string4) throws MalformedURLException, IOException, JRResponseException {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if (string2 == null) {
            string2 = "";
        } else if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        this.address = string + string2;
        JRClient.setNoLoginDialog(true);
        JRClient.login(null, this.address, string3, string4);
    }

    public Vector[] getUsersAndRolesInfo() throws ParserConfigurationException, SAXException, IOException, JRResponseException {
        this.QOIV = "jrs.get.securityInfo";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.address);
        if (this.QOIV != null) {
            stringBuffer.append("?").append("jrs.cmd").append("=").append(this.QOIV);
        }
        this.urlstr = stringBuffer.toString();
        this.connection = (HttpURLConnection)JRClient.openConnection(null, this.urlstr);
        APIUtil.checkResponseOK(this.connection);
        SecInfoXMLReader secInfoXMLReader = new SecInfoXMLReader();
        secInfoXMLReader.ReaderInputStream(this.connection.getInputStream());
        Vector[] vectorArray = secInfoXMLReader.getUsersAndRoles();
        JRClient.close(this.connection);
        return vectorArray;
    }

    public void deploy(String string, Vector vector) throws ConnectException, IOException, Exception {
        if (vector != null && vector.size() > 0) {
            this.QOIV(string);
            this.ReaderInputStream(CSUtil.replWithEsc(string, false), vector);
            this.WARNING(string);
        }
    }

    private void QOIV(String string) throws ConnectException, Exception {
        StringBuffer stringBuffer = new StringBuffer(this.address);
        stringBuffer.append(string).append("?").append("jrs.cmd").append("=").append("jrs.test_before_deploycat");
        URLConnection uRLConnection = JRClient.openConnection(null, stringBuffer.toString());
        if (uRLConnection == null) {
            throw new ConnectException(JCliResource.getError("JViewer.ClientConnector_E_00100", (Object[])new String[]{this.address, string, stringBuffer.toString()}));
        }
        if (uRLConnection.getHeaderField("Resource") != null) {
            throw new Exception(JCliResource.getError("JViewer.ClientConnector_E_00200", null) + uRLConnection.getHeaderField("Resource"));
        }
        JRClient.close(uRLConnection);
    }

    private void ReaderInputStream(String string, Vector vector) throws IOException, Exception {
        HttpURLConnection httpURLConnection = null;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            OutputStream outputStream;
            String string2 = (String)vector.elementAt(n2);
            String string3 = string + CSUtil.replWithEsc(string2.substring(string2.lastIndexOf(File.separator) + 1));
            httpURLConnection = this.close(this.address + string3);
            if (httpURLConnection != null && (outputStream = httpURLConnection.getOutputStream()) != null && !this.checkResponseOK(httpURLConnection, outputStream, new File(string2))) {
                throw new IOException(JCliResource.getError("JViewer.ClientConnector_E_00300", (Object[])new String[]{string2}));
            }
            ++n2;
        }
        JRClient.close(httpURLConnection);
    }

    private void WARNING(String string) throws IOException, JRResponseException {
        StringBuffer stringBuffer = new StringBuffer(this.address);
        stringBuffer.append(string).append("?").append("jrs.cmd").append("=").append("jrs.after_deployfiles");
        URLConnection uRLConnection = JRClient.openConnection(null, stringBuffer.toString());
        if (uRLConnection == null) {
            throw new ConnectException(JCliResource.getError("JViewer.ClientConnector_E_00100", (Object[])new String[]{this.address, string, stringBuffer.toString()}));
        }
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean address(HttpURLConnection httpURLConnection) throws Exception {
        InputStream inputStream = null;
        boolean bl = false;
        int n = httpURLConnection.getResponseCode();
        if (n != 200) {
            throw new Exception(JCliResource.getError("JViewer.ClientConnector_E_00400", (Object[])new String[]{String.valueOf(n), httpURLConnection.getResponseMessage()}));
        }
        try {
            inputStream = httpURLConnection.getInputStream();
            Hashtable hashtable = this.append(inputStream, 1);
            String string = (String)hashtable.get("rc");
            if (string.equals("1")) {
                bl = true;
            }
            Object var8_7 = null;
            if (inputStream == null) return bl;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                JDebug.WARNING(iOException);
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return bl;
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
        }
        return bl;
    }

    private Hashtable append(InputStream inputStream, int n) throws IOException {
        String string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while (null != (string = bufferedReader.readLine())) {
            int n2 = string.indexOf("=");
            if (n2 == -1) continue;
            hashtable.put(string.substring(0, n2), string.substring(n2 + 1));
        }
        return hashtable;
    }

    private boolean checkResponseOK(HttpURLConnection httpURLConnection, OutputStream outputStream, File file) throws IOException, Exception {
        int n;
        int n2 = 8192;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[n2];
        while ((n = fileInputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        outputStream.close();
        return this.address(httpURLConnection);
    }

    private HttpURLConnection close(String string) {
        HttpURLConnection httpURLConnection;
        try {
            httpURLConnection = (HttpURLConnection)JRClient.getConnection(new URL(string));
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/x-jreport-deploy-file");
            httpURLConnection.setDoOutput(true);
        }
        catch (Exception exception) {
            return null;
        }
        return httpURLConnection;
    }
}

