/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbColumn;
import jet.connect.DbValue;

public abstract class DbColumnBuffer
extends DbColumn {
    static byte getNullable = (byte)2;
    protected byte[] flags;
    int isNull;

    public DbColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc);
        this.isNull = n;
        this.flags = new byte[n];
    }

    protected abstract void writeValueToFile(DataOutput var1) throws IOException;

    protected abstract void readValueFromFile(DataInput var1) throws IOException;

    public final void updateValue(int n, DbValue dbValue) {
        if (!dbValue.isNull()) {
            int n2 = n;
            this.flags[n2] = (byte)(this.flags[n2] | DbColumn.Z);
            this.updateCell(n, dbValue);
        } else {
            int n3 = n;
            this.flags[n3] = (byte)(this.flags[n3] & ~DbColumn.Z);
        }
        int n4 = n;
        this.flags[n4] = (byte)(this.flags[n4] | getNullable);
    }

    public final void refreshValue(int n, DbValue dbValue) {
        if (this.C.getNullable() != 0 && this.isNull(n)) {
            dbValue.setNull();
        } else {
            this.refreshFromCell(n, dbValue);
        }
    }

    public final boolean isNull(int n) {
        return (this.flags[n] & DbColumn.Z) != DbColumn.Z;
    }

    public final boolean isReady(int n) {
        return (this.flags[n] & getNullable) == getNullable;
    }

    public void reset() {
        int n = 0;
        while (n < this.flags.length) {
            this.flags[n] = 0;
            ++n;
        }
    }

    public final void writeToFile(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.flags);
        this.writeValueToFile(dataOutput);
    }

    public final void readFromFile(DataInput dataInput) throws IOException {
        dataInput.readFully(this.flags);
        this.readValueFromFile(dataInput);
    }

    public void clearMem() {
        super.clearMem();
        this.flags = null;
    }
}

