/*
 * Decompiled with CFR 0.152.
 */
package jet.css;

import com.jinfonet.css.regularlib.RegulationV8ValidateKit;
import com.jinfonet.css.sac.impl.parser.JCSSDOMParser;
import com.jinfonet.css.util.W3CStyleSheetConvert;
import com.jinfonet.css.util.XSDStyleConvert;
import com.jinfonet.dom.css.JCSSProperty;
import com.jinfonet.dom.css.JCSSRuleList;
import com.jinfonet.dom.css.JCSSStyleDeclaration;
import com.jinfonet.dom.css.JCSSStyleRule;
import com.jinfonet.dom.css.JCSSStyleSheet;
import com.jinfonet.dom.css.JMediaList;
import com.jinfonet.dom.css.impl.JCSSMediaRuleImpl;
import com.jinfonet.dom.css.impl.JCSSRuleListImpl;
import com.jinfonet.dom.css.impl.JCSSStyleRuleImpl;
import com.jinfonet.dom.css.impl.JMediaListImpl;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.ReportEnv;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.css.CSSHandler;
import jet.css.JCSSException;
import jet.report.JetRptObject;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptReport;
import jet.universe.JetUStyleGroup;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.xml.sax.SAXException;

public class CssStyleSheetManager {
    static JCSSDOMParser QOIV = null;
    static CssStyleSheetManager add = null;
    private W3CStyleSheetConvert addAll = null;
    private XSDStyleConvert addAndMerge = null;
    private static Hashtable addRuleList = new Hashtable();
    private static Hashtable append = new Hashtable();
    private static Hashtable compareTo = new Hashtable();
    public static final int GET_CLASSCONDITION = 9;
    public static final int GET_IDCONDITION = 5;
    public static final String STYLEGROUP_TAG = "*";
    public static final String CSSSTYLE_TAG = "<CSS>";
    public static final String NONE_STYLEUSE = "None";

    CssStyleSheetManager() {
        QOIV = JCSSDOMParser.newInstance();
    }

    protected static CssStyleSheetManager getCSSStyleSheetManager() {
        if (add == null) {
            add = new CssStyleSheetManager();
        }
        return add;
    }

    public synchronized void refreshCSSStyleSheet(String string) {
        File file = new File(string);
        if (append.containsKey(file)) {
            long l = file.lastModified();
            CSSStyleSheet cSSStyleSheet = null;
            if (CssStyleSheetManager.add(string)) {
                try {
                    cSSStyleSheet = QOIV.parseStyleSheet(new InputSource((Reader)new FileReader(string)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    JRLog.error(2, 2205006, string);
                }
                catch (IOException iOException) {
                    JRLog.error(2, 2205003);
                }
                if (cSSStyleSheet != null) {
                    cSSStyleSheet = this.expanedCSSStyleSheet(cSSStyleSheet);
                    RegulationV8ValidateKit.regulationValidate(cSSStyleSheet);
                    append.put(file, cSSStyleSheet);
                    compareTo.put(file, new Long(l));
                }
            } else if (CssStyleSheetManager.addAll(string)) {
                if (this.addAndMerge == null) {
                    this.addAndMerge = XSDStyleConvert.newInstance();
                }
                try {
                    cSSStyleSheet = this.addAndMerge.convertToCssStyleSheet(string);
                }
                catch (SAXException sAXException) {
                    JRLog.error(2, 2205005, sAXException.getMessage());
                }
                catch (IOException iOException) {
                    JRLog.error(2, 2205004, iOException.getMessage());
                }
                if (cSSStyleSheet != null) {
                    append.put(file, cSSStyleSheet);
                    compareTo.put(file, new Long(l));
                }
            } else {
                JRLog.error(2, 2205006, string);
            }
        }
        if (addRuleList.containsKey(file)) {
            CSSStyleSheet cSSStyleSheet = (CSSStyleSheet)append.get(file);
            CSSHandler cSSHandler = new CSSHandler(cSSStyleSheet.getCssRules());
            addRuleList.put(file, cSSHandler);
        }
    }

    public CSSStyleSheet getCSSStyleSheet(String string) {
        File file = new File(string);
        if (CssStyleSheetManager.add(string)) {
            JRLog.trace(6, 6205028, new String[]{string});
            CSSStyleSheet cSSStyleSheet = (CSSStyleSheet)append.get(file);
            long l = file.lastModified();
            Long l2 = (Long)compareTo.get(file);
            if (cSSStyleSheet == null || l > l2) {
                try {
                    cSSStyleSheet = QOIV.parseStyleSheet(new InputSource((Reader)new FileReader(string)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    JRLog.error(2, 2205006, string);
                }
                catch (IOException iOException) {
                    JRLog.error(2, 2205003);
                }
                if (cSSStyleSheet != null) {
                    JRLog.trace(6, 6205029);
                    cSSStyleSheet = this.expanedCSSStyleSheet(cSSStyleSheet);
                    JRLog.trace(6, 6205030);
                    RegulationV8ValidateKit.regulationValidate(cSSStyleSheet);
                    append.put(file, cSSStyleSheet);
                    compareTo.put(file, new Long(l));
                }
            }
            JRLog.trace(6, 6205031, new String[]{string});
            return cSSStyleSheet;
        }
        if (CssStyleSheetManager.addAll(string)) {
            JRLog.trace(6, 6205032, new String[]{string});
            CSSStyleSheet cSSStyleSheet = (CSSStyleSheet)append.get(file);
            long l = file.lastModified();
            Long l3 = (Long)compareTo.get(file);
            if (cSSStyleSheet == null || l > l3) {
                if (this.addAndMerge == null) {
                    this.addAndMerge = XSDStyleConvert.newInstance();
                }
                try {
                    JRLog.trace(6, 6205033);
                    cSSStyleSheet = this.addAndMerge.convertToCssStyleSheet(string);
                }
                catch (SAXException sAXException) {
                    JRLog.error(2, 2205005, sAXException.getMessage());
                }
                catch (IOException iOException) {
                    JRLog.error(2, 2205004, iOException.getMessage());
                }
                if (cSSStyleSheet != null) {
                    append.put(file, cSSStyleSheet);
                    compareTo.put(file, new Long(l));
                }
            }
            JRLog.trace(6, 6205034, new String[]{string});
            return cSSStyleSheet;
        }
        JRLog.error(2, 2205006, string);
        return null;
    }

    public Collection getConditionTagFromStyleSheet(CSSStyleSheet cSSStyleSheet, int n) {
        if (n == 9 || n == 5) {
            if (this.addAll == null) {
                this.addAll = new W3CStyleSheetConvert();
            }
            if (!(cSSStyleSheet instanceof JCSSStyleSheet)) {
                cSSStyleSheet = this.addAll.convertW3CStyleSheet(cSSStyleSheet);
                cSSStyleSheet = this.expanedCSSStyleSheet(cSSStyleSheet);
                cSSStyleSheet = RegulationV8ValidateKit.regulationValidate(cSSStyleSheet);
            }
            CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
            Vector vector = new Vector();
            if (cSSRuleList != null) {
                List list = this.addAndMerge(cSSRuleList);
                int n2 = list.size();
                int n3 = 0;
                while (n3 < n2) {
                    ConditionalSelector conditionalSelector = (ConditionalSelector)list.get(n3);
                    Condition condition = conditionalSelector.getCondition();
                    if (condition.getConditionType() == n) {
                        this.addRuleList(vector, ((AttributeCondition)condition).getValue());
                    }
                    ++n3;
                }
                return vector;
            }
        } else {
            JRLog.error(3, 3205022, "invalidate get tag");
        }
        return new Vector();
    }

    public Collection getDeclarationsFromStyleSheet(CSSStyleSheet cSSStyleSheet, JetRptObject jetRptObject) {
        if (this.addAll == null) {
            this.addAll = new W3CStyleSheetConvert();
        }
        if (!(cSSStyleSheet instanceof JCSSStyleSheet)) {
            cSSStyleSheet = this.addAll.convertW3CStyleSheet(cSSStyleSheet);
            cSSStyleSheet = this.expanedCSSStyleSheet(cSSStyleSheet);
            cSSStyleSheet = RegulationV8ValidateKit.regulationValidate(cSSStyleSheet);
        }
        CSSHandler cSSHandler = new CSSHandler(cSSStyleSheet.getCssRules());
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = cSSHandler.getDeclareations(jetRptObject).toArray();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof JCSSProperty) {
                vector.add(objectArray[n].toString());
            } else if (objectArray[n] instanceof JetProperty) {
                String string = ((JetProperty)objectArray[n]).getName();
                vector.add(string + ":" + objectArray[n].toString());
            }
            ++n;
        }
        return vector;
    }

    public Hashtable getDeclarationModifyedFromStyleSheet(CSSStyleSheet cSSStyleSheet, JetRptObject jetRptObject, boolean bl) {
        if (this.addAll == null) {
            this.addAll = new W3CStyleSheetConvert();
        }
        if (!(cSSStyleSheet instanceof JCSSStyleSheet)) {
            cSSStyleSheet = this.addAll.convertW3CStyleSheet(cSSStyleSheet);
            cSSStyleSheet = this.expanedCSSStyleSheet(cSSStyleSheet);
            cSSStyleSheet = RegulationV8ValidateKit.regulationValidate(cSSStyleSheet);
        }
        CSSHandler cSSHandler = new CSSHandler(cSSStyleSheet.getCssRules());
        Hashtable hashtable = new Hashtable();
        if (jetRptObject instanceof JetRptReport) {
            this.QOIV(hashtable, "", cSSHandler, jetRptObject, bl, true);
        } else {
            this.QOIV(hashtable, "", cSSHandler, jetRptObject, bl, false);
        }
        return hashtable;
    }

    public Collection getConditionTagFromStyleSheet(String string, int n) {
        if (n == 9 || n == 5) {
            if (CssStyleSheetManager.add(string) || CssStyleSheetManager.addAll(string)) {
                CSSStyleSheet cSSStyleSheet = this.getCSSStyleSheet(string);
                Vector vector = new Vector();
                if (cSSStyleSheet != null) {
                    List list = this.addAndMerge(cSSStyleSheet.getCssRules());
                    int n2 = list.size();
                    int n3 = 0;
                    while (n3 < n2) {
                        ConditionalSelector conditionalSelector = (ConditionalSelector)list.get(n3);
                        Condition condition = conditionalSelector.getCondition();
                        if (condition.getConditionType() == n) {
                            this.addRuleList(vector, ((AttributeCondition)condition).getValue());
                        }
                        ++n3;
                    }
                }
                return vector;
            }
            JRLog.error(2, 2205006);
            return new Vector();
        }
        JRLog.error(3, 3205022, "invalidate get type");
        return new Vector();
    }

    public Collection getDeclarationsFromStyleSheet(String string, JetRptObject jetRptObject) {
        if (CssStyleSheetManager.add(string) || CssStyleSheetManager.addAll(string)) {
            Object object;
            File file = new File(string);
            CSSHandler cSSHandler = (CSSHandler)addRuleList.get(file);
            long l = file.lastModified();
            Long l2 = (Long)compareTo.get(file);
            if (cSSHandler == null || l > l2) {
                object = this.getCSSStyleSheet(string);
                if (object != null && object.getCssRules().getLength() > 0) {
                    cSSHandler = new CSSHandler(object.getCssRules());
                    addRuleList.put(file, cSSHandler);
                } else {
                    JRLog.error(2, 3205022, string);
                    return new Vector();
                }
            }
            object = new Vector();
            Object[] objectArray = cSSHandler.getDeclareations(jetRptObject).toArray();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof JCSSProperty) {
                    object.add(objectArray[n].toString());
                } else if (objectArray[n] instanceof JetProperty) {
                    String string2 = ((JetProperty)objectArray[n]).getName();
                    object.add(string2 + ":" + objectArray[n].toString());
                }
                ++n;
            }
            return object;
        }
        JRLog.error(2, 2205006, string);
        return new Vector();
    }

    public Hashtable getDeclarationModifyedFromStyleSheet(String string, JetRptObject jetRptObject, boolean bl) throws JCSSException {
        if (CssStyleSheetManager.add(string) || CssStyleSheetManager.addAll(string)) {
            Object object;
            File file = new File(string);
            CSSHandler cSSHandler = (CSSHandler)addRuleList.get(file);
            long l = file.lastModified();
            Long l2 = (Long)compareTo.get(file);
            if (cSSHandler == null || l > l2) {
                object = this.getCSSStyleSheet(string);
                if (object != null) {
                    cSSHandler = new CSSHandler(object.getCssRules());
                    addRuleList.put(file, cSSHandler);
                    if (object.getCssRules().getLength() == 0) {
                        return new Hashtable();
                    }
                } else {
                    throw new JCSSException(210502);
                }
            }
            object = new Hashtable();
            if (jetRptObject instanceof JetRptReport) {
                this.QOIV((Hashtable)object, string, cSSHandler, jetRptObject, bl, true);
            } else {
                this.QOIV((Hashtable)object, string, cSSHandler, jetRptObject, bl, false);
            }
            return object;
        }
        JRLog.error(2, 2205006, string);
        throw new JCSSException(210501, new String[]{string}, null);
    }

    public Hashtable getDeclarationModifyedFromStyleSheet(Reader reader, JetRptObject jetRptObject, boolean bl) throws JCSSException {
        CSSStyleSheet cSSStyleSheet = null;
        try {
            cSSStyleSheet = QOIV.parseStyleSheet(new InputSource(reader));
        }
        catch (IOException iOException) {
            JRLog.error(2, 2205003, iOException.getMessage());
            throw new JCSSException(210502);
        }
        if (cSSStyleSheet != null) {
            Hashtable hashtable = new Hashtable();
            cSSStyleSheet = this.expanedCSSStyleSheet(cSSStyleSheet);
            if ((cSSStyleSheet = RegulationV8ValidateKit.regulationValidate(cSSStyleSheet)).getCssRules().getLength() > 0) {
                CSSHandler cSSHandler = new CSSHandler(cSSStyleSheet.getCssRules());
                if (jetRptObject instanceof JetRptReport) {
                    this.QOIV(hashtable, "", cSSHandler, jetRptObject, bl, true);
                } else {
                    this.QOIV(hashtable, "", cSSHandler, jetRptObject, bl, false);
                }
            }
            return hashtable;
        }
        throw new JCSSException(210502);
    }

    private synchronized void QOIV(Hashtable hashtable, String string, CSSHandler cSSHandler, JetRptObject jetRptObject, boolean bl, boolean bl2) {
        Object object;
        String string2;
        Object[] objectArray = cSSHandler.getDeclareations(jetRptObject).toArray();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof JCSSProperty) {
                JetProperty jetProperty;
                string2 = ((JCSSProperty)objectArray[n]).getName();
                object = this.covertCssValueToString(((JCSSProperty)objectArray[n]).getValue());
                int n2 = ((String)object).indexOf(33);
                if (n2 > 0) {
                    object = ((String)object).substring(0, n2).trim();
                }
                if ((jetProperty = jetRptObject.nameToProperty(string2)) != null) {
                    hashtable.put(jetProperty, object);
                }
            } else if (objectArray[n] instanceof JetProperty) {
                string2 = ((JetProperty)objectArray[n]).getName();
                object = objectArray[n].toString();
                JetProperty jetProperty = jetRptObject.nameToProperty(string2);
                if (jetProperty != null) {
                    hashtable.put(jetProperty, object);
                }
            }
            ++n;
        }
        string2 = new File(string).getName();
        if (jetRptObject instanceof JetRptReport) {
            object = ((JetRptReport)jetRptObject).getCurrentViewObject().nameToProperty("CSSFileName");
            hashtable.put(object, string2);
        }
        if (bl && jetRptObject instanceof JetContainable) {
            object = (JetContainable)((Object)jetRptObject);
            Vector vector = object.getChildren();
            int n3 = 0;
            while (n3 < vector.size()) {
                JetObject jetObject = (JetObject)vector.get(n3);
                if (jetObject instanceof JetRptObject && (!ObjectLogicFactory.getViewLogic().isApplyStyleObject((JetRptObject)jetObject) || jetObject instanceof JetRptReport || ObjectLogicFactory.getViewLogic().isStyleInherit(jetObject) || bl2)) {
                    this.QOIV(hashtable, string, cSSHandler, (JetRptObject)jetObject, true, bl2);
                }
                ++n3;
            }
        }
    }

    public CSSHandler getHandlerOfCssFile(String string) {
        if (CssStyleSheetManager.add(string) || CssStyleSheetManager.addAll(string)) {
            File file = new File(string);
            CSSHandler cSSHandler = (CSSHandler)addRuleList.get(file);
            long l = file.lastModified();
            Long l2 = (Long)compareTo.get(file);
            if (cSSHandler == null || l > l2) {
                CSSStyleSheet cSSStyleSheet = this.getCSSStyleSheet(string);
                if (cSSStyleSheet != null && cSSStyleSheet.getCssRules().getLength() > 0) {
                    cSSHandler = new CSSHandler(cSSStyleSheet.getCssRules());
                    addRuleList.put(file, cSSHandler);
                } else {
                    JRLog.error(2, 3205022, string);
                }
            }
            return cSSHandler;
        }
        JRLog.error(2, 2205006, string);
        return null;
    }

    public CSSHandler getHandlerOfStyleGroup(JetUStyleGroup jetUStyleGroup) {
        CSSStyleSheet cSSStyleSheet;
        if (this.addAndMerge == null) {
            this.addAndMerge = XSDStyleConvert.newInstance();
        }
        if ((cSSStyleSheet = this.addAndMerge.convertToCssStyleSheet(jetUStyleGroup)).getCssRules().getLength() > 0) {
            return new CSSHandler(cSSStyleSheet.getCssRules());
        }
        return null;
    }

    public CSSHandler getHandlerOfReader(Reader reader) {
        CSSStyleSheet cSSStyleSheet = null;
        try {
            cSSStyleSheet = QOIV.parseStyleSheet(new InputSource(reader));
        }
        catch (IOException iOException) {
            JRLog.error(2, 2205007, iOException.getMessage());
            return null;
        }
        if (cSSStyleSheet != null) {
            cSSStyleSheet = this.expanedCSSStyleSheet(cSSStyleSheet);
            if ((cSSStyleSheet = RegulationV8ValidateKit.regulationValidate(cSSStyleSheet)).getCssRules().getLength() > 0) {
                return new CSSHandler(cSSStyleSheet.getCssRules());
            }
            JRLog.error(2, 2205007, "No suported StyleRule");
            return null;
        }
        JRLog.error(2, 2205007, "No suported StyleRule");
        return null;
    }

    private static boolean add(String string) {
        return string.toLowerCase().endsWith(".css");
    }

    private static boolean addAll(String string) {
        return string.toLowerCase().endsWith("_stl.xsd");
    }

    private List addAndMerge(CSSRuleList cSSRuleList) {
        Vector<Object> vector = new Vector<Object>();
        int n = cSSRuleList.getLength();
        int n2 = 0;
        while (n2 < n) {
            CSSRule cSSRule = cSSRuleList.item(n2);
            if (cSSRule.getType() == 1) {
                CSSStyleRule cSSStyleRule = (CSSStyleRule)cSSRule;
                SelectorList selectorList = ((JCSSStyleRule)cSSStyleRule).getSelectors();
                int n3 = 0;
                while (n3 < selectorList.getLength()) {
                    SimpleSelector simpleSelector;
                    Selector selector = selectorList.item(n3);
                    if (selector.getSelectorType() == 0) {
                        vector.add(selector);
                    } else if (selector.getSelectorType() == 12) {
                        simpleSelector = ((SiblingSelector)selector).getSiblingSelector();
                        if (simpleSelector.getSelectorType() == 0) {
                            vector.add(simpleSelector);
                        }
                    } else if ((selector.getSelectorType() == 11 || selector.getSelectorType() == 10) && (simpleSelector = ((DescendantSelector)selector).getSimpleSelector()).getSelectorType() == 0) {
                        vector.add(simpleSelector);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return vector;
    }

    private Collection addRuleList(Collection collection, String string) {
        if (!collection.contains(string)) {
            collection.add(string);
        }
        return collection;
    }

    protected CSSStyleSheet expanedCSSStyleSheet(CSSStyleSheet cSSStyleSheet) {
        CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
        JCSSRuleListImpl jCSSRuleListImpl = new JCSSRuleListImpl();
        int n = 0;
        while (n < cSSRuleList.getLength()) {
            CSSRule cSSRule = cSSRuleList.item(n);
            switch (cSSRule.getType()) {
                case 2: {
                    break;
                }
                case 3: {
                    CSSStyleSheet cSSStyleSheet2 = ((CSSImportRule)cSSRule).getStyleSheet();
                    if (cSSStyleSheet2 == null) break;
                    CSSStyleSheet cSSStyleSheet3 = this.expanedCSSStyleSheet(cSSStyleSheet2);
                    jCSSRuleListImpl.addRuleList(cSSStyleSheet3.getCssRules(), false);
                    break;
                }
                case 4: {
                    this.compareTo(jCSSRuleListImpl, (CSSMediaRule)cSSRule);
                    break;
                }
                case 1: {
                    this.append(jCSSRuleListImpl, (CSSStyleRule)cSSRule);
                    break;
                }
                case 6: {
                    jCSSRuleListImpl.add(cSSRule);
                    break;
                }
            }
            ++n;
        }
        ((JCSSStyleSheet)cSSStyleSheet).setRuleList(jCSSRuleListImpl);
        return cSSStyleSheet;
    }

    private void append(JCSSRuleList jCSSRuleList, CSSStyleRule cSSStyleRule) {
        SelectorList selectorList = ((JCSSStyleRule)cSSStyleRule).getSelectors();
        JCSSStyleDeclaration jCSSStyleDeclaration = (JCSSStyleDeclaration)cSSStyleRule.getStyle();
        int n = selectorList.getLength();
        if (n == 1) {
            jCSSRuleList.addAndMerge(cSSStyleRule);
        } else {
            int n2 = n - 1;
            while (n2 >= 0) {
                JCSSStyleRuleImpl jCSSStyleRuleImpl = new JCSSStyleRuleImpl(cSSStyleRule.getParentStyleSheet(), cSSStyleRule.getParentRule(), selectorList.item(n2));
                jCSSStyleRuleImpl.setStyle(jCSSStyleDeclaration.duplate());
                jCSSRuleList.addAndMerge(jCSSStyleRuleImpl);
                --n2;
            }
        }
    }

    private void compareTo(JCSSRuleList jCSSRuleList, CSSMediaRule cSSMediaRule) {
        JCSSRuleList jCSSRuleList2 = (JCSSRuleList)cSSMediaRule.getCssRules();
        JCSSRuleList jCSSRuleList3 = null;
        if (jCSSRuleList2.getLength() == 1) {
            jCSSRuleList3 = jCSSRuleList2;
        } else {
            jCSSRuleList3 = new JCSSRuleListImpl();
            int n = 0;
            while (n < jCSSRuleList2.getLength()) {
                this.append(jCSSRuleList3, (JCSSStyleRule)jCSSRuleList2.item(n));
                ++n;
            }
        }
        JMediaList jMediaList = (JMediaList)cSSMediaRule.getMedia();
        int n = jMediaList.getLength();
        int n2 = 1;
        while (n2 < n) {
            String string = jMediaList.item(n2);
            jMediaList.deleteMedium(string);
            JMediaListImpl jMediaListImpl = new JMediaListImpl(string);
            JCSSMediaRuleImpl jCSSMediaRuleImpl = new JCSSMediaRuleImpl(cSSMediaRule.getParentStyleSheet(), cSSMediaRule.getParentRule(), jMediaListImpl);
            jCSSMediaRuleImpl.setRuleList(jCSSRuleList3.duplate());
            jCSSRuleList.add(jCSSMediaRuleImpl);
        }
        jCSSRuleList.add(cSSMediaRule);
    }

    protected String covertCssValueToString(CSSValue cSSValue) {
        CSSPrimitiveValue cSSPrimitiveValue;
        short s = cSSValue.getCssValueType();
        if (s == 1 && (s = (cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue).getPrimitiveType()) == 19) {
            return cSSPrimitiveValue.getStringValue();
        }
        return cSSValue.toString();
    }

    public static List getSupportStyleNameList() {
        String string = ReportEnv.stylePath != null ? ReportEnv.stylePath : System.getProperty("reporthome") + File.separator + "style";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        Vector<String> vector = new Vector<String>();
        vector.add(NONE_STYLEUSE);
        if (fileArray != null && fileArray.length > 0) {
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            int n = 0;
            while (n < fileArray.length) {
                String string2;
                String string3 = fileArray[n].getName();
                if (CssStyleSheetManager.add(string3)) {
                    string2 = string3.substring(0, string3.length() - ".css".length());
                    vector3.add(string2.concat(CSSSTYLE_TAG));
                } else if (CssStyleSheetManager.addAll(string3)) {
                    string2 = string3.substring(0, string3.length() - "_stl.xsd".length());
                    vector2.add(string2.concat(STYLEGROUP_TAG));
                }
                ++n;
            }
            vector.addAll(vector2);
        } else {
            JRLog.error(2, 2205024, file);
        }
        return vector;
    }

    public static String getSuportStyleFullPath(String string) {
        String string2;
        if (string.compareTo(NONE_STYLEUSE) == 0) {
            return null;
        }
        String string3 = "";
        string3 = string.endsWith(STYLEGROUP_TAG) ? string.substring(0, string.length() - STYLEGROUP_TAG.length()).concat("_stl.xsd") : string.substring(0, string.length() - CSSSTYLE_TAG.length()).concat(".css");
        String string4 = string2 = ReportEnv.stylePath != null ? ReportEnv.stylePath : System.getProperty("reporthome") + File.separator + "style";
        if (!string2.endsWith(File.separator)) {
            string2 = string2.concat(File.separator);
        }
        if (new File(string2 + string3).exists()) {
            return string2 + string3;
        }
        return null;
    }

    protected JCSSDOMParser getCSSDOMParser() {
        return QOIV;
    }

    protected void putFileToMdTm(File file, Long l) {
        compareTo.put(file, l);
    }

    protected void putFileToStyle(File file, CSSStyleSheet cSSStyleSheet) {
        append.put(file, cSSStyleSheet);
    }
}

