/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api.schema.olap;

import com.jinfonet.dataservice.api.schema.DataSchemaObjectType;
import com.jinfonet.dataservice.schema.ASchemaObjectContainer;
import java.util.HashMap;
import jet.dataengine.api.DSException;
import jet.dataengine.api.schema.olap.JCube;
import jet.dataengine.api.schema.olap.JCubeMetaData;
import jet.dataengine.api.schema.olap.metadata.JDetailInformation;
import jet.dataengine.api.schema.olap.metadata.JDimension;
import jet.dataengine.api.schema.olap.metadata.JMeasure;

public class CubeImpl
extends ASchemaObjectContainer
implements JCube {
    public CubeImpl(String string) throws DSException {
        super(string, DataSchemaObjectType.CUBE);
        this.addTypedNameSpace(DataSchemaObjectType.DIMENSION);
        this.addTypedNameSpace(DataSchemaObjectType.MEASURE);
        this.addTypedNameSpace(DataSchemaObjectType.DETAILINFORMATION);
    }

    public CubeImpl(CubeImpl cubeImpl) throws DSException {
        this(cubeImpl.getName());
        this.addCubeMetaDatas(cubeImpl.getDimensions());
        this.addCubeMetaDatas(cubeImpl.getMeasures());
        this.addCubeMetaDatas(cubeImpl.getDetailInformations());
    }

    public void setCubeMetaDatas(JCubeMetaData[] jCubeMetaDataArray) throws DSException {
        this.removeAllCubeMetaDatas();
        int n = 0;
        int n2 = jCubeMetaDataArray.length;
        while (n < n2) {
            JCubeMetaData jCubeMetaData = jCubeMetaDataArray[n];
            super.addContentElement(jCubeMetaData.copy());
            ++n;
        }
    }

    public void addCubeMetaDatas(JCubeMetaData[] jCubeMetaDataArray) throws DSException {
        int n = 0;
        int n2 = jCubeMetaDataArray.length;
        while (n < n2) {
            JCubeMetaData jCubeMetaData = jCubeMetaDataArray[n];
            super.addContentElement(jCubeMetaData.copy());
            ++n;
        }
    }

    public void addCubeMetaData(JCubeMetaData jCubeMetaData) throws DSException {
        super.addContentElement(jCubeMetaData.copy());
    }

    public void removeAllCubeMetaDatas() throws DSException {
        super.removeAllContentElementsInTypedNameSpace(DataSchemaObjectType.DIMENSION);
        super.removeAllContentElementsInTypedNameSpace(DataSchemaObjectType.MEASURE);
        super.removeAllContentElementsInTypedNameSpace(DataSchemaObjectType.DETAILINFORMATION);
    }

    public void removeCubeMetaData(JCubeMetaData jCubeMetaData) throws DSException {
        super.removeContentElement(jCubeMetaData);
    }

    public JDimension[] getDimensions() throws DSException {
        JDimension[] jDimensionArray = (JDimension[])super.getAllContentElementsInTypedNameSpace(DataSchemaObjectType.DIMENSION, new JDimension[0]);
        int n = 0;
        int n2 = jDimensionArray.length;
        while (n < n2) {
            jDimensionArray[n] = (JDimension)jDimensionArray[n].copy();
            ++n;
        }
        return jDimensionArray;
    }

    public JDimension getDimension(String string) throws DSException {
        JCubeMetaData jCubeMetaData = (JCubeMetaData)super.getContentElementInTypedNameSpace(DataSchemaObjectType.DIMENSION, string);
        return (JDimension)jCubeMetaData.copy();
    }

    public JMeasure[] getMeasures() throws DSException {
        JMeasure[] jMeasureArray = (JMeasure[])super.getAllContentElementsInTypedNameSpace(DataSchemaObjectType.MEASURE, new JMeasure[0]);
        int n = 0;
        int n2 = jMeasureArray.length;
        while (n < n2) {
            jMeasureArray[n] = (JMeasure)jMeasureArray[n].copy();
            ++n;
        }
        return jMeasureArray;
    }

    public JMeasure getMeasure(String string) throws DSException {
        JCubeMetaData jCubeMetaData = (JCubeMetaData)super.getContentElementInTypedNameSpace(DataSchemaObjectType.MEASURE, string);
        return (JMeasure)jCubeMetaData.copy();
    }

    public JDetailInformation[] getDetailInformations() throws DSException {
        JDetailInformation[] jDetailInformationArray = (JDetailInformation[])super.getAllContentElementsInTypedNameSpace(DataSchemaObjectType.DETAILINFORMATION, new JDetailInformation[0]);
        int n = 0;
        int n2 = jDetailInformationArray.length;
        while (n < n2) {
            jDetailInformationArray[n] = (JDetailInformation)jDetailInformationArray[n].copy();
            ++n;
        }
        return jDetailInformationArray;
    }

    public JDetailInformation getDetailInformation(String string) throws DSException {
        JCubeMetaData jCubeMetaData = (JCubeMetaData)super.getContentElementInTypedNameSpace(DataSchemaObjectType.DETAILINFORMATION, string);
        return (JDetailInformation)jCubeMetaData.copy();
    }

    public JCube copy() throws DSException {
        return new CubeImpl(this);
    }

    public void dump() {
        this.log.debug("---- benig Cube");
        this.log.indent("CubeImpl");
        super.dump();
        this.log.deIndent("CubeImpl");
        this.log.debug("---- end Cube");
    }

    public boolean contain(JCube jCube) throws DSException {
        JCubeMetaData[] jCubeMetaDataArray;
        if (this == jCube) {
            return true;
        }
        if (jCube == null) {
            return false;
        }
        HashMap<String, JCubeMetaData[]> hashMap = new HashMap<String, JCubeMetaData[]>();
        JCubeMetaData[] jCubeMetaDataArray2 = (JCubeMetaData[])this.getAllContentElements(new JCubeMetaData[0]);
        int n = 0;
        int n2 = jCubeMetaDataArray2.length;
        while (n < n2) {
            jCubeMetaDataArray = jCubeMetaDataArray2[n];
            hashMap.put(jCubeMetaDataArray.getName(), jCubeMetaDataArray);
            ++n;
        }
        jCubeMetaDataArray = (JCubeMetaData[])jCube.getAllContentElements(new JCubeMetaData[0]);
        int n3 = 0;
        int n4 = jCubeMetaDataArray.length;
        while (n3 < n4) {
            JCubeMetaData jCubeMetaData = jCubeMetaDataArray[n3];
            JCubeMetaData jCubeMetaData2 = (JCubeMetaData)hashMap.remove(jCubeMetaData.getName());
            if (jCubeMetaData2 == null || !jCubeMetaData2.equals(jCubeMetaData)) {
                return false;
            }
            ++n3;
        }
        return hashMap.size() >= 0;
    }

    public boolean equals(Object object) {
        JCubeMetaData[] jCubeMetaDataArray;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CubeImpl)) {
            return false;
        }
        HashMap<String, JCubeMetaData[]> hashMap = new HashMap<String, JCubeMetaData[]>();
        CubeImpl cubeImpl = (CubeImpl)object;
        JCubeMetaData[] jCubeMetaDataArray2 = (JCubeMetaData[])this.getAllContentElements(new JCubeMetaData[0]);
        int n = 0;
        int n2 = jCubeMetaDataArray2.length;
        while (n < n2) {
            jCubeMetaDataArray = jCubeMetaDataArray2[n];
            hashMap.put(jCubeMetaDataArray.getName(), jCubeMetaDataArray);
            ++n;
        }
        jCubeMetaDataArray = (JCubeMetaData[])cubeImpl.getAllContentElements(new JCubeMetaData[0]);
        int n3 = 0;
        int n4 = jCubeMetaDataArray.length;
        while (n3 < n4) {
            JCubeMetaData jCubeMetaData = jCubeMetaDataArray[n3];
            JCubeMetaData jCubeMetaData2 = (JCubeMetaData)hashMap.remove(jCubeMetaData.getName());
            if (jCubeMetaData2 == null || !jCubeMetaData2.equals(jCubeMetaData)) {
                return false;
            }
            ++n3;
        }
        return hashMap.isEmpty();
    }

    public boolean dimensionsEquals(Object object) throws DSException {
        Object object2;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CubeImpl)) {
            return false;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        CubeImpl cubeImpl = (CubeImpl)object;
        JDimension[] jDimensionArray = this.getDimensions();
        int n = 0;
        int n2 = jDimensionArray.length;
        while (n < n2) {
            object2 = jDimensionArray[n];
            hashMap.put(object2.getName(), object2);
            ++n;
        }
        object2 = cubeImpl.getDimensions();
        int n3 = 0;
        int n4 = ((JDimension[])object2).length;
        while (n3 < n4) {
            Object object3 = object2[n3];
            JDimension jDimension = (JDimension)hashMap.remove(object3.getName());
            if (jDimension == null || !jDimension.equals(object3)) {
                return false;
            }
            ++n3;
        }
        return hashMap.isEmpty();
    }

    public int comapreDimensions(JCube jCube) throws DSException {
        Object object;
        if (this == jCube) {
            return 0;
        }
        if (jCube == null) {
            return 1;
        }
        if (!(jCube instanceof CubeImpl)) {
            return -1;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        JDimension[] jDimensionArray = this.getDimensions();
        int n = 0;
        int n2 = jDimensionArray.length;
        while (n < n2) {
            object = jDimensionArray[n];
            hashMap.put(object.getName(), object);
            ++n;
        }
        object = jCube.getDimensions();
        int n3 = 0;
        int n4 = ((JDimension[])object).length;
        while (n3 < n4) {
            Object object2 = object[n3];
            JDimension jDimension = (JDimension)hashMap.remove(object2.getName());
            if (jDimension == null || !jDimension.equals(object2)) {
                return -1;
            }
            ++n3;
        }
        if (hashMap.isEmpty()) {
            return 0;
        }
        return 1;
    }
}

