/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.queryengine.conntools;

import com.jinfonet.dataservice.api.schema.relational.datasource.relational.JRdbConnection;
import java.sql.Connection;
import java.sql.SQLException;
import jet.dataengine.api.DSException;
import jet.dataengine.util.StringTools;
import jet.dataengine8.core.queryengine.conntools.AConnectionCreator;
import toolkit.db.gui.ConnectionsBroker;

public class RDBConnectionCreator
extends AConnectionCreator {
    private String QOIV = null;
    private String append = null;
    private String debug = null;
    private String getConnection = null;
    private String getCurrentCatalog = null;

    RDBConnectionCreator(JRdbConnection jRdbConnection) {
        super(jRdbConnection);
        this.append = jRdbConnection.getUser();
        this.debug = jRdbConnection.getPassword();
        this.getConnection = jRdbConnection.getDriver();
        this.QOIV = jRdbConnection.getUrl();
        this.getCurrentCatalog = jRdbConnection.getCurrentCatalog();
    }

    public Connection createRDBConnection() throws DSException {
        Connection connection = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Connection info : User :" + this.append + " Password :" + this.debug + " url :" + this.QOIV + " driver :" + this.getConnection + "CatalogName : " + this.getCurrentCatalog);
        }
        try {
            connection = ConnectionsBroker.getConnection(this.QOIV, this.append, this.debug, this.getConnection);
            if (!StringTools.isEmptyStringWithTrim(this.getCurrentCatalog)) {
                connection.setCatalog(this.getCurrentCatalog);
            }
        }
        catch (SQLException sQLException) {
            throw new DSException(2053, (Throwable)sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DSException(2052, (Throwable)classNotFoundException);
        }
        return connection;
    }

    public int getType() {
        return 0;
    }
}

