/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.queryengine.transform;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.relational.datasource.Formula;
import com.jinfonet.dataservice.relational.datasource.FormulaMapping;
import com.jinfonet.dataservice.relational.datasource.NormalParameter;
import com.jinfonet.dataservice.relational.datasource.ParameterMapping;
import com.jinfonet.dataservice.schema.relational.datasource.DSDataField;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbDataField;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.DataDescription;
import jet.dataengine.api.query.JDynamicQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.api.query.MappingNameBindInfo;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine8.core.queryengine.RawDataQueryTools;
import jet.dataengine8.core.queryengine.transform.AttributeContainer;
import jet.dataengine8.core.queryengine.transform.FormulaEnvTools;
import jet.dataengine8.core.queryengine.transform.FormulaFetcher4Universe;
import jet.dataengine8.core.queryengine.transform.QueryTransform;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.universe.JetUFormula;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import toolkit.db.gui.MappingSQLType;

class DynamicQueryAttContainerParser {
    static final boolean $assertionsDisabled = !(class$jet$dataengine8$core$queryengine$transform$DynamicQueryAttContainerParser == null ? (class$jet$dataengine8$core$queryengine$transform$DynamicQueryAttContainerParser = DynamicQueryAttContainerParser.class$("jet.dataengine8.core.queryengine.transform.DynamicQueryAttContainerParser")) : class$jet$dataengine8$core$queryengine$transform$DynamicQueryAttContainerParser).desiredAssertionStatus();
    static Class class$jet$dataengine8$core$queryengine$transform$DynamicQueryAttContainerParser;

    DynamicQueryAttContainerParser() {
    }

    public AttributeContainer parseDynamicContainer(JDynamicQuery jDynamicQuery) throws DSException {
        DataDescription dataDescription = jDynamicQuery.getDataDescription();
        if (dataDescription.getType() == 2818) {
            return new AttributeContainer();
        }
        if (dataDescription.getType() == 1840903 || dataDescription.getType() == 1959688 || dataDescription.getType() == 3933963 || dataDescription.getType() == 1797) {
            return this.createParameterMapping(jDynamicQuery.getMappingNames(), jDynamicQuery, dataDescription);
        }
        if (dataDescription.getType() == 132864 || dataDescription.getType() == 139011 || dataDescription.getType() == 257796 || dataDescription.getType() == 2232076) {
            String string = jDynamicQuery.getDataDescription().getDataSourceName();
            JetUUniverse jetUUniverse = jDynamicQuery.getDataDescription().getCatalog();
            String string2 = jDynamicQuery.getDataDescription().getQueryName();
            JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(string, string2);
            return this.add(jDynamicQuery.getMappingNames(), jDynamicQuery, jetUQueriable, dataDescription);
        }
        if (dataDescription.getType() == 6) {
            return this.QOIV(jDynamicQuery.getMappingNames(), dataDescription.getConstantFormulas(), jDynamicQuery.getParameterValues());
        }
        if (dataDescription.getType() == 1) {
            return this.$assertionsDisabled(jDynamicQuery, dataDescription);
        }
        throw new IllegalArgumentException("dynamic query type error in DataDescription: " + dataDescription.getType());
    }

    private AttributeContainer $assertionsDisabled(JDynamicQuery jDynamicQuery, DataDescription dataDescription) {
        throw new UnsupportedOperationException();
    }

    private AttributeContainer QOIV(String[] stringArray, JetRptFormula[] jetRptFormulaArray, ParameterValueList parameterValueList) throws DSException {
        if (!(jetRptFormulaArray != null && stringArray != null || $assertionsDisabled)) {
            throw new AssertionError((Object)"constant formulas were null");
        }
        AttributeContainer attributeContainer = new AttributeContainer();
        boolean bl = false;
        int n = 0;
        while (n < jetRptFormulaArray.length) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (jetRptFormulaArray[n].getName().equalsIgnoreCase(stringArray[n2])) {
                    attributeContainer.add(new FormulaMapping(stringArray[n2], new Formula(jetRptFormulaArray[n].getName(), jetRptFormulaArray[n])));
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                throw new RuntimeException("can not found constant formula in mapping names : " + jetRptFormulaArray[n].getName());
            }
            ++n;
        }
        ParamDesc[] paramDescArray = parameterValueList.getParameterDescriptions();
        int n3 = 0;
        while (n3 < paramDescArray.length) {
            attributeContainer.add(new ParameterMapping(paramDescArray[n3].getName(), new NormalParameter(paramDescArray[n3].getName(), paramDescArray[n3].isReferedBy(), paramDescArray[n3].getValue(), Types.sqlTypeToType(MappingSQLType.mapSQLTypeToInt(paramDescArray[n3].getType())), paramDescArray[n3].getFormat(), -1, -1, -1, paramDescArray[n3])));
            ++n3;
        }
        attributeContainer.setDisplayMappingNames(stringArray);
        return attributeContainer;
    }

    private AttributeContainer add(String[] stringArray, JDynamicQuery jDynamicQuery, JetUQueriable jetUQueriable, DataDescription dataDescription) throws DSException {
        MappingNameBindInfo[] mappingNameBindInfoArray = jDynamicQuery.getDataDescription().getMappingNameBindInfos();
        if (mappingNameBindInfoArray == null) {
            throw new DSException(5031, new Object[]{"MappingNameBindInfo was empty"});
        }
        ResultSetMetaData resultSetMetaData = this.createFormulaMapping(jDynamicQuery, dataDescription);
        AttributeContainer attributeContainer = new AttributeContainer();
        this.append(mappingNameBindInfoArray, resultSetMetaData, attributeContainer);
        this.getAllNeedDbFieldMappingNames(jDynamicQuery, jetUQueriable, attributeContainer);
        this.executeQuery(jDynamicQuery.getDataDescription().getCatalog(), jDynamicQuery.getDataDescription().getDataSourceName(), stringArray, attributeContainer);
        this.forName(jDynamicQuery, attributeContainer);
        attributeContainer.setDisplayMappingNames(stringArray);
        return this.createRdbDataField(jDynamicQuery.getDataDescription().getCatalog(), jDynamicQuery.getDataDescription().getDataSourceName(), attributeContainer, stringArray, mappingNameBindInfoArray, jDynamicQuery);
    }

    private void append(MappingNameBindInfo[] mappingNameBindInfoArray, ResultSetMetaData resultSetMetaData, AttributeContainer attributeContainer) throws DSException {
        RdbDataField rdbDataField = null;
        int n = -1;
        int n2 = 0;
        while (n2 < mappingNameBindInfoArray.length) {
            n = mappingNameBindInfoArray[n2].getFieldIndex();
            this.class$jet$dataengine8$core$queryengine$transform$DynamicQueryAttContainerParser(n, resultSetMetaData);
            rdbDataField = this.class$(mappingNameBindInfoArray[n2], resultSetMetaData, n, n2);
            attributeContainer.add(rdbDataField);
            ++n2;
        }
    }

    private RdbDataField class$(MappingNameBindInfo mappingNameBindInfo, ResultSetMetaData resultSetMetaData, int n, int n2) throws DSException {
        RdbDataField rdbDataField = null;
        try {
            String string = resultSetMetaData.getColumnName(n);
            String string2 = mappingNameBindInfo.getMappingName();
            int n3 = resultSetMetaData.getColumnType(n);
            int n4 = resultSetMetaData.isNullable(n);
            int n5 = resultSetMetaData.getPrecision(n);
            int n6 = resultSetMetaData.getPrecision(n);
            int n7 = resultSetMetaData.getScale(n);
            rdbDataField = new RdbDataField(string);
            rdbDataField.setAliasName(string2);
            rdbDataField.setFieldIndex(n);
            rdbDataField.setDataType(Types.sqlTypeToType(n3));
            rdbDataField.setIsNullable(n4);
            rdbDataField.setLength(n5);
            rdbDataField.setPrecision(n6);
            rdbDataField.setScale(n7);
            rdbDataField.setFieldIndex(mappingNameBindInfo.getFieldIndex());
        }
        catch (SQLException sQLException) {
            throw new DSException(5033, new Object[]{"can not found collum : " + sQLException.getMessage()}, sQLException);
        }
        return rdbDataField;
    }

    private void class$jet$dataengine8$core$queryengine$transform$DynamicQueryAttContainerParser(int n, ResultSetMetaData resultSetMetaData) throws DSException {
        try {
            if (n < 1 || n > resultSetMetaData.getColumnCount()) {
                throw new DSException(5035, new Object[]{"col index out of bounds : " + n});
            }
        }
        catch (SQLException sQLException) {
            throw new DSException(5036, new Object[]{"can't get column count"});
        }
    }

    private ResultSetMetaData createFormulaMapping(JDynamicQuery jDynamicQuery, DataDescription dataDescription) throws DSException {
        ResultSetMetaData resultSetMetaData = null;
        try {
            if (dataDescription.getType() == 132864) {
                resultSetMetaData = jDynamicQuery.getDataDescription().getResultSet().getMetaData();
            } else if (dataDescription.getType() == 139011) {
                if (dataDescription.getConnection() == null) {
                    throw new IllegalArgumentException("DataDescription getConnection was null");
                }
                if (dataDescription.getSql() == null) {
                    throw new IllegalArgumentException("DataDescription getSql was null");
                }
                resultSetMetaData = dataDescription.getConnection().createStatement().executeQuery(dataDescription.getSql()).getMetaData();
            } else if (dataDescription.getType() == 257796) {
                if (dataDescription.getDriver() == null) {
                    throw new IllegalArgumentException("DataDescription getDriver was null");
                }
                if (dataDescription.getURL() == null) {
                    throw new IllegalArgumentException("DataDescription getURL was null");
                }
                if (dataDescription.getUsername() == null) {
                    throw new IllegalArgumentException("DataDescription getUsername was null");
                }
                if (dataDescription.getPassword() == null) {
                    throw new IllegalArgumentException("DataDescription getPassword was null");
                }
                if (dataDescription.getSql() == null) {
                    throw new IllegalArgumentException("DataDescription getSql was null");
                }
                Class.forName(dataDescription.getDriver()).newInstance();
                resultSetMetaData = DriverManager.getConnection(dataDescription.getURL(), dataDescription.getUsername(), dataDescription.getPassword()).createStatement().executeQuery(dataDescription.getSql()).getMetaData();
            }
        }
        catch (DSException dSException) {
            throw dSException;
        }
        catch (Exception exception) {
            throw new DSException(5030, new Object[]{"SQLException : " + exception.getMessage()}, exception);
        }
        return resultSetMetaData;
    }

    private AttributeContainer createParameterMapping(String[] stringArray, JDynamicQuery jDynamicQuery, DataDescription dataDescription) throws DSException {
        String string = jDynamicQuery.getDataDescription().getDataSourceName();
        JetUUniverse jetUUniverse = jDynamicQuery.getDataDescription().getCatalog();
        String string2 = jDynamicQuery.getDataDescription().getQueryName();
        JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(string, string2);
        AttributeContainer attributeContainer = new AttributeContainer();
        this.getAllNeedFormulaMappingNames(stringArray, string, jetUUniverse, attributeContainer);
        this.getAllNeedDbFieldMappingNames(jDynamicQuery, jetUQueriable, attributeContainer);
        this.executeQuery(jDynamicQuery.getDataDescription().getCatalog(), jDynamicQuery.getDataDescription().getDataSourceName(), stringArray, attributeContainer);
        this.forName(jDynamicQuery, attributeContainer);
        this.equalsIgnoreCase(attributeContainer);
        attributeContainer.setDisplayMappingNames(stringArray);
        return this.createRdbDataField(jDynamicQuery.getDataDescription().getCatalog(), jDynamicQuery.getDataDescription().getDataSourceName(), attributeContainer, stringArray, null, jDynamicQuery);
    }

    private AttributeContainer createRdbDataField(JetUUniverse jetUUniverse, String string, AttributeContainer attributeContainer, String[] stringArray, MappingNameBindInfo[] mappingNameBindInfoArray, JDynamicQuery jDynamicQuery) throws DSException {
        FormulaEnvTools formulaEnvTools = new FormulaEnvTools(attributeContainer.getOutputFunctionMappingNames(), new FormulaFetcher4Universe(jetUUniverse, string, RawDataQueryTools.getReportDefineJetRptFormulas(jDynamicQuery)));
        this.desiredAssertionStatus(mappingNameBindInfoArray, formulaEnvTools);
        this.createStatement(jetUUniverse, string, attributeContainer, formulaEnvTools);
        return attributeContainer;
    }

    private void createStatement(JetUUniverse jetUUniverse, String string, AttributeContainer attributeContainer, FormulaEnvTools formulaEnvTools) throws DSException {
        String[] stringArray = formulaEnvTools.getAllNeedFormulaMappingNames();
        FormulaMapping formulaMapping = null;
        int n = 0;
        while (n < stringArray.length) {
            JetUResourceEntity jetUResourceEntity = jetUUniverse.getResourceByName(string, null, stringArray[n]);
            if (jetUResourceEntity instanceof JetUFormula) {
                JetUFormula jetUFormula = (JetUFormula)jetUResourceEntity;
                formulaMapping = QueryTransform.createFormulaMapping(jetUFormula);
                formulaMapping.dump();
                attributeContainer.add(formulaMapping);
            }
            ++n;
        }
    }

    private void desiredAssertionStatus(MappingNameBindInfo[] mappingNameBindInfoArray, FormulaEnvTools formulaEnvTools) {
        String[] stringArray = formulaEnvTools.getAllNeedDbFieldMappingNames();
        if (mappingNameBindInfoArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (!this.dump(mappingNameBindInfoArray, stringArray[n])) {
                    throw new IllegalArgumentException("dependent db field not contained in mapping names : " + stringArray[n]);
                }
                ++n;
            }
        }
    }

    private boolean dump(MappingNameBindInfo[] mappingNameBindInfoArray, String string) {
        int n = 0;
        while (n < mappingNameBindInfoArray.length) {
            if (mappingNameBindInfoArray[n].getMappingName().equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void equalsIgnoreCase(AttributeContainer attributeContainer) {
    }

    private void executeQuery(JetUUniverse jetUUniverse, String string, String[] stringArray, AttributeContainer attributeContainer) throws DSException {
        FormulaMapping formulaMapping = null;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            JetUResourceEntity jetUResourceEntity = jetUUniverse.getResourceByName(string, null, stringArray[n]);
            if (jetUResourceEntity instanceof JetUFormula) {
                JetUFormula jetUFormula = (JetUFormula)jetUResourceEntity;
                formulaMapping = QueryTransform.createFormulaMapping(jetUFormula);
                formulaMapping.dump();
                attributeContainer.add(formulaMapping);
            }
            ++n;
        }
    }

    private void forName(JRawDataQuery jRawDataQuery, AttributeContainer attributeContainer) throws DSException {
        FormulaMapping formulaMapping = null;
        Hashtable hashtable = jRawDataQuery.getReportFormulas();
        Iterator iterator = hashtable.values().iterator();
        while (iterator.hasNext()) {
            JetUFormula jetUFormula = (JetUFormula)iterator.next();
            if (!QueryTransform.isConstantFormula(jetUFormula) && !QueryTransform.isPass1Formula(jetUFormula)) continue;
            formulaMapping = QueryTransform.createFormulaMapping(jetUFormula);
            attributeContainer.add(formulaMapping);
        }
    }

    private void getAllNeedDbFieldMappingNames(JDynamicQuery jDynamicQuery, JetUQueriable jetUQueriable, AttributeContainer attributeContainer) throws DSException {
        ParameterValueList parameterValueList = jDynamicQuery.getParameterValues();
        if (parameterValueList != null && parameterValueList.size() > 0) {
            ParamDesc[] paramDescArray = parameterValueList.getParameterDescriptions();
            int n = 0;
            int n2 = paramDescArray.length;
            while (n < n2) {
                ParameterMapping parameterMapping = QueryTransform.createParameterMapping(jDynamicQuery.getDataDescription().getCatalog(), jDynamicQuery.getDataDescription().getDataSourceName(), jetUQueriable, paramDescArray[n]);
                attributeContainer.add(parameterMapping);
                ++n;
            }
        }
    }

    private void getAllNeedFormulaMappingNames(String[] stringArray, String string, JetUUniverse jetUUniverse, AttributeContainer attributeContainer) throws DSException {
        DSDataField dSDataField = null;
        int n = 0;
        while (n < stringArray.length) {
            JetUResourceEntity jetUResourceEntity = jetUUniverse.getResourceByName(string, null, stringArray[n]);
            if (jetUResourceEntity == null) {
                throw new IllegalArgumentException("can not found resource entity : [" + stringArray[n] + "] in database: [" + string + "]");
            }
            dSDataField = QueryTransform.createRdbDataField(jetUResourceEntity, new Hashtable());
            if (dSDataField != null) {
                attributeContainer.add(dSDataField);
            }
            ++n;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

