/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core;

import jet.dataengine.api.DSException;

public class CoordinateCalculator {
    public static long[] calculateRadix(int[] nArray) throws DSException {
        return CoordinateCalculator.calculateRadix(nArray, new long[Math.max(nArray.length - 1, 0)]);
    }

    public static long[] calculateRadix(int[] nArray, long[] lArray) throws DSException {
        int n = nArray.length;
        if (n > 1) {
            lArray[lArray.length - 1] = nArray[n - 1] + 1;
            int n2 = lArray.length - 1;
            while (n2 > 0) {
                int n3 = nArray[n2] + 1;
                lArray[n2 - 1] = lArray[n2] * (long)n3;
                --n2;
            }
        }
        if (CoordinateCalculator.convertToDecimal(lArray, nArray) < 0L) {
            throw new DSException(3024);
        }
        return lArray;
    }

    public static long convertToDecimal(long[] lArray, int[] nArray) {
        int n = 0;
        long l = 0L;
        while (n < lArray.length) {
            l += (long)nArray[n] * lArray[n];
            ++n;
        }
        return l + (long)(nArray.length == 0 ? 0 : nArray[n]);
    }

    public static long convertToDecimal(long[] lArray, short[] sArray) {
        int n = 0;
        long l = 0L;
        while (n < lArray.length) {
            l += (long)sArray[n] * lArray[n];
            ++n;
        }
        return l + (long)sArray[n];
    }

    public static int[] convertFromDecimal(long[] lArray, long l) {
        int[] nArray = new int[lArray.length + 1];
        int n = 0;
        while (n < lArray.length) {
            nArray[n] = (int)(l / lArray[n]);
            l %= lArray[n];
            ++n;
        }
        nArray[n] = (int)l;
        return nArray;
    }

    public static int[] convertFromDecimal(int[] nArray, long[] lArray, long l) {
        int n = 0;
        while (n < lArray.length) {
            nArray[n] = (int)(l / lArray[n]);
            l %= lArray[n];
            ++n;
        }
        nArray[n] = (int)l;
        return nArray;
    }
}

