/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.util;

import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.dataservice.util.Bits;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.dataengine.api.DSException;
import jet.dataengine8.util.dataswap.IDataCache;

public class CacheObjectInputStream {
    private byte[] QOIV;
    private int arraycopy = 4;
    private int getBytes;
    private char[] getChar = new char[100];

    public CacheObjectInputStream(int n) {
        if (n < 10) {
            n = 10;
        }
        this.QOIV = new byte[n];
    }

    public void readFromDataCache(IDataCache iDataCache, int n) throws DSException {
        int n2 = iDataCache.getBytes(n, 0, this.QOIV);
        this.getBytes = Bits.getInt(this.QOIV, 0) + 4;
        if (n2 < this.getBytes) {
            byte[] byArray = this.QOIV;
            this.QOIV = new byte[this.getBytes];
            System.arraycopy(byArray, 0, this.QOIV, 0, byArray.length);
            n2 += iDataCache.getBytes(n, n2, this.QOIV, n2, this.getBytes - n2);
        }
        if (n2 != this.getBytes) {
            throw new DSException(3001);
        }
        this.arraycopy = 4;
    }

    public void refresh() {
        this.arraycopy = 4;
    }

    public int readInt() throws DSException {
        this.arraycopy(4, this.getBytes());
        if (this.arraycopy + 4 > this.getBytes) {
            throw new DSException(3002);
        }
        int n = Bits.getInt(this.QOIV, this.arraycopy);
        this.arraycopy += 4;
        return n;
    }

    public long readLong() throws DSException {
        this.arraycopy(-5, this.getBytes());
        if (this.arraycopy + 8 > this.getBytes) {
            throw new DSException(3003);
        }
        long l = Bits.getLong(this.QOIV, this.arraycopy);
        this.arraycopy += 8;
        return l;
    }

    public double readDouble() throws DSException {
        this.arraycopy(8, this.getBytes());
        if (this.arraycopy + 8 > this.getBytes) {
            throw new DSException(3004);
        }
        double d = Bits.getDouble(this.QOIV, this.arraycopy);
        this.arraycopy += 8;
        return d;
    }

    public BigDecimal readBigDecimal() throws DSException {
        int n = this.getBytes();
        if (n == 0) {
            return null;
        }
        this.arraycopy(3, n);
        int n2 = this.getChar();
        int n3 = this.getChar();
        if (this.arraycopy + n2 > this.getBytes) {
            throw new DSException(3005);
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.QOIV, this.arraycopy, byArray, 0, n2);
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(byArray), n3);
        this.arraycopy += n2;
        return bigDecimal;
    }

    public String readString() throws DSException {
        int n = this.getBytes();
        if (n == 0) {
            return null;
        }
        this.arraycopy(12, n);
        int n2 = this.getChar();
        if (n2 % 2 != 0 && this.arraycopy + n2 > this.getBytes) {
            throw new DSException(3006);
        }
        return new String(this.QOIV(n2 /= 2), 0, n2);
    }

    private char[] QOIV(int n) {
        if (this.getChar.length < n) {
            this.getChar = new char[n];
        }
        int n2 = 0;
        while (n2 < n) {
            this.getChar[n2] = Bits.getChar(this.QOIV, this.arraycopy);
            ++n2;
            this.arraycopy += 2;
        }
        return this.getChar;
    }

    public Date readDate() throws DSException {
        int n = this.getBytes();
        if (n == 0) {
            return null;
        }
        this.arraycopy(91, n);
        return new JinfonetDate(this.getDouble());
    }

    public Time readTime() throws DSException {
        int n = this.getBytes();
        if (n == 0) {
            return null;
        }
        this.arraycopy(92, n);
        return new JinfonetTime(this.getDouble());
    }

    public Timestamp readTimestamp() throws DSException {
        int n = this.getBytes();
        if (n == 0) {
            return null;
        }
        this.arraycopy(93, n);
        return new JinfonetTimeStamp(this.getDouble());
    }

    private boolean arraycopy(int n, int n2) throws DSException {
        if (n != n2) {
            throw new DSException(3007, new String[]{String.valueOf(n), String.valueOf(n2)});
        }
        return true;
    }

    private int getBytes() throws DSException {
        if (this.arraycopy + 1 > this.getBytes) {
            throw new DSException(3008);
        }
        return this.QOIV[this.arraycopy++];
    }

    private int getChar() throws DSException {
        if (this.arraycopy + 4 > this.getBytes) {
            throw new DSException(3009);
        }
        int n = Bits.getInt(this.QOIV, this.arraycopy);
        this.arraycopy += 4;
        return n;
    }

    private long getDouble() throws DSException {
        if (this.arraycopy + 8 > this.getBytes) {
            throw new DSException(3010);
        }
        long l = Bits.getLong(this.QOIV, this.arraycopy);
        this.arraycopy += 8;
        return l;
    }
}

