/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.util;

import java.util.Arrays;
import java.util.Random;

public class LongHashMap {
    transient int QOIV;
    private int fill;
    private float pow;
    private transient Entry[] put;

    public LongHashMap(int n) {
        this(n, 0.75f);
    }

    LongHashMap(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        int n2 = 1;
        while (n2 < n) {
            n2 <<= 1;
        }
        this.pow = f;
        this.put = new Entry[n2];
        this.fill = (int)((float)n2 * f);
        Arrays.fill(this.put, null);
    }

    public LongHashMap() {
        this(128, 0.75f);
    }

    public int size() {
        return this.QOIV;
    }

    public boolean isEmpty() {
        return this.QOIV == 0;
    }

    public long[] keys() {
        long[] lArray = new long[this.QOIV];
        int n = 0;
        int n2 = 0;
        while (n < this.put.length) {
            Entry entry = this.put[n];
            while (entry != null) {
                lArray[n2++] = entry.I();
                entry = entry.Z;
            }
            ++n;
        }
        return lArray;
    }

    public boolean contains(long l) {
        int n = LongHashMap.QOIV(l) & this.put.length - 1;
        Entry entry = this.put[n];
        while (entry != null) {
            if (entry.I() == l) {
                return true;
            }
            entry = entry.Z;
        }
        return false;
    }

    public long get(long l) {
        int n = LongHashMap.QOIV(l) & this.put.length - 1;
        Entry entry = this.put[n];
        while (entry != null) {
            if (entry.I() == l) {
                return entry.Z();
            }
            entry = entry.Z;
        }
        return 0L;
    }

    protected void rehash() {
        int n = this.put.length;
        Entry[] entryArray = this.put;
        int n2 = n << 1;
        Entry[] entryArray2 = new Entry[n2];
        this.fill = (int)((float)n2 * this.pow);
        this.put = entryArray2;
        int n3 = 0;
        while (n3 < n) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.Z;
                int n4 = LongHashMap.QOIV(entry2.I()) & n2 - 1;
                entry2.Z = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
            ++n3;
        }
    }

    public void put(long l, long l2) {
        int n = LongHashMap.QOIV(l) & this.put.length - 1;
        Entry entry = this.put[n];
        while (entry != null) {
            if (entry.I() == l) {
                return;
            }
            entry = entry.Z;
        }
        if (this.QOIV >= this.fill) {
            this.rehash();
            this.put(l, l2);
            return;
        }
        Entry entry2 = new Entry(l, l2);
        entry2.Z = this.put[n];
        this.put[n] = entry2;
        ++this.QOIV;
    }

    private static int QOIV(long l) {
        int n = (int)(l ^ l >>> 32);
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    public boolean remove(long l) {
        int n = LongHashMap.QOIV(l) & this.put.length - 1;
        Entry entry = this.put[n];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.I() == l) {
                if (entry2 != null) {
                    entry2.Z = entry.Z;
                } else {
                    this.put[n] = entry.Z;
                }
                --this.QOIV;
                return true;
            }
            entry2 = entry;
            entry = entry.Z;
        }
        return false;
    }

    public void clear() {
        int n = 0;
        while (n < this.put.length) {
            this.put[n] = null;
            ++n;
        }
        this.QOIV = 0;
    }

    public int getTakeUpSize() {
        return this.put.length;
    }

    public static void main(String[] stringArray) {
        Random random = new Random();
        int n = (int)Math.pow(10.0, 7.0);
        LongHashMap longHashMap = new LongHashMap();
        longHashMap.put(0L, 100L);
        longHashMap.put(1L, 0L);
    }

    private static class Entry {
        long QOIV;
        long I;
        Entry Z;

        Entry(long l, long l2) {
            this.QOIV = l;
            this.I = l2;
        }

        long I() {
            return this.QOIV;
        }

        long Z() {
            return this.I;
        }
    }
}

