/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util;

import java.util.Vector;
import jet.dataengine8.util.IntKeyHashNode;
import jet.dataengine8.util.IntVector;

public class IntKeyHashtable {
    private transient int QOIV;
    private int addElement;
    private float append;
    private transient IntKeyHashNode[] clone;

    public IntKeyHashtable(int n) {
        this(n, 0.618f);
    }

    public IntKeyHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.append = f;
        this.clone = new IntKeyHashNode[n];
        this.addElement = (int)((float)n * f);
    }

    public IntKeyHashtable() {
        this(103, 0.618f);
    }

    public int size() {
        return this.QOIV;
    }

    public boolean isEmpty() {
        return this.QOIV == 0;
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = 0;
        while (n < this.clone.length) {
            IntKeyHashNode intKeyHashNode = this.clone[n];
            while (intKeyHashNode != null) {
                if (intKeyHashNode.Z.equals(object)) {
                    return true;
                }
                intKeyHashNode = intKeyHashNode.C;
            }
            ++n;
        }
        return false;
    }

    public synchronized IntVector getKeys(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IntVector intVector = new IntVector(5);
        int n = 0;
        while (n < this.clone.length) {
            IntKeyHashNode intKeyHashNode = this.clone[n];
            while (intKeyHashNode != null) {
                if (intKeyHashNode.Z.equals(object)) {
                    intVector.addElement(intKeyHashNode.I);
                }
                intKeyHashNode = intKeyHashNode.C;
            }
            ++n;
        }
        return intVector;
    }

    public synchronized boolean containsKey(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.clone.length;
        IntKeyHashNode intKeyHashNode = this.clone[n2];
        while (intKeyHashNode != null) {
            if (intKeyHashNode.I == n) {
                return true;
            }
            intKeyHashNode = intKeyHashNode.C;
        }
        return false;
    }

    public synchronized Object get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.clone.length;
        IntKeyHashNode intKeyHashNode = this.clone[n2];
        while (intKeyHashNode != null) {
            if (intKeyHashNode.I == n) {
                return intKeyHashNode.Z;
            }
            intKeyHashNode = intKeyHashNode.C;
        }
        return null;
    }

    protected void rehash() {
        int n = this.clone.length;
        IntKeyHashNode[] intKeyHashNodeArray = this.clone;
        int n2 = n * 2 + 1;
        IntKeyHashNode[] intKeyHashNodeArray2 = new IntKeyHashNode[n2];
        this.addElement = (int)((float)n2 * this.append);
        this.clone = intKeyHashNodeArray2;
        int n3 = 0;
        while (n3 < n) {
            IntKeyHashNode intKeyHashNode = intKeyHashNodeArray[n3];
            while (intKeyHashNode != null) {
                IntKeyHashNode intKeyHashNode2 = intKeyHashNode;
                intKeyHashNode = intKeyHashNode.C;
                int n4 = (intKeyHashNode2.I & Integer.MAX_VALUE) % n2;
                intKeyHashNode2.C = intKeyHashNodeArray2[n4];
                intKeyHashNodeArray2[n4] = intKeyHashNode2;
            }
            ++n3;
        }
    }

    public synchronized Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = (n & Integer.MAX_VALUE) % this.clone.length;
        IntKeyHashNode intKeyHashNode = this.clone[n2];
        while (intKeyHashNode != null) {
            if (intKeyHashNode.I == n) {
                Object object2 = intKeyHashNode.Z;
                intKeyHashNode.Z = object;
                return object2;
            }
            intKeyHashNode = intKeyHashNode.C;
        }
        if (this.QOIV >= this.addElement) {
            this.rehash();
            return this.put(n, object);
        }
        IntKeyHashNode intKeyHashNode2 = new IntKeyHashNode();
        intKeyHashNode2.I = n;
        intKeyHashNode2.Z = object;
        intKeyHashNode2.C = this.clone[n2];
        this.clone[n2] = intKeyHashNode2;
        ++this.QOIV;
        return null;
    }

    public synchronized Object remove(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.clone.length;
        IntKeyHashNode intKeyHashNode = this.clone[n2];
        IntKeyHashNode intKeyHashNode2 = null;
        while (intKeyHashNode != null) {
            if (intKeyHashNode.I == n) {
                if (intKeyHashNode2 != null) {
                    intKeyHashNode2.C = intKeyHashNode.C;
                } else {
                    this.clone[n2] = intKeyHashNode.C;
                }
                --this.QOIV;
                return intKeyHashNode.Z;
            }
            intKeyHashNode2 = intKeyHashNode;
            intKeyHashNode = intKeyHashNode.C;
        }
        return null;
    }

    public synchronized void clear() {
        int n = 0;
        while (n < this.clone.length) {
            this.clone[n] = null;
            ++n;
        }
        this.QOIV = 0;
    }

    public synchronized Object clone() {
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable(this.clone.length, this.append);
        int n = 0;
        while (n < this.clone.length) {
            intKeyHashtable.clone[n] = this.clone[n] != null ? (IntKeyHashNode)this.clone[n].clone() : null;
            ++n;
        }
        return intKeyHashtable;
    }

    public synchronized IntVector keys() {
        IntVector intVector = null;
        if (this.QOIV != 0) {
            intVector = new IntVector();
            int n = 0;
            while (n < this.clone.length) {
                IntKeyHashNode intKeyHashNode = this.clone[n];
                if (intKeyHashNode != null) {
                    do {
                        intVector.addElement(intKeyHashNode.I);
                    } while ((intKeyHashNode = intKeyHashNode.C) != null);
                }
                ++n;
            }
        }
        return intVector;
    }

    public synchronized Vector elements() {
        Vector<Object> vector = null;
        if (this.QOIV != 0) {
            vector = new Vector<Object>();
            int n = 0;
            while (n < this.clone.length) {
                IntKeyHashNode intKeyHashNode = this.clone[n];
                if (intKeyHashNode != null) {
                    do {
                        vector.addElement(intKeyHashNode.Z);
                    } while ((intKeyHashNode = intKeyHashNode.C) != null);
                }
                ++n;
            }
        }
        return vector;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.QOIV != 0) {
            stringBuffer.append("[");
            int n = 0;
            while (n < this.clone.length) {
                IntKeyHashNode intKeyHashNode = this.clone[n];
                if (intKeyHashNode != null) {
                    do {
                        stringBuffer.append("[").append(intKeyHashNode.I).append(",").append(intKeyHashNode.Z == this ? super.toString() : intKeyHashNode.Z).append("],");
                    } while ((intKeyHashNode = intKeyHashNode.C) != null);
                }
                ++n;
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }
}

