/*
 * Decompiled with CFR 0.152.
 */
package jet.datasource.oracle;

import com.jinfonet.common.api.JdbcDriversConfig;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Vector;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.oracle.AbstractUds;
import jet.datasource.oracle.MyStringTokenizer;
import oracle.jdbc.driver.OracleCallableStatement;
import toolkit.db.ParameterFormatInvalid;
import toolkit.db.ProcParaInfo;

public class OracleUDS
extends AbstractUds {
    OracleUDS(Connection connection, Connection connection2, JdbcDriversConfig jdbcDriversConfig) {
        this.Z = connection;
        this.M = connection2;
        this.I = jdbcDriversConfig;
    }

    public ResultSet getResultSet(Properties properties) throws JRUserDataSourceException {
        try {
            this.D = properties;
            this.G.removeAllElements();
            this.H.removeAllElements();
            this.I(properties);
            this.add();
            this.run();
        }
        catch (SQLException sQLException) {
            throw new JRUserDataSourceException(sQLException.getMessage());
        }
        catch (ParameterFormatInvalid parameterFormatInvalid) {
            throw new JRUserDataSourceException(parameterFormatInvalid.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            throw new JRUserDataSourceException(numberFormatException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JRUserDataSourceException(illegalArgumentException.getMessage());
        }
        catch (ParseException parseException) {
            throw new JRUserDataSourceException(parseException.getMessage());
        }
        catch (IOException iOException) {
            throw new JRUserDataSourceException(iOException.getMessage());
        }
        return this.C;
    }

    private void I(Properties properties) throws JRUserDataSourceException {
        MyStringTokenizer myStringTokenizer;
        this.F = properties.getProperty("OWNER");
        this.J = properties.getProperty("PROCNAME");
        this.S = properties.getProperty("SQL");
        this.A = properties.getProperty("REFCURSORINDEX");
        this.N = Integer.parseInt(this.A);
        this.L = properties.getProperty("OUTPARAMINDEX");
        if (this.L != null) {
            try {
                this.L = new String(this.L.getBytes("8859_1"), "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new JRUserDataSourceException(unsupportedEncodingException.getMessage());
            }
        }
        if (this.L == null || this.L.trim().length() < 0) {
            this.K.add(null);
        } else {
            myStringTokenizer = new MyStringTokenizer(this.L, AbstractUds.strParaValueSeparator);
            String string = null;
            while (myStringTokenizer.hasMoreTokens()) {
                string = myStringTokenizer.nextToken();
                if (string != null) {
                    string = this.I(string, AbstractUds.strParaValueReplaceSymbol, AbstractUds.strParaValueSeparator);
                }
                this.K.addElement(new Integer(string));
            }
        }
        this.E = properties.getProperty("PARAMVALUE");
        if (this.E != null) {
            try {
                this.E = new String(this.E.getBytes("8859_1"), "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new JRUserDataSourceException(unsupportedEncodingException.getMessage());
            }
        }
        if (this.E == null || this.E.trim().length() < 1) {
            this.G.addElement(null);
        } else if (this.E != null) {
            this.E = this.I(this.E, AbstractUds.strParaValueTranferSymbol, AbstractUds.strParaValueReplaceSymbol);
            myStringTokenizer = new MyStringTokenizer(this.E, AbstractUds.strParaValueSeparator);
            while (myStringTokenizer.hasMoreTokens()) {
                String string = myStringTokenizer.nextToken();
                if (string != null) {
                    string = this.I(string, AbstractUds.strParaValueReplaceSymbol, AbstractUds.strParaValueSeparator);
                }
                this.G.addElement(string);
            }
        }
    }

    protected void prepareParameter() throws SQLException, ParameterFormatInvalid, NumberFormatException, IllegalArgumentException, ParseException, IOException {
        ProcParaInfo procParaInfo = null;
        int n = this.H.size();
        int n2 = 1;
        while (n2 < n) {
            if (n2 == this.N) {
                this.B.registerOutParameter(this.N, -10);
            } else if (this.K.contains(new Integer(n2))) {
                this.B.registerOutParameter(n2, ((ProcParaInfo)this.H.elementAt(n2)).getSQLType());
            } else {
                procParaInfo = (ProcParaInfo)this.H.elementAt(n2);
                switch (procParaInfo.getSQLType()) {
                    case -7: {
                        this.B.setBoolean(n2, procParaInfo.getValue().equals("1"));
                        break;
                    }
                    case -6: {
                        this.B.setByte(n2, Byte.parseByte(procParaInfo.getValue()));
                        break;
                    }
                    case 5: {
                        this.B.setShort(n2, Short.parseShort(procParaInfo.getValue()));
                        break;
                    }
                    case 4: {
                        this.B.setInt(n2, Integer.parseInt(procParaInfo.getValue()));
                        break;
                    }
                    case -5: {
                        this.B.setLong(n2, Long.parseLong(procParaInfo.getValue()));
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        this.B.setString(n2, procParaInfo.getValue());
                        break;
                    }
                    case 7: {
                        this.B.setFloat(n2, new Float(procParaInfo.getValue()).floatValue());
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.B.setDouble(n2, (double)new Double(procParaInfo.getValue()));
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (procParaInfo.getValue() == null || "NULL".equals(procParaInfo.getValue())) {
                            this.B.setBigDecimal(n2, null);
                            break;
                        }
                        this.B.setBigDecimal(n2, new BigDecimal(procParaInfo.getValue()));
                        break;
                    }
                    case 91: {
                        Object object = new SimpleDateFormat(AbstractUds.dateFormat);
                        Object object2 = ((DateFormat)object).parse(procParaInfo.getValue());
                        this.B.setDate(n2, new Date(((java.util.Date)object2).getTime()));
                        break;
                    }
                    case 92: {
                        Object object = new SimpleDateFormat(AbstractUds.timeFormat);
                        Object object2 = ((DateFormat)object).parse(procParaInfo.getValue());
                        this.B.setTime(n2, new Time(((java.util.Date)object2).getTime()));
                        break;
                    }
                    case 2005: {
                        Object object = procParaInfo.getValue();
                        Object object2 = this.I((String)object);
                        this.B.setClob(n2, (Clob)object2);
                        break;
                    }
                    case 93: {
                        Object object = new SimpleDateFormat(AbstractUds.timestampFormat);
                        Object object2 = ((DateFormat)object).parse(procParaInfo.getValue());
                        this.B.setTimestamp(n2, new Timestamp(((java.util.Date)object2).getTime()));
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        this.B.setBytes(n2, procParaInfo.getValue().getBytes());
                        break;
                    }
                    case 1111: {
                        Object object2;
                        Object object = procParaInfo.getValue();
                        if (procParaInfo.getSQLTypeName().equals("CLOB")) {
                            object2 = this.I((String)object);
                            this.B.setClob(n2, (Clob)object2);
                            break;
                        }
                        this.B.setObject(n2, (Object)procParaInfo.getValue());
                    }
                }
            }
            ++n2;
        }
    }

    private void QOIV() {
        int n = this.H.size();
        ProcParaInfo procParaInfo = null;
        int n2 = 0;
        int n3 = 1;
        while (n3 < n) {
            procParaInfo = (ProcParaInfo)this.H.elementAt(n3);
            if (n3 != this.N && !this.K.contains(new Integer(n3)) && procParaInfo != null) {
                procParaInfo.setValue((String)this.G.elementAt(n2++));
            }
            ++n3;
        }
    }

    private void add() throws SQLException {
        DatabaseMetaData databaseMetaData = this.Z.getMetaData();
        String string = null;
        int n = this.J.indexOf(".");
        if (n >= 0) {
            string = this.J.substring(0, n).toUpperCase();
            this.J = this.J.substring(n + 1);
        }
        ResultSet resultSet = databaseMetaData.getProcedureColumns(string, this.F.equals("") ? "%" : this.F.toUpperCase(), this.J.toUpperCase(), "%");
        int n2 = 1;
        ProcParaInfo procParaInfo = null;
        this.H.addElement(new Object());
        Vector<String> vector = new Vector<String>();
        int n3 = -1;
        while (resultSet.next()) {
            String string2 = resultSet.getString(4);
            n3 = vector.indexOf(string2);
            if (n3 != -1) continue;
            vector.addElement(string2);
            int n4 = resultSet.getInt(5);
            String string3 = resultSet.getString(7);
            if (n4 == 1) {
                procParaInfo = new ProcParaInfo(n2, string2, n4, resultSet.getInt(6), string3, resultSet.getInt(8), resultSet.getInt(9), resultSet.getShort(10), resultSet.getShort(11), resultSet.getShort(12), true, "");
                while (n2 >= this.H.size()) {
                    this.H.add(null);
                }
                this.H.setElementAt(procParaInfo, n2);
                ++n2;
                continue;
            }
            if (n2 == this.N) {
                procParaInfo = new ProcParaInfo(this.N, "", 4, -10, "Ref Cursor", 0, 0, 0, 0, 0, false, "");
                while (n2 >= this.H.size()) {
                    this.H.add(null);
                }
                this.H.setElementAt(procParaInfo, this.N);
                ++n2;
                continue;
            }
            if (!this.K.contains(new Integer(n2))) continue;
            procParaInfo = new ProcParaInfo(n2, "", 4, resultSet.getInt(6), string3, resultSet.getInt(8), resultSet.getInt(9), resultSet.getShort(10), resultSet.getShort(11), resultSet.getShort(12), false, "");
            while (n2 >= this.H.size()) {
                this.H.add(null);
            }
            this.H.setElementAt(procParaInfo, n2);
            ++n2;
        }
        resultSet.close();
        this.QOIV();
    }

    public void run() throws SQLException, ParameterFormatInvalid, NumberFormatException, IllegalArgumentException, ParseException, IOException {
        int n = this.getFetchSize(this.Z, this.I);
        if (n == 0) {
            this.B = this.Z.prepareCall(this.S);
        } else {
            this.B = this.Z.prepareCall(this.S, 1003, 1007);
            this.B.setFetchSize(n);
        }
        this.prepareParameter();
        this.B.execute();
        this.C = ((OracleCallableStatement)this.B).getCursor(this.N);
    }
}

