/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import jet.JRStopEngineException;
import jet.connect.DbBinary;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.datastream.JRObjectResult;
import jet.util.BitmapReader;
import jet.util.VersionControlable;

public class DSMap
extends DSContainer {
    String QOIV = "";
    String UTFLength = "";
    float addImage = 1.0f;
    float booleanValue = 1.0f;
    private DbBinary clone = null;
    private boolean colName = false;
    private int createImage;
    private byte desc;
    private int drawImage;
    private boolean dup = false;
    private byte[] error = null;

    public String getName() {
        return this.QOIV;
    }

    public void setName(String string) {
        this.QOIV = string;
    }

    public float getWZoom() {
        return this.addImage;
    }

    public void setWZoom(float f) {
        this.addImage = f;
    }

    public float getHZoom() {
        return this.booleanValue;
    }

    public void setHZoom(float f) {
        this.booleanValue = f;
    }

    public String getValue() {
        return this.UTFLength;
    }

    public void setValue(String string) {
        this.UTFLength = string;
    }

    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        int n;
        super.readProperties(dataInput, dSDataStreamable);
        this.createImage = n = ((VersionControlable)((Object)dataInput)).getVersion();
        this.QOIV = dataInput.readUTF();
        this.UTFLength = dataInput.readUTF();
        if (n >= 262145 || n == 0) {
            this.colName = dataInput.readBoolean();
            if (this.colName) {
                this.clone = DSMap.UTFLength(dataInput);
            }
        }
        if (n >= 262176 || n == 0) {
            this.desc = dataInput.readByte();
        }
        if (n >= 262416 || n == 0) {
            this.drawImage = dataInput.readInt();
            this.dup = dataInput.readBoolean();
            if (this.dup) {
                boolean bl = dataInput.readBoolean();
                if (!bl) {
                    int n2 = dataInput.readInt();
                    byte[] byArray = new byte[n2];
                    dataInput.readFully(byArray, 0, n2);
                    this.setDefaultImageData(byArray);
                } else {
                    this.error = null;
                }
            }
        }
    }

    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeUTF(this.QOIV);
        dataOutput.writeUTF(this.UTFLength);
        dataOutput.writeBoolean(this.colName);
        if (this.colName) {
            DSMap.QOIV(dataOutput, this.clone);
        }
        dataOutput.writeByte(this.desc);
        dataOutput.writeInt(this.drawImage);
        dataOutput.writeBoolean(this.dup);
        if (this.dup) {
            boolean bl = false;
            if (this.error != null) {
                dataOutput.writeBoolean(bl);
                int n = this.error.length;
                dataOutput.writeInt(n);
                dataOutput.write(this.error, 0, n);
            } else {
                bl = true;
                dataOutput.writeBoolean(bl);
            }
        }
    }

    protected int propLength() {
        int n = super.propLength();
        n += JRObjectResult.UTFLength(this.QOIV) + 2 + (JRObjectResult.UTFLength(this.UTFLength) + 2);
        ++n;
        if (this.colName) {
            n += DSMap.addImage(this.clone);
        }
        ++n;
        n += 4;
        ++n;
        if (this.dup) {
            ++n;
            if (this.error != null) {
                n += 4 + 1 * this.getDefaultImageData().length;
            }
        }
        return n;
    }

    public Object clone() {
        return this.dup(new DSMap());
    }

    public DSMap dup(DSMap dSMap) {
        super.dup(dSMap);
        dSMap.QOIV = this.QOIV;
        dSMap.addImage = this.addImage;
        dSMap.booleanValue = this.booleanValue;
        dSMap.UTFLength = this.UTFLength;
        dSMap.drawImage = this.drawImage;
        dSMap.dup = this.dup;
        if (this.error != null) {
            dSMap.setDefaultImageData((byte[])this.error.clone());
        } else {
            dSMap.error = null;
        }
        return dSMap;
    }

    public void paint(Graphics graphics) {
        Object object;
        boolean bl = (Boolean)this.getPropertyByName("FromDatabase").getObject();
        Image image = null;
        if (bl) {
            object = null;
            object = this.createImage >= 262145 || this.createImage == 0 ? (String)this.getPropertyByName("RuntimeColumnName").getObject() : (String)this.getPropertyByName("ColumnName").getObject();
            JRecord jRecord = this.getRecord();
            DbBinary dbBinary = (DbBinary)jRecord.getCell((String)object);
            if (!dbBinary.isNull()) {
                BitmapReader bitmapReader;
                byte[] byArray = dbBinary.get();
                int n = -1;
                if (byArray != null && byArray.length > 0) {
                    if (byArray[0] == 66 && byArray[1] == 77) {
                        n = 1;
                    } else if (byArray[0] == 71 && byArray[1] == 73 && byArray[2] == 70) {
                        n = 4;
                    } else if (byArray[0] == -1 && byArray[1] == -40 && byArray[2] == -1 && byArray[3] == -32) {
                        n = 0;
                    }
                }
                MediaTracker mediaTracker = new MediaTracker(new Container());
                if (n == 4 || n == 0) {
                    image = Toolkit.getDefaultToolkit().createImage(byArray);
                } else if (n == 1 && (bitmapReader = BitmapReader.loadFromBMP(new DataInputStream(new ByteArrayInputStream(byArray)))) != null) {
                    image = Toolkit.getDefaultToolkit().createImage(bitmapReader.getMemImgSrc());
                }
                if (image != null) {
                    mediaTracker.addImage(image, 0);
                    try {
                        mediaTracker.waitForID(0);
                    }
                    catch (InterruptedException interruptedException) {
                        JRLog.error(2, interruptedException);
                    }
                }
            }
        } else {
            image = (Image)this.getPropertyByName("ImageSource").getObject();
        }
        if (image != null) {
            object = this.getBounds();
            graphics.drawImage(image, 0, 0, ((Rectangle)object).width, ((Rectangle)object).height, null);
        }
        super.paint(graphics);
    }

    public void setHasDataset() {
        this.colName = true;
    }

    public void setImageValue(DbBinary dbBinary) {
        if (dbBinary != null) {
            this.clone = dbBinary;
        }
    }

    public DbBinary getImageValue() {
        if (this.colName) {
            return this.clone;
        }
        String string = null;
        string = this.createImage >= 262145 || this.createImage == 0 ? (String)this.getPropertyByName("RuntimeColumnName").getObject() : (String)this.getPropertyByName("ColumnName").getObject();
        JRecord jRecord = this.getRecord();
        DbBinary dbBinary = (DbBinary)jRecord.getCell(string);
        return dbBinary;
    }

    static void QOIV(DataOutput dataOutput, DbBinary dbBinary) throws IOException {
        boolean bl = false;
        byte[] byArray = null;
        int n = -7;
        if (dbBinary == null) {
            bl = true;
        } else {
            bl = dbBinary.isNull();
            n = dbBinary.getSqlType();
        }
        dataOutput.writeBoolean(bl);
        dataOutput.writeInt(n);
        if (!bl) {
            String string = dbBinary.desc.colName;
            boolean bl2 = string != null;
            dataOutput.writeBoolean(bl2);
            if (bl2) {
                dataOutput.writeUTF(string);
            }
            byArray = dbBinary.get();
            int n2 = byArray.length;
            dataOutput.writeInt(n2);
            dataOutput.write(byArray, 0, n2);
        }
    }

    static DbBinary UTFLength(DataInput dataInput) throws IOException {
        int n;
        int n2 = ((VersionControlable)((Object)dataInput)).getVersion();
        DbValue dbValue = null;
        boolean bl = dataInput.readBoolean();
        DbColDesc dbColDesc = null;
        if (n2 >= 131084 || n2 == 0 || !bl) {
            n = dataInput.readInt();
            if (!(bl || n2 < 262145 && n2 != 0)) {
                boolean bl2 = dataInput.readBoolean();
                if (bl2) {
                    String string = dataInput.readUTF();
                    dbColDesc = new DbColDesc(string, n, 0, 0, 2);
                } else {
                    dbColDesc = new DbColDesc(null, n, 0, 0, 2);
                }
            } else {
                dbColDesc = new DbColDesc(null, n, 0, 0, 2);
            }
            dbValue = (DbBinary)DbValue.makeDbValue(dbColDesc);
        }
        if (!bl) {
            n = dataInput.readInt();
            byte[] byArray = new byte[n];
            dataInput.readFully(byArray, 0, n);
            if (dbValue != null) {
                ((DbBinary)dbValue).set(byArray);
            }
        } else if (dbValue != null) {
            dbValue.setNull();
        }
        return dbValue;
    }

    static int addImage(DbBinary dbBinary) {
        int n = 0;
        boolean bl = false;
        Object var3_3 = null;
        bl = dbBinary == null ? true : dbBinary.isNull();
        ++n;
        n += 4;
        if (!bl) {
            String string = dbBinary.desc.colName;
            boolean bl2 = string != null;
            ++n;
            if (bl2) {
                n += 2 + JRObjectResult.UTFLength(string);
            }
            n += 4 + dbBinary.get().length * 1;
        }
        return n;
    }

    public int getImageType() {
        return this.desc;
    }

    public void setImageType(int n) {
        this.desc = (byte)n;
    }

    public int getGroupTreeIDX() {
        return this.drawImage;
    }

    public void setGroupTreeIDX(int n) {
        this.drawImage = n;
    }

    public Image getDefaultImage() {
        if (this.isDefaultImage()) {
            MediaTracker mediaTracker = new MediaTracker(new Container());
            Image image = Toolkit.getDefaultToolkit().createImage(this.error);
            if (image != null) {
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                    mediaTracker.removeImage(image, 0);
                }
                catch (InterruptedException interruptedException) {
                    JRLog.error(2, interruptedException);
                    mediaTracker.removeImage(image);
                    image = null;
                }
            }
            return image;
        }
        return null;
    }

    public boolean isDefaultImage() {
        return this.dup;
    }

    public void setDefaultImage(boolean bl) {
        this.dup = bl;
    }

    public byte[] getDefaultImageData() {
        return this.error;
    }

    public void setDefaultImageData(byte[] byArray) {
        this.error = byArray;
    }
}

