/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import chart.data.ChartTypeInfo;
import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import jet.controls.ChangedProperties;
import jet.datastream.DSFieldTemplate;
import jet.datastream.DSTemplatible;
import jet.datastream.PropertyMapTable;
import jet.datastream.PropertyValue;
import jet.util.BitmapReader;
import jet.util.ImageLoader;
import jet.util.PictureFileFormatDetector;
import jet.util.Propertiable;
import jet.util.VersionControlable;

public class DSTemplate
implements DSTemplatible {
    private int BUILTINTYPES;
    private boolean add = false;
    private int addElement = 0;
    Hashtable addImage = new Hashtable();

    public DSTemplate(int n) {
        this.BUILTINTYPES = n;
    }

    public int getObjectType() {
        return this.BUILTINTYPES;
    }

    public Propertiable getProperty(short s) {
        return this.getPropertyByName(PropertyMapTable.getPropertyName(s));
    }

    public Propertiable getPropertyByName(String string) {
        return (Propertiable)this.addImage.get(string);
    }

    public void addProperty(String string, Propertiable propertiable) {
        this.addImage.put(string, propertiable);
    }

    public void addProperty(short s, Propertiable propertiable) {
        this.addImage.put(PropertyMapTable.getPropertyName(s), propertiable);
    }

    public static final DSTemplate makeTemplate(int n, boolean bl) {
        DSTemplate dSTemplate = null;
        dSTemplate = (n & 0x100) == 256 ? new DSFieldTemplate(n) : new DSTemplate(n);
        dSTemplate.add = bl;
        return dSTemplate;
    }

    public void readProperties(DataInput dataInput, String[] stringArray) throws IOException {
        PropertyValue propertyValue;
        int n = -1;
        if (dataInput instanceof VersionControlable) {
            this.addElement = n = ((VersionControlable)((Object)dataInput)).getVersion();
        }
        int n2 = dataInput.readShort();
        int n3 = 0;
        while (n3 < n2) {
            short s = dataInput.readShort();
            if (s != 0) {
                Object object;
                int n4;
                String string = stringArray != null ? stringArray[dataInput.readShort()] : dataInput.readUTF();
                String[] stringArray2 = null;
                if (n < 131091 && n != -1) {
                    if (this.BUILTINTYPES == 71) {
                        stringArray2 = (String[])ChangedProperties.htDSChartPlatform.get(string);
                    } else if (this.BUILTINTYPES == 72) {
                        stringArray2 = (String[])ChangedProperties.htDSChartCoordinatepaper.get(string);
                    } else if (this.BUILTINTYPES == 70) {
                        stringArray2 = (String[])ChangedProperties.htDSChartLegend.get(string);
                    } else if (this.BUILTINTYPES == 69) {
                        stringArray2 = (String[])ChangedProperties.htDSChartLabel.get(string);
                    }
                }
                boolean bl = dataInput.readBoolean();
                boolean bl2 = dataInput.readBoolean();
                propertyValue = new PropertyValue();
                propertyValue.tag = s;
                if (!bl2) {
                    if (bl) {
                        if (stringArray2 != null && (string.equals("Bold") || string.equals("Italic"))) {
                            dataInput.readUTF();
                            propertyValue.setObject(new Integer(0));
                            if (JRLog.isError(3)) {
                                JRLog.error(3, 3300008);
                            }
                        } else {
                            propertyValue.loadFullChangeBy(dataInput.readUTF());
                        }
                        if (n >= 262416) {
                            n4 = dataInput.readInt();
                            if (n4 == 0) {
                                propertyValue.setObject(null);
                            } else {
                                object = new byte[n4];
                                dataInput.readFully((byte[])object);
                                propertyValue.setObject(this.addElement((byte[])object));
                            }
                        }
                    } else {
                        switch (s) {
                            case 1: {
                                n4 = dataInput.readBoolean();
                                object = null;
                                if (stringArray2 != null && ChangedProperties.vBooleanToEnum.contains(string)) {
                                    int n5;
                                    Propertiable propertiable = (Propertiable)this.addImage.get(stringArray2[0]);
                                    int n6 = n5 = propertiable == null ? 0 : (Integer)propertiable.getNormalObject();
                                    if (n5 == 0) {
                                        if (string.equals("Bold") && n4 != 0) {
                                            n5 = 1;
                                        } else if (string.equals("Italic") && n4 != 0) {
                                            n5 = 2;
                                        }
                                    } else if (n5 == 1 && string.equals("Italic") && n4 != 0) {
                                        n5 = 3;
                                    } else if (n5 == 2 && string.equals("Bold") && n4 != 0) {
                                        n5 = 3;
                                    }
                                    object = new Integer(n5);
                                }
                                if (object == null) {
                                    propertyValue.setObject(new Boolean(n4 != 0));
                                    break;
                                }
                                propertyValue.setObject(object);
                                propertyValue.tag = 3;
                                break;
                            }
                            case 2: {
                                propertyValue.setObject(new Color(dataInput.readInt()));
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                int n7 = dataInput.readInt();
                                if (n < 5 && n != -1) {
                                    if (string.equals("FontSize") || string.equals("BorderSize") || string.equals("LabelWidth") || string.equals("LineWidth") || string.equals("BorderWidth")) {
                                        n7 = Unit.convertPixelToUnit(n7);
                                    }
                                } else if (n < 131087 && n != -1 && s == 4) {
                                    n7 = (int)Math.round((double)n7 * 5760.0 / 65535.0);
                                }
                                if (stringArray2 != null && string.equals("Type")) {
                                    switch (n7) {
                                        case 2: {
                                            n7 = ChartTypeInfo.BUILTINTYPES[0][3];
                                            break;
                                        }
                                        case 65539: {
                                            n7 = ChartTypeInfo.BUILTINTYPES[0][6];
                                            break;
                                        }
                                        case 131074: {
                                            n7 = ChartTypeInfo.BUILTINTYPES[0][4];
                                            break;
                                        }
                                        case 196610: {
                                            n7 = ChartTypeInfo.BUILTINTYPES[1][3];
                                            break;
                                        }
                                        case 262147: {
                                            n7 = ChartTypeInfo.BUILTINTYPES[1][6];
                                            break;
                                        }
                                        case 327682: {
                                            n7 = ChartTypeInfo.BUILTINTYPES[1][4];
                                            break;
                                        }
                                        case 393219: {
                                            n7 = ChartTypeInfo.BUILTINTYPES[2][3];
                                            break;
                                        }
                                        case 458754: {
                                            n7 = ChartTypeInfo.BUILTINTYPES[3][2];
                                            break;
                                        }
                                        case 524294: {
                                            n7 = ChartTypeInfo.BUILTINTYPES[4][1];
                                            break;
                                        }
                                    }
                                }
                                propertyValue.setObject(new Integer(n7));
                                break;
                            }
                            case 11: {
                                double d = dataInput.readDouble();
                                propertyValue.setObject(new Double(d));
                                break;
                            }
                            case 6: {
                                String string2 = dataInput.readUTF();
                                Vector<String> vector = null;
                                if (stringArray2 != null && ChangedProperties.vStringToVector.contains(string)) {
                                    vector = new Vector<String>();
                                    if (string.equals("GroupValueFormat")) {
                                        if (string2.indexOf("XX") > -1 || string2.indexOf("..") > -1 || string2.equals("X")) {
                                            vector.addElement(3 + string2);
                                        } else if (string2.indexOf("yy") > -1 || string2.indexOf("MM") > -1 || string2.indexOf("dd") > -1 || string2.indexOf("hh") > -1 || string2.indexOf("mm") > -1 || string2.indexOf("ss") > -1 || string2.indexOf("SS") > -1) {
                                            vector.addElement(2 + string2);
                                        } else if (string2.indexOf("#") > -1 || string2.indexOf("0") > -1) {
                                            vector.addElement(1 + string2);
                                        } else {
                                            vector.addElement(3 + string2);
                                        }
                                    } else {
                                        vector.addElement(string2);
                                    }
                                }
                                if (vector == null) {
                                    propertyValue.setObject(string2);
                                    break;
                                }
                                propertyValue.setObject(vector);
                                propertyValue.tag = 9;
                                break;
                            }
                            case 12: {
                                int n8 = dataInput.readInt();
                                Vector<Image> vector = new Vector<Image>(n8);
                                int n9 = n8;
                                while (n9-- > 0) {
                                    Image image = null;
                                    int n10 = dataInput.readInt();
                                    if (n10 != 0) {
                                        byte[] byArray = new byte[n10];
                                        dataInput.readFully(byArray);
                                        image = this.QOIV(byArray);
                                    }
                                    vector.add(image);
                                }
                                propertyValue.setObject(vector);
                                break;
                            }
                            case 7: {
                                Image image = null;
                                int n11 = dataInput.readInt();
                                if (n11 != 0) {
                                    byte[] byArray = new byte[n11];
                                    dataInput.readFully(byArray);
                                    image = this.QOIV(byArray);
                                }
                                propertyValue.setObject(image);
                                break;
                            }
                            case 13: {
                                int n12 = dataInput.readInt();
                                if (n12 == 0) break;
                                byte[] byArray = new byte[n12];
                                dataInput.readFully(byArray);
                                propertyValue.setObject(new String(byArray));
                                break;
                            }
                            case 8: {
                                boolean bl3;
                                String string3;
                                ObjectInputStream objectInputStream;
                                int n13 = dataInput.readInt();
                                if (n13 == 0) break;
                                byte[] byArray = new byte[n13];
                                dataInput.readFully(byArray);
                                try {
                                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                                    objectInputStream = new ObjectInputStream(byteArrayInputStream);
                                    string3 = objectInputStream.readUTF();
                                    bl3 = objectInputStream.readBoolean();
                                    if (!bl3) {
                                        propertyValue.setObject(objectInputStream.readObject());
                                    }
                                    objectInputStream.close();
                                }
                                catch (Exception exception) {
                                    if (!JRLog.isError(2)) break;
                                    JRLog.error(2, exception);
                                }
                                break;
                            }
                            case 9: {
                                int n14 = dataInput.readInt();
                                Vector<String> vector = new Vector<String>(n14);
                                int n15 = 0;
                                while (n15 < n14) {
                                    if (stringArray2 != null && string.indexOf("GroupColorList") > -1) {
                                        vector.addElement("c" + this.BUILTINTYPES(dataInput.readUTF()) + "000");
                                    } else {
                                        vector.addElement(dataInput.readUTF());
                                    }
                                    ++n15;
                                }
                                propertyValue.setObject(vector);
                                break;
                            }
                            case 14: {
                                boolean bl3;
                                String string3;
                                ObjectInputStream objectInputStream;
                                int n16 = dataInput.readInt();
                                if (n16 == 0) break;
                                byte[] byArray = new byte[n16];
                                dataInput.readFully(byArray);
                                try {
                                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                                    objectInputStream = new ObjectInputStream(byteArrayInputStream);
                                    string3 = objectInputStream.readUTF();
                                    bl3 = objectInputStream.readBoolean();
                                    if (!bl3) {
                                        propertyValue.setObject(objectInputStream.readObject());
                                    }
                                    objectInputStream.close();
                                }
                                catch (Exception exception) {
                                    if (!JRLog.isError(2)) break;
                                    JRLog.error(2, exception);
                                }
                                break;
                            }
                        }
                    }
                }
                if (stringArray2 != null) {
                    if (string.startsWith("NumberofGroups(")) {
                        n4 = (Integer)propertyValue.getNormalObject();
                        if (!propertyValue.isChangeByOther() && n4 > 0) {
                            propertyValue.setObject(new Integer(n4));
                        }
                        this.addProperty(stringArray2[1], (Propertiable)propertyValue);
                        object = new PropertyValue();
                        ((PropertyValue)object).tag = propertyValue.tag;
                        if (propertyValue.isChangeByOther() || n4 > 0) {
                            ((PropertyValue)object).setObject(new Integer(0));
                        } else {
                            ((PropertyValue)object).setObject(new Integer(-1));
                        }
                        this.addProperty(stringArray2[0], (Propertiable)object);
                    } else {
                        n4 = 0;
                        while (n4 < stringArray2.length) {
                            this.addProperty(stringArray2[n4], (Propertiable)propertyValue);
                            ++n4;
                        }
                    }
                } else {
                    this.addProperty(string, (Propertiable)propertyValue);
                }
            }
            ++n3;
        }
        if (n < 131091 && n != -1) {
            if (this.BUILTINTYPES == 71) {
                propertyValue = new PropertyValue();
                propertyValue.tag = 5;
                Propertiable propertiable = (Propertiable)this.addImage.get("Image");
                if (propertiable != null && propertiable.getObject() != null) {
                    propertyValue.setObject(new Integer(4));
                } else {
                    propertyValue.setObject(new Integer(1));
                }
                this.addProperty("FillPattern", (Propertiable)propertyValue);
                propertyValue = new PropertyValue();
                propertyValue.tag = 5;
                propertyValue.setObject(new Integer(2));
                this.addProperty("ImageLayout", (Propertiable)propertyValue);
            } else if (this.BUILTINTYPES == 72 || this.BUILTINTYPES == 70 || this.BUILTINTYPES == 69) {
                Propertiable propertiable;
                propertyValue = new PropertyValue();
                propertyValue.tag = 5;
                propertyValue.setObject(new Integer(1));
                this.addProperty("FillPattern", (Propertiable)propertyValue);
                if (this.BUILTINTYPES == 70 && (propertiable = (Propertiable)this.addImage.get("ShowLegend")) != null && !((Boolean)propertiable.getNormalObject()).booleanValue()) {
                    propertyValue = new PropertyValue();
                    propertyValue.tag = 1;
                    propertyValue.setObject(new Boolean(true));
                    this.addProperty("HideCategory", (Propertiable)propertyValue);
                    this.addProperty("HideSeries", (Propertiable)propertyValue);
                }
            }
        }
    }

    private String BUILTINTYPES(String string) {
        String string2;
        int n = 8 - string.length();
        switch (n) {
            case 1: {
                string2 = "0";
                break;
            }
            case 2: {
                string2 = "00";
                break;
            }
            case 3: {
                string2 = "000";
                break;
            }
            case 4: {
                string2 = "0000";
                break;
            }
            case 5: {
                string2 = "00000";
                break;
            }
            case 6: {
                string2 = "000000";
                break;
            }
            default: {
                string2 = "";
            }
        }
        if (n <= 0) {
            return string;
        }
        return "0x" + string2 + string.substring(2);
    }

    public Hashtable getProperties() {
        return this.addImage;
    }

    public boolean isLinkable() {
        return this.add;
    }

    public Vector getChildren() {
        return null;
    }

    public String getInstName() {
        Propertiable propertiable = (Propertiable)this.addImage.get("Name_");
        if (propertiable != null) {
            return (String)propertiable.getObject();
        }
        return null;
    }

    private Image QOIV(byte[] byArray) throws IOException {
        int n = PictureFileFormatDetector.getPictureFileType(byArray);
        Image image = null;
        if (n == 1) {
            BitmapReader bitmapReader = BitmapReader.loadFromBMP(new DataInputStream(new ByteArrayInputStream(byArray)));
            if (bitmapReader != null) {
                image = Toolkit.getDefaultToolkit().createImage(bitmapReader.getMemImgSrc());
                MediaTracker mediaTracker = new MediaTracker(new Canvas());
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, interruptedException);
                    }
                }
            }
        } else if (n == 4) {
            image = Toolkit.getDefaultToolkit().createImage(byArray);
            MediaTracker mediaTracker = new MediaTracker(new Canvas());
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, interruptedException);
                }
            }
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            image = ImageIO.read(byteArrayInputStream);
        }
        if (image != null && image.getWidth(null) > 0 && image.getHeight(null) > 0) {
            ImageLoader.backupImageType(image, new Integer(n));
        }
        return image;
    }

    public short getTopLineChangeByType() {
        Propertiable propertiable = this.getPropertyByName("TopLine");
        if (propertiable == null) {
            return -1;
        }
        return this.add(propertiable);
    }

    public short getBottomLineChangeByType() {
        Propertiable propertiable = this.getPropertyByName("BottomLine");
        if (propertiable == null) {
            return -1;
        }
        return this.add(propertiable);
    }

    public short getLeftLineChangeByType() {
        Propertiable propertiable = this.getPropertyByName("LeftLine");
        if (propertiable == null) {
            return -1;
        }
        return this.add(propertiable);
    }

    public short getRightLineChangeByType() {
        Propertiable propertiable = this.getPropertyByName("RightLine");
        if (propertiable == null) {
            return -1;
        }
        return this.add(propertiable);
    }

    public short getFontFaceChangeByType() {
        Propertiable propertiable = this.getPropertyByName("FontFace");
        if (propertiable == null) {
            return -1;
        }
        return this.add(propertiable);
    }

    public short getFontSizeChangeByType() {
        Propertiable propertiable = this.getPropertyByName("FontSize");
        if (propertiable == null) {
            return -1;
        }
        return this.add(propertiable);
    }

    public short getBoldChangeByType() {
        Propertiable propertiable = this.getPropertyByName("Bold");
        if (propertiable == null) {
            return -1;
        }
        return this.add(propertiable);
    }

    public short getItalicChangeByType() {
        Propertiable propertiable = this.getPropertyByName("Italic");
        if (propertiable == null) {
            return -1;
        }
        return this.add(propertiable);
    }

    public short getUnderlineChangeByType() {
        Propertiable propertiable = this.getPropertyByName("Underline");
        if (propertiable == null) {
            return -1;
        }
        return this.add(propertiable);
    }

    public short getForegroundChangeByType() {
        Propertiable propertiable = this.getPropertyByName("Foreground");
        if (propertiable == null) {
            return -1;
        }
        return this.add(propertiable);
    }

    public short getBackgroundByType() {
        Propertiable propertiable = this.getPropertyByName("Background");
        if (propertiable == null) {
            return -1;
        }
        return this.add(propertiable);
    }

    private short add(Propertiable propertiable) {
        short s = 0;
        if (propertiable.isChangeByOther()) {
            s = 1;
        }
        if (propertiable.isChagneByFmtt()) {
            s = (short)(2 | s);
        }
        if (propertiable.isChangeByBL()) {
            s = (short)(4 | s);
        }
        return s;
    }

    public DSTemplatible getBasedArea() {
        return null;
    }

    public DSTemplatible getBasedMapDBField() {
        return null;
    }

    public DSTemplatible getBasedMapTextField() {
        return null;
    }

    public Hashtable getDefaultProperties() {
        return null;
    }

    private Object addElement(byte[] byArray) {
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            boolean bl = objectInputStream.readBoolean();
            if (!bl) {
                object = objectInputStream.readObject();
            }
            objectInputStream.close();
        }
        catch (Exception exception) {
            JRLog.trace(6, 6200000, (Throwable)exception);
        }
        return object;
    }
}

