/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.awt.JFont;
import guitools.toolkit.Unit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.util.Vector;
import jet.datastream.DSControlSymbol;
import jet.datastream.DSParagraphText;
import jet.datastream.DSPicture;
import jet.datastream.JRVisiableResult;

public class ParagraphTools {
    public static boolean canNotBeginChar(char c) {
        int n = Character.getType(c);
        return Character.isWhitespace(c) || n == 20 || n == 22 || n == 24 || n == 14;
    }

    public static boolean isBreakChar(char c) {
        return Character.isWhitespace(c) || c == ' ' || Character.getType(c) == 14 || c > '\u2e80' && c < '\u9fff';
    }

    public static boolean isDoubleChar(char c) {
        return c > '\u2e80' && c < '\u9fff';
    }

    public static FontMetrics getFontMetrics(Font font) {
        return font instanceof JFont ? ((JFont)((Object)font)).getFontMetrics() : Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static int charsWidth(String string, int n, int n2, FontMetrics fontMetrics) {
        return fontMetrics.stringWidth(new String(string.toCharArray(), n, n2));
    }

    public static int textWidth(String string, int n, int n2, Font font) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, true);
        return (int)font.getStringBounds(new String(string.toCharArray(), n, n2), fontRenderContext).getBounds().getWidth();
    }

    public static int textWidthUsePrecision(String string, int n, int n2, Font font, boolean bl) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, bl);
        return (int)Math.round(font.getStringBounds(new String(string.toCharArray(), n, n2), fontRenderContext).getBounds().getWidth());
    }

    public static int textWidth(String string, FontMetrics fontMetrics) {
        return ParagraphTools.charsWidth(string, 0, string.length(), fontMetrics);
    }

    public static int textWidth(String string, Font font) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, true);
        int n = (int)font.getStringBounds(string, fontRenderContext).getBounds().getWidth();
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public static int textWidthUsePrecision(String string, Font font, boolean bl) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, bl);
        int n = (int)Math.round(font.getStringBounds(string, fontRenderContext).getBounds().getWidth());
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public static int textHeight(Font font) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, true);
        return (int)Math.round(font.getStringBounds("", fontRenderContext).getHeight());
    }

    public static int textHeightUsePrecision(Font font, boolean bl) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, bl);
        return (int)Math.round(font.getStringBounds("", fontRenderContext).getHeight());
    }

    public static double textHeight(String string, Font font) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, true);
        return font.getStringBounds("g", fontRenderContext).getHeight();
    }

    public static int textHeightUsePrecision(String string, Font font, boolean bl) {
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, bl);
        return (int)Math.round(font.getStringBounds("g", fontRenderContext).getHeight());
    }

    public static double getTextAscent(String string, Font font) {
        return ParagraphTools.getFontMetrics(font).getAscent();
    }

    public static double getTextDscent(String string, Font font) {
        return ParagraphTools.getFontMetrics(font).getDescent();
    }

    public static double getLeading(String string, Font font) {
        return ParagraphTools.getFontMetrics(font).getLeading();
    }

    public static int lastBreakPos(int n, int n2, String string) {
        int n3 = -1;
        char[] cArray = string.toCharArray();
        int n4 = n + n2 >= cArray.length ? n + n2 - 1 : n + n2;
        while (n4 >= 0) {
            if (ParagraphTools.isDoubleChar(cArray[n4])) {
                n3 = n2;
                break;
            }
            if (ParagraphTools.isBreakChar(cArray[n4])) {
                n3 = n4 + 1;
                break;
            }
            --n4;
        }
        return n3;
    }

    public static int getFirstDecimal(String string) {
        int n = -1;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < string.length() - 1) {
            if (('0' <= cArray[n2] || cArray[n2] <= '9') && '0' > cArray[n2 + 1] && cArray[n2 + 1] > '9') {
                n = n2;
                if (cArray[n2 + 1] != '.') break;
                n = n2 + 1;
                break;
            }
            if (cArray[n2] == '.') {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            n = string.length();
        }
        return n;
    }

    public static int getWidthBeforeFirstDecimalUsePrecision(String string, Font font, boolean bl) {
        return ParagraphTools.textWidthUsePrecision(string, 0, ParagraphTools.getFirstDecimal(string), font, bl);
    }

    public static int[] getWrapPostion(String string, Font font, int n) {
        int[] nArray = new int[]{-1, -1};
        int n2 = Math.round(string.length() * n / ParagraphTools.textWidth(string, font));
        if (string.length() * n / ParagraphTools.textWidth(string, font) < 1) {
            return nArray;
        }
        if (ParagraphTools.textWidth(string, 0, n2, font) <= n) {
            if (ParagraphTools.textWidth(string, 0, n2, font) == n) {
                nArray[1] = n2;
            }
            int n3 = n2 + 1;
            while (n3 <= string.length()) {
                if (ParagraphTools.textWidth(string, 0, n3, font) > n) {
                    nArray[1] = n3 - 1;
                    break;
                }
                if (ParagraphTools.textWidth(string, 0, n3, font) == n) {
                    nArray[1] = n3;
                    break;
                }
                ++n3;
            }
        } else {
            int n4 = n2 - 1;
            while (n4 >= 0) {
                if (ParagraphTools.textWidth(string, 0, n4, font) <= n) {
                    nArray[1] = n4;
                    break;
                }
                if (ParagraphTools.textWidth(string, 0, n4, font) == n) {
                    nArray[1] = n4;
                    break;
                }
                --n4;
            }
        }
        nArray[0] = ParagraphTools.lastBreakPos(0, nArray[1], string);
        return nArray;
    }

    public static int[] getWrapPostionUsePrecision(String string, Font font, int n, boolean bl) {
        int[] nArray = new int[]{-1, -1};
        int n2 = Math.round(string.length() * n / ParagraphTools.textWidthUsePrecision(string, font, bl));
        if (string.length() * n / ParagraphTools.textWidthUsePrecision(string, font, bl) < 1) {
            return nArray;
        }
        if (ParagraphTools.textWidthUsePrecision(string, 0, n2, font, bl) <= n) {
            if (ParagraphTools.textWidthUsePrecision(string, 0, n2, font, bl) == n) {
                nArray[1] = n2;
            }
            int n3 = n2 + 1;
            while (n3 <= string.length()) {
                if (ParagraphTools.textWidthUsePrecision(string, 0, n3, font, bl) > n) {
                    nArray[1] = n3 - 1;
                    break;
                }
                if (ParagraphTools.textWidthUsePrecision(string, 0, n3, font, bl) == n) {
                    nArray[1] = n3;
                    break;
                }
                ++n3;
            }
        } else {
            int n4 = n2 - 1;
            while (n4 >= 0) {
                if (ParagraphTools.textWidthUsePrecision(string, 0, n4, font, bl) <= n) {
                    nArray[1] = n4;
                    break;
                }
                if (ParagraphTools.textWidthUsePrecision(string, 0, n4, font, bl) == n) {
                    nArray[1] = n4;
                    break;
                }
                --n4;
            }
        }
        nArray[0] = ParagraphTools.lastBreakPos(0, nArray[1], string);
        return nArray;
    }

    public static Vector layoutLineElements(Vector vector, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17 = n;
        int n18 = 0;
        while (n18 < vector.size()) {
            if (vector.elementAt(n18) instanceof DSParagraphText) {
                ((DSParagraphText)vector.elementAt(n18)).setX(n17);
                n17 += ((DSParagraphText)vector.elementAt(n18)).getTextWidth();
            } else if (vector.elementAt(n18) instanceof DSControlSymbol) {
                n16 = 0;
                n15 = 0;
                n14 = n17;
                n13 = 0;
                n12 = 0;
                n11 = ((DSControlSymbol)vector.elementAt(n18)).getAlignment(n17);
                ((DSControlSymbol)vector.elementAt(n18)).setX(n17);
                switch (n11) {
                    case 0: {
                        n17 = ((DSControlSymbol)vector.elementAt(n18)).getStop(n17);
                        ((DSControlSymbol)vector.elementAt(n18)).setTabWidth(n17 - n14);
                        break;
                    }
                    case 1: {
                        n15 = ((DSControlSymbol)vector.elementAt(n18)).getStop(n17) - n14;
                        n13 = n18;
                        n10 = n18 + 1;
                        while (n10 < vector.size()) {
                            n13 = n10;
                            if (vector.elementAt(n10) instanceof DSParagraphText) {
                                n16 += ((DSParagraphText)vector.elementAt(n10)).getTextWidth();
                            } else {
                                if (vector.elementAt(n10) instanceof DSControlSymbol) {
                                    n13 = n10 - 1;
                                    break;
                                }
                                n16 += ((JRVisiableResult)vector.elementAt(n10)).getWidth();
                            }
                            ++n10;
                        }
                        if (n15 > n16) {
                            n12 = n15 - n16;
                            n17 = ((DSControlSymbol)vector.elementAt(n18)).getStop(n17);
                        } else {
                            n17 += n16;
                        }
                        ((DSControlSymbol)vector.elementAt(n18)).setTabWidth(n12);
                        n9 = n18;
                        while (n9 < n13 + 1) {
                            if (vector.elementAt(n9) instanceof DSParagraphText) {
                                ((DSParagraphText)vector.elementAt(n9)).setX(n14);
                                n14 += ((DSParagraphText)vector.elementAt(n9)).getTextWidth();
                            } else if (vector.elementAt(n9) instanceof DSControlSymbol) {
                                n14 += n12;
                            } else {
                                ((JRVisiableResult)vector.elementAt(n9)).setX(n14);
                                n14 += ((JRVisiableResult)vector.elementAt(n9)).getWidth();
                            }
                            ++n9;
                        }
                        n18 = n13;
                        break;
                    }
                    case 2: {
                        n15 = ((DSControlSymbol)vector.elementAt(n18)).getStop(n17) - n14;
                        n13 = n18;
                        n8 = n18 + 1;
                        while (n8 < vector.size()) {
                            n13 = n8;
                            if (vector.elementAt(n8) instanceof DSParagraphText) {
                                n16 += ((DSParagraphText)vector.elementAt(n8)).getTextWidth();
                            } else {
                                if (vector.elementAt(n8) instanceof DSControlSymbol) {
                                    n13 = n8 - 1;
                                    break;
                                }
                                n16 += ((JRVisiableResult)vector.elementAt(n8)).getWidth();
                            }
                            ++n8;
                        }
                        if (n15 > n16 / 2) {
                            n12 = n15 - n16 / 2;
                            n17 = ((DSControlSymbol)vector.elementAt(n18)).getStop(n17) + n16 / 2;
                            if (n17 > n + n2) {
                                if (n2 - n14 + n > n16) {
                                    n17 = n + n2;
                                    n12 = n15 - n16;
                                } else {
                                    n17 = n14 + n16;
                                    n12 = 0;
                                }
                            }
                        } else {
                            n17 += n16;
                            n12 = 0;
                        }
                        ((DSControlSymbol)vector.elementAt(n18)).setX(n14);
                        ((DSControlSymbol)vector.elementAt(n18)).setTabWidth(n12);
                        n7 = n18;
                        while (n7 < n13 + 1) {
                            if (vector.elementAt(n7) instanceof DSParagraphText) {
                                ((DSParagraphText)vector.elementAt(n7)).setX(n14);
                                n14 += ((DSParagraphText)vector.elementAt(n7)).getTextWidth();
                            } else if (vector.elementAt(n7) instanceof DSControlSymbol) {
                                n14 += n12;
                            } else {
                                ((JRVisiableResult)vector.elementAt(n7)).setX(n14);
                                n14 += ((JRVisiableResult)vector.elementAt(n7)).getWidth();
                            }
                            ++n7;
                        }
                        n18 = n13;
                        break;
                    }
                    case 3: {
                        n6 = 0;
                        int n19 = 0;
                        n15 = ((DSControlSymbol)vector.elementAt(n18)).getStop(n17) - n14;
                        n13 = n18;
                        n5 = n18 + 1;
                        while (n5 < vector.size()) {
                            n13 = n5;
                            if (vector.elementAt(n5) instanceof DSParagraphText) {
                                if (((DSParagraphText)vector.elementAt(n5)).getBeforeDecimalWidth() != ((DSParagraphText)vector.elementAt(n5)).getTextWidth()) {
                                    ++n6;
                                }
                                if (n6 < 2) {
                                    n19 += ((DSParagraphText)vector.elementAt(n5)).getBeforeDecimalWidth();
                                }
                                n16 += ((DSParagraphText)vector.elementAt(n5)).getTextWidth();
                            } else {
                                if (vector.elementAt(n5) instanceof DSControlSymbol) {
                                    n13 = n5 - 1;
                                    break;
                                }
                                n16 += ((JRVisiableResult)vector.elementAt(n5)).getWidth();
                                if (n19 == 0) {
                                    n19 = n16;
                                }
                            }
                            ++n5;
                        }
                        if (n19 == 0) {
                            n19 = n16;
                        }
                        if (n15 > n19) {
                            n12 = n15 - n19;
                            n17 = ((DSControlSymbol)vector.elementAt(n18)).getStop(n17) + n16 - n19;
                            if (n17 > n + n2) {
                                if (n2 - n14 + n > n16) {
                                    n17 = n + n2;
                                    n12 = n15 - n16;
                                } else {
                                    n17 = n14 + n16;
                                    n12 = 0;
                                }
                            }
                        } else {
                            n17 += n16;
                        }
                        ((DSControlSymbol)vector.elementAt(n18)).setX(n14);
                        ((DSControlSymbol)vector.elementAt(n18)).setTabWidth(n12);
                        n4 = n18;
                        while (n4 < n13 + 1) {
                            if (vector.elementAt(n4) instanceof DSParagraphText) {
                                ((DSParagraphText)vector.elementAt(n4)).setX(n14);
                                n14 += ((DSParagraphText)vector.elementAt(n4)).getTextWidth();
                            } else if (vector.elementAt(n4) instanceof DSControlSymbol) {
                                n14 += n12;
                            } else {
                                ((JRVisiableResult)vector.elementAt(n4)).setX(n14);
                                n14 += ((JRVisiableResult)vector.elementAt(n4)).getWidth();
                            }
                            ++n4;
                        }
                        n18 = n13;
                        break;
                    }
                    default: {
                        new Exception("tab Alignment is wrong").printStackTrace();
                        break;
                    }
                }
            } else {
                ((JRVisiableResult)vector.elementAt(n18)).setX(n17);
                n17 += ((JRVisiableResult)vector.elementAt(n18)).getWidth();
            }
            ++n18;
        }
        n16 = 0;
        n15 = 0;
        n15 = n2 - n17 + n;
        if (n15 < 0) {
            n15 = 0;
        }
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                if (n15 <= 0) break;
                n16 = n15;
                n14 = 0;
                n13 = 0;
                while (n13 < vector.size()) {
                    if (vector.elementAt(n13) instanceof DSParagraphText) {
                        n14 = ((DSParagraphText)vector.elementAt(n13)).getX();
                        ((DSParagraphText)vector.elementAt(n13)).setX(n14 + n16);
                    } else if (vector.elementAt(n13) instanceof DSControlSymbol) {
                        n14 = ((DSControlSymbol)vector.elementAt(n13)).getX();
                        ((DSControlSymbol)vector.elementAt(n13)).setX(n14 + n16);
                    } else {
                        n14 = ((JRVisiableResult)vector.elementAt(n13)).getX();
                        ((JRVisiableResult)vector.elementAt(n13)).setX(n14 + n16);
                    }
                    ++n13;
                }
                break;
            }
            case 2: {
                if (n15 <= 0) break;
                n16 = n15 / 2;
                n14 = 0;
                n13 = 0;
                while (n13 < vector.size()) {
                    if (vector.elementAt(n13) instanceof DSParagraphText) {
                        n14 = ((DSParagraphText)vector.elementAt(n13)).getX();
                        ((DSParagraphText)vector.elementAt(n13)).setX(n14 + n16);
                    } else if (vector.elementAt(n13) instanceof DSControlSymbol) {
                        n14 = ((DSControlSymbol)vector.elementAt(n13)).getX();
                        ((DSControlSymbol)vector.elementAt(n13)).setX(n14 + n16);
                    } else {
                        n14 = ((JRVisiableResult)vector.elementAt(n13)).getX();
                        ((JRVisiableResult)vector.elementAt(n13)).setX(n14 + n16);
                    }
                    ++n13;
                }
                break;
            }
            case 3: {
                if (n15 <= 0) break;
                n16 = n15;
                n14 = 0;
                n13 = vector.size();
                n12 = 0;
                n11 = 0;
                n10 = 0;
                n9 = -1;
                n8 = 0;
                n7 = 0;
                n6 = 0;
                while (n6 < vector.size()) {
                    if (vector.elementAt(n6) instanceof DSParagraphText) {
                        n12 += ((DSParagraphText)vector.elementAt(n6)).getWhiteSpaceNum();
                    } else if (vector.elementAt(n6) instanceof DSControlSymbol) {
                        n9 = n6;
                        n12 = 0;
                    }
                    ++n6;
                }
                if (n9 != -1 && ((DSControlSymbol)vector.elementAt(n9)).getAlignment(((DSControlSymbol)vector.elementAt(n9)).getX()) != 0) {
                    n16 += ((DSControlSymbol)vector.elementAt(n9)).getTabWidth();
                    ((DSControlSymbol)vector.elementAt(n9)).setTabWidth(0);
                }
                if (n9 != -1 && vector.elementAt(n9 + 1) instanceof DSParagraphText) {
                    n11 = ((DSParagraphText)vector.elementAt(n9 + 1)).getBeforeWordWNum();
                }
                if (vector.size() > 0 && vector.elementAt(vector.size() - 1) instanceof DSParagraphText) {
                    n10 = ((DSParagraphText)vector.elementAt(n9 + 1)).getAfterWordWNum();
                }
                if ((n12 = n12 - n11 - n10) != 0) {
                    n8 = n16 / n12;
                }
                if (n9 != -1 && vector.elementAt(n9 + 1) instanceof DSParagraphText) {
                    int[] nArray = new int[((DSParagraphText)vector.elementAt(n9 + 1)).getWhiteSpaceNum()];
                    n5 = 0;
                    while (n5 < n11) {
                        nArray[n5] = 0;
                        ++n5;
                    }
                    n4 = n11;
                    while (n4 < nArray.length) {
                        nArray[n4] = n8;
                        ++n4;
                    }
                    ((DSParagraphText)vector.elementAt(n9 + 1)).setWhitSpaceWidth(nArray);
                }
                int n20 = n9 + 1;
                while (n20 < vector.size() - 1) {
                    if (vector.elementAt(n20) instanceof DSParagraphText) {
                        int[] nArray = new int[((DSParagraphText)vector.elementAt(n20)).getWhiteSpaceNum()];
                        n4 = 0;
                        while (n4 < nArray.length) {
                            nArray[n4] = n8;
                            ++n4;
                        }
                        ((DSParagraphText)vector.elementAt(n20)).setWhitSpaceWidth(nArray);
                    }
                    ++n20;
                }
                if (vector.size() > 0 && vector.elementAt(vector.size() - 1) instanceof DSParagraphText) {
                    int[] nArray = new int[((DSParagraphText)vector.elementAt(vector.size() - 1)).getWhiteSpaceNum()];
                    n4 = 0;
                    while (n4 < nArray.length - n10) {
                        nArray[n4] = n8;
                        ++n4;
                    }
                    int n21 = nArray.length - n10;
                    while (n21 < nArray.length) {
                        nArray[n21] = 0;
                        ++n21;
                    }
                    ((DSParagraphText)vector.elementAt(vector.size() - 1)).setWhitSpaceWidth(nArray);
                }
                n7 = n9 != -1 ? ((DSControlSymbol)vector.elementAt(n9)).getTabWidth() + ((DSControlSymbol)vector.elementAt(n9)).getX() : n;
                int n22 = n9 + 1;
                while (n22 < vector.size()) {
                    n4 = 0;
                    if (vector.elementAt(n22) instanceof DSParagraphText) {
                        int[] nArray = new int[((DSParagraphText)vector.elementAt(n22)).getWhiteSpaceNum()];
                        nArray = ((DSParagraphText)vector.elementAt(n22)).getWhiteSpaceWidth();
                        ((DSParagraphText)vector.elementAt(n22)).setX(n7);
                        int n23 = 0;
                        while (n23 < nArray.length) {
                            n4 += nArray[n23];
                            ++n23;
                        }
                        n7 = n7 + n4 + ((DSParagraphText)vector.elementAt(n22)).getTextWidth();
                    } else {
                        ((JRVisiableResult)vector.elementAt(n22)).setX(n7);
                        n7 += ((JRVisiableResult)vector.elementAt(n22)).getWidth();
                    }
                    ++n22;
                }
                n4 = 0;
                while (n4 < vector.size()) {
                    if (vector.elementAt(n4) instanceof DSParagraphText) {
                        ((DSParagraphText)vector.elementAt(n4)).calculateJustifyWords();
                    }
                    ++n4;
                }
                break;
            }
        }
        return vector;
    }

    public static int getBeforeWordWNum(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < string.length()) {
            if (cArray[n2] != ' ') break;
            ++n;
            ++n2;
        }
        return n;
    }

    public static int getAfterWordWNum(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            if (cArray[n2] != ' ') break;
            ++n;
            --n2;
        }
        return n;
    }

    public static int getWhiteSpaceNum(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < string.length()) {
            if (cArray[n2] == ' ') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static int getMaxHeight(Vector vector) {
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            n = vector.elementAt(n2) instanceof DSParagraphText ? Math.max(n, ((DSParagraphText)vector.elementAt(n2)).getTextHeight()) : (vector.elementAt(n2) instanceof DSControlSymbol ? Math.max(n, ((DSControlSymbol)vector.elementAt(n2)).getTabHeight()) : Math.max(n, ((JRVisiableResult)vector.elementAt(n2)).getHeight()));
            ++n2;
        }
        return n;
    }

    public static int getMaxTextHeight(Vector vector) {
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) instanceof DSParagraphText) {
                n = Math.max(n, ((DSParagraphText)vector.elementAt(n2)).getTextHeight());
            }
            ++n2;
        }
        return n;
    }

    public static float getBaseLineY(Vector vector) {
        float f = 0.0f;
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof DSParagraphText) {
                f = Math.max(f, (float)((DSParagraphText)vector.elementAt(n)).getTextBaseLineY());
            }
            ++n;
        }
        return f;
    }

    public static float getTextBaseLineY(String string, Font font) {
        return (float)ParagraphTools.getTextAscent(string, font);
    }

    public static boolean haveOtherObject(Vector vector) {
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            if (!(vector.elementAt(n) instanceof DSParagraphText) && !(vector.elementAt(n) instanceof DSControlSymbol)) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public static void paintText(Graphics graphics, String string, int n, int n2, int n3, Font font) {
    }

    public static int[] getPictureWH(DSPicture dSPicture) {
        int[] nArray = new int[]{dSPicture.getWidth(), dSPicture.getHeight()};
        return nArray;
    }

    public static int getPictureW(DSPicture dSPicture) {
        return ParagraphTools.getPictureWH(dSPicture)[0];
    }

    public static int getPictureH(DSPicture dSPicture) {
        return ParagraphTools.getPictureWH(dSPicture)[1];
    }

    public static int getErrorWidth(String string, Vector vector, Font font) {
        int n = ParagraphTools.textWidth(string, font);
        int n2 = 0;
        int n3 = 0;
        while (n3 < vector.size()) {
            n2 += ParagraphTools.textWidth((String)vector.elementAt(n3), font);
            ++n3;
        }
        int n4 = Unit.convertPixelToUnit(n2 - n) / vector.size();
        return n4;
    }

    public static int splitDrityData(String string, int n, Font font) {
        int[] nArray = new int[]{n};
        int n2 = ParagraphTools.layoutText(string, nArray, font)[0][1];
        return n2;
    }

    public static int[][] layoutText(String string, int[] nArray, Font font) {
        int n;
        int[][] nArray2 = new int[nArray.length][2];
        int n2 = 0;
        int n3 = nArray.length;
        while (n2 < n3) {
            if (n2 == 0) {
                nArray2[n2][0] = 0;
                if (ParagraphTools.textWidth(string, font) > nArray[0]) {
                    int[] nArray3 = ParagraphTools.getWrapPostion(string, font, nArray[0]);
                    nArray2[n2][1] = nArray3[0] != -1 ? nArray3[0] : nArray3[1];
                } else {
                    nArray2[n2][1] = string.length();
                }
            } else {
                int n4 = 0;
                n = 0;
                while (n < n2) {
                    n4 += nArray2[n][1];
                    ++n;
                }
                if (n4 == string.length()) {
                    nArray2[n2][0] = 0;
                    nArray2[n2][1] = 0;
                    break;
                }
                nArray2[n2][0] = n4;
                if (ParagraphTools.textWidth(string.substring(nArray2[n2][0]), font) > nArray[n2]) {
                    int[] nArray4 = ParagraphTools.getWrapPostion(string.substring(nArray2[n2][0]), font, nArray[n2]);
                    nArray2[n2][1] = nArray4[0] != -1 ? nArray4[0] : nArray4[1];
                } else {
                    nArray2[n2][1] = string.length() - nArray2[n2][0];
                }
            }
            ++n2;
        }
        int n5 = 0;
        n = nArray.length;
        while (n5 < n) {
            nArray2[n5][1] = nArray2[n5][1] + nArray2[n5][0];
            ++n5;
        }
        return nArray2;
    }
}

