/*
 * Decompiled with CFR 0.152.
 */
package jet.export.html;

import com.jinfonet.image.encoder.ImageFrame;
import com.jinfonet.image.encoder.ImageFrameGrabber;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import jet.datastream.JRObjectResult;
import jet.export.util.CCUtil;
import jet.export.util.ImageEncoder;
import jet.export.util.ImageGrabber;
import jet.ie.ChartProTextConverter;
import jet.util.FontSets;

public class HtmlUtil {
    static final Map ENGLISH = new HashMap();

    public static String HTMLEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        HtmlUtil.HTMLEncode(string, stringBuffer);
        return stringBuffer.toString();
    }

    public static String escapeFileName(String string) {
        int n = string.length();
        char c = '-';
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c == '\\' || c == '/' || c == ':' || c == '*' || c == '?' || c == '\"' || c == '<' || c == '>' || c == '|') {
                stringBuffer.append('-');
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void HTMLEncode(String string, StringBuffer stringBuffer) {
        if (string != null) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                switch (c) {
                    case ' ': {
                        stringBuffer.append("&nbsp;");
                        break;
                    }
                    case '&': {
                        stringBuffer.append("&amp;");
                        break;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        break;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        break;
                    }
                    case '\'': {
                        stringBuffer.append("&acute;");
                        break;
                    }
                    case '\u00a9': {
                        stringBuffer.append("&copy;");
                        break;
                    }
                    case '\u00ae': {
                        stringBuffer.append("&reg;");
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                ++n;
            }
        }
    }

    public static String getFilename(String string) {
        File file = new File(string);
        return file.getName();
    }

    public static String getFilePath(String string) {
        String string2 = HtmlUtil.getFilename(string);
        return string.substring(0, string.lastIndexOf(string2));
    }

    public static String getFilenameHead(String string) {
        String string2;
        String string3 = HtmlUtil.getFilename(string);
        int n = string3.lastIndexOf(46);
        String string4 = n != -1 && n != 0 ? ((string2 = string3.substring(n).toLowerCase()).equals(".htm") || string2.equals(".html") ? string3.substring(0, n) : string3) : string3;
        return string4;
    }

    public static String getFontName(String string) {
        String string2 = (String)ENGLISH.get(string.toLowerCase());
        if (string2 == null || string2.length() == 0) {
            Font font = FontSets.getFont(string, 0, 16);
            string2 = font.getFontName(Locale.ENGLISH);
            ENGLISH.put(string, string2);
        }
        return string2;
    }

    public static String getColorString(Color color) {
        if (color == null) {
            return null;
        }
        return Integer.toHexString(color.getRGB()).substring(2);
    }

    public static String getHtmlBgColorTags(Color color) {
        if (color != null) {
            return new String("background-color:#" + HtmlUtil.getColorString(color) + ";");
        }
        return "";
    }

    public static String getHtmlFileNameHeader(File file) {
        String string = file.getName();
        int n = string.length();
        String string2 = string.substring(string.lastIndexOf(46) == -1 ? 0 : string.lastIndexOf(46), n);
        if (string2.equalsIgnoreCase(".html") || string2.equalsIgnoreCase(".htm")) {
            return string.substring(0, string.lastIndexOf(46));
        }
        return string;
    }

    public static String getAppletChartHtmlCodes(Map map, int n, int n2, int n3, int n4, String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<applet alt=\"" + string2 + "\" code=\"jet.viewerchart1.appletChart.class\" archive=\"chart.jar\" style=\"position:absolute;left:" + n + "px;top:" + n2 + "px;width:" + n3 + "px; height:" + n4 + "px;\" " + "width=\"" + n3 + "px\" height=\"" + n4 + "px\" " + ">");
        if (string != null) {
            stringBuffer.append("<param name=\"DrilldownPrefix\" value=\"").append(string).append("\" />");
        }
        stringBuffer.append("\t\t<param name=\"chartValue\" value=\"").append(HtmlUtil.ENGLISH(map)).append("\" />\n");
        stringBuffer.append("\t\t\tNo Java 2 SDK, Standard Edition v 1.3 support for APPLET!!\r\n").append("\t</applet>\n");
        return stringBuffer.toString();
    }

    private static String ENGLISH(Map map) throws IOException {
        ChartProTextConverter chartProTextConverter = new ChartProTextConverter(map);
        chartProTextConverter.ziped(false);
        return chartProTextConverter.convert();
    }

    public static int getFontStyle(String string) {
        if (FontSets.isTrueType(string)) {
            return FontSets.getTrueTypeFontStyle(string);
        }
        return -1;
    }

    public int getRealFontStyle(JRObjectResult jRObjectResult, String string) {
        int n = HtmlUtil.getFontStyle(string);
        int n2 = 0;
        if (n != -1) {
            if ((n & 1) == 1) {
                n2 |= 1;
            }
            if ((n & 2) == 2) {
                n2 |= 2;
            }
        } else {
            if (CCUtil.getBooleanPropertyByName(jRObjectResult, "Bold")) {
                n2 |= 1;
            }
            if (CCUtil.getBooleanPropertyByName(jRObjectResult, "Italic")) {
                n2 |= 2;
            }
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String I(String string, Image image, int n) throws IOException {
        String string3;
        byte[] byArray;
        String string2 = null;
        if (image == null) return string2;
        ImageEncoder imageEncoder = new ImageEncoder();
        if (n != 4 && n != 0 && n != 3) {
            n = HtmlUtil.HTMLEncode(image);
        }
        switch (n) {
            case 4: {
                byArray = imageEncoder.renderImageToGif(image);
                string3 = ".gif";
                break;
            }
            case 3: {
                byArray = imageEncoder.renderImageToPNG(image);
                string3 = ".png";
                break;
            }
            default: {
                byArray = imageEncoder.renderImageToJpeg(image);
                string3 = ".jpg";
            }
        }
        string2 = string + string3;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
        try {
            bufferedOutputStream.write(byArray);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            bufferedOutputStream.close();
            throw throwable;
        }
        bufferedOutputStream.close();
        return string2;
    }

    static int HTMLEncode(Image image) {
        Object object;
        Vector vector = new Vector();
        if (!new ImageFrameGrabber().startGrab(image, vector)) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            object = (ImageFrame)vector.elementAt(n2);
            n = Math.max(((ImageFrame)object).model.getPixelSize(), n);
            ++n2;
        }
        object = new ImageGrabber(image);
        if (n > 8 && ((ImageGrabber)object).hasAlpha()) {
            return 3;
        }
        if (n > 8 && vector.size() == 1) {
            return 0;
        }
        return 4;
    }

    static String I(String string) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            switch (c) {
                case ' ': 
                case '\"': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '{': 
                case '}': {
                    stringBuffer.append(URLEncoder.encode(stringBuffer2.toString(), "utf-8"));
                    stringBuffer.append(c);
                    stringBuffer2 = new StringBuffer();
                    break;
                }
                default: {
                    stringBuffer2.append(c);
                }
            }
            ++n;
        }
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void I(String string, String string2) throws IOException {
        BufferedInputStream bufferedInputStream;
        BufferedInputStream bufferedInputStream2 = bufferedInputStream = new BufferedInputStream(ClassLoader.getSystemResourceAsStream(string));
        synchronized (bufferedInputStream2) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            try {
                HtmlUtil.copySrc2Dex(bufferedInputStream, bufferedOutputStream);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                bufferedInputStream.close();
                bufferedOutputStream.close();
                throw throwable;
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
    }

    protected static void copySrc2Dex(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[10240];
        while ((n = bufferedInputStream.read(byArray)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
    }

    static {
        ENGLISH.put("default", "Arial");
        ENGLISH.put("dialog", "Arial");
        ENGLISH.put("sansserif", "Arial");
        ENGLISH.put("serif", "'Times New Roman'");
        ENGLISH.put("helvetica", "sansserif");
        ENGLISH.put("timesroman", "serif");
        ENGLISH.put("courier", "'Courier New'");
        ENGLISH.put("dialoginput", "'Courier New'");
        ENGLISH.put("zapfdingbats", "WingDings");
    }
}

