/*
 * Decompiled with CFR 0.152.
 */
package jet.export.pdf;

import com.jinfonet.util.JRLog;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jet.bean.PDFParameter;
import jet.export.ExpException;
import jet.export.pdf.PDFWriter;

public class PDFImporter {
    private PdfReader QOIV;
    private int addPage;
    private PDFParameter close;
    PdfCopy encrypt;
    Document error;

    public PDFImporter(PDFParameter pDFParameter) {
        this.close = pDFParameter;
    }

    public boolean openSourcePDFFile(String string) throws ExpException {
        boolean bl = false;
        try {
            if (this.close.hasEncryption()) {
                String string2 = this.close.getOwnerPassword();
                if (string2 == null || string2.length() == 0) {
                    string2 = this.close.getUserPassword();
                }
                this.QOIV = new PdfReader(string, string2.getBytes());
            } else {
                this.QOIV = new PdfReader(string);
            }
            this.addPage = this.QOIV.getNumberOfPages();
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401013, (Throwable)fileNotFoundException);
            }
            throw new ExpException(401021, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401014, (Throwable)iOException);
            }
            throw new ExpException(401021, (Throwable)iOException);
        }
        return bl;
    }

    public void closeSourcePDFFile() {
        this.QOIV = null;
    }

    public int getTotalPagesNumberOfSourcePDF() {
        return this.addPage;
    }

    void QOIV(String string) throws ExpException {
        this.error = new Document(this.QOIV.getPageSizeWithRotation(1));
        try {
            this.encrypt = new PdfCopy(this.error, (OutputStream)new FileOutputStream(string));
            PDFWriter.encrypt((PdfWriter)this.encrypt, this.close);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401015, (Throwable)fileNotFoundException);
            }
            throw new ExpException(401021, (Throwable)fileNotFoundException);
        }
        catch (DocumentException documentException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401016, (Throwable)documentException);
            }
            throw new ExpException(401021, (Throwable)documentException);
        }
    }

    public void importPDFFile(String string, int n, int n2) throws ExpException {
        if (this.addPage < n2) {
            return;
        }
        this.QOIV(string);
        this.error.open();
        try {
            PdfImportedPage pdfImportedPage;
            try {
                int n3 = n;
                while (n3 <= n2) {
                    pdfImportedPage = this.encrypt.getImportedPage(this.QOIV, n3);
                    this.encrypt.addPage(pdfImportedPage);
                    ++n3;
                }
            }
            catch (Exception exception) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2401017, (Throwable)exception);
                }
                throw new ExpException(401001, (Throwable)exception);
            }
            Object var7_8 = null;
            pdfImportedPage = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            Object var4_7 = null;
            this.error.close();
            this.error = null;
            this.encrypt = null;
            throw throwable;
        }
        this.error.close();
        this.error = null;
        this.encrypt = null;
    }
}

