/*
 * Decompiled with CFR 0.152.
 */
package jet.export.pdf;

import com.jinfonet.util.JRLog;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.HashMap;
import jet.bean.PDFParameter;
import jet.datastream.TOCNode;
import jet.export.pdf.PDFConstants;
import jet.export.pdf.PdfExt;
import jet.export.util.ImageEncoder;
import jet.util.IntKeyHashtable;
import jet.util.MessageDigestMaker;

public class PDFWriter
implements PDFConstants {
    static Toolkit I = Toolkit.getDefaultToolkit();
    static HashMap QOIV = new HashMap();
    int SELF_SIGNED = 0;
    Font VERISIGN_SIGNED;
    Dimension WINCER_SIGNED;
    PdfExt Z;
    boolean addImage = false;
    PdfWriter aliases;
    PdfContentByte append;
    IntKeyHashtable arc;
    MessageDigestMaker beginText;
    int clear = -1;
    HashMap clip = new HashMap();

    public PDFWriter(PdfExt pdfExt, String string, PDFParameter pDFParameter) throws IOException, DocumentException {
        this.Z = pdfExt;
        this.aliases = PdfWriter.getInstance((Document)pdfExt, (OutputStream)new BufferedOutputStream(new FileOutputStream(string)));
        int n = pDFParameter.getImageCompressRatio();
        if (pDFParameter.isTransparent()) {
            n = -1;
        } else {
            this.clear = n < 0 || n > 100 ? -1 : 100 - n;
        }
        this.arc = new IntKeyHashtable();
        this.beginText = new MessageDigestMaker();
        if (pDFParameter != null && !pDFParameter.hasSignature()) {
            PDFWriter.encrypt(this.aliases, pDFParameter);
        }
    }

    public PDFWriter(PdfExt pdfExt, OutputStream outputStream, PDFParameter pDFParameter) throws DocumentException {
        this.Z = pdfExt;
        this.aliases = PdfWriter.getInstance((Document)pdfExt, (OutputStream)outputStream);
        int n = pDFParameter.getImageCompressRatio();
        if (pDFParameter.isTransparent()) {
            n = -1;
        } else {
            this.clear = n < 0 || n > 100 ? -1 : 100 - n;
        }
        this.arc = new IntKeyHashtable();
        this.beginText = new MessageDigestMaker();
        if (pDFParameter != null && !pDFParameter.hasSignature()) {
            PDFWriter.encrypt(this.aliases, pDFParameter);
        }
    }

    public void open(Dimension dimension, Color color) {
        this.WINCER_SIGNED = dimension;
        Rectangle rectangle = new Rectangle(0.0f, 0.0f, (float)this.WINCER_SIGNED.width, (float)this.WINCER_SIGNED.height);
        rectangle.setBackgroundColor(color);
        this.Z.setPageSize(rectangle);
        this.Z.open();
        this.append = this.aliases.getDirectContent();
    }

    void I(Dimension dimension, Color color) throws DocumentException {
        this.WINCER_SIGNED = dimension;
        Rectangle rectangle = new Rectangle(0.0f, 0.0f, (float)this.WINCER_SIGNED.width, (float)this.WINCER_SIGNED.height);
        rectangle.setBackgroundColor(color);
        this.Z.setPageSize(rectangle);
        this.Z.newPage();
        this.SELF_SIGNED = (int)this.Z.PdfContentSize;
    }

    void I(float f, float f2, float f3, float f4) {
        this.append.rectangle(f, this.convertY(f2 + f4), f3, f4);
        this.append.clip();
        this.append.newPath();
    }

    void I() {
        this.append.saveState();
    }

    void Z() {
        this.append.restoreState();
    }

    public static void encrypt(PdfWriter pdfWriter, PDFParameter pDFParameter) throws DocumentException {
        if (pDFParameter != null && pDFParameter.hasEncryption()) {
            String string = pDFParameter.getOwnerPassword();
            String string2 = pDFParameter.getUserPassword();
            int n = pDFParameter.getPermissions();
            if (string == null || string.length() == 0) {
                string = string2;
                n = 2108;
            }
            pdfWriter.setEncryption(pDFParameter.isStrength128Bits(), string2, string, n);
        }
    }

    public static void encrypt(PdfStamper pdfStamper, PDFParameter pDFParameter) throws DocumentException {
        if (pDFParameter != null && pDFParameter.hasEncryption()) {
            String string = pDFParameter.getOwnerPassword();
            String string2 = pDFParameter.getUserPassword();
            int n = pDFParameter.getPermissions();
            if (string == null || string.length() == 0) {
                string = string2;
                n = 2108;
            }
            pdfStamper.setEncryption(pDFParameter.isStrength128Bits(), string2, string, n);
        }
    }

    public static void signAndEncrypt(KeyStore keyStore, PdfStamper pdfStamper, PDFParameter pDFParameter) throws DocumentException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        PDFWriter.encrypt(pdfStamper, pDFParameter);
        if (pDFParameter != null && pDFParameter.hasSignature()) {
            String string = keyStore.aliases().nextElement();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(string, pDFParameter.getDigitalIDFilePassword().toCharArray());
            Certificate[] certificateArray = keyStore.getCertificateChain(string);
            PdfSignatureAppearance pdfSignatureAppearance = pdfStamper.getSignatureAppearance();
            pdfSignatureAppearance.setCrypto(privateKey, certificateArray, null, PDFWriter.I(pDFParameter.getSignatureMethod()));
            pdfSignatureAppearance.setReason(pDFParameter.getSigningReason());
            pdfSignatureAppearance.setLocation(pDFParameter.getSigningLocation());
            pdfSignatureAppearance.setContact(pDFParameter.getSigningContact());
        }
    }

    private static PdfName I(int n) {
        PdfName pdfName = null;
        switch (n) {
            case 0: {
                pdfName = PdfSignatureAppearance.SELF_SIGNED;
                break;
            }
            case 2: {
                pdfName = PdfSignatureAppearance.WINCER_SIGNED;
                break;
            }
            case 1: {
                pdfName = PdfSignatureAppearance.VERISIGN_SIGNED;
                break;
            }
            default: {
                pdfName = PdfSignatureAppearance.SELF_SIGNED;
            }
        }
        return pdfName;
    }

    public void setEncryption(String string) {
        block3: {
            if (string != null && string.length() != 0) {
                try {
                    this.aliases.setEncryption(true, string, string, 2108);
                }
                catch (DocumentException documentException) {
                    if (!JRLog.isError(2)) break block3;
                    JRLog.error(2, 2401006, (Throwable)documentException);
                }
            }
        }
    }

    void I(TOCNode tOCNode) {
        if (tOCNode != null) {
            String string = tOCNode.getNodeDisplayValue();
            float f = Unit.convertUnitToPixel(tOCNode.getX(), 72);
            float f2 = this.convertY(Unit.convertUnitToPixel(tOCNode.getY(), 72));
            int n = tOCNode.getPage();
            PdfAction pdfAction = PdfAction.gotoLocalPage((int)n, (PdfDestination)new PdfDestination(0, f, f2, 0.0f), (PdfWriter)this.aliases);
            PdfOutline pdfOutline = new PdfOutline(this.append.getRootOutline(), pdfAction, string);
            int n2 = tOCNode.getNodeCount();
            int n3 = 0;
            while (n3 < n2) {
                TOCNode tOCNode2 = (TOCNode)tOCNode.getNode(n3);
                this.PdfContentSize(pdfOutline, tOCNode2);
                ++n3;
            }
        }
    }

    private void PdfContentSize(PdfOutline pdfOutline, TOCNode tOCNode) {
        if (tOCNode != null) {
            String string = tOCNode.getNodeDisplayValue();
            float f = Unit.convertUnitToPixel(tOCNode.getX(), 72);
            float f2 = this.convertY(Unit.convertUnitToPixel(tOCNode.getY(), 72));
            int n = tOCNode.getPage();
            PdfAction pdfAction = PdfAction.gotoLocalPage((int)n, (PdfDestination)new PdfDestination(0, f, f2, 0.0f), (PdfWriter)this.aliases);
            PdfOutline pdfOutline2 = new PdfOutline(pdfOutline, pdfAction, string);
            int n2 = tOCNode.getNodeCount();
            int n3 = 0;
            while (n3 < n2) {
                TOCNode tOCNode2 = (TOCNode)tOCNode.getNode(n3);
                this.PdfContentSize(pdfOutline2, tOCNode2);
                ++n3;
            }
        }
    }

    public void setEncoding(String string) {
        this.Z.setEncoding(string);
    }

    public void setFont(Font font, boolean bl) {
        this.VERISIGN_SIGNED = font;
        this.addImage = bl;
    }

    public static FontMetrics getFontMetrics(Font font) {
        Object v = QOIV.get(font);
        if (v != null) {
            return (FontMetrics)v;
        }
        FontMetrics fontMetrics = I.getFontMetrics(font);
        QOIV.put(font, fontMetrics);
        return fontMetrics;
    }

    public void dispose() {
        this.Z.close();
        this.arc.clear();
        this.arc = null;
        this.aliases = null;
        this.append = null;
        this.Z = null;
        QOIV.clear();
    }

    public void setBorderStyle(float f, int n) {
        if (n > 0) {
            float f2 = this.QOIV(f, n);
            this.VERISIGN_SIGNED(f2);
        }
    }

    private float QOIV(float f, int n) {
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 0.0f;
        float f5 = f;
        switch (n) {
            case 6: {
                f5 = this.SELF_SIGNED(f5);
            }
            case 1: {
                this.append.setLineDash(0.0f);
                break;
            }
            case 2: {
                f2 = f5 * 4.0f;
                f3 = f5 * 3.0f;
                this.append.setLineDash(f2, f3, f4);
                break;
            }
            case 9: {
                f5 = this.SELF_SIGNED(f5);
            }
            case 3: {
                f2 = f5;
                f3 = (float)((double)f5 * 1.5);
                this.append.setLineDash(f2, f3, f4);
                break;
            }
            case 12: {
                f5 = this.SELF_SIGNED(f5);
            }
            case 4: {
                float[] fArray2 = new float[]{f5 * 5.0f, f5 * 3.0f, f5, f5 * 3.0f};
                this.append.setLineDash(fArray2, f4);
                break;
            }
            case 8: {
                f5 = this.SELF_SIGNED(f5);
            }
            case 7: {
                f2 = f5 * 5.0f;
                f3 = f5 * 3.0f;
                this.append.setLineDash(f2, f3, f4);
                break;
            }
            case 11: {
                f5 = this.SELF_SIGNED(f5);
            }
            case 10: {
                f2 = 12.0f;
                f3 = 7.0f;
                this.append.setLineDash(f2, f3, f4);
                break;
            }
            case 14: {
                f5 = this.SELF_SIGNED(f5);
            }
            case 13: {
                float[] fArray3 = new float[]{f5 * 5.0f, f5 * 3.0f, f5, f5 * 3.0f, f5, f5 * 3.0f};
                this.append.setLineDash(fArray3, f4);
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                this.append.setLineDash(0.0f);
            }
        }
        return f5;
    }

    private float SELF_SIGNED(float f) {
        return f * 1.5f;
    }

    private void VERISIGN_SIGNED(float f) {
        this.append.setLineWidth(f);
    }

    public void drawLine(float f, float f2, float f3, float f4, float f5, int n, Color color) {
        if (color != null) {
            this.setStrokeColor(color);
        }
        this.setBorderStyle(f5, n);
        this.append.moveTo(f, this.convertY(f2));
        this.append.lineTo(f3, this.convertY(f4));
        this.append.stroke();
    }

    public void fillRect(float f, float f2, float f3, float f4, Color color) {
        if (color != null) {
            this.setColor(color);
        }
        this.append.rectangle(f, this.convertY(f2 + f4), f3, f4);
        this.append.fill();
    }

    public void fillRect(java.awt.Rectangle rectangle, Color color) {
        this.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, color);
    }

    public void drawRect(float f, float f2, float f3, float f4, float f5, int n, Color color) {
        if (color != null) {
            this.setStrokeColor(color);
        }
        this.setBorderStyle(f5, n);
        this.append.rectangle(f, this.convertY(f2 + f4), f3, f4);
        this.append.stroke();
    }

    public void drawRect(java.awt.Rectangle rectangle, float f, int n, Color color) {
        this.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, f, n, color);
    }

    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, float f6, int n, int n2, Color color) {
        if (color != null) {
            this.setStrokeColor(color);
        }
        this.setBorderStyle(n, n2);
        if (f5 > f4 || f5 > f3) {
            f5 = f4 < f3 ? f4 : f3;
        }
        this.append.roundRectangle(f, this.convertY(f2 + f4), f3, f4, f5 / 2.0f);
        this.append.stroke();
    }

    public void fillRoundRect(float f, float f2, float f3, float f4, float f5, float f6, Color color) {
        if (color != null) {
            this.setColor(color);
        }
        if (f5 > f4 || f5 > f3) {
            f5 = f4 < f3 ? f4 : f3;
        }
        this.append.roundRectangle(f, this.convertY(f2 + f4), f3, f4, f5 / 2.0f);
        this.append.fill();
    }

    public void drawOval(float f, float f2, float f3, float f4, float f5, int n, Color color) {
        if (color != null) {
            this.setStrokeColor(color);
        }
        this.setBorderStyle(f5, n);
        this.append.ellipse(f, this.convertY(f2), f + f3, this.convertY(f2 + f4));
        this.append.stroke();
    }

    public void fillOval(float f, float f2, float f3, float f4, Color color) {
        if (color != null) {
            this.setColor(color);
        }
        this.append.ellipse(f, this.convertY(f2), f + f3, this.convertY(f2 + f4));
        this.append.fill();
    }

    public void drawArc(float f, float f2, float f3, float f4, float f5, float f6, float f7, int n, Color color) {
        if (color != null) {
            this.setStrokeColor(color);
        }
        this.setBorderStyle(f7, n);
        this.append.arc(f, this.convertY(f2), f + f3, this.convertY(f2 + f4), f5, f6);
        this.append.stroke();
    }

    public void fillArc(float f, float f2, float f3, float f4, float f5, float f6, Color color) {
        if (color != null) {
            this.setColor(color);
        }
        this.append.arc(f, this.convertY(f2), f + f3, this.convertY(f2 + f4), f5, f6);
        this.append.fill();
    }

    public void drawFileLink(String string, float f, float f2, float f3, float f4) {
        PdfAction pdfAction = new PdfAction(string, 1);
        this.append.setAction(pdfAction, f, this.convertY(f2) - f4, f + f3, this.convertY(f2));
    }

    public void drawLocalLink(int n, float f, float f2, float f3, float f4) {
        PdfAction pdfAction = PdfAction.gotoLocalPage((int)n, (PdfDestination)new PdfDestination(0, -1.0f, 10000.0f, 0.0f), (PdfWriter)this.aliases);
        this.append.setAction(pdfAction, f, this.convertY(f2) - f4, f + f3, this.convertY(f2));
    }

    public void drawURLLink(String string, float f, float f2, float f3, float f4) {
        PdfAction pdfAction = (string = string.trim()).startsWith("\\") ? new PdfAction(string, null, null, null) : new PdfAction(string);
        this.append.setAction(pdfAction, f, this.convertY(f2) - f4, f + f3, this.convertY(f2));
    }

    public void drawString(String string, BaseFont baseFont, float f, float f2, float f3, Color color) {
        this.setColor(color);
        this.append.beginText();
        this.append.setFontAndSize(baseFont, f);
        this.append.setTextMatrix(f2, this.convertY(f3));
        this.append.showText(string);
        this.append.endText();
    }

    public void drawString(String string, float f, float f2, Color color) throws IOException, DocumentException {
        if (string != null && string.length() != 0 && color != null) {
            BaseFont baseFont = this.Z.getBaseFont(string, this.VERISIGN_SIGNED, this.addImage, false);
            this.drawString(string, baseFont, this.VERISIGN_SIGNED.getSize2D(), f, f2, color);
        }
    }

    protected String getImgID(Image image) {
        Object v = this.clip.get(image);
        if (v != null) {
            return "" + v.toString();
        }
        Integer n = this.beginText.generate(image);
        this.clip.put(image, n);
        return n.toString();
    }

    public void drawImage(Image image, float f, float f2, float f3, float f4, String string) {
        block8: {
            if (image != null) {
                String string2 = null;
                string2 = string == null ? "" + this.beginText.generate(image) : string;
                int n = Integer.parseInt(string2);
                com.lowagie.text.Image image2 = (com.lowagie.text.Image)this.arc.get(n);
                try {
                    if (image2 == null) {
                        if (this.clear == -1) {
                            image2 = com.lowagie.text.Image.getInstance((Image)image, null);
                        } else {
                            ImageEncoder imageEncoder = new ImageEncoder();
                            byte[] byArray = imageEncoder.encoderImage(image, (float)this.clear / 100.0f);
                            image2 = com.lowagie.text.Image.getInstance((byte[])byArray);
                        }
                        this.arc.put(n, image2);
                    }
                    image2.setAbsolutePosition(f, this.convertY(f2 + f4));
                    image2.scaleAbsolute(f3, f4);
                    this.append.addImage(image2);
                }
                catch (IOException iOException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2401007, (Throwable)iOException);
                    }
                }
                catch (DocumentException documentException) {
                    if (!JRLog.isError(2)) break block8;
                    JRLog.error(2, 2401007, (Throwable)documentException);
                }
            }
        }
    }

    public final void setColor(Color color) {
        this.append.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
    }

    public final void setStrokeColor(Color color) {
        this.append.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
    }

    public final float convertY(double d) {
        return (float)((double)this.WINCER_SIGNED.height - d);
    }

    public Graphics2D getGraphics(float f, float f2) {
        return this.append.createGraphicsShapes(f, f2);
    }

    public int getContentSize() {
        return (int)Math.round((double)this.SELF_SIGNED * 1.625);
    }
}

