/*
 * Decompiled with CFR 0.152.
 */
package jet.export.pdf;

import com.jinfonet.util.JRLog;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Font;
import java.io.IOException;
import java.util.Hashtable;
import jet.export.pdf.PDFConstants;
import jet.util.FontSets;

public class PdfExt
extends Document
implements PDFConstants {
    private static final String[] PdfContentSize = new String[]{"Bold", "Oblique", "Italic"};
    public int size;
    static Hashtable QOIV = new Hashtable();
    Hashtable append;
    Hashtable charAt;
    int clear;
    private static final char[] close;

    public PdfExt() {
        this.size = ((Document)this).PdfContentSize;
        this.append = new Hashtable(10);
        this.charAt = new Hashtable(10);
    }

    public void setEncoding(String string) {
        this.clear = PdfExt.getEncoding(string);
    }

    public static final int getEncoding(String string) {
        int n = -1;
        if (string.startsWith("GB") || string.equals("UTF-8")) {
            n = 0;
        } else if (string.equals("MS950") || string.equals("Big5")) {
            n = 1;
        } else if (string.equals("KSC5601") || string.equals("MS949") || string.equals("EUK_KR") || string.equals("ISO2022KR")) {
            n = 2;
        } else if (string.equals("MS932") || string.equals("EUC_JP") || string.equals("EUC_JP_LINUX") || string.equals("SJIS") || string.equals("ISO2022JP")) {
            n = 3;
        }
        return n;
    }

    public BaseFont getBaseFont(String string, Font font, boolean bl, boolean bl2) throws IOException, DocumentException {
        BaseFont baseFont = null;
        boolean bl3 = this.append(string);
        baseFont = bl2 ? (bl3 ? this.getTrueTypeFontUnicode(font).getBaseFont() : this.getTrueTypeFont(font, bl).getBaseFont()) : this.getType1Font(font, bl3).getBaseFont();
        return baseFont;
    }

    private com.lowagie.text.Font PdfContentSize(String string, String string2) {
        if (string.equals("Cp1252")) {
            return (com.lowagie.text.Font)this.charAt.get(string2);
        }
        return (com.lowagie.text.Font)this.append.get(string2);
    }

    private void QOIV(String string, String string2, com.lowagie.text.Font font) {
        if (string.equals("Cp1252")) {
            this.charAt.put(string2, font);
        } else {
            this.append.put(string2, font);
        }
    }

    protected com.lowagie.text.Font getTrueTypeFontUnicode(Font font) throws IOException, DocumentException {
        com.lowagie.text.Font font2 = null;
        try {
            font2 = this.getUserFont(font, "Identity-H", true);
        }
        catch (Exception exception) {
            font2 = this.getTrueTypeFont(font, false);
            String string = '*' + FontSets.getBaseName(font);
            this.QOIV("Identity-H", string, font2);
            return this.getTrueTypeFont(font, false);
        }
        return font2;
    }

    protected com.lowagie.text.Font getTrueTypeFont(Font font, boolean bl) throws IOException, DocumentException {
        return this.getUserFont(font, "Cp1252", bl);
    }

    protected com.lowagie.text.Font getUserFont(Font font, String string, boolean bl) throws IOException, DocumentException {
        BaseFont baseFont = null;
        String string2 = '*' + FontSets.getBaseName(font);
        com.lowagie.text.Font font2 = this.PdfContentSize(string, string2);
        if (font2 == null) {
            font2 = this.PdfContentSize(string, string2.replace(' ', '-'));
        }
        if (font2 == null) {
            try {
                String string3 = FontSets.getFontPath(string2);
                baseFont = string3 == null ? this.getType1Font(font, string != "Cp1252").getBaseFont() : this.createBaseFont(string3, string, bl);
            }
            catch (IOException iOException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2401008, (Throwable)iOException);
                }
                string2 = string2.replace(' ', '-');
                baseFont = this.createBaseFont(FontSets.getFontPath(string2), string, bl);
            }
            catch (DocumentException documentException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2401008, (Throwable)documentException);
                }
                string2 = string2.replace(' ', '-');
                baseFont = this.createBaseFont(FontSets.getFontPath(string2), string, bl);
            }
            font2 = new com.lowagie.text.Font(baseFont);
            this.QOIV(string, string2, font2);
        }
        return font2;
    }

    protected com.lowagie.text.Font getType1Font(Font font, boolean bl) throws IOException, DocumentException {
        com.lowagie.text.Font font2;
        String string = null;
        String string2 = null;
        if (bl) {
            switch (this.clear) {
                case 0: {
                    string = "STSong-Light";
                    string2 = "UniGB-UCS2-H";
                    break;
                }
                case 1: {
                    string = "MSung-Light";
                    string2 = "UniCNS-UCS2-H";
                    break;
                }
                case 2: {
                    string = "HYGoThic-Medium";
                    string2 = "UniKS-UCS2-H";
                    break;
                }
                case 3: {
                    string = "HeiseiMin-W3";
                    string2 = "UniJIS-UCS2-H";
                }
            }
        }
        if (string == null) {
            string = PdfExt.convertFont(font);
            string2 = "Cp1252";
        }
        if ((font2 = this.PdfContentSize(string2, string)) == null) {
            BaseFont baseFont = this.createBaseFont(string, string2, false);
            font2 = new com.lowagie.text.Font(baseFont, 12.0f, 0);
            this.QOIV(string2, string, font2);
        }
        return font2;
    }

    protected BaseFont createBaseFont(String string, String string2, boolean bl) throws DocumentException, IOException {
        return BaseFont.createFont((String)string, (String)string2, (boolean)bl);
    }

    protected static final String convertFont(Font font) {
        String string = font.getName();
        String string2 = (String)QOIV.get(string);
        if (string2 == null) {
            string2 = "Helvetica";
        }
        String string3 = "-";
        if (font.isBold()) {
            if (string2.startsWith("Times")) {
                string2 = "Times";
            }
            string3 = string3 + PdfContentSize[0];
        }
        if (font.isItalic()) {
            if (string2.startsWith("Times")) {
                string2 = "Times";
                string3 = string3 + PdfContentSize[2];
            } else {
                string3 = string3 + PdfContentSize[1];
            }
        }
        if (string3.length() > 1) {
            string2 = string2 + string3;
        }
        return string2;
    }

    private boolean append(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            int n3 = (c = this.charAt(c)) & 0xFFFF;
            if (n3 > 255) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private char charAt(char c) {
        switch (c) {
            case '\u0080': {
                c = (char)8364;
                break;
            }
            case '\u0082': {
                c = (char)8218;
                break;
            }
            case '\u0083': {
                c = (char)402;
                break;
            }
            case '\u0089': {
                c = (char)8240;
            }
        }
        return c;
    }

    public void close() {
        super.close();
        this.charAt.clear();
        this.charAt = null;
        this.append.clear();
        this.append = null;
    }

    public static final byte[] toHex(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2 + byArray.length / 32 + 2];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (n2 != 0 && n2 % 32 == 0) {
                byArray2[n++] = 10;
            }
            int n3 = byArray[n2] >> 4 & 0xF;
            byArray2[n++] = (byte)close[n3];
            n3 = byArray[n2] & 0xF;
            byArray2[n++] = (byte)close[n3];
            ++n2;
        }
        byArray2[n++] = 62;
        byArray2[n++] = 10;
        return byArray2;
    }

    static {
        QOIV.put("Dialog", "Helvetica");
        QOIV.put("SansSerif", "Helvetica");
        QOIV.put("Helvetica", "Helvetica");
        QOIV.put("Serif", "Times-Roman");
        QOIV.put("DialogInput", "Courier");
        QOIV.put("TimesRoman", "Times-Roman");
        QOIV.put("Times New Roman", "Times-Roman");
        QOIV.put("Monospaced", "Courier");
        QOIV.put("Courier", "Courier");
        QOIV.put("ZapfDingbats", "ZapfDingbats");
        QOIV.put("Default", "Times-Roman");
        close = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

