/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AggDesc {
    public String fieldname;
    public String groupname;
    public String specFunc;
    public int aggCode;
    public boolean onFml;
    public int pass = -1;
    public int grpidx = -1;
    public int aggidx = -1;
    public int calIndex = -1;
    private int QOIV = 0;
    public static String delim = "    ";
    private boolean append = false;

    public boolean isDynamicSummary() {
        return this.append;
    }

    public void setDynamicSummary(boolean bl) {
        this.append = bl;
    }

    public AggDesc() {
        this.QOIV = 0;
    }

    public AggDesc(String string, String string2, int n) {
        this.fieldname = string;
        this.groupname = string2;
        this.aggCode = n;
        this.onFml = false;
        try {
            Integer.parseInt(string2);
            this.append = true;
        }
        catch (Exception exception) {
            this.append = false;
        }
        this.QOIV = 0;
    }

    public AggDesc(String string, String string2, int n, boolean bl) {
        this(string, string2, n);
        this.onFml = bl;
        this.QOIV = 0;
    }

    public AggDesc(String string, String string2, int n, boolean bl, String string3) {
        this(string, string2, n, bl);
        this.specFunc = string3;
    }

    public AggDesc(String string, String string2, int n, String string3) {
        this(string, string2, n);
        this.specFunc = string3;
    }

    public boolean equals(Object object) {
        AggDesc aggDesc = (AggDesc)object;
        return aggDesc.fieldname.equals(this.fieldname) && aggDesc.groupname.equals(this.groupname) && aggDesc.aggCode == this.aggCode && aggDesc.specFunc == this.specFunc;
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.fieldname);
        if (this.specFunc != null) {
            dataOutputStream.writeUTF(this.groupname + delim + this.specFunc);
        } else {
            dataOutputStream.writeUTF(this.groupname);
        }
        dataOutputStream.writeInt(this.aggCode);
        dataOutputStream.writeBoolean(this.onFml);
    }

    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        this.fieldname = dataInputStream.readUTF();
        this.groupname = dataInputStream.readUTF();
        this.aggCode = dataInputStream.readInt();
        this.onFml = dataInputStream.readBoolean();
        int n = this.groupname.indexOf(delim);
        if (n != -1) {
            this.specFunc = this.groupname.substring(n + delim.length());
            this.groupname = this.groupname.substring(0, n);
        }
        try {
            Integer.parseInt(this.groupname);
            this.append = true;
        }
        catch (Exception exception) {
            this.append = false;
        }
    }

    public static final String mapCodeToString(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "Count";
                break;
            }
            case 2: {
                string = "Summary";
                break;
            }
            case 3: {
                string = "Minimum";
                break;
            }
            case 4: {
                string = "Maximum";
                break;
            }
            case 5: {
                string = "Distinctcount";
                break;
            }
            case 6: {
                string = "Average";
                break;
            }
            case 7: {
                string = "SQRSUM";
                break;
            }
            case 8: {
                string = "PopulationStdDev";
                break;
            }
            case 9: {
                string = "PopulationVariance";
                break;
            }
            case 10: {
                string = "StdDev";
                break;
            }
            case 11: {
                string = "Variance";
                break;
            }
            default: {
                throw new Error("error agg type : " + n);
            }
        }
        return string;
    }

    public String toString() {
        if (this.specFunc != null) {
            return AggDesc.mapCodeToString(this.aggCode) + "{" + this.fieldname + "," + this.groupname + "," + this.specFunc + "}";
        }
        return AggDesc.mapCodeToString(this.aggCode) + "{" + this.fieldname + "," + this.groupname + "}";
    }

    public Object clone() {
        AggDesc aggDesc = new AggDesc();
        aggDesc.fieldname = this.fieldname;
        aggDesc.groupname = this.groupname;
        aggDesc.aggCode = this.aggCode;
        aggDesc.onFml = this.onFml;
        aggDesc.pass = this.pass;
        aggDesc.grpidx = this.grpidx;
        aggDesc.aggidx = this.aggidx;
        aggDesc.calIndex = this.calIndex;
        aggDesc.QOIV = this.QOIV;
        aggDesc.specFunc = this.specFunc;
        aggDesc.setDynamicSummary(this.append);
        return aggDesc;
    }

    public void setSumSqlType(int n) {
        this.QOIV = n;
    }

    public int getSumSqlType() {
        return this.QOIV;
    }

    public String getFullGroupName() {
        if (this.specFunc != null && this.specFunc.trim().length() != 0) {
            return this.groupname + delim + this.specFunc;
        }
        return this.groupname;
    }
}

