/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import jet.ie.AbstractRSDLoader;
import jet.ie.RSDImages;
import jet.ie.RSDIndexInfo;
import jet.ie.RSDNlsManager;
import jet.ie.RSDRptInfo;
import jet.ie.RSDTools;
import jet.ie.RSTLoadControler;
import jet.ie.UpgradeToV8RsdUtil;
import jet.ie.V7ResultSetReader;
import jet.ie.VersionException;
import jet.ie.io.PJFDataInput;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUUniverse;
import jet.util.ImageLoader;
import jet.util.JFieldValueNLSManager;
import jet.util.RAFInputStream;
import jet.util.RAFile;

public class RSDLoadControler
extends AbstractRSDLoader {
    public static final String REPORT_PANELS = "Report panel";
    public static final String DBBUFFERS = "DbBuffers";
    public static final String CQRS = "CQRS";
    public static final String FmlImage = "FmlImage";
    public static final String IMAGE = "Image";
    public static final String NLSMANAGER = "NlsManager";
    private long I;
    private String QOIV = "";
    private boolean Z;
    protected Hashtable resultSetAddressTable;
    protected Hashtable dbBufferAddressTable;
    protected Vector _indexInfo;
    protected RSDNlsManager _nls;

    public RSDLoadControler(String string) {
        this._fileName = string;
        this._reportSet = new Hashtable();
        File file = new File(string);
        this._rsdTools = new RSDTools(file.getParent());
        this._rsdTools.setCompression(this._isZip, this.bufferSize);
    }

    public synchronized void openFile() throws VersionException {
        try {
            this._raf = new RAFile(this._fileName, "r");
            this._in = new PJFDataInput(new RAFInputStream(this._raf));
            this.loadHeader();
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 2407320);
                JRLog.trace(4, 2407321, this._fileName);
                JRLog.trace(4, 2407322, new Integer(this._versionNumber));
            }
            this._in.setVersion(this._versionNumber);
            boolean bl = this.Z = this._versionNumber < 131073;
            if (this._rsdTools == null) {
                File file = new File(this._fileName);
                this._rsdTools = new RSDTools(file.getParent());
            }
            this._rsdTools.setCompression(this._isZip, this.bufferSize);
            if (this._versionNumber < 131073) {
                int n = this._raf.readInt();
                this._reportNames = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    this._reportNames[n2] = this._raf.readUTF() + ".cls";
                    ++n2;
                }
                this._raf.seek(this._raf.readLong());
                this.addressTable = this.readAddressTable();
                this.I = this._raf.getPosition();
                this.getRSTLoadControler();
                this.reportPanelAddressTable = this.QOIV(REPORT_PANELS);
                this.dbBufferAddressTable = this.QOIV(DBBUFFERS);
                ArrayList<String> arrayList = new ArrayList<String>();
                int n3 = this._reportNames.length;
                this.jrReportSet = new JetRptReportSet[n3];
                int n4 = 0;
                while (n4 < n3) {
                    arrayList.add(n4, this._reportNames[n4]);
                    this.jrReportSet[n4] = this.getReportSet(n4, true);
                    this._reportSet.put(new Integer(n4), this.jrReportSet[n4]);
                    ++n4;
                }
                if (this._versionNumber > 65549) {
                    Hashtable hashtable = this._rsdTools.readCQRsAddressTable(this.addressTable, CQRS, this._raf);
                    this.rstReader = new V7ResultSetReader(hashtable, arrayList, this._rsdTools, this._raf, this._versionNumber, this._flag);
                } else {
                    this.rstReader = new V7ResultSetReader(this.dbBufferAddressTable, arrayList, this._rsdTools, this._raf, this._versionNumber, this._flag);
                }
                this._upgradeTool = new UpgradeToV8RsdUtil(this._reportNames, this.jrReportSet, this.rstReader);
            } else {
                this._raf.seek(this._raf.readLong());
                this.addressTable = this.readAddressTable();
                if (this._versionNumber < 131329) {
                    this.I = this._raf.getPosition();
                    this.getRSTLoadControler();
                }
                this._reportNames = this.getReportNames();
                this.jrReportSet = new JetRptReportSet[this._reportNames.length];
                this.reportSetAddressTable = this.readSubBlockAddressTableH("ReportSets");
                this.resultSetAddressTable = this.readSubBlockAddressTableH("ResultSets");
                this._parameter = this.getParameters();
                this._rptInfos = this.loadRptInfo();
                this._dataSetInfo = this.loadDataSetInfo();
                if (this._versionNumber >= 131329) {
                    this._nls = this.getNlsManagers();
                    this._precisions = this.getPrecisions();
                    this._clsInfos = this.getClsInfos();
                    this._permissions = this.getPermissions();
                    this._indexInfo = this.getIndexInfo();
                    this.readChangeByFMLImg();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407315, (Throwable)fileNotFoundException);
            }
            throw new VersionException(407315, new Object[]{this._fileName}, fileNotFoundException);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407303, (Throwable)iOException);
            }
            throw new VersionException(407303, (Throwable)iOException);
        }
    }

    public synchronized ResultSet getResultSet(int n, String string) throws VersionException {
        ResultSet resultSet;
        String string2 = "######  resultSet: index :: " + n + "  dataSetName :: " + string;
        JRLog.trace(5, string2);
        long l = System.currentTimeMillis();
        if (this._versionNumber < 131073) {
            return this._upgradeTool.getResultSet(n, string);
        }
        String string3 = this._rsdTools.getKey(n, string);
        Long l2 = (Long)this.resultSetAddressTable.get(string3);
        if (l2 == null) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407311);
            }
            throw new VersionException(407311);
        }
        try {
            this._raf.seek(l2);
            resultSet = this._rsdTools.loadResultSet(this._raf, this._versionNumber, this._flag);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407304, (Throwable)exception);
            }
            throw new VersionException(407304, (Throwable)exception);
        }
        long l3 = System.currentTimeMillis();
        String string4 = "######## load resultSet cast time :: " + (l3 - l);
        JRLog.trace(5, string4);
        return resultSet;
    }

    public synchronized JetUUniverse getUniverse() throws VersionException {
        if (this._universe != null) {
            return this._universe;
        }
        if (this._versionNumber < 131073) {
            try {
                long l = (Long)this.reportPanelAddressTable.get(new Integer(0));
                this._raf.seek(l);
                this._raf.readInt();
                ArrayList arrayList = this._rsdTools.loadSelfContainPanelToReportSet(this._in);
                this._universe = (JetUUniverse)arrayList.get(1);
                return this._universe;
            }
            catch (Exception exception) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2407305, (Throwable)exception);
                }
                throw new VersionException(407305, (Throwable)exception);
            }
        }
        Long l = (Long)this.addressTable.get("Universe");
        try {
            long l2 = System.currentTimeMillis();
            this._raf.seek(l);
            this._universe = this._rsdTools.loadUniverse(this._in);
            long l3 = System.currentTimeMillis();
            String string = "#######  load Universe cast time :: " + (l3 - l2);
            JRLog.trace(5, string);
            return this._universe;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407305, (Throwable)exception);
            }
            throw new VersionException(407305, (Throwable)exception);
        }
    }

    public synchronized RSTLoadControler getRSTLoadControler() throws VersionException, IOException {
        if (this._versionNumber < 131329) {
            this._rstLoader = new RSTLoadControler(this.I());
            this._rstLoader.openFile();
        }
        return this._rstLoader;
    }

    private String I() throws VersionException {
        try {
            this.QOIV = this._rsdTools.I();
            File file = new File(this.QOIV);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this._raf.seek(this.I);
            byte[] byArray = new byte[4096];
            long l = this._raf.length() - this.I;
            long l2 = l / 4096L;
            long l3 = 0L;
            while (l3 < l2) {
                this._raf.readFully(byArray);
                fileOutputStream.write(byArray);
                ++l3;
            }
            int n = (int)(l % 4096L);
            this._raf.read(byArray, 0, n);
            fileOutputStream.write(byArray, 0, n);
            fileOutputStream.close();
            file.deleteOnExit();
            return this.QOIV;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407308, (Throwable)iOException);
            }
            throw new VersionException(407308, (Throwable)iOException);
        }
    }

    public synchronized Vector getIndexInfo() throws VersionException {
        if (this._indexInfo == null) {
            Long l = (Long)this.addressTable.get("IndexInfo");
            try {
                this._raf.seek(l);
                RSDIndexInfo rSDIndexInfo = new RSDIndexInfo();
                rSDIndexInfo.load(this._raf);
                return (Vector)rSDIndexInfo.getSrc();
            }
            catch (Exception exception) {
                throw new VersionException(exception);
            }
        }
        return this._indexInfo;
    }

    public synchronized int getIndex(int n, String string, String string2, String string3, String string4) throws VersionException {
        int n2 = -1;
        if (this._versionNumber < 131073) {
            int n3 = 0;
            while (n3 < this._reportNames.length) {
                if (this._reportNames[n3].equals(string4)) {
                    return n3;
                }
                ++n3;
            }
        } else if (this._indexInfo != null) {
            int n4 = 0;
            while (n4 < this._indexInfo.size()) {
                RSDRptInfo rSDRptInfo = (RSDRptInfo)this._indexInfo.get(n4);
                if (rSDRptInfo.hasMappingRptSet(n, string, string2, string3)) {
                    return rSDRptInfo.getSIndex();
                }
                ++n4;
            }
        }
        if (n2 == -1) {
            throw new VersionException(new Exception("Subreport set index not found!!!"));
        }
        return n2;
    }

    public synchronized Hashtable getImages() throws VersionException {
        Hashtable hashtable = new Hashtable();
        if (this._versionNumber < 131073) {
            return hashtable;
        }
        Long l = (Long)this.addressTable.get(IMAGE);
        try {
            this._raf.seek(l);
            RSDImages rSDImages = new RSDImages(this._isZip, this._versionNumber);
            rSDImages.load(this._raf);
            hashtable = (Hashtable)rSDImages.getSrc();
            return hashtable;
        }
        catch (Exception exception) {
            throw new VersionException(exception);
        }
    }

    protected RSDNlsManager getNlsManagers() throws VersionException {
        try {
            Long l = (Long)this.addressTable.get(NLSMANAGER);
            this._raf.seek(l);
            RSDNlsManager rSDNlsManager = new RSDNlsManager();
            rSDNlsManager.load(this._raf);
            return rSDNlsManager;
        }
        catch (Exception exception) {
            throw new VersionException(exception);
        }
    }

    public synchronized JFieldValueNLSManager getNLSManager(String string, String string2) throws VersionException {
        if (this._versionNumber >= 131329) {
            if (this._nls == null) {
                this._nls = this.getNlsManagers();
            }
            return this._nls.getNLSManager(string, string2);
        }
        return this._rstLoader.getNLSManager(string, string2);
    }

    protected void readChangeByFMLImg() throws VersionException {
        Long l = (Long)this.addressTable.get(FmlImage);
        try {
            this._raf.seek(l);
            ImageLoader.loadChgByMapping(this._in, this._fileName);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407318, (Throwable)iOException);
            }
            throw new VersionException(407318, (Throwable)iOException);
        }
    }

    private Hashtable QOIV(String string) throws VersionException {
        try {
            Long l = (Long)this.addressTable.get(string);
            if (l == null) {
                return null;
            }
            long l2 = l;
            this._raf.seek(l2);
            long l3 = this._raf.readLong();
            this._raf.seek(l3);
            int n = this._raf.readInt();
            Hashtable<Integer, Long> hashtable = new Hashtable<Integer, Long>(n);
            int n2 = 0;
            while (n2 < n) {
                hashtable.put(new Integer(n2), new Long(this._raf.readLong()));
                ++n2;
            }
            return hashtable;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407303, (Throwable)iOException);
            }
            throw new VersionException(407303, (Throwable)iOException);
        }
    }

    protected void loadHeader() throws VersionException {
        try {
            this._flag = this._raf.readUTF();
            if (!this._flag.equals("DHTML Result version")) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2407301);
                }
                throw new VersionException(407301);
            }
            this._versionNumber = this._raf.readInt();
            long l = this._raf.readLong();
            String string = this._raf.readUTF();
            if (this._versionNumber >= 131329) {
                this._isZip = this._raf.readBoolean();
                this._id = this._raf.readUTF();
            } else {
                this._isZip = false;
            }
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407302, (Throwable)iOException);
            }
            throw new VersionException(407302, (Throwable)iOException);
        }
    }

    public synchronized void clear() throws IOException {
        block21: {
            block20: {
                File file;
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, 2407323);
                }
                this._rsdTools = null;
                this._reportNames = null;
                this._universe = null;
                int n = 0;
                while (this.jrReportSet != null && n < this.jrReportSet.length) {
                    if (this.jrReportSet[n] != null) {
                        this.jrReportSet[n].setCached(false);
                        if (this.jrReportSet[n].getRefCount() <= 0) {
                            this.jrReportSet[n].free();
                        }
                    }
                    ++n;
                }
                this.jrReportSet = null;
                if (this.addressTable != null) {
                    this.addressTable.clear();
                    this.addressTable = null;
                }
                if (this.reportPanelAddressTable != null) {
                    this.reportPanelAddressTable.clear();
                    this.reportPanelAddressTable = null;
                }
                if (this.dbBufferAddressTable != null) {
                    this.dbBufferAddressTable.clear();
                    this.dbBufferAddressTable = null;
                }
                if (this.reportSetAddressTable != null) {
                    this.reportSetAddressTable.clear();
                    this.reportSetAddressTable = null;
                }
                if (this.resultSetAddressTable != null) {
                    this.resultSetAddressTable.clear();
                    this.resultSetAddressTable = null;
                }
                if (this._indexInfo != null) {
                    this._indexInfo.clear();
                    this._indexInfo = null;
                }
                if (this._permissions != null) {
                    this._permissions.clear();
                }
                if (this._nls != null) {
                    this._nls.clear();
                }
                if (this._precisions != null) {
                    this._precisions.clear();
                }
                if (this._clsInfos != null) {
                    this._clsInfos.clear();
                }
                if (this.QOIV != null && !this.QOIV.equals("") && (file = new File(this.QOIV)).exists()) {
                    file.delete();
                }
                if (this._rstLoader != null) {
                    try {
                        this._rstLoader.clear();
                    }
                    catch (VersionException versionException) {
                        if (!JRLog.isError(2)) break block20;
                        JRLog.error(2, 2407316, (Throwable)versionException);
                    }
                }
            }
            try {
                ImageLoader.releaseChgByMapping(this._fileName);
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block21;
                JRLog.error(2, 2407317, (Throwable)iOException);
            }
        }
        this._raf.close();
    }
}

