/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import barcode.linearBarcode.BarcodeConstraints;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Vector;
import jet.JResource;
import jet.controls.JetBoolean;
import jet.controls.JetColumnName;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.report.JetRptDBField;
import jet.report.JetRptParameterField;
import jet.util.FontSets;
import jet.util.HashVector;

public class JetRptBarcode
extends JetRptDBField {
    public JetNumber barheight;
    public JetEnumeration bar128;
    public JetNumber narrowwidth;
    public JetBoolean hrdisplay;
    public JetString message;
    public JetNumber ratio;
    public JetBoolean checkenable;
    public JetNumber quietzone;
    public JetEnumeration symbology;
    public JetString supplement;
    public JetEnumeration scalemode;
    public JetString displayNull;
    public JetColumnName param;
    public JetBoolean paramdatasource;
    public JetNumber orientation;
    public JetBoolean useDefaultMessage;
    private BarcodeConstraints QOIV = new BarcodeConstraints();
    private static HashMap Z = null;
    private static final HashVector add = new HashVector(11);

    public JetRptBarcode() {
        this.QOIV();
        this.setObjectType(264);
        this.suppressedIfNull.setEditFlag(0);
        ((JetRptDBField)this).displayNull.setEditFlag(0);
        this.wordWrap.setEditFlag(0);
        this.columnName.setEditFlag(0);
        this.autoFit.setEditFlag(0);
        this.maxWidth.setEditFlag(0);
        this.format.set("");
    }

    public JetRptBarcode(JetObject jetObject, BarcodeConstraints barcodeConstraints) {
        this();
        JetObject.copyProperties(this, jetObject);
        this.bar128.set(new Integer(barcodeConstraints.getBar128Type()));
        this.checkenable.set(barcodeConstraints.getBarCheckEnable());
        this.narrowwidth.set(barcodeConstraints.getBarNarrowWidth());
        this.message.set(barcodeConstraints.getBarMessage());
        this.quietzone.set(barcodeConstraints.getBarQuietZone());
        this.ratio.set(barcodeConstraints.getBarRatio());
        this.scalemode.set(new Integer(barcodeConstraints.getBarScaleMode()));
        this.supplement.set(barcodeConstraints.getBarSupplement());
        this.symbology.set(new Integer(barcodeConstraints.getBarSymbology()));
        if (barcodeConstraints.getBarSymbology() != 5) {
            this.bar128.setEditFlag(0);
        }
        this.barheight.set(barcodeConstraints.getBarHeight());
        this.hrdisplay.set(barcodeConstraints.getBarHRDisplay());
        this.orientation.set(barcodeConstraints.getBarOrientation());
        this.QOIV = barcodeConstraints;
        if (jetObject instanceof JetRptParameterField) {
            this.paramdatasource.set(true);
        }
    }

    public Dimension getPreferredSize() {
        String string = this.getProperty("FontFace").toString();
        int n = 0;
        if (((JetBoolean)this.getProperty("Bold")).get()) {
            n = 1;
        }
        if (((JetBoolean)this.getProperty("Italic")).get()) {
            n |= 2;
        }
        int n2 = ((JetNumber)this.getProperty("FontSize")).get();
        if (this.QOIV == null) {
            this.QOIV = new BarcodeConstraints();
            this.QOIV.setBarScaleMode(2);
        }
        this.QOIV.setBarHRFont(FontSets.getFont(string, n, n2));
        this.QOIV.setBar128Type((Integer)this.bar128.get());
        this.QOIV.setBarCheckEnable(this.checkenable.get());
        this.QOIV.setBarNarrowWidth((short)this.narrowwidth.get());
        this.QOIV.setBarMessage(this.message.get());
        this.QOIV.setBarQuietZone((short)this.quietzone.get());
        this.QOIV.setBarRatio(this.ratio.get());
        this.QOIV.setBarScaleMode((Integer)this.scalemode.get());
        this.QOIV.setBarSupplement(this.supplement.get());
        this.QOIV.setBarSymbology((Integer)this.symbology.get());
        this.QOIV.setBarHeight((short)this.barheight.get());
        this.QOIV.setBarHRDisplay(this.hrdisplay.get());
        this.QOIV.setBackground(this.backColor.get());
        this.QOIV.setForeground(super.getForeColor());
        this.QOIV.setBarOrientation(this.orientation.get());
        return this.QOIV.getPreferredSize();
    }

    public String getInstancePrefix() {
        return "Barcode";
    }

    public String getPrefix() {
        return JResource.getMessage("Barcode");
    }

    public boolean isParamDataSource() {
        return this.paramdatasource.get();
    }

    public HashMap getIndecialMap() {
        if (Z != null) {
            return Z;
        }
        Z = new HashMap();
        HashMap hashMap = super.getIndecialMap();
        Z.putAll(hashMap);
        int n = hashMap.size();
        Z.put("BarHeight", new Integer(n++));
        Z.put("Bar128Type", new Integer(n++));
        Z.put("NarrowWidth", new Integer(n++));
        Z.put("HRDisplay", new Integer(n++));
        Z.put("Message", new Integer(n++));
        Z.put("Ratio", new Integer(n++));
        Z.put("CheckEnable", new Integer(n++));
        Z.put("QuietZone", new Integer(n++));
        Z.put("Symbology", new Integer(n++));
        Z.put("Supplement", new Integer(n++));
        Z.put("ScaleMode", new Integer(n++));
        Z.put("Parameter", new Integer(n++));
        Z.put("ParamDataSource", new Integer(n++));
        Z.put("Orientation", new Integer(n++));
        Z.put("UseDefaultMessage", new Integer(n++));
        return Z;
    }

    private void QOIV() {
        this.barheight = new JetNumber(this, "BarHeight", 50);
        this.bar128 = new JetEnumeration(this, "Bar128Type", 10);
        this.narrowwidth = new JetNumber(this, "NarrowWidth");
        this.hrdisplay = new JetBoolean(this, "HRDisplay", true);
        this.message = new JetString(this, "Message", "");
        this.ratio = new JetNumber(this, "Ratio", 2);
        this.checkenable = new JetBoolean(this, "CheckEnable", true);
        this.quietzone = new JetNumber(this, "QuietZone");
        this.symbology = new JetEnumeration(this, "Symbology", 92);
        this.supplement = new JetString(this, "Supplement", "");
        this.scalemode = new JetEnumeration(this, "ScaleMode", 11);
        this.param = new JetColumnName(this, "Parameter");
        this.paramdatasource = new JetBoolean(this, "ParamDataSource", false);
        this.orientation = new JetNumber(this, "Orientation", 0);
        this.useDefaultMessage = new JetBoolean(this, "UseDefaultMessage", false);
        this.displayNull = new JetString(this, "DisplayNull");
        this.displayNull.set("invalide");
        this.scalemode.set(new Integer(2));
        this.checkenable.set(false);
        this.symbology.set(new Integer(5));
        this.bar128.set(new Integer(3));
    }

    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return add;
        }
        return null;
    }

    static {
        String string = null;
        Vector<String> vector = null;
        string = "Geometry";
        vector = new Vector<String>(4);
        vector.add("X");
        vector.add("Y");
        vector.add("Width");
        vector.add("Height");
        add.put(string, vector);
        string = "Color";
        vector = new Vector(2);
        vector.add("Background");
        vector.add("Foreground");
        add.put(string, vector);
        string = "CSS";
        vector = new Vector(4);
        vector.add("Style");
        vector.add("id");
        vector.add("class");
        vector.add("ExternalCSSClassValue");
        add.put(string, vector);
        string = "Excel";
        vector = new Vector(2);
        vector.add("ColumnIndex");
        vector.add("RowIndex");
        add.put(string, vector);
        string = "Padding";
        vector = new Vector(4);
        vector.add("padding-top");
        vector.add("padding-bottom");
        vector.add("padding-left");
        vector.add("padding-right");
        add.put(string, vector);
        string = "Border";
        vector = new Vector(8);
        vector.add("BorderWidth");
        vector.add("TopLine");
        vector.add("BottomLine");
        vector.add("LeftLine");
        vector.add("RightLine");
        vector.add("Shadow");
        vector.add("BorderColor");
        vector.add("ShadowColor");
        add.put(string, vector);
        string = "Pattern";
        vector = new Vector(2);
        vector.add("PatternColor");
        vector.add("PatternStyle");
        add.put(string, vector);
        string = "TextFormat";
        vector = new Vector(12);
        vector.add("FontFace");
        vector.add("FontSize");
        vector.add("Bold");
        vector.add("Italic");
        vector.add("StrikeOut");
        vector.add("Underline");
        vector.add("AutoFit");
        vector.add("MaxWidth");
        vector.add("WordWrap");
        vector.add("TransWhileToHtml");
        vector.add("VerticalAlignment");
        vector.add("HorizontalAlignment");
        add.put(string, vector);
        string = "Others";
        vector = new Vector(22);
        vector.add("position");
        vector.add("ExportToDHTML");
        vector.add("Invisible");
        vector.add("Suppressed");
        vector.add("SuppressedIfNoRecords");
        vector.add("RecordLocation");
        vector.add("ExportToCSV");
        vector.add("ExportToXLS");
        vector.add("Link");
        vector.add("EnableHyperlinkOnPDF");
        vector.add("EnableHyperlinkOnExcel");
        vector.add("EnableHyperlinkOnHTML");
        vector.add("DetailReport");
        vector.add("TransferStyle");
        vector.add("GotoDetail");
        vector.add("FilterOptions");
        vector.add("DataMappingFile");
        vector.add("SuppressedIfNull");
        vector.add("DisplayNull");
        vector.add("ColumnName");
        vector.add("ValueDelimiter");
        vector.add("CacheValue");
        add.put(string, vector);
        string = "Barcode";
        vector = new Vector(13);
        vector.add("BarHeight");
        vector.add("NarrowWidth");
        vector.add("HRDisplay");
        vector.add("Supplement");
        vector.add("Orientation");
        vector.add("ScaleMode");
        vector.add("Message");
        vector.add("UseDefaultMessage");
        vector.add("Ratio");
        vector.add("CheckEnable");
        vector.add("QuietZone");
        vector.add("Symbology");
        vector.add("Bar128Type");
        add.put(string, vector);
        string = "TOC";
        vector = new Vector(2);
        vector.add("TOCAnchor");
        vector.add("AnchorDispValue");
        add.put(string, vector);
    }
}

